<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Admin_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }


    public function get_admin($get, $count) {
    
        if (!empty($get['search'])) {
            $this->db->group_start();
            $this->db->like('admin_name', $get['search']);
            $this->db->or_like('username', $get['search']);
            $this->db->group_end();
        }
        
        if (!empty($get['status'])) {
            switch ($get['status']) {
              case 'inactive':
                  $this->db->where('status', '0');
                  break;
              case 'active':
                  $this->db->where('status', '1');
                  break;
              case 'new':
                  $this->db->where('created_at >=', date('Y-m-d 00:00:00'));
                  $this->db->where('created_at <=', date('Y-m-d 23:59:59'));
                  break;
            }
            
        }

        if (!empty($count)) {
            return $this->db->get('gm_admin_users')->num_rows();
        } else {
            $offset = !empty($get['offset']) ? $get['offset'] : 0;
            $limit  = !empty($get['limit']) ? $get['limit'] : 25;
    
            $this->db->limit($limit, $offset);
            $this->db->order_by('admin_id', 'ASC');
            $query =  $this->db->get('gm_admin_users');
            $result = $query->result_array();
            //echo $this->db->last_query();
            return $result;
        }
    }
    

}
?>