<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

function add_breadcrumb($label, $url = '') {
    $CI =& get_instance();
    if (!isset($CI->breadcrumbs)) {
        $CI->breadcrumbs = [];
    }
    $CI->breadcrumbs[] = ['label' => $label, 'url' => $url];
}

function get_breadcrumbs() {
    $CI =& get_instance();
    return isset($CI->breadcrumbs) ? $CI->breadcrumbs : [];
}



// this breadcrumb is used in sitepanel categories
function get_category_breadcrumb($parent_id, $db) {
    $links = [];
  
    while ($parent_id > 0) {
        $category = $db->get_where('gm_categories', ['category_id' => $parent_id])->row_array();
        if (!$category) break;
  
        $links[] = [
            'title' => $category['category_name'],
            'url'   => base_url('sitepanel/category/index/' . $category['category_id'])
        ];
  
        $parent_id = $category['parent_id'];
    }
  
    $links = array_reverse($links);
  
    // Add Dashboard first
    array_unshift($links, [
        'title' => 'Categories',
        'url'   => base_url('sitepanel/category')
    ]);
  
     // Add Dashboard as first item
     array_unshift($links, [
      'title' => 'Dashboard',
      'url'   => base_url('sitepanel/dashboard')
    ]);
  
    // Prepare final HTML string
    $html = '<ol class="breadcrumb">';
    $last = array_pop($links);
  
    foreach ($links as $item) {
        $html .= '<li class="breadcrumb-item"><a href="' . $item['url'] . '">' . htmlspecialchars($item['title']) . '</a></li>';
    }
  
    // Last one without link
    $html .= '<li class="breadcrumb-item active" aria-current="page">' . htmlspecialchars($last['title']) . '</li>';
    $html .= '</ol>';
  
    return $html;
  }
  
  
// this breadcrumb is used in sitepanel location
function get_location_breadcrumb($parent_id, $db) {
    $links = [];
  
    while ($parent_id > 0) {
        $location = $db->get_where('gm_location', ['location_id' => $parent_id])->row_array();
        if (!$location) break;
  
        $links[] = [
            'title' => $location['location_name'],
            'url'   => base_url('sitepanel/location/index/' . $location['location_id'])
        ];
  
        $parent_id = $location['parent_id'];
    }
  
    $links = array_reverse($links);
  
    // Add Dashboard first
    array_unshift($links, [
        'title' => 'Location',
        'url'   => base_url('sitepanel/location')
    ]);
  
     // Add Dashboard as first item
     array_unshift($links, [
      'title' => 'Dashboard',
      'url'   => base_url('sitepanel/dashboard')
    ]);
  
    // Prepare final HTML string
    $html = '<ol class="breadcrumb">';
    $last = array_pop($links);
  
    foreach ($links as $item) {
        $html .= '<li class="breadcrumb-item"><a href="' . $item['url'] . '">' . htmlspecialchars($item['title']) . '</a></li>';
    }
  
    // Last one without link
    $html .= '<li class="breadcrumb-item active" aria-current="page">' . htmlspecialchars($last['title']) . '</li>';
    $html .= '</ol>';
  
    return $html;
  }
  


  // this breadcrumb is used in frontend listing page
  function get_page_breadcrumb($location_slug = null, $category_slug = null, $db) {
    $links = [];

    // Always start with Home
    $links[] = ['title' => 'Home', 'url' => base_url()];

    // Add Location
    if (!empty($location_slug)) {
        $loc = $db->get_where('gm_location', ['location_url' => $location_slug])->row_array();
        if ($loc) {
            $links[] = [
                'title' => $loc['location_name'],
                'url'   => base_url($loc['location_url']) . '/'
            ];
        }
    }

    // Add Category and its parents (hierarchy)
    if (!empty($category_slug)) {
        $cat_seo = $db->get_where('gm_seo_urls', ['page_url' => $category_slug, 'entity_type' => 'category'])->row_array();
        if ($cat_seo) {
            $category = $db->get_where('gm_categories', ['category_id' => $cat_seo['entity_id']])->row_array();
            $category_links = [];

            // Get all parent categories
            while ($category && $category['parent_id'] > 0) {
                $parent = $db->get_where('gm_categories', ['category_id' => $category['parent_id']])->row_array();
                if (!$parent) break;

                $parent_seo = $db->get_where('gm_seo_urls', [
                    'entity_type' => 'category',
                    'entity_id'   => $parent['category_id']
                ])->row_array();

                if ($parent_seo) {
                    $url = $location_slug
                        ? base_url("$location_slug/" . $parent_seo['page_url'])
                        : base_url($parent_seo['page_url']);

                    $category_links[] = [
                        'title' => $parent['category_name'],
                        'url'   => $url
                    ];
                }

                $category = $parent;
            }

            // Reverse to get correct order
            $category_links = array_reverse($category_links);

            // Add category links to main list
            $links = array_merge($links, $category_links);

            // Now add the current category as last (without link)
            $links[] = [
                'title' => $db->escape_str(ucwords(str_replace(['-', '.htm'], [' ', ''], $category_slug))),
                'url' => null
            ];
        }
    }

    // Build HTML
    $html = '';
    $last = array_pop($links);
    foreach ($links as $item) {
        $html .= '<li><a href="' . $item['url'] . '">' . htmlspecialchars($item['title']) . '</a></li>';
    }
    $html .= '<li>' . htmlspecialchars($last['title']) . '</li>';

    return $html;
}


  
