<?php

class Location extends Sitepanel_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('sitepanel/location_model'));
    $this->load->library('paginator');
  }

  public function index($parent_id=0) {

    if (!has_permission('location_view')) {
        redirect('sitepanel/errorpage/error403');
    }

    if(empty($this->session->userdata('admin_id'))){
        return redirect(base_url());
    }
    $get = $this->input->get();
    
    if(!empty($get['search'])){
        $get['search'] = $get['search'];
    }
    
    if(!empty($get['status'])){
        $get['status'] = $get['status'];
    }

    /*$status_search = $this->input->get('status_search');
    if(!empty($status_search)){
      $get['status_search'] = $status_search;
    }*/
    
    $total_row = $this->location_model->get_location($parent_id,$get,'count');
    $current_page = isset($get['page']) ? (int)$get['page'] : 1;
    $this->paginator->initialize(['base_url' => base_url('sitepanel/location/index/'.$parent_id),'total_items' => $total_row,'current_page' => $current_page]);
    $get['limit'] = $this->paginator->limit_end; 
    $get['offset'] = $this->paginator->limit_start;
    
	$data['pagelist'] = $this->location_model->get_location($parent_id,$get,$count=NULL);
    $data['pages'] = $get['offset'];
    $data['heading'] = 'Manage Locations';
    $data['breadcrumb'] = get_location_breadcrumb($parent_id, $this->db);
    $data['counts'] = $this->location_model->get_location_counts();

    $this->load->view('sitepanel/location/list_location_view', $data);
  }

  public function add($parent_id){

    if (!has_permission('location_add')) {
        redirect('sitepanel/errorpage/error403');
    }
    
    if (!is_numeric($parent_id) || (int)$parent_id < 0) {
      $this->session->set_flashdata('error', 'Invalid parent ID');
      redirect('sitepanel/location');
      return;
    }

    $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

   if(!empty($this->input->post())){
      
      $location_name = $this->db->escape_str($this->input->post('location_name'));
      $location_url = strtolower(url_title($location_name, '-', TRUE));
      $meta_title = $this->input->post('meta_title');
      $meta_description = $this->input->post('meta_desc');
      $meta_keyword = $this->input->post('meta_keyword');

      $parent_id = applyFilter('NUMERIC_GT_ZERO', $parent_id);

      $this->form_validation->set_rules('location_name', 'Location Name', [
        'trim', 'required', 'max_length[100]',
        [
            'unique_location_check',
            function ($location_name) {
                $CI = &get_instance(); 
                $exists = $CI->db->where('location_name', $location_name)
                                 ->where('status !=', '2')
                                 ->get('gm_location')->row();
                return !$exists;
            }
        ]
      ]);
      $this->form_validation->set_message('unique_location_check', 'This location name already exists.');

      if ($this->form_validation->run() === TRUE){
        $posted_data = array(
            'location_name' => $location_name,
            'parent_id' => $parent_id,
            'location_url' => $location_url,
            'meta_title' => $meta_title,
            'meta_description' => $meta_description,
            'meta_keyword' => $meta_keyword,
            'added_date' => date('Y-m-d H:i:s'),
          );

        $res = $this->db->insert('gm_location', $posted_data);

        if ($res == TRUE) {
            /*$this->session->set_flashdata('success', 'Location added successfully.');
            redirect('sitepanel/location/index/' . $parent_id . $query_string);*/   
            
            
            $action = $this->input->post('submit');
            if ($action === 'save') {
                $this->session->set_flashdata('success', 'Location saved successfully.');
                redirect('sitepanel/location/add/'.$parent_id);
            } elseif ($action === 'save_new') {
                $this->session->set_flashdata('success', 'Location saved. Add another one.');
                redirect('sitepanel/location/add/'.$parent_id);
            } elseif ($action === 'save_close') {
                $this->session->set_flashdata('success', 'Location saved successfully.');
                redirect('sitepanel/location/index/' . $parent_id . $query_string);
            } else {
                redirect('sitepanel/location/index/' . $parent_id . $query_string);
            }
            
            
        } else {
            $this->session->set_flashdata('error', 'Something went wrong. Please try again.');
            redirect(current_url());
        }
      }
    }

      $data['heading'] = 'Add Location'; 
      $data['parent_id'] = $parent_id;
      $data['query_string'] = $_SERVER['QUERY_STRING'];
      $this->load->view('sitepanel/location/add_location_view', $data);
  }



  public function edit($rowid=0,$parent_id=0){

    if (!has_permission('location_edit')) {
        redirect('sitepanel/errorpage/error403');
    }
   
    if($rowid == '' || (int) $rowid == 0  || $parent_id == '' || (int) $parent_id < 0){  
      $this->session->set_flashdata('error', 'Invalid record');
      redirect('sitepanel/location');
      return;
    }
    $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

    if(!empty($this->input->post())){

      $location_name = $this->db->escape_str($this->input->post('location_name'));
      $location_url = strtolower(url_title($location_name, '-', TRUE));

      
      $parent_id = applyFilter('NUMERIC_GT_ZERO', $parent_id);

      $this->form_validation->set_rules('location_name', 'Location Name', [
        'trim', 'required', 'max_length[100]',
        [
            'unique_location_check',
            function ($location_name) use ($rowid) {
                $CI = &get_instance();
                $CI->db->where('location_name', $location_name)
                       ->where('status !=', '2')
                       ->where('location_id !=', $rowid); // Exclude current row
                $exists = $CI->db->get('gm_location')->row();
                return !$exists;
            }
        ]
    ]);
    
      $this->form_validation->set_message('unique_location_check', 'This location name already exists.');


      if ($this->form_validation->run() === TRUE){
        $posted_data = array(
            'location_name' => $location_name,
            'location_url' => $location_url,
            'meta_title' => $this->input->post('meta_title'),
            'meta_description' => $this->input->post('meta_desc'),
            'meta_keyword' => $this->input->post('meta_keyword')
          );

        $this->db->update('gm_location', $posted_data,['location_id'=>$rowid]);

        if ($this->db->affected_rows()) {
            $this->session->set_flashdata('success', 'Location updated successfully.');
            redirect('sitepanel/location/index/' . $parent_id . $query_string);   
        } else {
            $this->session->set_flashdata('error', 'Something went wrong. Please try again.');
            redirect(current_url());
        }
      }
    }
      
      $location_data = $this->db->get_where('gm_location', ['location_id' => $rowid])->row_array();
      $data['res'] = $location_data;

      $data['heading'] = 'Edit Location'; 
      $data['rowid'] = $rowid;
      $data['parent_id'] = $parent_id;
      $data['query_string'] = $_SERVER['QUERY_STRING'];
      $this->load->view('sitepanel/location/edit_location_view', $data);
  }


  public function generate_slug() {
    $location_name = $this->input->post('location_name');
    $slug = strtolower(url_title($location_name, '-', TRUE));
    echo json_encode(['slug' => $slug]);
  }

  public function bulk_action() {

    $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';
    $parent_id = $this->input->post('parent_id');

    $action = $this->input->post('bulk_action');
    $ids = $this->input->post('location_ids');
    $sort_orders = $this->input->post('sort_order');
  
    if ($action === 'update_order') {
      if (!empty($sort_orders)) {
        foreach ($sort_orders as $id => $order) {
          $this->db->update('gm_location', ['sort_order' => (int)$order], ['location_id' => (int)$id]);
        }
        $this->session->set_flashdata('success', 'Order updated successfully.');
      } else {
        $this->session->set_flashdata('error', 'No order values found.');
      }
      redirect('sitepanel/location/index/' . $parent_id . $query_string);
      return;
    }
  
    // For other actions, checkboxes must be selected
    if (empty($ids)) {
      $this->session->set_flashdata('error', 'No Location selected.');
      redirect('sitepanel/location/index/' . $parent_id . $query_string);
      return;
    }
  
    switch ($action) {
      case 'activate':
        $this->db->where_in('location_id', $ids)->update('gm_location', ['status' => '1']);
        break;
      case 'deactivate':
        $this->db->where_in('location_id', $ids)->update('gm_location', ['status' => '0']);
        break;
      case 'featured':
        $this->db->where_in('location_id', $ids)->update('gm_location', ['is_featured' => '1']);
        break;
      case 'unfeatured':
        $this->db->where_in('location_id', $ids)->update('gm_location', ['is_featured' => '0']);
        break;
      case 'delete':
        if (!has_permission('location_delete')) {
          redirect('sitepanel/errorpage/error403');
        }
        $this->db->where_in('location_id', $ids)->update('gm_location', ['status' => '2']);
        break;
    }
  
    $this->session->set_flashdata('success', 'Action applied successfully.');
    redirect('sitepanel/location/index/' . $parent_id . $query_string);
  }

}

?>