<?php
class Company extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('sitepanel/company_model');
        $this->load->library('paginator');
    }

    public function index(){
        if (!has_permission('company_view')) {
        redirect('sitepanel/errorpage/error403');
        }
    
        if(empty($this->session->userdata('admin_id'))){
            return redirect(base_url());
        }
    
        $get = $this->input->get();
        if(!empty($get['search'])){
            $get['search'] = $get['search'];
        }
        
        if(!empty($get['status'])){
            $get['status'] = $get['status'];
        }
        
        $total_row = $this->company_model->get_company($get,'count');
        $current_page = isset($get['page']) ? (int)$get['page'] : 1;
        $this->paginator->initialize(['base_url' => base_url('sitepanel/company/index/'),'total_items' => $total_row,'current_page' => $current_page]);
        $get['limit'] = $this->paginator->limit_end; 
        $get['offset'] = $this->paginator->limit_start;
        
        $data['pagelist'] = $this->company_model->get_company($get,$count=NULL);
        $data['pages'] = $get['offset'];

        $data['heading'] = 'Manage Companies';
        $this->load->view('sitepanel/company/list_company_view', $data);
    }
    
    
    
    public function import_csv() {
        if (isset($_FILES['excel_file']['name']) && $_FILES['excel_file']['name'] != '') {
            $file = $_FILES['excel_file']['tmp_name'];
    
            $handle = fopen($file, "r");
            $count = 0;
            $imported = 0;
            $skipped = 0; // count duplicates skipped
    
            while (($row = fgetcsv($handle, 1000, ",")) !== FALSE) {
                if ($count == 0) { // skip header row
                    $count++;
                    continue;
                }
                
                $company_url = $this->create_unique_slug(trim($row[1]));
                    
                $data = [
                    'company_name'        => trim($row[1]),
                    'company_ceo'         => trim($row[2]),
                    'company_url'         => $company_url,
                    'primary_person_name' => trim($row[2]),
                    'mobile'              => trim($row[3]),
                    'alt_mobile'          => trim($row[4]),
                    'email'               => trim($row[5]),
                    'address'             => trim($row[6]),
                    'city'                => trim($row[7]),
                    'state'               => trim($row[8]),
                    'country'             => trim($row[9]),
                    'website'             => trim($row[10]),
                ];
    
                // Check duplicates (company_name)
                $this->db->from('gm_companies');
                if (!empty($data['company_name'])) {
                    $this->db->where('company_name', $data['company_name']);
                }
                $exists = $this->db->get()->row();
    
                if (!$exists) {
                    $this->db->insert('gm_companies', $data);
                    $company_id = $this->db->insert_id();
    
                    if ($company_id) {
                        $imported++;
    
                        // Handle product list (CSV column 11, index 11)
                        if (!empty($row[11])) {
                            $products = explode(",", $row[11]);
                            foreach ($products as $product) {
                                $product = trim($product);
                                $product_url = $this->create_unique_slug($product);
                                
                                if ($product != '') {
                                    $this->db->insert('gm_company_products', [
                                        'company_id'   => $company_id,
                                        'product_name' => $product,
                                        'product_url' => $product_url,
                                        'created_at' => date('Y-m-d H:i:s'),
                                        'updated_at' => date('Y-m-d H:i:s')
                                    ]);
                                }
                            }
                        }
                    }
                } else {
                    $skipped++;
                }
            }
            fclose($handle);
    
            $msg = $imported . ' companies imported.';
            if ($skipped > 0) {
                $msg .= ' ' . $skipped . ' duplicate entries skipped.';
            }
    
            $this->session->set_flashdata('success', $msg);
            redirect('sitepanel/company/index');
        } else {
            $this->session->set_flashdata('error', 'Please select a CSV file.');
            redirect('sitepanel/company/index');
        }
    }



    public function add() {

        $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

        if ($this->input->post('submit')) {
            
            
            $this->form_validation->set_rules('company_name', 'Company Name', [
            'trim', 'required', 'max_length[100]',
            [
                'unique_company_check',
                function ($company_name) {
                    $CI = &get_instance(); 
                    $exists = $CI->db->where('company_name', $company_name)
                                     ->where('status !=', '2')
                                     ->get('gm_companies')->row();
                    //echo $CI->db->last_query();
                    return !$exists;
                }
            ]
          ]);
          $this->form_validation->set_message('unique_company_check', 'This company name already exists.');
          //$this->form_validation->set_rules('category_description', 'Description', "max_length[6000]");
            
            if ($this->form_validation->run() === TRUE){
                
                /*echo '<pre>';
                print_r($this->input->post());
                die;*/
                
                
                // Member Data
                $member_data = [
                    'member_name' => $this->input->post('primary_person_name'),
                    'designation' => $this->input->post('designation'),
                    'mobile' => $this->input->post('mobile'),
                    'alt_mobile' => $this->input->post('alt_mobile'),
                    'email' => $this->input->post('email'),
                    'alt_email' => $this->input->post('alt_email'),
                    'password'    => password_hash($this->input->post('password'), PASSWORD_DEFAULT),
                    'role'        => 'admin',
                    'created_at'  => date('Y-m-d H:i:s'),
                    'updated_at'    => date('Y-m-d H:i:s')
                ];
                
                $this->db->insert('gm_members',$member_data);
                $member_id = $this->db->insert_id();
                
                
                $company_data = [
                    'member_id' => $member_id,
                    'company_name' => $this->input->post('company_name'),
                    'company_url' => $this->input->post('company_url'),
                    'primary_business_type' => $this->input->post('primary_business_type'),
                    'seconday_business_type' => !empty($this->input->post('seconday_business_type')) ? implode(',',$this->input->post('seconday_business_type')) : NULL,
                    'selected_categories' => $this->input->post('selected_categories'), // you can explode it later if you save as separate rows
                    'pincode' => $this->input->post('pincode'),
                    'country' => $this->input->post('country'),
                    'state' => $this->input->post('state'),
                    'district' => $this->input->post('district'),
                    'landmark' => $this->input->post('landmark'),
                    'locality' => $this->input->post('locality'),
                    'address' => $this->input->post('address'),
                    'company_ceo' => $this->input->post('company_ceo'),
                    'website' => $this->input->post('website'),
                    'established_year' => $this->input->post('established_year'),
                    'company_no_of_emp' => $this->input->post('company_no_of_emp'),
                    'turnover' => $this->input->post('turnover'),
                    'ownership_type' => $this->input->post('ownership_type'),
                    'company_gst' => $this->input->post('company_gst'),
                    'company_pan' => $this->input->post('company_pan'),
                    'company_tan' => $this->input->post('company_tan'),
                    'company_cin' => $this->input->post('company_cin'),
                    'company_desc' => $this->input->post('company_desc'),
                    'account_no' => $this->input->post('account_no'),
                    'account_type' => $this->input->post('account_type'),
                    'ifsc_code' => $this->input->post('ifsc_code'),
                    'bank_name' => $this->input->post('bank_name'),
                    'bank_branch' => $this->input->post('bank_branch'),
                    'primary_person_name' => $this->input->post('primary_person_name'),
                    'designation' => $this->input->post('designation'),
                    'mobile' => $this->input->post('mobile'),
                    'alt_mobile' => $this->input->post('alt_mobile'),
                    'email' => $this->input->post('email'),
                    'alt_email' => $this->input->post('alt_email'),
                    'twitter' => $this->input->post('twitter'),
                    'linkedin' => $this->input->post('linkedin'),
                    'facebook' => $this->input->post('facebook'),
                    'instagram' => $this->input->post('instagram'),
                    'youtube' => $this->input->post('youtube'),
                    'created_at'  => date('Y-m-d H:i:s'),
                    'updated_at'    => date('Y-m-d H:i:s')
                ];
                
                $this->db->insert('gm_companies',$company_data);
                $company_id = $this->db->insert_id();
                
                // insert in company categories table
                $company_categories = explode(',',$this->input->post('selected_categories'));
                if(!empty($company_categories)){
                    foreach($company_categories as $comp_cat){
                        $company_category_data = [
                            'company_id' => $company_id,
                            'category_id'=> $comp_cat,
                            'created_at' => date('Y-m-d H:i:s'),
                            'updated_at' => date('Y-m-d H:i:s')
                            ];
                        
                        $this->db->insert('gm_company_categories',$company_category_data);
                    }
                }
                
                  // seo url insert
                if ($company_id > 0) {
                    $seo_data = array(
                        'page_url' => $this->input->post('company_url'),
                        'entity_type' => 'company',
                        'entity_id' => $company_id,
                        'meta_title' => $this->input->post('meta_title'),
                        'meta_description' => $this->input->post('meta_desc'),
                        'meta_keyword' => $this->input->post('meta_keyword'),
                        'created_at' => date('Y-m-d H:i:s')
                    );
                    $this->db->insert('gm_seo_urls', $seo_data);
                }
                
                
                $submit_type = $this->input->post('submit');
                if ($submit_type == 'save') {
                    $this->session->set_flashdata('success', 'Company added.');
                    redirect('sitepanel/company' . $query_string);
                } elseif ($submit_type == 'save_new') {
                    $this->session->set_flashdata('success', 'Company added. Add another one.');
                    redirect('sitepanel/company/add' . $query_string);
                } elseif ($submit_type == 'save_close') {
                    $this->session->set_flashdata('success', 'Company added.');
                    redirect('sitepanel/company' . $query_string);
                }
    
                //$this->session->set_flashdata('success', 'Company added successfully.');
                //redirect('sitepanel/company');
            }
        }

        $data['heading'] = 'Add New Company';
        $data['query_string'] = $_SERVER['QUERY_STRING'];
        
        $data['country_list'] = $this->db->get_where('gm_countries_list', array('id =' => '102'))->result_array();
        $data['state_list'] = $this->db->get_where('gm_states_list', array('country_id='=>'102'))->result_array();
        
        $data['categories_list'] = $this->db->get_where('gm_categories', array('status =' => '1'),100)->result_array();
        //$data['location_list'] = $this->db->get_where('gm_location', array('status =' => '1'),100)->result_array();
        $data['primary_busi_type'] = $this->db->get_where('gm_business_type', array( 'status =' => '1'))->result_array();
        $data['secondary_busi_type'] = $this->db->get_where('gm_business_type', array( 'status =' => '1'))->result_array();
        $this->load->view('sitepanel/company/add_company_view',$data);
    }
    
    
    public function edit($company_id){
     
        if( $company_id == '' || (int) $company_id == 0 ){
            $this->session->set_flashdata('error', 'Invalid ID or ID not found');
            redirect('sitepanel/company');
            return;
        }
        $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';
        $this->form_validation->set_rules('company_name', 'Company name', 'trim|required');
        
        
        $company_data = $this->db->get_where('gm_companies', array('company_id='=>$company_id))->row_array();
        
        if(!empty($this->input->post())){
        
            if ($this->form_validation->run() === TRUE){
                
        
                $exists = $this->db->where('company_name', $this->input->post('company_name'))->where('company_id !=', $company_id)->get('gm_companies')->num_rows();
                if ($exists > 0) {
                    $this->session->set_flashdata('error', 'Company name already exist.');
                    redirect('sitepanel/company/edit/'.$company_id . $query_string);
                }
                
                
                $member_data = [
                    'member_name' => $this->input->post('primary_person_name'),
                    'designation' => $this->input->post('designation'),
                    'mobile' => $this->input->post('mobile'),
                    'alt_mobile' => $this->input->post('alt_mobile'),
                    'email' => $this->input->post('email'),
                    'alt_email' => $this->input->post('alt_email'),
                    'password'    => password_hash($this->input->post('password'), PASSWORD_DEFAULT),
                    'role'        => 'admin',
                    'created_at'  => date('Y-m-d H:i:s'),
                    'updated_at'    => date('Y-m-d H:i:s')
                ];
                
                $this->db->where('member_id', $company_data['member_id']);
                $this->db->update('gm_members', $member_data);
            
                 $update_data = [
                    'company_name' => $this->input->post('company_name'),
                    'company_url' => $this->input->post('company_url'),
                    'primary_business_type' => $this->input->post('primary_business_type'),
                    'seconday_business_type' => implode(',',$this->input->post('seconday_business_type')),
                    'selected_categories' => $this->input->post('selected_categories',FALSE), // you can explode it later if you save as separate rows
                    'pincode' => $this->input->post('pincode'),
                    'country' => $this->input->post('country'),
                    'state' => $this->input->post('state'),
                    'district' => $this->input->post('district'),
                    'landmark' => $this->input->post('landmark'),
                    'locality' => $this->input->post('locality'),
                    'address' => $this->input->post('address'),
                    'company_ceo' => $this->input->post('company_ceo'),
                    'website' => $this->input->post('website'),
                    'established_year' => $this->input->post('established_year'),
                    'company_no_of_emp' => $this->input->post('company_no_of_emp'),
                    'turnover' => $this->input->post('turnover'),
                    'ownership_type' => $this->input->post('ownership_type'),
                    'company_gst' => $this->input->post('company_gst'),
                    'company_pan' => $this->input->post('company_pan'),
                    'company_tan' => $this->input->post('company_tan'),
                    'company_cin' => $this->input->post('company_cin'),
                    'company_desc' => $this->input->post('company_desc'),
                    'account_no' => $this->input->post('account_no'),
                    'account_type' => $this->input->post('account_type'),
                    'ifsc_code' => $this->input->post('ifsc_code'),
                    'bank_name' => $this->input->post('bank_name'),
                    'bank_branch' => $this->input->post('bank_branch'),
                    'primary_person_name' => $this->input->post('primary_person_name'),
                    'designation' => $this->input->post('designation'),
                    'mobile' => $this->input->post('mobile'),
                    'alt_mobile' => $this->input->post('alt_mobile'),
                    'email' => $this->input->post('email'),
                    'alt_email' => $this->input->post('alt_email'),
                    'twitter' => $this->input->post('twitter'),
                    'linkedin' => $this->input->post('linkedin'),
                    'facebook' => $this->input->post('facebook'),
                    'instagram' => $this->input->post('instagram'),
                    'youtube' => $this->input->post('youtube'),
                    'updated_at'    => date('Y-m-d H:i:s')
                    ];
                    
                    
                    $this->db->where('company_id', $company_id);
                    $this->db->update('gm_companies', $update_data);
                    
                    // seo url update
                    if ($this->db->affected_rows()) {
                        $seo_data = array(
                          'page_url' => $this->input->post('company_url'),
                          'entity_type' => 'company',
                          'entity_id' => $company_id,
                          'meta_title' => $this->input->post('meta_title'),
                          'meta_description' => $this->input->post('meta_desc'),
                          'meta_keyword' => $this->input->post('meta_keyword'),
                          'created_at' => date('Y-m-d H:i:s')
                        );
                        $this->db->update('gm_seo_urls', $seo_data,['entity_id'=>$company_id,'entity_type' => 'company']);
                      }
                    
                    
                    
                    // update in company categories table
                    $company_categories = explode(',', $this->input->post('selected_categories'));
                    
                    $old_categories = $this->db->select('category_id')
                        ->from('gm_company_categories')
                        ->where('company_id', $company_id)
                        ->get()
                        ->result_array();
                    
                    $old_categories = array_column($old_categories, 'category_id');
                    $new_categories = array_map('trim', $company_categories);
                    
                    $to_insert = array_diff($new_categories, $old_categories);
                    $to_delete = array_diff($old_categories, $new_categories);
                    
                    foreach ($to_insert as $comp_cat) {
                        $this->db->insert('gm_company_categories', [
                            'company_id'  => $company_id,
                            'category_id' => $comp_cat,
                            'created_at'  => date('Y-m-d H:i:s'),
                            'updated_at'  => date('Y-m-d H:i:s')
                        ]);
                    }
                    
                    if (!empty($to_delete)) {
                        $this->db->where('company_id', $company_id);
                        $this->db->where_in('category_id', $to_delete);
                        $this->db->delete('gm_company_categories');
                    }
                    
                    
                    
        
                    $this->session->set_flashdata('success', 'Updated successfully.');
                    redirect('sitepanel/company' . $query_string);
                    
            }
        }
        
        
        
        $data['res'] = $this->db->where('company_id',$company_id)->get('gm_companies')->row_array();
        
        
        $data['heading'] = 'Edit Company';
        
        $data['query_string'] = $_SERVER['QUERY_STRING'];
        
        $data['country_list'] = $this->db->get_where('gm_countries_list', array('id =' => '102'))->result_array();
        $data['state_list'] = $this->db->get_where('gm_states_list', array('country_id='=>'102'))->result_array();
        
        $data['categories_list'] = $this->db->get_where('gm_categories', array('status =' => '1'),100)->result_array();
        //$data['location_list'] = $this->db->get_where('gm_location', array('status =' => '1'),100)->result_array();
        $data['primary_busi_type'] = $this->db->get_where('gm_business_type', array( 'status =' => '1'))->result_array();
        $data['secondary_busi_type'] = $this->db->get_where('gm_business_type', array( 'status =' => '1'))->result_array();
        
        $this->db->select('company_id, GROUP_CONCAT(category_id) as selected_categories');
        $this->db->from('gm_company_categories');
        $this->db->where('company_id', $company_id);
        $this->db->group_by('company_id');
        $query = $this->db->get();
        $data['company_cat_list'] = $query->row_array();
        
        
        
        $this->load->view('sitepanel/company/edit_company_view',$data);
    }
    
    /*public function generate_slug($companyName=NULL) {
        if(!empty($companyName)){
            $company_name = $companyName;
        }else{
           $company_name = $this->input->post('company_name'); 
        }
        $exists = $this->db->where('company_name', $company_name)->get('gm_companies')->row();
        if($exists){
            echo json_encode(['error' => "Company name already exists."]);
            exit;
        }
        
        $slug = strtolower(url_title($company_name, '-', TRUE));
        echo json_encode(['slug' => $slug]);
     }*/
      
      
      
     public function generate_slug($companyId = NULL) {
        $company_name = $this->input->post('company_name');
        $company_id   = $companyId ?: $this->input->post('company_id'); // get ID if available
    
        if (empty($company_name)) {
            echo json_encode(['error' => "Company name is required."]);
            exit;
        }
    
        $slug = strtolower(url_title($company_name, '-', TRUE));
        $original_slug = $slug;
    
        $this->db->where('company_url', $slug)->where('status !=', '2');
        if (!empty($company_id)) {
            $this->db->where('company_id !=', $company_id); // Exclude own record
        }
        $exists = $this->db->get('gm_companies')->num_rows();
    
        if ($exists > 0) {
            $count = 1;
            $new_slug = $original_slug . '-' . $count;
    
            while (true) {
                $this->db->where('company_url', $new_slug)->where('status !=', '2');
                if (!empty($company_id)) {
                    $this->db->where('company_id !=', $company_id);
                }
                if ($this->db->get('gm_companies')->num_rows() == 0) break;
    
                $count++;
                $new_slug = $original_slug . '-' . $count;
            }
    
            echo json_encode([
                'error'   => "Company name already exists.",
                'suggest' => $new_slug
            ]);
        } else {
            echo json_encode(['slug' => $slug]);
        }
    }


    //This function used in import company csv method
    private function create_unique_slug($company_name) {
        $slug = strtolower(url_title($company_name, '-', TRUE));
        $original_slug = $slug;
    
        $count = 1;
        while ($this->db->where('company_url', $slug)->get('gm_companies')->num_rows() > 0) {
            $slug = $original_slug . '-' . $count;
            $count++;
        }
    
        return $slug;
    }
     
      
      
    public function get_states() {
        $country_id = $this->input->post('country_id');
        $states = $this->db->where('country_id', $country_id)->get('gm_states_list')->result_array();
        //echo $this->db->last_query();
        //die;
        echo json_encode($states);
    }
    
    public function get_cities() {
        $state_id = $this->input->post('state_id');
        $cities = $this->db->where('state_id', $state_id)->get('gm_cities_list')->result_array();
        echo json_encode($cities);
    }
    
    public function get_list(){
        $search = $this->input->post('query');
        
        $getResult = $this->db->like('category_name', $search)->get('gm_categories')->result_array();
        if($getResult){
            foreach($getResult as $result){
                $category_name = $result['category_name'];
                $category_id = $result['category_id'];
                
                echo "<div onclick=\"addUser('$category_name','$category_id')\">$category_name</div>";
            }
            
        }else{
            echo "<div>No result found</div>";
        }
    }
    
    
    public function get_pincode_info() {
        $pincode = $this->input->post('pincode');
        $response = ['status' => 'error', 'message' => 'Pincode not found'];
    
        if (!empty($pincode) && strlen($pincode) == 6) {
            // Step 1: Try India Post API using cURL
            $apiUrl = 'https://api.postalpincode.in/pincode/' . $pincode;
    
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $apiUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 5 seconds timeout
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3); // connection timeout
            $apiResponse = curl_exec($ch);
            $curlError = curl_error($ch);
            curl_close($ch);
    
            if (!$curlError && $apiResponse) {
                $apiData = json_decode($apiResponse, true);
    
                if (
                    is_array($apiData) &&
                    isset($apiData[0]['Status']) &&
                    $apiData[0]['Status'] === 'Success' &&
                    !empty($apiData[0]['PostOffice'][0])
                ) {
                    $po = $apiData[0]['PostOffice'][0];
                    $response = [
                        'status' => 'success',
                        'district' => $po['District'],
                        'state' => $po['State'],
                        'country' => $po['Country']
                    ];
                }
            }
    
            // Step 2: Fallback to DB if API failed or returned no valid data
            if ($response['status'] !== 'success') {
                $row = $this->db->get_where('gm_pincode_list', ['pincode' => $pincode])->row_array();
    
                if ($row) {
                    $response = [
                        'status' => 'success',
                        'district' => $row['district'],
                        'state' => $row['state'],
                        'country' => $row['country'] ?? 'India'
                    ];
                }
            }
        }
    
        echo json_encode($response);
    }
    
    
    public function bulk_action() {

        $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

        $action = $this->input->post('bulk_action');
        $ids = $this->input->post('company_ids');

         $sort_orders = $this->input->post('sort_order');
        if ($action === 'update_order') {
            if (!empty($sort_orders)) {
                foreach ($sort_orders as $id => $order) {
                $this->db->update('gm_admin_users', ['sort_order' => (int)$order], ['company_id' => (int)$id]);
                }
                $this->session->set_flashdata('success', 'Order updated successfully.');
            } else {
                $this->session->set_flashdata('error', 'No order values found.');
            }
        redirect('sitepanel/company/index/' . $query_string);
        return;
        } 
    
        // For other actions, checkboxes must be selected
        if (empty($ids)) {
        $this->session->set_flashdata('error', 'No Record selected.');
        redirect('sitepanel/company/index/' . $query_string);
        return;
        }
    
        switch ($action) {
        case 'activate':
            $this->db->where_in('company_id', $ids)->update('gm_companies', ['status' => '1']);
            break;
        case 'deactivate':
            $this->db->where_in('company_id', $ids)->update('gm_companies', ['status' => '0']);
            break;
        case 'delete':
            $this->db->where_in('company_id', $ids)->update('gm_companies', ['status' => '2']);
            break;
        }
    
        $this->session->set_flashdata('success', 'Action applied successfully.');
        redirect('sitepanel/company/index/' . $query_string);
    }
    
    
    public function products($company_id){
        /*if( $company_id == '' || (int) $company_id == 0 ){
            $this->session->set_flashdata('error', 'Invalid ID or ID not found');
            redirect('sitepanel/company');
            return;
        }
        $data['company_id'] = $company_id;
        $data['company'] = $this->db->get_where('gm_companies', array('company_id =' => $company_id))->row_array();
        $data['product_list'] = $this->db->get_where('gm_company_products', array('company_id =' => $company_id))->result_array();
        $this->load->view('sitepanel/company/list_product_view',$data);*/
        
        
        
        if (!has_permission('product_view')) {
        redirect('sitepanel/errorpage/error403');
        }
    
        if(empty($this->session->userdata('admin_id'))){
            return redirect(base_url());
        }
    
        $get = $this->input->get();
        if(!empty($get['search'])){
            $get['search'] = $get['search'];
        }
        
        if(!empty($get['status'])){
            $get['status'] = $get['status'];
        }
        
        $total_row = $this->company_model->get_product($get,'count');
        $current_page = isset($get['page']) ? (int)$get['page'] : 1;
        $this->paginator->initialize(['base_url' => base_url('sitepanel/company/products/'.$company_id.'/'),'total_items' => $total_row,'current_page' => $current_page]);
        $get['limit'] = $this->paginator->limit_end; 
        $get['offset'] = $this->paginator->limit_start;
        
        $data['pagelist'] = $this->company_model->get_product($get,$count=NULL);
        $data['pages'] = $get['offset'];
        $data['company_id'] = $company_id;
        $data['company'] = $this->db->get_where('gm_companies', array('company_id =' => $company_id))->row_array();
        $data['heading'] = 'Manage Company Products';
        $this->load->view('sitepanel/company/list_product_view', $data);
        
        
        
        
    }
    
    public function add_product($company_id){
        if( $company_id == '' || (int) $company_id == 0 ){
            $this->session->set_flashdata('error', 'Invalid ID or ID not found');
            redirect('sitepanel/company');
            return;
        }
        $data['company'] = $this->db->get_where('gm_companies', array('company_id =' => $company_id))->row_array();
        $data['product_list'] = $this->db->get_where('gm_company_products', array('company_id =' => $company_id))->result_array();
        $this->load->view('sitepanel/company/add_product_view',$data);
    }
    
    public function edit_product($company_id,$product_id){
        if( $company_id == '' || (int) $company_id == 0 ){
            $this->session->set_flashdata('error', 'Invalid ID or ID not found');
            redirect('sitepanel/company/products/'.$company_id);
            return;
        }
        
        if(empty($product_id)){
            $this->session->set_flashdata('error', 'Invalid record ID or record not found');
            redirect('sitepanel/company/products/'.$company_id);
            return;
        }
        
        $data['company'] = $this->db->get_where('gm_companies', array('company_id =' => $company_id))->row_array();
        $data['product_list'] = $this->db->get_where('gm_company_products', array('company_id =' => $company_id))->result_array();
        $this->load->view('sitepanel/company/edit_product_view',$data);
    }


}
