<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Agriculture Manufacturers, Suppliers, Exporters, wholesale in India</title>
    <meta name="description" content="">
    <meta name="keywords" content="">
    <?php include 'app_top.php'; ?>
</head>

<body>

    <?php include 'app_header.php'; ?>

    <nav class="breadcrumbs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li><a href="#">Apparel & Fashion</a></li>
                        <li>Ladies Kurti</li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <div class="listDirectory">
        <div class="listDirectoryTop">
            <div class="container">
                <ul class="catList">
                    <li class="active"><a href="">All</a></li>
                    <li><a href="">Delhi</a></li>
                    <li><a href="">Gurgaon</a></li>
                    <li><a href="">Jaipur</a></li>
                    <li><a href="">Surat</a></li>
                    <li><a href="">Mumbai</a></li>
                    <li><a href="">Kolkata</a></li>
                    <li><a href="">Noida</a></li>
                    <li><a href="">Bangalore</a></li>
                    <li><a href="">Ahmedabad</a></li>
                    <li><a href="">Kolkata</a></li>
                    <li><a href="">Chennai</a></li>

                </ul>

            </div>
        </div>

        <div class="container">
            <div class="listTagsWrapper">
                <div class="swiper listTags">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide"><a href="">Embroidered Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Short Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Designer Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Crepe Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Synthetic Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Synthetic Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Synthetic Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Synthetic Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Synthetic Kurtis</a></div>
                        <div class="swiper-slide"><a href="">Synthetic Kurtis</a></div>
                        <div class="swiper-slide"><a href="">More..</a></div>
                    </div>

                </div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>


            <div class="listingTitleSection">
                <h1 class="listingTitleH1">Apparel manufacturer in Delhi</h1>
                <div class="listContent">
                    <div class="textLimit" data-show-char="550">
                        <p>An apparel manufacturer is a company that designs, produces, and distributes clothing and related accessories. They handle various stages of production, including sourcing fabrics, creating patterns, cutting, sewing, and finishing garments. Depending on scale, some manufacturers focus on specific types of apparel, such as sportswear, formalwear, or casual clothing, while others offer a full range. Many work with fashion brands or retailers to bring collections to market, ensuring quality control and adherence to industry standards. Modern apparel manufacturers often integrate technology for efficient production and sustainability practices. They may operate domestically or internationally, depending on cost and market reach. Their goal is to deliver stylish, durable, and well-crafted garments that meet consumer demands and evolving fashion trends.</p>

                    </div>
                    <div class="actionButton">
                        <a href="javascript:void(0);" class="listBusinessBtn">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                        <path d="M855 4789 c-16 -5 -38 -15 -48 -23 -10 -7 -194 -324 -410 -702 l-392 -689 1 -80 c3 -139 55 -287 143 -404 51 -68 160 -162 234 -202 l57 -30 0 -1116 c0 -1230 -4 -1158 63 -1198 31 -20 65 -20 2057 -20 1992 0 2026 0 2057 20 67 40 63 -32 63 1198 l0 1116 59 31 c218 116 371 364 375 605 l1 80 -384 675 c-211 371 -396 688 -411 703 -15 16 -44 32 -66 37 -52 13 -3359 11 -3399 -1z m3602 -769 l293 -515 -1095 -3 c-602 -1 -1588 -1 -2190 0 l-1095 3 293 517 292 517 1605 -2 1605 -2 292 -515z m-3253 -797 c-74 -308 -410 -462 -694 -318 -58 29 -132 95 -171 151 -27 40 -79 160 -79 184 0 6 172 10 475 10 l475 0 -6 -27z m1212 -15 c-10 -63 -64 -156 -127 -219 -190 -190 -503 -183 -686 15 -56 60 -107 151 -119 214 l-6 32 472 0 473 0 -7 -42z m1220 10 c-31 -155 -185 -310 -350 -354 -178 -48 -392 28 -501 176 -41 56 -84 152 -85 188 l0 22 471 0 472 0 -7 -32z m1218 -5 c-14 -66 -70 -160 -129 -219 -164 -165 -407 -191 -601 -66 -99 64 -164 152 -200 270 l-13 42 475 0 474 0 -6 -27z m-3407 -410 c77 -76 171 -133 278 -169 114 -39 277 -45 396 -15 141 35 239 91 347 198 l93 92 87 -87 c98 -98 180 -150 297 -189 72 -25 95 -27 225 -27 133 -1 151 2 225 27 44 16 110 46 147 68 67 39 177 138 214 192 l20 28 49 -61 c124 -154 341 -259 538 -260 l67 0 0 -1010 0 -1010 -1035 0 -1035 0 0 689 c0 420 -4 709 -10 741 -31 164 -152 292 -315 335 -81 21 -482 21 -570 1 -144 -34 -261 -143 -312 -292 -15 -44 -17 -124 -20 -761 l-4 -713 -220 0 -219 0 0 1010 0 1010 68 0 c196 1 413 106 537 260 l49 61 20 -28 c10 -15 48 -56 83 -90z m558 -712 c48 -22 69 -44 90 -94 13 -31 15 -128 15 -727 l0 -690 -360 0 -360 0 0 694 c0 468 3 704 11 723 15 40 48 73 94 94 35 16 67 19 255 19 187 0 220 -3 255 -19z"></path>
                                        <path d="M2853 2349 c-54 -13 -142 -72 -182 -122 -17 -22 -40 -64 -51 -94 -20 -53 -21 -72 -18 -397 l3 -341 26 -56 c34 -72 96 -134 168 -168 l56 -26 435 0 435 0 56 26 c72 34 134 96 168 168 l26 56 0 355 0 355 -26 55 c-33 69 -97 133 -169 168 l-55 27 -415 2 c-240 1 -433 -3 -457 -8z m827 -254 c16 -8 34 -24 40 -34 6 -12 10 -132 10 -316 l0 -297 -29 -29 -29 -29 -382 0 -382 0 -29 29 -29 29 0 299 c0 321 2 332 54 353 11 5 184 9 384 9 305 1 368 -1 392 -14z"></path>
                                    </g>
                                </svg>
                            </span> List your Business
                        </a>

                        <a href="javascript:void(0);" class="requirementBtn">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                        <path d="M1665 4794 c-377 -59 -665 -332 -741 -704 -20 -101 -15 -279 11 -380 69 -265 269 -491 527 -593 98 -40 196 -57 318 -57 246 0 442 81 615 256 96 96 137 156 190 281 135 315 58 699 -190 947 -162 162 -353 244 -585 251 -63 2 -128 1 -145 -1z m297 -347 c223 -81 368 -286 368 -519 0 -248 -171 -472 -406 -532 -77 -20 -212 -20 -283 -1 -174 46 -323 183 -382 350 -29 83 -36 220 -15 309 50 210 227 377 446 420 61 12 206 -3 272 -27z"></path>
                                        <path d="M3600 3513 c-117 -19 -257 -103 -327 -194 -89 -118 -113 -198 -113 -386 l0 -133 -78 0 c-43 0 -102 -6 -132 -14 l-54 -14 -72 66 c-107 99 -175 137 -244 137 -48 0 -62 -5 -116 -42 -129 -88 -285 -154 -446 -189 -116 -26 -361 -25 -478 0 -152 33 -318 103 -444 188 -102 70 -158 63 -287 -34 -171 -129 -335 -369 -388 -570 -28 -106 -59 -327 -81 -583 -17 -195 -24 -641 -11 -710 35 -188 194 -350 380 -385 34 -6 410 -10 1036 -10 l983 0 28 -57 c57 -119 202 -229 333 -253 77 -14 1134 -13 1203 1 166 35 308 163 357 324 31 98 158 1654 143 1743 -40 236 -244 402 -494 402 l-78 0 0 123 c0 209 -47 336 -167 447 -124 117 -293 170 -453 143z m153 -324 c49 -13 105 -63 128 -114 15 -31 19 -66 19 -157 l0 -118 -210 0 -210 0 0 120 c0 99 3 127 19 158 51 98 148 141 254 111z m-2659 -624 c127 -64 285 -117 418 -142 129 -24 408 -24 538 0 130 24 316 88 429 147 51 28 99 50 106 50 6 0 22 -11 34 -24 l23 -24 -28 -69 c-20 -50 -28 -90 -31 -153 -4 -69 78 -1143 102 -1343 l6 -47 -974 2 -974 3 -35 27 c-66 51 -72 83 -65 371 7 288 17 415 52 679 28 210 50 281 120 393 49 78 140 185 158 185 7 0 61 -25 121 -55z m2066 -192 c0 -89 3 -114 20 -140 54 -89 178 -103 248 -30 40 44 52 85 52 188 l0 89 210 0 210 0 0 -97 c0 -77 4 -105 21 -139 56 -116 221 -117 279 -3 16 30 20 58 20 139 l0 100 65 0 c36 0 80 -6 98 -14 42 -17 85 -68 92 -109 10 -52 -122 -1591 -139 -1624 -18 -36 -54 -69 -89 -82 -19 -7 -208 -11 -561 -11 -532 0 -532 0 -576 22 -83 42 -76 3 -146 842 -35 413 -64 775 -64 804 0 57 15 95 52 129 34 32 65 42 141 42 l67 1 0 -107z"></path>
                                    </g>
                                </svg>
                            </span> Post Your Buy Requirement
                        </a>



                    </div>
                </div>
            </div>


            <div class="listingFilter">
                <label>
                    <input type="checkbox" name="listFilter" value="Top Rated">
                    <span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
                            <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z" />
                        </svg> Top Rated</span>
                </label>
                <label>
                    <input type="checkbox" name="listFilter" data-value="postCompany" value="Agent">
                    <span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-patch-check" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M10.354 6.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7 8.793l2.646-2.647a.5.5 0 0 1 .708 0" />
                            <path d="m10.273 2.513-.921-.944.715-.698.622.637.89-.011a2.89 2.89 0 0 1 2.924 2.924l-.01.89.636.622a2.89 2.89 0 0 1 0 4.134l-.637.622.011.89a2.89 2.89 0 0 1-2.924 2.924l-.89-.01-.622.636a2.89 2.89 0 0 1-4.134 0l-.622-.637-.89.011a2.89 2.89 0 0 1-2.924-2.924l.01-.89-.636-.622a2.89 2.89 0 0 1 0-4.134l.637-.622-.011-.89a2.89 2.89 0 0 1 2.924-2.924l.89.01.622-.636a2.89 2.89 0 0 1 4.134 0l-.715.698a1.89 1.89 0 0 0-2.704 0l-.92.944-1.32-.016a1.89 1.89 0 0 0-1.911 1.912l.016 1.318-.944.921a1.89 1.89 0 0 0 0 2.704l.944.92-.016 1.32a1.89 1.89 0 0 0 1.912 1.911l1.318-.016.921.944a1.89 1.89 0 0 0 2.704 0l.92-.944 1.32.016a1.89 1.89 0 0 0 1.911-1.912l-.016-1.318.944-.921a1.89 1.89 0 0 0 0-2.704l-.944-.92.016-1.32a1.89 1.89 0 0 0-1.912-1.911z" />
                        </svg> GM Verified</span>
                </label>

                <div class="itemRating">
                    <div class="ratingBtn" id="selectedRating">Ratings</div>
                    <ul class="itemRatingsList" id="ratingsList">
                        <li data-value="Any">Any</li>
                        <li data-value="3.5">3.5</li>
                        <li data-value="4.0">4.0</li>
                        <li data-value="4.5">4.5</li>
                        <li data-value="5.0">5.0</li>
                        <li class="clear-option"><button id="clearOrClose">Closed</button></li>
                    </ul>
                </div>


            </div>





            <div class="row gx-5">
                <div class="col-xxl-9 col-xl-9 col-md-9 col-sm-9 col-12">
                    <div class="listItem">
                        <div class="listItemLeft">
                            <div class="ribbon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                        <path d="M2466 4250 c-63 -16 -153 -70 -197 -117 -22 -24 -55 -74 -72 -111 -29 -61 -32 -76 -32 -162 0 -86 3 -102 31 -160 17 -36 45 -82 63 -102 l31 -36 -57 -111 c-54 -103 -60 -111 -83 -107 -67 14 -242 18 -323 7 -362 -49 -640 -239 -842 -576 -9 -14 -29 4 -132 118 l-123 136 33 68 c29 62 32 77 32 164 0 90 -2 99 -37 171 -45 91 -103 147 -196 191 -61 29 -76 32 -162 32 -86 0 -101 -3 -162 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -163 17 -37 50 -87 73 -112 43 -47 164 -116 204 -116 11 0 27 -4 34 -8 8 -5 62 -281 141 -723 110 -607 127 -715 114 -722 -40 -23 -85 -74 -110 -125 -23 -47 -28 -70 -28 -132 0 -125 62 -222 174 -274 l46 -21 1875 0 1875 0 46 21 c25 12 61 36 82 53 92 82 121 237 64 353 -25 51 -70 102 -110 125 -13 7 4 115 114 722 80 445 133 718 141 723 7 4 23 8 34 8 40 0 161 69 204 116 23 25 56 75 73 112 29 61 32 76 32 162 0 86 -3 101 -32 162 -44 93 -100 151 -191 196 -72 35 -81 37 -171 37 -87 0 -102 -3 -163 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -164 l33 -68 -122 -135 c-100 -110 -124 -133 -133 -120 -5 8 -31 49 -57 89 -154 241 -423 422 -713 478 -76 14 -289 18 -370 7 l-50 -8 -58 111 -57 111 31 36 c18 20 46 66 63 102 28 59 31 74 31 161 0 90 -2 99 -37 171 -68 136 -188 217 -336 224 -42 2 -94 -1 -116 -6z m204 -224 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m400 -1350 c308 -584 421 -791 440 -802 34 -18 70 -17 101 4 15 9 217 229 449 487 479 533 487 541 496 532 4 -3 -51 -328 -122 -722 l-129 -715 -682 0 c-507 0 -689 -3 -708 -12 -29 -13 -55 -55 -55 -88 0 -33 26 -75 55 -88 19 -9 209 -12 745 -12 536 0 726 -3 745 -12 47 -21 67 -82 43 -133 -26 -58 93 -55 -1887 -55 -1390 0 -1826 3 -1846 12 -69 31 -72 132 -5 171 25 15 94 17 749 17 537 0 727 3 746 12 29 13 55 55 55 88 0 33 -26 75 -55 88 -19 9 -200 12 -708 12 l-682 0 -129 715 c-71 394 -126 719 -122 722 9 9 16 2 496 -532 232 -258 434 -478 449 -487 14 -10 36 -18 49 -18 63 0 59 -7 486 807 225 428 413 783 417 788 4 6 49 10 101 9 l93 -1 415 -787z m-2560 750 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m4320 0 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m-2773 -274 c9 -6 -59 -145 -247 -502 -143 -271 -264 -498 -268 -502 -10 -10 -405 422 -410 447 -2 9 15 50 38 93 130 240 362 408 633 457 81 15 235 19 254 7z m1328 -21 c173 -45 359 -163 468 -298 61 -76 140 -215 135 -238 -5 -25 -400 -457 -410 -447 -4 4 -125 231 -268 502 -191 364 -257 496 -247 503 21 14 236 0 322 -22z" />
                                        <path d="M2348 2372 c-167 -166 -168 -168 -168 -212 0 -44 1 -46 168 -212 166 -167 168 -168 212 -168 44 0 46 1 212 168 167 166 168 168 168 212 0 44 -1 46 -168 212 -166 167 -168 168 -212 168 -44 0 -46 -1 -212 -168z m287 -142 l70 -70 -73 -73 -72 -72 -72 72 -73 73 70 70 c38 38 72 70 75 70 3 0 37 -32 75 -70z" />
                                        <path d="M2511 1446 c-87 -48 -50 -186 49 -186 51 0 100 49 100 99 0 75 -83 124 -149 87z" />
                                    </g>
                                </svg> Industry Leaders
                            </div>
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="designer/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <h2 class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</h2>
                            </a>
                            <a href="" class="textImg">
                                <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                            </a>

                            <p class="itemLocation">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                </svg> 3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015
                            </p>
                            <div class="textLimit">
                                <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            </div>

                            <div class="memberText">
                                <div class="memberStar">
                                    <img src="designer/images/favicon.ico">
                                    <span class="ratingNumber">4.3</span>/5
                                    <div class="starDiv">
                                        <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                        <div class="emsRt"><span>★★★★★</span></div>
                                    </div>
                                    <span class="color">(135)</span>
                                </div>

                                <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                    <div class="memberIcon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                        </svg>
                                    </div>
                                    <div class="memberText">Factory Video</div>
                                </div>

                                <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                    <div class="memberIcon"><img src="designer/images/trustSeal.webp"></div>
                                    <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                </div>
                            </div>

                            <div class="actionButton">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>

                                <a href="" class="visitWebsite">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe2" viewBox="0 0 16 16">
                                        <path d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                    </svg> Visit Website</a>
                            </div>
                        </div>
                    </div>


                    <div class="listItem">
                        <div class="listItemLeft">
                            <div class="ribbon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                        <path d="M2466 4250 c-63 -16 -153 -70 -197 -117 -22 -24 -55 -74 -72 -111 -29 -61 -32 -76 -32 -162 0 -86 3 -102 31 -160 17 -36 45 -82 63 -102 l31 -36 -57 -111 c-54 -103 -60 -111 -83 -107 -67 14 -242 18 -323 7 -362 -49 -640 -239 -842 -576 -9 -14 -29 4 -132 118 l-123 136 33 68 c29 62 32 77 32 164 0 90 -2 99 -37 171 -45 91 -103 147 -196 191 -61 29 -76 32 -162 32 -86 0 -101 -3 -162 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -163 17 -37 50 -87 73 -112 43 -47 164 -116 204 -116 11 0 27 -4 34 -8 8 -5 62 -281 141 -723 110 -607 127 -715 114 -722 -40 -23 -85 -74 -110 -125 -23 -47 -28 -70 -28 -132 0 -125 62 -222 174 -274 l46 -21 1875 0 1875 0 46 21 c25 12 61 36 82 53 92 82 121 237 64 353 -25 51 -70 102 -110 125 -13 7 4 115 114 722 80 445 133 718 141 723 7 4 23 8 34 8 40 0 161 69 204 116 23 25 56 75 73 112 29 61 32 76 32 162 0 86 -3 101 -32 162 -44 93 -100 151 -191 196 -72 35 -81 37 -171 37 -87 0 -102 -3 -163 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -164 l33 -68 -122 -135 c-100 -110 -124 -133 -133 -120 -5 8 -31 49 -57 89 -154 241 -423 422 -713 478 -76 14 -289 18 -370 7 l-50 -8 -58 111 -57 111 31 36 c18 20 46 66 63 102 28 59 31 74 31 161 0 90 -2 99 -37 171 -68 136 -188 217 -336 224 -42 2 -94 -1 -116 -6z m204 -224 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m400 -1350 c308 -584 421 -791 440 -802 34 -18 70 -17 101 4 15 9 217 229 449 487 479 533 487 541 496 532 4 -3 -51 -328 -122 -722 l-129 -715 -682 0 c-507 0 -689 -3 -708 -12 -29 -13 -55 -55 -55 -88 0 -33 26 -75 55 -88 19 -9 209 -12 745 -12 536 0 726 -3 745 -12 47 -21 67 -82 43 -133 -26 -58 93 -55 -1887 -55 -1390 0 -1826 3 -1846 12 -69 31 -72 132 -5 171 25 15 94 17 749 17 537 0 727 3 746 12 29 13 55 55 55 88 0 33 -26 75 -55 88 -19 9 -200 12 -708 12 l-682 0 -129 715 c-71 394 -126 719 -122 722 9 9 16 2 496 -532 232 -258 434 -478 449 -487 14 -10 36 -18 49 -18 63 0 59 -7 486 807 225 428 413 783 417 788 4 6 49 10 101 9 l93 -1 415 -787z m-2560 750 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m4320 0 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m-2773 -274 c9 -6 -59 -145 -247 -502 -143 -271 -264 -498 -268 -502 -10 -10 -405 422 -410 447 -2 9 15 50 38 93 130 240 362 408 633 457 81 15 235 19 254 7z m1328 -21 c173 -45 359 -163 468 -298 61 -76 140 -215 135 -238 -5 -25 -400 -457 -410 -447 -4 4 -125 231 -268 502 -191 364 -257 496 -247 503 21 14 236 0 322 -22z" />
                                        <path d="M2348 2372 c-167 -166 -168 -168 -168 -212 0 -44 1 -46 168 -212 166 -167 168 -168 212 -168 44 0 46 1 212 168 167 166 168 168 168 212 0 44 -1 46 -168 212 -166 167 -168 168 -212 168 -44 0 -46 -1 -212 -168z m287 -142 l70 -70 -73 -73 -72 -72 -72 72 -73 73 70 70 c38 38 72 70 75 70 3 0 37 -32 75 -70z" />
                                        <path d="M2511 1446 c-87 -48 -50 -186 49 -186 51 0 100 49 100 99 0 75 -83 124 -149 87z" />
                                    </g>
                                </svg> Industry Leaders
                            </div>
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="designer/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <h2 class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</h2>
                            </a>
                            <a href="" class="textImg">
                                <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                            </a>

                            <p class="itemLocation">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                </svg> 3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015
                            </p>
                            <div class="textLimit">
                                <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            </div>

                            <div class="memberText">
                                <div class="memberStar">
                                    <img src="designer/images/favicon.ico">
                                    <span class="ratingNumber">4.3</span>/5
                                    <div class="starDiv">
                                        <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                        <div class="emsRt"><span>★★★★★</span></div>
                                    </div>
                                    <span class="color">(135)</span>
                                </div>

                                <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                    <div class="memberIcon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                        </svg>
                                    </div>
                                    <div class="memberText">Factory Video</div>
                                </div>

                                <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                    <div class="memberIcon"><img src="designer/images/trustSeal.webp"></div>
                                    <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                </div>
                            </div>

                            <div class="actionButton">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>

                                <a href="" class="visitWebsite">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe2" viewBox="0 0 16 16">
                                        <path d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                    </svg> Visit Website</a>
                            </div>
                        </div>
                    </div>



                    <div class="listItem">
                        <div class="listItemLeft">
                            <div class="ribbon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                        <path d="M2466 4250 c-63 -16 -153 -70 -197 -117 -22 -24 -55 -74 -72 -111 -29 -61 -32 -76 -32 -162 0 -86 3 -102 31 -160 17 -36 45 -82 63 -102 l31 -36 -57 -111 c-54 -103 -60 -111 -83 -107 -67 14 -242 18 -323 7 -362 -49 -640 -239 -842 -576 -9 -14 -29 4 -132 118 l-123 136 33 68 c29 62 32 77 32 164 0 90 -2 99 -37 171 -45 91 -103 147 -196 191 -61 29 -76 32 -162 32 -86 0 -101 -3 -162 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -163 17 -37 50 -87 73 -112 43 -47 164 -116 204 -116 11 0 27 -4 34 -8 8 -5 62 -281 141 -723 110 -607 127 -715 114 -722 -40 -23 -85 -74 -110 -125 -23 -47 -28 -70 -28 -132 0 -125 62 -222 174 -274 l46 -21 1875 0 1875 0 46 21 c25 12 61 36 82 53 92 82 121 237 64 353 -25 51 -70 102 -110 125 -13 7 4 115 114 722 80 445 133 718 141 723 7 4 23 8 34 8 40 0 161 69 204 116 23 25 56 75 73 112 29 61 32 76 32 162 0 86 -3 101 -32 162 -44 93 -100 151 -191 196 -72 35 -81 37 -171 37 -87 0 -102 -3 -163 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -164 l33 -68 -122 -135 c-100 -110 -124 -133 -133 -120 -5 8 -31 49 -57 89 -154 241 -423 422 -713 478 -76 14 -289 18 -370 7 l-50 -8 -58 111 -57 111 31 36 c18 20 46 66 63 102 28 59 31 74 31 161 0 90 -2 99 -37 171 -68 136 -188 217 -336 224 -42 2 -94 -1 -116 -6z m204 -224 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m400 -1350 c308 -584 421 -791 440 -802 34 -18 70 -17 101 4 15 9 217 229 449 487 479 533 487 541 496 532 4 -3 -51 -328 -122 -722 l-129 -715 -682 0 c-507 0 -689 -3 -708 -12 -29 -13 -55 -55 -55 -88 0 -33 26 -75 55 -88 19 -9 209 -12 745 -12 536 0 726 -3 745 -12 47 -21 67 -82 43 -133 -26 -58 93 -55 -1887 -55 -1390 0 -1826 3 -1846 12 -69 31 -72 132 -5 171 25 15 94 17 749 17 537 0 727 3 746 12 29 13 55 55 55 88 0 33 -26 75 -55 88 -19 9 -200 12 -708 12 l-682 0 -129 715 c-71 394 -126 719 -122 722 9 9 16 2 496 -532 232 -258 434 -478 449 -487 14 -10 36 -18 49 -18 63 0 59 -7 486 807 225 428 413 783 417 788 4 6 49 10 101 9 l93 -1 415 -787z m-2560 750 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m4320 0 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m-2773 -274 c9 -6 -59 -145 -247 -502 -143 -271 -264 -498 -268 -502 -10 -10 -405 422 -410 447 -2 9 15 50 38 93 130 240 362 408 633 457 81 15 235 19 254 7z m1328 -21 c173 -45 359 -163 468 -298 61 -76 140 -215 135 -238 -5 -25 -400 -457 -410 -447 -4 4 -125 231 -268 502 -191 364 -257 496 -247 503 21 14 236 0 322 -22z" />
                                        <path d="M2348 2372 c-167 -166 -168 -168 -168 -212 0 -44 1 -46 168 -212 166 -167 168 -168 212 -168 44 0 46 1 212 168 167 166 168 168 168 212 0 44 -1 46 -168 212 -166 167 -168 168 -212 168 -44 0 -46 -1 -212 -168z m287 -142 l70 -70 -73 -73 -72 -72 -72 72 -73 73 70 70 c38 38 72 70 75 70 3 0 37 -32 75 -70z" />
                                        <path d="M2511 1446 c-87 -48 -50 -186 49 -186 51 0 100 49 100 99 0 75 -83 124 -149 87z" />
                                    </g>
                                </svg> Industry Leaders
                            </div>
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="designer/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <h2 class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</h2>
                            </a>
                            <a href="" class="textImg">
                                <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                            </a>

                            <p class="itemLocation">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                </svg> 3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015
                            </p>
                            <div class="textLimit">
                                <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            </div>

                            <div class="memberText">
                                <div class="memberStar">
                                    <img src="designer/images/favicon.ico">
                                    <span class="ratingNumber">4.3</span>/5
                                    <div class="starDiv">
                                        <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                        <div class="emsRt"><span>★★★★★</span></div>
                                    </div>
                                    <span class="color">(135)</span>
                                </div>

                                <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                    <div class="memberIcon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                        </svg>
                                    </div>
                                    <div class="memberText">Factory Video</div>
                                </div>

                                <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                    <div class="memberIcon"><img src="designer/images/trustSeal.webp"></div>
                                    <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                </div>
                            </div>

                            <div class="actionButton">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>

                                <a href="" class="visitWebsite">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe2" viewBox="0 0 16 16">
                                        <path d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                    </svg> Visit Website</a>
                            </div>
                        </div>
                    </div>



                    <div class="listItem">
                        <div class="listItemLeft">
                            <div class="ribbon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                        <path d="M2466 4250 c-63 -16 -153 -70 -197 -117 -22 -24 -55 -74 -72 -111 -29 -61 -32 -76 -32 -162 0 -86 3 -102 31 -160 17 -36 45 -82 63 -102 l31 -36 -57 -111 c-54 -103 -60 -111 -83 -107 -67 14 -242 18 -323 7 -362 -49 -640 -239 -842 -576 -9 -14 -29 4 -132 118 l-123 136 33 68 c29 62 32 77 32 164 0 90 -2 99 -37 171 -45 91 -103 147 -196 191 -61 29 -76 32 -162 32 -86 0 -101 -3 -162 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -163 17 -37 50 -87 73 -112 43 -47 164 -116 204 -116 11 0 27 -4 34 -8 8 -5 62 -281 141 -723 110 -607 127 -715 114 -722 -40 -23 -85 -74 -110 -125 -23 -47 -28 -70 -28 -132 0 -125 62 -222 174 -274 l46 -21 1875 0 1875 0 46 21 c25 12 61 36 82 53 92 82 121 237 64 353 -25 51 -70 102 -110 125 -13 7 4 115 114 722 80 445 133 718 141 723 7 4 23 8 34 8 40 0 161 69 204 116 23 25 56 75 73 112 29 61 32 76 32 162 0 86 -3 101 -32 162 -44 93 -100 151 -191 196 -72 35 -81 37 -171 37 -87 0 -102 -3 -163 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -164 l33 -68 -122 -135 c-100 -110 -124 -133 -133 -120 -5 8 -31 49 -57 89 -154 241 -423 422 -713 478 -76 14 -289 18 -370 7 l-50 -8 -58 111 -57 111 31 36 c18 20 46 66 63 102 28 59 31 74 31 161 0 90 -2 99 -37 171 -68 136 -188 217 -336 224 -42 2 -94 -1 -116 -6z m204 -224 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m400 -1350 c308 -584 421 -791 440 -802 34 -18 70 -17 101 4 15 9 217 229 449 487 479 533 487 541 496 532 4 -3 -51 -328 -122 -722 l-129 -715 -682 0 c-507 0 -689 -3 -708 -12 -29 -13 -55 -55 -55 -88 0 -33 26 -75 55 -88 19 -9 209 -12 745 -12 536 0 726 -3 745 -12 47 -21 67 -82 43 -133 -26 -58 93 -55 -1887 -55 -1390 0 -1826 3 -1846 12 -69 31 -72 132 -5 171 25 15 94 17 749 17 537 0 727 3 746 12 29 13 55 55 55 88 0 33 -26 75 -55 88 -19 9 -200 12 -708 12 l-682 0 -129 715 c-71 394 -126 719 -122 722 9 9 16 2 496 -532 232 -258 434 -478 449 -487 14 -10 36 -18 49 -18 63 0 59 -7 486 807 225 428 413 783 417 788 4 6 49 10 101 9 l93 -1 415 -787z m-2560 750 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m4320 0 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m-2773 -274 c9 -6 -59 -145 -247 -502 -143 -271 -264 -498 -268 -502 -10 -10 -405 422 -410 447 -2 9 15 50 38 93 130 240 362 408 633 457 81 15 235 19 254 7z m1328 -21 c173 -45 359 -163 468 -298 61 -76 140 -215 135 -238 -5 -25 -400 -457 -410 -447 -4 4 -125 231 -268 502 -191 364 -257 496 -247 503 21 14 236 0 322 -22z" />
                                        <path d="M2348 2372 c-167 -166 -168 -168 -168 -212 0 -44 1 -46 168 -212 166 -167 168 -168 212 -168 44 0 46 1 212 168 167 166 168 168 168 212 0 44 -1 46 -168 212 -166 167 -168 168 -212 168 -44 0 -46 -1 -212 -168z m287 -142 l70 -70 -73 -73 -72 -72 -72 72 -73 73 70 70 c38 38 72 70 75 70 3 0 37 -32 75 -70z" />
                                        <path d="M2511 1446 c-87 -48 -50 -186 49 -186 51 0 100 49 100 99 0 75 -83 124 -149 87z" />
                                    </g>
                                </svg> Industry Leaders
                            </div>
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="designer/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <h2 class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</h2>
                            </a>
                            <a href="" class="textImg">
                                <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                            </a>

                            <p class="itemLocation">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                </svg> 3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015
                            </p>
                            <div class="textLimit">
                                <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            </div>

                            <div class="memberText">
                                <div class="memberStar">
                                    <img src="designer/images/favicon.ico">
                                    <span class="ratingNumber">4.3</span>/5
                                    <div class="starDiv">
                                        <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                        <div class="emsRt"><span>★★★★★</span></div>
                                    </div>
                                    <span class="color">(135)</span>
                                </div>

                                <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                    <div class="memberIcon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                        </svg>
                                    </div>
                                    <div class="memberText">Factory Video</div>
                                </div>

                                <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                    <div class="memberIcon"><img src="designer/images/trustSeal.webp"></div>
                                    <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                </div>
                            </div>

                            <div class="actionButton">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>

                                <a href="" class="visitWebsite">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe2" viewBox="0 0 16 16">
                                        <path d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                    </svg> Visit Website</a>
                            </div>
                        </div>
                    </div>



                    <div class="postRequirement">
                        <div class="ribbonSave">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clock" viewBox="0 0 16 16">
                                    <path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71z" />
                                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0" />
                                </svg> Save Your Time</span>
                        </div>
                        <form>
                            <div class="postRequirementTitle">Post your Buy Requirement</div>
                            <p>Get Quotes from Verified Suppliers</p>
                            <div class="row">
                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="fname2" placeholder="Products / Services you are looking for..." value="" required="">
                                    </div>
                                </div>

                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <div class="inputGroup">
                                            <input type="text" name="quantity" class="form-control" placeholder="Quantity*" required="">
                                            <input type="hidden" name="unit" class="unitInput" value="Piece">
                                            <div class="unitToggle">Piece</div>
                                            <ul class="unitDropdown" style="display: none;">
                                                <li>Piece</li>
                                                <li>Unit</li>
                                            </ul>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control telePhone" name="phone" placeholder="Phone Number*" value="" required>
                                    </div>
                                </div>

                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <input type="email" class="form-control" name="fname2" placeholder="Email Address*" value="" required="">
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <button type="submit" class="submitButton">Get Quotes Now</button>
                                </div>

                            </div>

                        </form>
                    </div>

                    <div class="listItem">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="designer/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <h2 class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</h2>
                            </a>
                            <a href="" class="textImg">
                                <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                            </a>

                            <p class="itemLocation">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                </svg> 3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015
                            </p>
                            <div class="textLimit">
                                <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            </div>

                            <div class="memberText">
                                <div class="memberStar">
                                    <img src="designer/images/favicon.ico">
                                    <span class="ratingNumber">4.3</span>/5
                                    <div class="starDiv">
                                        <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                        <div class="emsRt"><span>★★★★★</span></div>
                                    </div>
                                    <span class="color">(135)</span>
                                </div>

                                <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                    <div class="memberIcon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                        </svg>
                                    </div>
                                    <div class="memberText">Factory Video</div>
                                </div>

                                <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                    <div class="memberIcon"><img src="designer/images/trustSeal.webp"></div>
                                    <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                </div>
                            </div>

                            <div class="actionButton">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>

                                <a href="" class="visitWebsite">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe2" viewBox="0 0 16 16">
                                        <path d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                    </svg> Visit Website</a>
                            </div>
                        </div>
                    </div>

                    <div class="listItem">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="designer/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <h2 class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</h2>
                            </a>
                            <a href="" class="textImg">
                                <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                            </a>

                            <p class="itemLocation">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                </svg> 3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015
                            </p>
                            <div class="textLimit">
                                <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            </div>

                            <div class="memberText">
                                <div class="memberStar">
                                    <img src="designer/images/favicon.ico">
                                    <span class="ratingNumber">4.3</span>/5
                                    <div class="starDiv">
                                        <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                        <div class="emsRt"><span>★★★★★</span></div>
                                    </div>
                                    <span class="color">(135)</span>
                                </div>

                                <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                    <div class="memberIcon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                        </svg>
                                    </div>
                                    <div class="memberText">Factory Video</div>
                                </div>

                                <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                    <div class="memberIcon"><img src="designer/images/trustSeal.webp"></div>
                                    <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                </div>
                            </div>

                            <div class="actionButton">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>

                                <a href="" class="visitWebsite">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe2" viewBox="0 0 16 16">
                                        <path d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                    </svg> Visit Website</a>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="col-xxl-3 col-xl-3 col-md-3 col-sm-3 col-12">
                    <?php include "app_sidebar.php"; ?>

                </div>
            </div>

        </div>
    </div>

    <?php include 'app_footer.php'; ?>
    <?php include 'app_modal.php'; ?>
    <?php include 'app_bottom.php'; ?>
    <script>
        $(document).ready(function() {
            var ellipsestext = "...";
            var moretext = "Read More";
            var lesstext = "Read Less";

            $('.textLimit').each(function() {
                var showChar = $(this).data('show-char') || 300; // default to 300 if not set
                var contentText = $(this).text();

                if (contentText.length > showChar) {
                    var visibleText = contentText.substr(0, showChar);
                    var hiddenText = contentText.substr(showChar);

                    var html = '<span class="visiblepart">' + visibleText + '</span>' +
                        '<span class="moreellipses">' + ellipsestext + '</span>' +
                        '<span class="morecontent" style="display:none;">' + hiddenText + '</span>' +
                        '<a href="#" class="morelink">' + moretext + '</a>';
                    $(this).html(html);
                }
            });

            $(document).on('click', '.morelink', function(e) {
                e.preventDefault();
                var $this = $(this);
                var $parent = $this.parent();

                if ($this.hasClass('less')) {
                    $this.removeClass('less').html(moretext);
                    $parent.find('.morecontent').hide();
                    $parent.find('.moreellipses').show();
                } else {
                    $this.addClass('less').html(lesstext);
                    $parent.find('.morecontent').show();
                    $parent.find('.moreellipses').hide();
                }
            });
        });
    </script>

    <script>
        $(function() {
            $('.ratingBtn').click(() => $('#ratingsList').toggle());

            $('#ratingsList li:not(.clear-option)').click(function() {
                const text = $(this).text();
                $('#selectedRating').text(text).addClass('selected');
                $('#clearOrClose').text('Clear');
                $('#ratingsList').hide();
            });

            $('#clearOrClose').click(function(e) {
                e.stopPropagation();
                const btn = $('#selectedRating');
                if ($(this).text() === 'Clear') {
                    btn.text('Ratings').removeClass('selected');
                    $(this).text('Closed');
                }
                $('#ratingsList').hide();
            });

            $(document).click(function(e) {
                if (!$(e.target).closest('.itemRating').length) {
                    $('#ratingsList').hide();
                }
            });
        });
    </script>

    <script>
        const videoId = 'Tm7ui3Tv7j8'; // Replace with your YouTube video ID
        const $iframe = $('#youtubeIframe');

        $('#videoModal').on('show.bs.modal', function() {
            const videoUrl = `https://www.youtube.com/embed/${videoId}?autoplay=1`;
            $iframe.attr('src', videoUrl);
        });

        $('#videoModal').on('hidden.bs.modal', function() {
            $iframe.attr('src', ''); // Reset the iframe to stop video
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.inputGroup').each(function() {
                const group = $(this);

                group.find('.unitToggle').on('click', function() {
                    group.find('.unitDropdown').toggle();
                });

                group.find('.unitDropdown li').on('click', function() {
                    const selected = $(this).text();
                    group.find('.unitToggle').text(selected);
                    group.find('.unitInput').val(selected);
                    group.find('.unitDropdown').hide();
                });
            });

            $(document).on('click', function(e) {
                if (!$(e.target).closest('.inputGroup').length) {
                    $('.unitDropdown').hide();
                }
            });
        });
    </script>

    <script>
        var swiper = new Swiper(".listTags", {
            slidesPerView: 1,
            spaceBetween: 10,
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                640: {
                    slidesPerView: 2,
                    spaceBetween: 8,
                },
                768: {
                    slidesPerView: 6,
                    spaceBetween: 8,
                },
                1024: {
                    slidesPerView: 8,
                    spaceBetween: 8,
                },
            },
        });
    </script>


</body>

</html>