'use strict';

$(document).ready(function () {

  function generateData(baseval, count, yrange) {
    var i = 0;
    var series = [];
    while (i < count) {
      var x = Math.floor(Math.random() * (750 - 1 + 1)) + 1;;
      var y = Math.floor(Math.random() * (yrange.max - yrange.min + 1)) + yrange.min;
      var z = Math.floor(Math.random() * (75 - 15 + 1)) + 15;

      series.push([x, y, z]);
      baseval += 86400000;
      i++;
    }
    return series;
  }


  // Leads Received
  if ($('#company-chart').length > 0) {
    var sColStacked = {
      chart: {
        height: 180,
        type: 'bar',
        toolbar: {
          show: false,
        }
      },
      colors: ['#437bd8'],
      responsive: [{
        breakpoint: 480,
        options: {
          legend: {
            position: 'bottom',
            offsetX: -10,
            offsetY: 0
          }
        }
      }],
      plotOptions: {
        bar: {
          borderRadius: 2,
          borderRadiusWhenStacked: 'all',
          horizontal: false,
          endingShape: 'rounded',
          colors: {
            backgroundBarColors: ['#f3f4f5'], // Background color for bars
            backgroundBarOpacity: 0.5,
            hover: {
              enabled: true,
              borderColor: '#214d98', // Color when hovering over the bar
            }
          }
        },
      },
      series: [{
        name: 'Leads Received',
        data: [40, 60, 20, 80, 60, 60, 60]
      }],
      xaxis: {
        categories: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
        labels: {
          style: {
            colors: '#333',
            fontSize: '13px',
          }
        }
      },
      yaxis: {
        labels: {
          offsetX: -15,
          show: false
        }
      },
      grid: {
        borderColor: '#E5E7EB',
        strokeDashArray: 5,
        padding: {
          left: -8,
        },
      },
      legend: {
        show: false
      },
      dataLabels: {
        enabled: false // Disable data labels
      },
      fill: {
        opacity: 1
      },
    }

    var chart = new ApexCharts(
      document.querySelector("#company-chart"),
      sColStacked
    );

    chart.render();
  }
});



// Subscriptions Sold
if ($('#subscriptionsSold').length > 0) {
  var donutChart = {
    chart: {
      height: 200,
      type: 'donut',
      toolbar: {
        show: false,
      }
    },
    colors: ['#447bd6', '#a6afbe'],
    series: [100, 0.1],
    labels: ['Premium', 'Active'],
    plotOptions: {
      pie: {
        donut: {
          size: '50%',
          labels: {
            show: false
          },
          borderRadius: 30
        }
      }
    },
    stroke: {
      lineCap: 'round',
      show: true,
      width: 0,    // Space between donut sections
      colors: '#fff'
    },
    dataLabels: {
      enabled: false
    },
    legend: { show: true },
    responsive: [{
      breakpoint: 480,
      options: {
        chart: {
          height: 180,
        },
        legend: {
          position: 'bottom'
        }
      }
    }]
  }

  var donut = new ApexCharts(
    document.querySelector("#subscriptionsSold"),
    donutChart
  );

  donut.render();
}
