<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->

    <div class="content">
                <div class="pageTitleSection">
                    <div class="pageTitle_1">
                        <button class="backButton" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                            </svg> Back
                        </button>
                        Manage Subdomain Content
                    </div>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/category')?>">Categories</a></li>
                        <li class="breadcrumb-item active">Manage Subdomain Content</li>
                    </ol>
                </div>
                
                
                <!-- row  -->
                <div class="row">
                    <div class="col-12 col-sm-12">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="col-md-12">
                            <div class="alert alert-success">
                            <?php echo $this->session->flashdata('success'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
        
                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="col-md-12">
                            <div class="alert alert-danger">
                            <?php echo $this->session->flashdata('error'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    </div>
        
                </div>

                <!-- Manage Companies -->
                <div class="col-xxl-12 col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-body p-4">
                            
                            <div class="row mb-5">
                                <div class="col-md-12">
                                    <h6>Category Name : <?=$category['category_name']?></h6></div>
                            </div>
                            
                            
                            <form action="<?=base_url('sitepanel/locationcontent/index/'.$category_id.'/'.$parent_id)?>" method="post" enctype="multipart/form-data">  
                            
                                <div class="metaBox">
                                    <div class="form-group">
                                        <label class="form-label text-dark">Meta Title</label>
                                        <input type="text" class="form-control" name="meta_title" value="<?php echo set_value('meta_title', $res['meta_title'] ?? ''); ?>">
                                        <?php if(form_error('meta_title')){ ?>
                                            <div class="text-danger"><?php echo form_error('meta_title') ?></div>
                                        <?php } ?>

                                    </div>
                                    <div class="form-group">
                                        <label class="form-label text-dark">Meta Description</label>
                                        <textarea class="form-control" name="meta_description"><?php echo set_value('meta_description',$res['meta_description'] ?? ''); ?></textarea>
                                        <?php if(form_error('meta_description')){ ?>
                                            <div class="text-danger"><?php echo form_error('meta_description') ?></div>
                                        <?php } ?>
                                    </div>

                                    <div class="form-group">
                                        <label class="form-label text-dark">Meta Keyword</label>
                                        <input type="text" class="form-control" name="meta_keywords" value="<?php echo set_value('meta_keywords',$res['meta_keywords'] ?? ''); ?>">
                                    </div>
                                    <?php if(form_error('meta_keywords')){ ?>
                                        <div class="text-danger"><?php echo form_error('meta_keywords',$res['meta_keywords']) ?></div>
                                    <?php } ?>

                                </div>
                                <div class="form-group">
                                    <label class="form-label text-dark">Short Description</label>
                                    <textarea class="form-control" name="location_short_desc" ><?php echo set_value('location_short_desc',$res['location_short_desc'] ?? '');?></textarea>
                                </div>

                                <div class="form-group">
                                    <label class="form-label text-dark">Description</label>
                                    <!--<textarea id="editor" class="form-control"></textarea>-->
                                    <textarea class="form-control editor" name="location_description"><?php echo set_value('location_description',$res['location_description'] ?? '');?></textarea>
                                </div>

                               
                                
                                <?php 
                                $back_query_string = $_SERVER['QUERY_STRING'] ? '?' . $_SERVER['QUERY_STRING'] : '';
                                ?>

                                <div class="form-group">
                                    <input type="hidden" name="edit_id" value="<?=(!empty($res['id'])) ? $res['id'] : '0' ?>">
                                    <input type="hidden" name="query_string" value="<?= html_escape($query_string); ?>">
                                    <button class="btn save_btn" type="submit" name="submit" value="save">Save</button>
                                    <button class="btn saveClosed" type="submit" name="submit" value="save_close">Save & Close</button>
                                    <a href="<?=base_url('sitepanel/category/index/'.$parent_id.$back_query_string)?>" class="btn cancel_btn">Cancel</a>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>



            </div>
    
<!-- /main-content -->
<?php $this->load->view('sitepanel/common/footer-new'); ?>


<script>
$('#category_name').on('blur', function() {
    let name = $(this).val().trim();
    if (name.length > 0) {
        $.post('<?= base_url("sitepanel/category/generate_slug") ?>', { category_name: name }, function(resp) {
            $('#page_url').val(resp.slug);
        }, 'json');
    }
});

</script>


<script>
        $(document).ready(function() {
            $('.image_upload_box').each(function() {
                const $box = $(this);
                const $preview = $box.find('.js--image-preview');
                const $uploadField = $box.find('.image-upload');
                const $controls = $box.find('.controls');

                $preview.on('click', function(e) {
                    const offset = $preview.offset();
                    const x = e.pageX - offset.left;
                    const y = e.pageY - offset.top;

                    const $drop = $('<span class="drop animate"></span>').css({
                        width: Math.max($preview.width(), $preview.height()),
                        height: Math.max($preview.width(), $preview.height()),
                        top: y - $preview.height() / 2,
                        left: x - $preview.width() / 2
                    });

                    $preview.append($drop);
                    setTimeout(() => $drop.remove(), 600);

                    $uploadField.click();
                });

                $uploadField.on('change', function() {
                    const file = this.files[0];
                    if (!file || !file.type.match(/image.*/)) {
                        alert('Please select a valid image file.');
                        return;
                    }

                    const reader = new FileReader();
                    reader.onload = function() {
                        $preview.css('background-image', 'url(' + reader.result + ')');
                        $preview.addClass('js--no-default');
                        $controls.removeClass('hidden');
                    };
                    reader.readAsDataURL(file);
                });

                $box.find('.edit-btn').on('click', function(e) {
                    e.stopPropagation();
                    $uploadField.click();
                });

                $box.find('.delete-btn').on('click', function(e) {
                    e.stopPropagation();
                    $preview.css('background-image', '');
                    $preview.removeClass('js--no-default');
                    $uploadField.val('');
                    $controls.addClass('hidden');
                });
            });
        });
    </script>