<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->

<div class="content">
    
    
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>
        
        
        <div class="pageTitleSection">
            <div class="pageTitle_1"><button class="backButton" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                </svg> Back
            </button>
                Location Management
            </div>
            <?php if (!empty($breadcrumb)) echo $breadcrumb; ?>
            
        </div>
        
        
        <div class="row mt-3">
                    <div class="col-xl-3 col-sm-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="totalInfo manageCat">
                                        <p>Total Locations</p>
                                        <div class="totalTitle"><?= $counts['total'] ?></div>
                                    </div>
                                    <div class="avatar2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                            <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                                <path d="M548 4582 l-459 -457 1 -1866 c0 -1026 4 -1878 9 -1895 30 -104 117 -205 219 -252 l57 -27 1695 0 1695 0 56 28 c88 43 143 98 186 185 l38 76 0 2186 0 2186 -38 76 c-43 87 -98 142 -186 185 l-56 28 -1380 3 -1379 2 -458 -458z m3227 273 c27 -17 63 -50 80 -74 l30 -43 0 -2178 0 -2178 -30 -43 c-17 -24 -53 -57 -80 -74 l-48 -30 -1626 -3 c-1174 -2 -1640 0 -1678 8 -39 8 -65 23 -102 56 -88 79 -81 -96 -81 1925 l0 1788 303 3 302 3 65 31 c79 38 140 97 177 172 l28 57 3 308 3 307 1303 -2 1303 -3 48 -30z m-2807 -344 l-3 -198 -30 -48 c-20 -32 -45 -56 -74 -72 -43 -22 -53 -23 -275 -23 l-231 0 300 300 300 300 8 -31 c5 -17 7 -120 5 -228z"></path>
                                                <path d="M1449 4555 c-151 -49 -250 -197 -236 -353 7 -75 49 -171 102 -236 37 -45 45 -89 23 -118 -7 -9 -60 -41 -118 -72 -66 -36 -121 -74 -147 -102 -102 -110 -94 -276 17 -332 45 -23 45 -23 472 -20 415 3 427 4 455 24 77 57 95 151 49 250 -33 70 -76 108 -203 179 l-108 60 -3 53 c-3 48 0 57 29 90 62 71 108 212 94 291 -21 120 -90 218 -189 266 -67 33 -170 41 -237 20z m180 -166 c112 -62 120 -215 19 -325 -70 -76 -133 -77 -204 -6 -105 105 -96 279 18 335 47 23 122 22 167 -4z m-29 -573 c23 -71 62 -108 183 -175 116 -63 140 -85 153 -135 l6 -26 -391 0 -391 0 0 29 c0 46 33 76 157 143 121 66 164 106 178 169 6 27 10 29 50 29 41 0 44 -2 55 -34z"></path>
                                                <path d="M2774 4188 c-42 -20 -44 -42 -44 -439 l0 -380 25 -24 24 -25 388 0 c289 1 392 4 404 13 37 29 39 48 39 432 l0 377 -29 29 -29 29 -379 -1 c-238 0 -386 -4 -399 -11z m676 -428 l0 -280 -280 0 -280 0 0 280 0 280 280 0 280 0 0 -280z"></path>
                                                <path d="M3191 3855 l-79 -76 -36 17 c-42 20 -75 11 -101 -29 -23 -36 -11 -67 50 -127 82 -81 91 -79 236 66 101 100 119 123 119 150 0 40 -36 74 -78 74 -26 0 -47 -14 -111 -75z"></path>
                                                <path d="M1481 3190 c-101 -21 -201 -101 -243 -197 -54 -123 -21 -290 83 -407 34 -39 39 -94 12 -118 -10 -8 -62 -39 -116 -67 -121 -65 -151 -90 -185 -155 -21 -41 -26 -65 -27 -122 0 -63 3 -75 29 -108 50 -66 48 -66 517 -66 407 0 422 1 458 21 55 31 75 65 79 134 8 122 -52 203 -214 290 -119 64 -124 69 -124 121 0 35 9 56 44 108 111 163 108 335 -9 465 -70 77 -202 121 -304 101z m167 -187 c79 -63 93 -148 41 -252 -35 -70 -82 -111 -136 -118 -83 -11 -183 112 -183 224 0 60 15 95 57 135 40 38 70 48 131 45 40 -3 61 -11 90 -34z m-46 -565 c18 -59 72 -111 178 -168 110 -60 147 -92 156 -137 l7 -33 -392 0 -391 0 0 33 c0 50 21 71 143 137 61 34 123 72 135 83 26 24 62 88 62 111 0 10 12 14 45 14 43 0 45 -1 57 -40z"></path>
                                                <path d="M2784 2810 c-54 -22 -54 -24 -54 -438 l0 -383 25 -24 24 -25 385 0 c211 0 392 3 401 6 42 17 45 44 45 438 l0 375 -24 28 -24 28 -379 2 c-208 1 -388 -2 -399 -7z m666 -435 l0 -285 -280 0 -280 0 0 285 0 285 280 0 280 0 0 -285z"></path>
                                                <path d="M3196 2471 l-79 -79 -31 19 c-43 26 -63 24 -98 -11 -40 -40 -33 -69 35 -137 86 -86 87 -86 232 58 107 105 125 127 125 154 0 40 -36 75 -76 75 -24 0 -45 -16 -108 -79z"></path>
                                                <path d="M1423 1799 c-156 -60 -245 -242 -198 -404 22 -78 48 -127 90 -174 35 -38 46 -89 27 -117 -4 -6 -54 -37 -112 -68 -58 -32 -119 -69 -137 -82 -64 -49 -109 -190 -84 -267 15 -46 69 -93 121 -107 28 -7 174 -10 443 -8 385 3 404 4 437 24 56 33 80 77 80 149 0 116 -58 193 -202 269 -123 66 -138 80 -138 133 0 34 6 53 26 76 41 48 82 139 95 208 46 252 -208 460 -448 368z m180 -143 c48 -18 74 -41 98 -88 59 -116 -41 -308 -160 -308 -80 0 -171 121 -171 228 0 80 36 134 110 166 43 19 74 19 123 2z m-3 -587 c17 -61 72 -112 190 -178 105 -57 150 -101 150 -142 0 -18 -17 -19 -390 -19 l-390 0 0 25 c0 54 25 79 143 143 122 66 180 118 192 170 6 28 11 31 48 35 23 2 43 4 44 5 1 1 7 -17 13 -39z"></path>
                                                <path d="M2793 1433 c-13 -2 -32 -16 -43 -30 -19 -25 -20 -40 -20 -410 l0 -384 25 -24 24 -25 389 0 c369 0 391 1 413 19 l24 19 3 390 3 390 -25 29 -24 28 -374 1 c-205 1 -383 0 -395 -3z m657 -438 l0 -285 -280 0 -280 0 0 285 0 285 280 0 280 0 0 -285z"></path>
                                                <path d="M2989 1181 c-16 -13 -23 -29 -23 -55 0 -30 8 -45 49 -86 l49 -49 -53 -56 c-45 -48 -52 -60 -46 -83 9 -39 39 -65 75 -65 24 0 43 11 80 48 l50 49 48 -46 c57 -55 81 -64 120 -44 58 30 57 81 -3 145 -25 26 -45 52 -45 57 0 6 20 30 45 54 53 52 60 93 22 128 -38 36 -76 29 -127 -23 -24 -25 -48 -45 -54 -45 -5 0 -31 20 -57 45 -54 50 -91 58 -130 26z"></path>
                                                <path d="M4378 3545 c-64 -21 -149 -100 -179 -167 l-24 -53 -3 -1169 -2 -1168 35 -34 c34 -32 37 -40 56 -152 l20 -119 -30 -106 c-17 -58 -31 -113 -31 -122 0 -19 168 -299 207 -346 31 -37 80 -40 110 -7 22 25 185 288 203 329 10 22 6 43 -25 142 l-36 116 20 116 c18 107 22 118 54 148 l34 32 -5 968 -5 967 52 0 51 0 0 -268 c0 -268 0 -269 23 -290 30 -28 80 -29 107 -2 19 19 20 33 20 349 l0 330 -26 20 c-23 18 -41 21 -124 21 l-98 0 -4 128 c-3 108 -7 134 -28 176 -30 63 -90 122 -148 149 -60 26 -162 32 -224 12z m174 -161 c53 -27 68 -70 68 -193 l0 -111 -145 0 -145 0 0 104 c0 117 6 139 45 179 47 46 111 54 177 21z m72 -541 c3 -42 6 -453 6 -915 l0 -838 -150 0 -150 0 0 915 0 915 144 0 143 0 7 -77z m-69 -1965 c-4 -29 -9 -56 -12 -60 -2 -5 -31 -8 -63 -8 -32 0 -61 3 -63 8 -3 4 -8 31 -12 60 l-7 52 82 0 82 0 -7 -52z m-1 -312 c14 -46 26 -89 26 -96 0 -22 -93 -161 -101 -153 -5 5 -29 41 -53 81 l-45 72 26 90 26 90 48 0 48 0 25 -84z"></path>
                                            </g>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-sm-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="totalInfo manageCat">
                                        <p>Total Countries</p>
                                        <div class="totalTitle"><?= $counts['country'] ?></div>
                                    </div>
                                    <div class="avatar2 bg-success">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                            <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                                <path d="M540 5100 c-263 -70 -455 -265 -521 -529 -30 -119 -24 -282 15 -396 117 -344 465 -548 818 -481 91 17 186 55 255 101 29 19 56 35 60 35 5 0 78 -69 162 -154 154 -154 154 -155 137 -178 -9 -13 -44 -59 -76 -103 -33 -44 -85 -129 -115 -190 -85 -170 -118 -288 -151 -532 l-5 -33 -84 0 -84 0 -24 53 c-30 66 -81 118 -150 154 -44 23 -65 27 -137 28 -101 0 -159 -23 -228 -93 -65 -65 -87 -120 -87 -222 0 -102 22 -157 87 -222 67 -67 127 -92 223 -93 66 0 90 5 136 26 70 33 125 87 156 156 l24 53 84 0 84 0 6 -47 c33 -267 106 -472 236 -666 l52 -78 -119 -120 c-65 -65 -122 -119 -127 -119 -4 0 -31 16 -60 35 -160 108 -402 143 -592 85 -252 -78 -432 -267 -497 -522 -27 -108 -22 -288 12 -388 83 -246 269 -419 519 -481 120 -30 282 -24 396 15 394 135 592 558 444 947 -16 42 -47 101 -68 131 l-39 56 118 117 118 118 85 -75 c267 -233 558 -350 909 -365 l146 -6 26 -101 25 -101 -45 -43 c-67 -63 -98 -138 -98 -232 0 -90 22 -147 84 -214 122 -132 327 -136 454 -10 63 63 91 134 91 229 -1 64 -5 90 -25 130 -49 100 -148 171 -254 182 l-54 6 -22 89 c-13 49 -21 90 -19 91 2 1 46 13 98 26 121 30 244 79 352 142 56 32 98 49 120 49 30 0 86 -52 704 -668 714 -712 691 -692 785 -692 84 0 171 55 212 134 29 53 31 155 4 206 -10 19 -315 332 -677 695 -753 755 -691 674 -615 804 51 87 109 217 132 299 9 31 18 60 21 64 2 4 48 -14 102 -42 l98 -49 5 -58 c7 -75 41 -147 96 -201 160 -161 441 -100 521 113 45 119 10 272 -81 349 -72 62 -122 80 -218 81 -78 0 -90 -3 -149 -35 -35 -19 -75 -48 -89 -66 l-26 -32 -113 56 -113 56 7 116 c14 265 -53 544 -185 775 l-40 70 90 91 90 92 56 -39 c30 -21 89 -52 131 -68 389 -148 812 50 947 444 39 114 45 276 15 396 -62 250 -235 436 -481 519 -100 34 -280 39 -388 12 -427 -108 -659 -553 -501 -962 16 -41 44 -98 64 -127 19 -29 35 -56 35 -60 0 -4 -34 -42 -76 -84 l-76 -77 -102 102 c-246 246 -518 375 -888 421 l-48 6 0 84 0 84 53 24 c69 31 123 86 156 156 21 46 26 70 26 136 -1 96 -26 156 -93 223 -65 65 -120 87 -222 87 -102 0 -157 -22 -222 -87 -70 -69 -93 -127 -93 -228 1 -72 5 -93 28 -137 36 -69 88 -120 154 -150 l53 -24 0 -84 0 -84 -32 -5 c-245 -33 -363 -66 -533 -151 -60 -30 -146 -82 -190 -115 -44 -32 -90 -67 -103 -76 -23 -17 -24 -17 -178 137 -85 84 -154 157 -154 162 0 4 16 31 35 60 46 69 84 164 101 255 67 353 -137 700 -481 818 -110 38 -293 44 -405 14z m361 -172 c149 -55 254 -147 319 -282 106 -220 65 -469 -106 -640 -299 -299 -792 -175 -930 234 -26 76 -26 244 0 320 59 176 175 300 339 362 81 31 125 37 222 33 63 -2 110 -11 156 -27z m1722 -302 c103 -43 128 -177 48 -257 -112 -113 -296 -12 -267 146 18 94 128 150 219 111z m1883 3 c96 -17 213 -79 286 -152 112 -112 163 -235 163 -397 0 -160 -51 -285 -161 -394 -109 -110 -234 -161 -394 -161 -162 0 -285 51 -397 163 -216 216 -215 567 3 786 134 133 313 189 500 155z m-1757 -805 c461 -67 856 -392 1016 -834 42 -117 64 -234 71 -370 13 -252 -42 -476 -173 -705 -49 -86 -58 -109 -61 -162 -2 -33 1 -78 8 -100 10 -30 141 -167 670 -698 362 -363 663 -670 670 -683 26 -52 -14 -112 -74 -112 -27 0 -112 82 -701 669 -539 538 -678 671 -708 681 -22 7 -67 10 -100 8 -53 -3 -76 -12 -162 -61 -229 -131 -453 -186 -705 -173 -327 16 -610 141 -842 372 -436 434 -501 1107 -155 1624 64 96 241 273 337 337 273 182 588 254 909 207z m-2046 -1118 c103 -43 128 -177 48 -257 -65 -65 -157 -65 -222 0 -124 123 13 325 174 257z m3840 -480 c104 -43 128 -175 47 -256 -66 -66 -156 -67 -221 -1 -124 123 13 325 174 257z m-3642 -818 c149 -55 254 -147 319 -282 106 -220 65 -469 -106 -640 -299 -299 -792 -175 -930 234 -26 76 -26 244 0 320 59 176 175 300 339 362 81 31 125 37 222 33 63 -2 110 -11 156 -27z m2042 -622 c103 -43 128 -177 48 -257 -65 -65 -157 -65 -222 0 -124 123 13 325 174 257z"></path>
                                                <path d="M640 4867 c-53 -17 -133 -102 -149 -160 -16 -55 -11 -121 13 -167 15 -32 15 -34 -6 -48 -87 -59 -162 -181 -174 -284 -15 -131 39 -208 178 -254 74 -25 97 -27 218 -27 109 0 149 4 205 22 140 42 190 103 190 231 -1 63 -6 86 -32 141 -29 62 -90 137 -141 171 -21 14 -21 16 -6 48 45 89 25 190 -50 265 -71 71 -153 91 -246 62z m135 -172 c50 -49 15 -135 -55 -135 -41 0 -80 39 -80 80 0 41 39 80 80 80 19 0 40 -9 55 -25z m19 -307 c58 -17 138 -99 155 -159 19 -67 12 -91 -30 -112 -129 -62 -427 -34 -437 42 -8 51 20 115 72 166 71 71 146 90 240 63z"></path>
                                                <path d="M4320 4547 c-53 -17 -133 -102 -149 -160 -16 -55 -11 -121 13 -167 15 -32 15 -34 -6 -48 -87 -59 -162 -181 -174 -284 -15 -131 39 -208 178 -254 74 -25 97 -27 218 -27 109 0 149 4 205 22 140 42 190 103 190 231 -1 63 -6 86 -32 141 -29 62 -90 137 -141 171 -21 14 -21 16 -6 48 45 89 25 190 -50 265 -71 71 -153 91 -246 62z m135 -172 c16 -15 25 -36 25 -55 0 -19 -9 -40 -25 -55 -15 -16 -36 -25 -55 -25 -19 0 -40 9 -55 25 -16 15 -25 36 -25 55 0 19 9 40 25 55 15 16 36 25 55 25 19 0 40 -9 55 -25z m19 -307 c58 -17 138 -99 155 -159 19 -67 12 -91 -30 -112 -129 -62 -427 -34 -437 42 -8 51 20 115 72 166 71 71 146 90 240 63z"></path>
                                                <path d="M2380 3665 c-237 -40 -479 -168 -633 -335 -215 -231 -320 -519 -304 -830 25 -490 360 -897 845 -1028 87 -23 115 -26 272 -26 157 0 185 3 272 26 417 113 716 418 821 837 28 116 30 356 4 481 -34 156 -132 367 -213 455 -39 43 -83 47 -119 10 -38 -37 -31 -67 35 -167 62 -95 109 -201 137 -316 24 -92 23 -330 0 -426 -46 -185 -128 -329 -267 -466 -133 -132 -275 -212 -456 -257 -95 -23 -333 -23 -428 0 -171 43 -323 126 -449 246 -276 264 -368 662 -237 1024 91 250 317 476 567 567 264 95 531 77 787 -55 101 -52 136 -56 165 -19 47 59 11 111 -121 176 -210 104 -456 141 -678 103z"></path>
                                                <path d="M2485 3351 c-212 -55 -312 -306 -192 -482 l24 -35 -51 -27 c-166 -87 -293 -254 -332 -436 -7 -36 -14 -121 -14 -187 0 -193 29 -248 163 -313 301 -148 678 -145 969 6 126 66 153 128 145 342 -7 199 -39 293 -147 430 -44 55 -139 130 -206 164 l-42 20 24 35 c107 157 42 380 -135 463 -48 22 -157 33 -206 20z m138 -165 c103 -43 128 -177 48 -257 -112 -113 -296 -12 -267 146 18 94 128 150 219 111z m52 -481 c178 -47 321 -197 355 -374 5 -30 10 -100 10 -157 0 -122 -8 -135 -107 -178 -125 -54 -205 -69 -368 -70 -163 -1 -251 16 -380 71 -98 42 -105 54 -105 186 0 69 6 136 15 172 67 256 330 415 580 350z"></path>
                                                <path d="M640 1347 c-53 -17 -133 -102 -149 -160 -16 -55 -11 -121 13 -167 15 -32 15 -34 -6 -48 -87 -59 -162 -181 -174 -284 -15 -131 39 -208 178 -254 74 -25 97 -27 218 -27 109 0 149 4 205 22 140 42 190 103 190 231 -1 63 -6 86 -32 141 -29 62 -90 137 -141 171 -21 14 -21 16 -6 48 45 89 25 190 -50 265 -71 71 -153 91 -246 62z m135 -172 c16 -15 25 -36 25 -55 0 -19 -9 -40 -25 -55 -15 -16 -36 -25 -55 -25 -19 0 -40 9 -55 25 -16 15 -25 36 -25 55 0 19 9 40 25 55 15 16 36 25 55 25 19 0 40 -9 55 -25z m19 -307 c58 -17 138 -99 155 -159 19 -67 12 -91 -30 -112 -129 -62 -427 -34 -437 42 -8 51 20 115 72 166 71 71 146 90 240 63z"></path>
                                            </g>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-sm-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="totalInfo manageCat">
                                        <p>Total Indian States</p>
                                        <div class="totalTitle"><?= $counts['indian_states'] ?></div>
                                    </div>

                                    <div class="avatar2 bg-secondary">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                            <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                                <path d="M1004 4876 c-17 -8 -34 -21 -38 -31 -3 -9 -6 -378 -6 -819 l0 -803 -37 -40 c-38 -40 -643 -1077 -675 -1156 -35 -86 -10 -196 58 -258 35 -32 394 -241 443 -257 81 -28 202 3 250 64 l19 24 131 -164 131 -164 -26 -56 c-66 -146 4 -304 158 -357 l52 -17 12 -62 c15 -69 41 -117 86 -155 56 -47 109 -68 175 -69 62 -1 62 -1 79 -39 21 -46 89 -110 141 -133 46 -20 158 -23 193 -4 20 11 25 11 28 0 11 -32 87 -100 135 -120 63 -28 143 -29 205 -5 39 16 142 115 142 137 0 16 23 6 143 -62 157 -89 220 -102 318 -62 68 27 138 121 154 205 7 34 10 37 59 47 28 6 69 23 91 38 49 33 102 110 116 167 10 41 12 43 59 48 27 3 66 15 88 26 56 29 119 104 137 164 19 64 19 90 -1 156 l-15 52 41 41 c77 74 104 174 76 273 -10 31 -16 58 -14 60 10 10 155 85 163 84 6 0 22 -17 36 -38 51 -74 170 -110 260 -79 50 17 409 225 443 256 68 63 93 174 58 259 -32 79 -637 1116 -674 1156 l-38 40 0 804 c0 506 -4 811 -10 823 -5 10 -24 23 -41 29 -23 8 -467 11 -1553 11 -1254 -1 -1526 -3 -1552 -14z m2996 -885 l0 -738 -30 -7 c-31 -6 -388 -208 -446 -252 -46 -34 -84 -116 -84 -180 l0 -52 -47 -10 c-169 -37 -384 -39 -553 -8 -221 42 -299 50 -377 39 -92 -13 -215 -71 -290 -137 l-51 -46 -219 78 -218 77 -6 66 c-7 82 -42 147 -102 187 -87 59 -398 233 -427 238 l-30 7 0 738 0 739 1440 0 1440 0 0 -739z m86 -925 c36 -36 644 -1102 644 -1127 0 -13 -7 -32 -14 -41 -21 -28 -392 -238 -420 -238 -14 0 -36 10 -49 23 -37 34 -647 1100 -647 1130 0 41 34 68 200 163 246 140 240 138 286 90z m-2788 -77 c188 -108 222 -135 222 -176 0 -30 -610 -1096 -647 -1130 -13 -13 -35 -23 -49 -23 -28 0 -399 210 -420 238 -7 9 -14 28 -14 41 0 24 605 1085 643 1129 38 41 72 31 265 -79z m1442 -391 c148 -28 184 -31 355 -31 157 -1 208 3 295 21 58 12 110 22 116 22 8 0 415 -690 491 -832 3 -7 -209 -118 -227 -118 -6 0 -225 125 -488 277 -262 152 -499 285 -527 295 -102 36 -229 13 -395 -69 l-75 -38 -66 -133 c-36 -73 -81 -148 -99 -167 -47 -49 -158 -83 -175 -55 -4 6 -2 111 4 233 l11 222 138 133 c229 222 302 268 432 271 25 1 119 -13 210 -31z m-936 -55 l189 -67 -91 -88 c-51 -48 -94 -98 -96 -110 -3 -13 -10 -129 -16 -259 -15 -307 -4 -351 96 -399 67 -33 151 -24 250 25 93 45 142 104 216 257 l52 107 83 36 c94 41 166 53 213 37 57 -20 1024 -584 1053 -613 30 -33 34 -66 12 -109 -19 -38 -52 -60 -88 -60 -19 0 -94 37 -210 105 -193 112 -223 122 -264 83 -26 -24 -30 -72 -10 -100 7 -9 107 -71 222 -137 211 -122 265 -164 265 -202 0 -39 -32 -90 -67 -107 -45 -21 -48 -20 -317 137 -133 78 -235 131 -251 131 -54 0 -92 -70 -65 -120 5 -10 94 -67 196 -126 148 -87 190 -115 202 -140 18 -40 11 -74 -27 -116 -47 -53 -71 -46 -291 83 -211 123 -237 131 -277 85 -27 -31 -29 -62 -8 -93 8 -11 82 -60 165 -108 83 -48 158 -98 167 -111 21 -33 11 -89 -23 -126 -44 -45 -81 -39 -209 36 l-110 63 4 62 c2 35 -2 83 -9 107 -17 59 -84 133 -149 164 -38 17 -50 28 -46 39 4 9 9 37 12 62 15 123 -89 254 -224 283 -28 6 -33 13 -39 44 -28 159 -198 265 -346 215 l-57 -19 -35 42 c-50 60 -124 94 -203 94 -106 0 -163 -36 -243 -154 -25 -36 -48 -66 -51 -66 -11 0 -270 332 -267 344 5 21 490 856 497 856 3 0 91 -30 195 -67z m-58 -1107 c56 -56 51 -77 -76 -257 -115 -164 -142 -188 -196 -175 -44 11 -84 59 -84 101 0 30 18 62 102 182 55 80 110 154 121 164 13 12 35 19 60 19 31 0 46 -7 73 -34z m361 -92 c37 -23 56 -70 44 -105 -14 -40 -327 -484 -359 -509 -32 -26 -61 -25 -103 3 -43 29 -64 66 -56 99 6 24 296 447 341 497 39 43 83 48 133 15z m281 -289 c55 -59 58 -52 -158 -358 -63 -90 -116 -155 -133 -163 -38 -20 -79 -10 -117 28 -38 38 -40 81 -4 134 110 163 260 367 282 385 38 30 87 20 130 -26z m147 -325 c41 -16 75 -59 75 -96 0 -44 -113 -212 -155 -230 -41 -17 -80 -7 -115 28 -47 46 -41 80 32 188 76 112 105 132 163 110z"></path>
                                                <path d="M1865 4388 c-11 -6 -64 -54 -117 -106 l-98 -96 -43 42 c-53 52 -103 58 -136 16 -38 -48 -29 -70 68 -167 120 -120 112 -121 299 66 158 160 166 175 113 228 -31 31 -53 35 -86 17z"></path>
                                                <path d="M2304 4256 c-50 -22 -61 -87 -21 -124 l23 -22 658 0 657 0 24 25 c32 31 32 66 1 102 l-24 28 -644 2 c-524 2 -649 0 -674 -11z"></path>
                                                <path d="M1874 3529 c-10 -4 -62 -50 -114 -103 -52 -53 -99 -96 -105 -96 -6 0 -29 18 -50 40 -29 30 -47 40 -71 40 -41 0 -72 -26 -80 -68 -6 -31 -2 -38 83 -123 71 -71 95 -89 118 -89 24 0 55 25 177 148 159 159 168 174 128 224 -21 28 -56 39 -86 27z"></path>
                                                <path d="M2282 3387 c-22 -23 -28 -60 -16 -92 17 -44 26 -45 704 -45 l642 0 30 30 c25 26 29 36 24 63 -3 18 -16 40 -27 50 -20 16 -67 17 -678 17 l-658 0 -21 -23z"></path>
                                            </g>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-sm-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="totalInfo manageCat">
                                        <p>Total Cities</p>
                                        <div class="totalTitle"><?= $counts['cities'] ?></div>
                                    </div>

                                    <div class="avatar2 bg-danger">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                            <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                                <path d="M715 5105 c-125 -23 -260 -80 -355 -150 -72 -53 -193 -185 -234 -255 -89 -151 -120 -269 -120 -450 0 -148 16 -230 73 -354 91 -200 277 -377 481 -455 138 -54 212 -61 621 -61 209 0 379 4 393 10 50 19 74 93 46 144 -7 13 -39 39 -71 57 -32 19 -59 39 -59 45 0 6 10 19 21 30 68 61 155 217 196 351 23 78 26 104 26 233 0 129 -3 155 -26 233 -89 290 -296 504 -577 595 -131 43 -280 52 -415 27z m287 -149 c389 -75 648 -452 574 -838 -28 -146 -87 -257 -202 -379 -59 -63 -64 -72 -64 -112 0 -30 7 -53 21 -71 l20 -26 -269 0 c-300 0 -373 9 -491 58 -133 56 -263 170 -340 296 -18 31 -47 95 -64 143 -28 81 -31 99 -31 218 -1 109 3 142 22 205 40 126 88 206 182 301 178 180 401 251 642 205z"></path>
                                                <path d="M517 4302 c-23 -25 -22 -85 1 -105 25 -23 85 -22 105 1 23 25 22 85 -1 105 -25 23 -85 22 -105 -1z"></path>
                                                <path d="M817 4302 c-23 -25 -22 -85 1 -105 25 -23 85 -22 105 1 23 25 22 85 -1 105 -25 23 -85 22 -105 -1z"></path>
                                                <path d="M1117 4302 c-23 -25 -22 -85 1 -105 25 -23 85 -22 105 1 23 25 22 85 -1 105 -25 23 -85 22 -105 -1z"></path>
                                                <path d="M2915 5114 c-462 -66 -823 -358 -978 -791 -50 -137 -59 -216 -67 -553 -8 -345 -12 -374 -75 -505 -19 -39 -67 -116 -108 -172 -109 -150 -147 -252 -147 -398 1 -247 147 -471 368 -561 65 -26 83 -13 -173 -124 -104 -45 -214 -96 -244 -112 -126 -72 -235 -190 -297 -323 -68 -147 -67 -137 -71 -707 l-4 -518 25 -25 c31 -30 64 -32 100 -4 l26 20 0 482 c0 543 3 567 70 703 47 97 140 195 228 242 66 35 539 242 553 242 6 0 8 -92 7 -223 l-3 -222 -150 -5 c-162 -5 -186 -12 -236 -67 -43 -46 -59 -87 -59 -154 0 -52 98 -1015 116 -1147 l6 -42 -876 0 -877 0 -24 -25 c-32 -31 -32 -69 0 -100 l24 -25 2511 0 2511 0 24 25 c32 31 32 69 0 100 -19 20 -34 25 -75 25 l-50 0 0 589 c0 635 -3 675 -53 801 -57 141 -173 280 -293 352 -48 30 -339 161 -463 209 -22 9 -19 12 45 43 142 68 247 182 305 331 27 67 33 98 37 185 2 61 -1 129 -7 161 -17 79 -68 181 -136 269 -32 41 -75 111 -96 156 -68 143 -71 163 -80 529 -4 182 -12 351 -18 377 -56 256 -153 440 -320 611 -168 172 -365 281 -603 333 -70 15 -311 27 -373 18z m300 -159 c50 -8 122 -25 162 -39 79 -27 233 -104 233 -116 0 -13 -106 -158 -179 -244 -305 -364 -843 -626 -1285 -626 -146 0 -133 -14 -116 130 72 584 608 989 1185 895z m685 -435 c96 -141 162 -330 176 -503 l7 -85 -47 -7 c-100 -15 -293 17 -409 69 -28 12 -81 42 -117 65 -70 46 -100 48 -132 9 -28 -32 -23 -75 12 -107 45 -41 182 -111 279 -142 l86 -27 3 -199 2 -198 -32 -63 c-17 -35 -54 -87 -82 -116 -51 -53 -151 -126 -172 -126 -6 0 -23 15 -38 34 -47 62 -93 76 -255 76 -136 0 -146 -1 -192 -26 -151 -83 -152 -293 -2 -381 47 -27 52 -28 193 -28 130 0 149 2 186 22 46 25 84 65 103 109 7 19 32 40 71 62 33 18 89 55 125 82 37 28 68 50 71 50 12 0 -10 -69 -43 -138 -65 -138 -204 -256 -358 -305 -64 -20 -90 -22 -295 -22 -209 0 -230 2 -290 24 -200 71 -344 224 -395 418 -12 45 -15 128 -15 390 l0 333 23 4 c150 31 199 44 301 77 397 130 763 403 1007 749 l64 91 61 -64 c34 -36 81 -93 104 -127z m-1708 -1102 c4 -348 5 -366 27 -428 56 -160 171 -313 294 -390 67 -42 70 -58 28 -145 -36 -78 -101 -136 -199 -181 -77 -35 -78 -36 -198 -32 -115 3 -123 4 -195 40 -173 86 -267 244 -257 436 5 107 34 177 119 289 76 100 141 226 175 339 23 77 27 111 32 262 l4 172 83 0 84 0 3 -362z m1891 185 c4 -155 8 -190 31 -268 38 -125 84 -218 162 -321 37 -49 78 -114 93 -144 23 -50 26 -67 26 -175 0 -111 -2 -125 -28 -180 -87 -186 -228 -275 -434 -275 -87 0 -102 3 -180 37 -128 55 -213 150 -229 255 -5 31 -2 35 46 63 80 47 198 176 248 272 78 150 84 191 89 570 l5 332 72 4 c39 1 76 4 82 5 8 1 13 -52 17 -175z m-769 -569 c38 -37 27 -96 -20 -114 -35 -14 -198 -12 -227 1 -22 10 -47 46 -47 68 0 5 9 20 21 35 20 25 23 26 139 26 94 0 122 -3 134 -16z m-479 -555 c94 -14 370 -10 460 6 44 8 81 15 83 15 1 0 2 -8 2 -18 0 -10 16 -50 35 -91 53 -111 128 -180 262 -242 60 -27 115 -53 123 -58 11 -6 15 -28 15 -91 l0 -84 -110 -28 c-441 -111 -915 -113 -1342 -6 l-83 20 0 94 c0 64 4 94 11 94 7 0 62 24 123 54 86 41 125 68 169 111 54 55 127 177 127 215 0 25 11 32 40 25 14 -4 52 -11 85 -16z m1405 -574 c113 -48 235 -103 272 -122 123 -64 228 -189 280 -333 l23 -65 3 -617 3 -618 -226 0 c-173 0 -225 3 -225 13 0 6 27 268 61 582 33 314 59 593 57 622 -5 64 -41 122 -100 160 -41 28 -43 28 -230 31 l-188 3 0 230 0 229 33 -13 c17 -8 124 -53 237 -102z m-422 -242 l-3 -98 -767 -3 -768 -2 0 94 0 93 78 -19 c256 -61 572 -88 840 -69 180 12 402 46 527 80 103 28 96 34 93 -76z m502 -273 c11 -11 20 -33 20 -49 0 -15 -27 -282 -60 -592 -33 -310 -60 -572 -60 -581 0 -17 -61 -18 -1135 -18 -624 0 -1135 2 -1135 4 0 2 -27 258 -60 568 -33 309 -60 583 -60 607 0 27 6 51 17 63 15 17 67 18 1235 18 1205 0 1218 0 1238 -20z"></path>
                                                <path d="M3008 1057 c-159 -45 -246 -213 -191 -373 23 -68 102 -145 172 -169 106 -35 235 -4 303 74 99 113 101 270 3 379 -75 83 -185 117 -287 89z m148 -162 c56 -36 77 -110 49 -169 -64 -135 -269 -77 -252 71 11 98 122 151 203 98z"></path>
                                            </g>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                
                
                <div class="col-xxl-12 col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <div class="statusSelect">
                                <?php $status = $this->input->get('status'); ?>
                                <select name="status" class="selectOne" onchange="filterByStatus(this)">
                                    <option value="" <?= $status == '' ? 'selected' : '' ?>>All statuses</option>
                                    <option value="active" <?= $status == 'active' ? 'selected' : '' ?>>Active Locations</option>
                                    <option value="inactive" <?= $status == 'inactive' ? 'selected' : '' ?>>Inactive Locations</option>
                                    <option value="featured" <?= $status == 'featured' ? 'selected' : '' ?>>Featured Locations</option>
                                    <option value="deleted" <?= $status == 'deleted' ? 'selected' : '' ?>>Deleted Locations</option>
                                    <option value="new" <?= $status == 'new' ? 'selected' : '' ?>>New Locations</option>
                                </select>

                            </div>


                            <form class="tableSearchReset">
                                <div class="tableSearch">
                                    <input placeholder="Search location..." type="search" name="search" required value="<?= (isset($_GET['search'])) ? $_GET['search'] : '' ?>">
                                    <button type="submit" class="searchBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"></path>
                                        </svg>
                                    </button>
                                </div>

                                <a href="<?= base_url('sitepanel/location') ?>" class="resetBtn" type="reset">Reset</a>
                            </form>
                            <?php
                                $parent_id = (int) $this->uri->segment(4, 0);
                            ?>
                            <div class="view-all-link">
                                <a class="addCompanyBtn" href="<?= base_url('sitepanel/location/add/' . $parent_id . (!empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : '')) ?>">Add New Location</a>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            
                            <?= $this->paginator->dispaly_page_record_ipp(); ?>
                            
                              <form id="bulkActionForm" method="post" action="<?= base_url('sitepanel/location/bulk_action') ?>">
                            <div class="table-responsive dataview">
                              
                                <table class="table dashboardTable" id="my_data">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>
                                                <label class="checkboxs">
                                                    <input type="checkbox" class="select-all" id="checkAll">
                                                    <span class="checkmarks"></span>
                                                </label>
                                            </th>
                                            <th>Name</th>
                                            <th>Display Order</td>
                                            <th>Status</th>
                                            <th class="no-sort">Action</th>
                                        </tr>
                                    </thead>
                                        <tbody>
                                            <?php
                                            foreach ($pagelist as $pageVal) {
                                                $total_sublocation = $this->db->where('parent_id', $pageVal['location_id'])->get('gm_location')->num_rows();
                                            ?>
                                                <tr>
                                                    <td>
                                                        <label class="checkboxs">
                                                            <input type="checkbox" name="location_ids[]" value="<?php echo $pageVal['location_id']; ?>" class="rowCheckbox">
                                                            <span class="checkmarks"></span>
                                                        </label>
                                                    </td>
                                                    
                                                    
                                                    <td>
                                                        <div class="companyName">
                                                            <div class="catTitle"><?php echo $pageVal['location_name']; ?> 
                                                            <?php if($pageVal['is_featured'] == '1') {?>
                                                            <span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                                              <path fill-rule="evenodd" d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0"/>
                                                              <path d="M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.777.416L8 13.101l-5.223 2.815A.5.5 0 0 1 2 15.5zm2-1a1 1 0 0 0-1 1v12.566l4.723-2.482a.5.5 0 0 1 .554 0L13 14.566V2a1 1 0 0 0-1-1z"/>
                                                            </svg></span>
                                                            <?php } ?>
                                                            </div>
                                                            <div class="date">Added Date: <?=date('d F, Y', strtotime($pageVal['added_date']))?></div>
            
                                                            <?php
                                                                echo anchor("sitepanel/location/index/" . $pageVal['location_id'], 'Sublocation [' . $total_sublocation . ']', 'class="link" ');
                                                            ?>
                                                        </div>
                                                    </td>
    
                                                    <td><input type="text" name="sort_order[<?= $pageVal['location_id'] ?>]" value="<?= ($pageVal['sort_order'] != '') ? $pageVal['sort_order'] : "0" ?>" size="5" />
                                                    </td>
                                                    <td><?=getStatusBadge($pageVal['status'])?></td>
                                                    
                                                    
                                                    <td class="action-table-data">
                                                        <div class="edit-delete-action">
                                                            <a class="me-2 p-2 edit toolTip" href="<?= base_url('sitepanel/location/edit/' . $pageVal['location_id'] . '/' . $parent_id . (!empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : '')) ?>" data-tooltip="Edit Category">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                                    <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                                    <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                                                                </svg>
                                                             Edit
                                                            </a>
                                                            
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php
                                            }
                                            ?>
                                        </tbody>
                                </table>
                                
                                
                            </div>
                            
                            <div class="row mt-3 mb-3 mx-1">
                                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8 col-sm-8 col-12">
                                    <ul class="actionButtons">
                                        <li><a class="bulk-action-btn" data-action="activate" href="javascript:void(0);">Activate</a></li>
                                        <li><a class="bulk-action-btn" data-action="deactivate" href="javascript:void(0);">Deactivate</a></li>
                                        <li><a class="bulk-action-btn" data-action="featured" href="javascript:void(0);">Featured</a></li>
                                        <li><a class="bulk-action-btn" data-action="unfeatured" href="javascript:void(0);">Un-Featured</a></li>
                                        <li><a class="bulk-action-btn" data-action="update_order" href="javascript:void(0);">Update Order</a></li>
                                        <li><a class="bulk-action-btn" data-action="delete" href="javascript:void(0);">Delete</a></li>
                                    </ul>
                                </div>
                            </div>
                            <input type="hidden" name="bulk_action" id="bulk_action_field">
                            <input type="hidden" name="parent_id" value="<?=$parent_id?>">
                            <input type="hidden" name="query_string" value="<?= html_escape($_SERVER['QUERY_STRING']); ?>">   
                            </form>
                            
                        </div>
                    </div>
                </div>

                <div class="row">
                     <?php echo $this->paginator->display_jump_menu_pages(); ?>
                </div>
                
                

    
    
    
    
</div>
<!-- /main-content -->
<?php $this->load->view('sitepanel/common/footer-new'); ?>

<script>
    document.getElementById('checkAll').addEventListener('change', function() {
        let checkboxes = document.querySelectorAll('.rowCheckbox');
        for (let checkbox of checkboxes) {
            checkbox.checked = this.checked;
        }
    });
</script>

<script>
            $(document).ready(function () {
                $('.bulk-action-btn').on('click', function () {
                    const action = $(this).data('action');
                    const form = $('#bulkActionForm');
                    const selectedCheckboxes = $('input[name="location_ids[]"]:checked');
            
                    // Check for update_order or checkbox selection
                    if (action !== 'update_order' && selectedCheckboxes.length === 0) {
                        alert('Please select at least one location.');
                        return;
                    }
            
                    $('#bulk_action_field').val(action);
                    form.submit();
                });
            });

        </script>
        
        
        <script>
            
            function filterByStatus(select) {
                var status = select.value;
                var url = new URL(window.location.href);
                var currentStatus = url.searchParams.get('status');
            
                if ((status === "" && currentStatus === null) || status === currentStatus) {
                    return; 
                }
                
                if (status) {
                    url.searchParams.set('status', status);
                } else {
                    url.searchParams.delete('status');
                }
                window.location.href = url.toString();
            }

        </script>