<?php $this->load->view('sitepanel/common/header-new');?>
            <div class="content">
                
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success">
                            <?php echo $this->session->flashdata('success'); ?>
                        </div>
                    <?php endif; ?>

                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger">
                            <?php echo $this->session->flashdata('error'); ?>
                        </div>
                    <?php endif; ?>
                
                
                <div class="pageTitleSection">
                    <div class="pageTitle_1"><button class="backButton" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                        </svg> Back
                    </button>
                        Inactive Categories
                    </div>
                    <?php if (!empty($breadcrumb)) echo $breadcrumb; ?>
                    
                </div>

              

                
                <div class="col-xxl-12 col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            
                            <form class="tableSearchReset">
                                <div class="tableSearch">
                                    <input placeholder="Search category..." type="search" name="search" required value="<?= (isset($_GET['search'])) ? $_GET['search'] : '' ?>">
                                    <button type="submit" class="searchBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"></path>
                                        </svg>
                                    </button>
                                </div>

                                <a href="<?= base_url('sitepanel/category/inactive') ?>" class="resetBtn" type="reset">Reset</a>
                            </form>
                            <?php
                                $parent_id = (int) $this->uri->segment(4, 0);
                            ?>
                            
                        </div>
                        <div class="card-body p-0">
                            <?= $this->paginator->dispaly_page_record_ipp(); ?>
                            
                              <form id="bulkActionForm" method="post" action="<?= base_url('sitepanel/category/activate') ?>">
                            <div class="table-responsive dataview">
                              
                                <table class="table dashboardTable" id="my_data">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>
                                                <label class="checkboxs">
                                                    <input type="checkbox" class="select-all" id="checkAll">
                                                    <span class="checkmarks"></span>
                                                </label>
                                            </th>
                                            <th>Category Name</th>
                                            <th>Image</th>
                                            <th>Icon</th>
                                            <th>Display Order</th>
                                            <th>Status</th>
                                            <!--<th class="no-sort">Action</th>-->
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php if (is_array($pagelist) && !empty($pagelist)) {
                                        foreach ($pagelist as $pageVal) {
                                            $total_subcategory = $this->db->where('parent_id', $pageVal['category_id'])->get('gm_categories')->num_rows();
                                            $condtion_product = "AND category_id='" . $pageVal['category_id'] . "'";
                                            $total_products = count_products($condtion_product);
                                        ?>
                                        <tr>
                                            <td>
                                                <label class="checkboxs">
                                                    <input type="checkbox" name="category_ids[]" value="<?php echo $pageVal['category_id']; ?>" class="singleCheck">
                                                    <span class="checkmarks"></span>
                                                </label>
                                            </td>
                                            <td>
                                                <div class="companyName">
                                                    <div class="catTitle"><?php echo $pageVal['category_name']; ?> 
                                                    <?php if($pageVal['is_featured'] == '1') {?>
                                                    <span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                                      <path fill-rule="evenodd" d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0"/>
                                                      <path d="M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.777.416L8 13.101l-5.223 2.815A.5.5 0 0 1 2 15.5zm2-1a1 1 0 0 0-1 1v12.566l4.723-2.482a.5.5 0 0 1 .554 0L13 14.566V2a1 1 0 0 0-1-1z"/>
                                                    </svg></span>
                                                    <?php } ?>
                                                    </div>
                                                    <div class="date">Added Date: <?=date('d F, Y', strtotime($pageVal['date_added']))?></div>
    
                                                    <?php
                                                        echo anchor("sitepanel/category/index/" . $pageVal['category_id'], 'Subcategory [' . $total_subcategory . ']', 'class="link" ');
                                                        echo " ". anchor("sitepanel/products/index/" . $pageVal['category_id'], 'Products [' . $total_products . ']', 'class="link" ');
                                                    ?>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="thumb_1">
                                                <img src="<?= (!empty($pageVal['category_image_thumb'])) ? base_url('uploaded-files/category/thumb-cache/' . $pageVal['category_image_thumb']) : base_url('uploaded-files/category/thumb-cache/thumb_75_75_noimg.png') ?>">
                                                </div>
                                            </td>
                                            <td>
                                                <div class="thumb_2">
                                                <img src="<?= (!empty($pageVal['category_icon'])) ? base_url('uploaded-files/category/' . $pageVal['category_icon']) : base_url('uploaded-files/category/thumb_75_75_noimg.png') ?>" height="45">
                                                </div>
                                            </td>
                                            <td>
                                                <input type="text" class="form-control order_input" name="sort_order[<?= $pageVal['category_id'] ?>]" value="<?= ($pageVal['sort_order'] != '') ? $pageVal['sort_order'] : "0" ?>" size="5" />
                                            </td>
                                            <td><?=getStatusBadge($pageVal['status'])?></td>
                                            <!--<td class="action-table-data">
                                                <div class="edit-delete-action">
                                                    <a class="me-2 p-2 edit toolTip" href="<?= base_url('sitepanel/category/edit/' . $pageVal['category_id'] . '/' . $parent_id . (!empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : '')) ?>" data-tooltip="Edit Category">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                            <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                            <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                                                        </svg>
                                                     Edit
                                                    </a>
                                                    
                                                </div>
                                            </td>-->
                                        </tr>
                                        <?php } } ?>

                                    </tbody>
                                </table>
                                
                                
                            </div>
                            
                            <div class="row mt-3 mb-3 mx-1">
                                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-8 col-sm-8 col-12">
                                    <ul class="actionButtons">
                                        <li><a class="bulk-action-btn" data-action="restore" href="javascript:void(0);">Activate</a></li>
                                        
                                    </ul>
                                </div>
                            </div>
                            <input type="hidden" name="bulk_action" id="bulk_action_field">
                            <input type="hidden" name="parent_id" value="<?=$parent_id?>">
                            <input type="hidden" name="query_string" value="<?= html_escape($_SERVER['QUERY_STRING']); ?>">   
                            </form>
                            
                        </div>
                    </div>
                </div>

                <div class="row">
                     <?php echo $this->paginator->display_jump_menu_pages(); ?>
                </div>

            </div>
        <?php $this->load->view('sitepanel/common/footer-new');?>
        
                
        <script>
            document.getElementById('checkAll').addEventListener('change', function() {
                let checkboxes = document.querySelectorAll('.rowCheckbox');
                for (let checkbox of checkboxes) {
                    checkbox.checked = this.checked;
                }
            });
        </script>
        
        <script>
            $(document).ready(function () {
                $('.bulk-action-btn').on('click', function () {
                    const action = $(this).data('action');
                    const form = $('#bulkActionForm');
                    const selectedCheckboxes = $('input[name="category_ids[]"]:checked');
            
                    // Check for update_order or checkbox selection
                    if (action !== 'update_order' && selectedCheckboxes.length === 0) {
                        alert('Please select at least one category.');
                        return;
                    }
            
                    $('#bulk_action_field').val(action);
                    form.submit();
                });
            });

        </script>
        
        
        <script>
            
            function filterByStatus(select) {
                var status = select.value;
                var url = new URL(window.location.href);
                var currentStatus = url.searchParams.get('status');
            
                if ((status === "" && currentStatus === null) || status === currentStatus) {
                    return; 
                }
                
                if (status) {
                    url.searchParams.set('status', status);
                } else {
                    url.searchParams.delete('status');
                }
                window.location.href = url.toString();
            }

        </script>
        
        

        </body>

</html>