<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->

    <div class="content">
    
    
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>


        <div class="pageTitleSection">
            <div class="pageTitle_1"><button class="backButton" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                </svg> Back
            </button>
                Manage Roles
            </div>
            <?php if (!empty($breadcrumb)) echo $breadcrumb; ?>
        </div>
        

            <div class="col-xxl-12 col-xl-12 col-lg-12">
                <div class="card">

                    <div class="card-body pb-3 example1-table">

                       

                            <form style="margin-bottom:20px">
                                <div class="row">
                                    <div class="col-5 col-sm-5">
                                        <input class="form-control" placeholder="Search..." type="search" name="search" value="<?= (isset($_GET['search'])) ? $_GET['search'] : '' ?>">
                                    </div>
                                    <div class="col-2 col-sm-2">
                                   
                                    </div>
                                    <div class="col-3 col-sm-3">
                                        <button type="submit" class="btn btn-dark">Search</button>
                                        <a href="<?= base_url('sitepanel/adminroles') ?>" class="btn btn-light">Reset</a>
                                    </div>
                                    <?php
                                    $parent_id = (int) $this->uri->segment(4, 0);
                                    ?>
                                    <div class="col-2 col-sm-2"><a href="<?= base_url('sitepanel/adminroles/add')?>" class="addCompanyBtn" style="float:right">Add New Role</a></div>

                                </div>
                            </form>

                            <div class="table-responsive dataview">
                           <table class="table dashboardTable" id="my_data">
                               <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Role Name</th>
                                        <th class="no-sort">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($roles as $role): ?>
                                    <tr>
                                        <td><?= $role['id'] ?></td>
                                        <td> <div class="companyName"><?= $role['role_name'] ?> (<a href="javascript:void(0);" data-role-id="<?= $role['id']; ?>" class="open-user-modal" data-bs-toggle="modal" data-bs-target="#userListModal"><?= $role['user_count']; ?></a>) </div></td>
                                        
                                        <?php if($role['id'] > 1) {?>
                                        <td class="action-table-data">
                                            <div class="edit-delete-action">
                                                <a class="me-2 p-2 edit toolTip" href="<?= site_url('sitepanel/adminroles/edit/'.$role['id']) ?>" data-tooltip="Manage Permission">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                        <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                        <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                                                    </svg>
                                                 Manage Permission
                                                </a>
                                                
                                               
                                                <a href="<?= site_url('sitepanel/adminroles/delete/'.$role['id']) ?>" onclick="return confirm('Are you sure want to delete record?')">Delete</a>
                                                
                                                
                                            </div>
                                        </td>
                                        <?php } ?>
      
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            </div>      
                        
                    
                </div>
            </div>
        
        </div>
</div>
<!-- /main-content -->

<!-- Modal -->
<div class="modal fade" id="userListModal" tabindex="-1" aria-labelledby="userListModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Users in this Role</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="user-list-content">
        <!-- AJAX content goes here -->
        Loading...
      </div>
    </div>
  </div>
</div>




<?php $this->load->view('sitepanel/common/footer-new'); ?>


<script>
$(document).on('click', '.open-user-modal', function() {
    var roleId = $(this).data('role-id');
    $('#user-list-content').html('Loading...');
    $.get('<?= base_url("sitepanel/adminroles/ajax_users_by_role") ?>/' + roleId, function(data) {
        $('#user-list-content').html(data);
    });
});
</script>

    

</body>

</html>

