<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->
<div class="content">
    
    
    <div class="pageTitleSection">
        <div class="pageTitle_1">
            <button class="backButton" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                </svg> Back
            </button>
            <?=$heading?>
        </div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/adminroles')?>">Roles</a></li>
            <li class="breadcrumb-item active"><?=$heading?></li>
        </ol>
    </div>
    
    <!-- row  -->
    <div class="row">
        <div class="col-12 col-sm-12">
        <?php if ($this->session->flashdata('success')): ?>
            <div class="col-md-12">
                <div class="alert alert-success">
                <?php echo $this->session->flashdata('success'); ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="col-md-12">
                <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
                </div>
            </div>
        <?php endif; ?>
        
        </div>

    </div>

            
            <div class="col-12 col-sm-12">
            
                <div class="card">
                    <div class="card-body">
                    <div class="row"><div class="col-md-12"><a href="<?=base_url('sitepanel/adminroles')?>" class="btn btn-sm btn-light" style="float: right;">Back</a></div></div>


                    <form id="role-form" action="<?= base_url('sitepanel/adminroles/add') ?>" method="post" enctype="multipart/form-data">     
                    
                    <div class="row">
                        <div class="col-6">
                    <p>
                        Role Name: <input type="text" class="form-control" name="role_name" required>
                    </p>
                     </div>
                     </div>


                    <p>
                        Permissions:<br>

                        <?php foreach ($grouped_permissions as $group): ?>
                        <fieldset style="margin-bottom: 20px; padding: 10px; border: 1px solid #ccc;">
                            <legend style="font-size:1rem">
                                <strong><?= htmlspecialchars($group['group_name']) ?></strong>
                                &nbsp;
                                <label style="float: right;">
                                    <input type="checkbox" class="select-all-group" data-group="<?= $group['group_id'] ?>">
                                    Select All
                                </label>
                            </legend>

                            <?php foreach ($group['permissions'] as $perm): ?>
                                <label style="display: inline-block; width: 250px; margin-bottom: 5px;">
                                    <input type="checkbox" 
                                        name="permissions[]" 
                                        value="<?= $perm['id'] ?>" 
                                        class="group-checkbox-<?= $group['group_id'] ?>"
                                        <?= isset($assigned_permissions) && in_array($perm['id'], $assigned_permissions) ? 'checked' : '' ?>>
                                    <?= htmlspecialchars($perm['permission_name']) ?>
                                </label><br>
                            <?php endforeach; ?>
                        </fieldset>
                    <?php endforeach; ?>

                    </p>

                    <button class="btn save_btn" type="submit">Save Role</button>
                    <a href="<?=base_url('sitepanel/adminroles')?>" class="btn btn-default">Cancel</a>
                </form>



                    </div>
                </div>
            </div>

       

    
</div>
<!-- /main-content -->
<?php $this->load->view('sitepanel/common/footer-new'); ?>

<script>
$(function () {
    // Toggle all checkboxes in a group when Select All is clicked
    $('.select-all-group').on('change', function () {
        var groupId = $(this).data('group');
        var isChecked = $(this).is(':checked');
        $('.group-checkbox-' + groupId).prop('checked', isChecked);
    });

    // When any permission checkbox is changed, update the Select All
    $('[class^="group-checkbox-"]').on('change', function () {
        var checkbox = $(this);
        var groupClass = checkbox.attr('class').match(/group-checkbox-(\d+)/)[0];
        var groupId = groupClass.split('-')[2];

        var all = $('.' + groupClass);
        var allChecked = all.length === all.filter(':checked').length;

        $('.select-all-group[data-group="' + groupId + '"]').prop('checked', allChecked);
    });

    // On page load, auto-set Select All status
    $('.select-all-group').each(function () {
        var groupId = $(this).data('group');
        var checkboxes = $('.group-checkbox-' + groupId);
        var allChecked = checkboxes.length === checkboxes.filter(':checked').length;
        $(this).prop('checked', allChecked);
    });
});
</script>



