<?php

class Members extends Sitepanel_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('sitepanel/members_model'));
    //$this->config->set_item('menu_highlight', 'members management');
    $this->load->library('paginator');
  }

  public function index() {
    error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE); // added for not showing notice error in excel file upload;

    if(empty($this->session->userdata('admin_id'))){
        return redirect(base_url());
    }

     /* upload Bulk Excel */
     if ($this->input->post('action') == 'submit_excel') {
        
        $this->form_validation->set_rules('excel_file', 'Upload Excel File', 'callback_check_upload_excel');
        if ($this->form_validation->run() == TRUE) {

          require_once FCPATH . 'application/third_party/Excel/reader.php';
          $data = new Spreadsheet_Excel_Reader();
          $data->setOutputEncoding('CP1251');
  
          //$data->setUTFEncoder('');
          chmod($_FILES["excel_file"]["tmp_name"], 0777);
          $data->read($_FILES["excel_file"]["tmp_name"]);
          $worksheet = $data->sheets[0]['cells'];
  
          $process_add = $this->members_model->add_bulk_upload_users($worksheet);
          //echo "sss";
        
          if ($process_add === TRUE) {
            $this->session->set_userdata(array('msg_type' => 'success'));
            $this->session->set_flashdata('success', 'Excel file inserted successfully!!!');
            redirect('sitepanel/members', '');
          } else {
            $this->form_validation->_error_array['image'] = 'Uploading Failed. Please Try Again';
          }
        }
      }

    $get = $this->input->get();
    if(!empty($get['search'])){
        $get['search'] = $get['search'];
    }
    
    $total_row = $this->members_model->get_members($get,'count');
    $current_page = isset($get['page']) ? (int)$get['page'] : 1;
    $this->paginator->initialize(['base_url' => base_url('sitepanel/members'),'total_items' => $total_row,'current_page' => $current_page]);
    $get['limit'] = $this->paginator->limit_end; 
    $get['offset'] = $this->paginator->limit_start;
    
	  $data['pagelist'] = $this->members_model->get_members($get,$count=NULL);
    $data['pages'] = $get['offset'];
    $data['heading'] = 'Manage Manufacturers';

    $this->load->view('sitepanel/members/list_member_view', $data);
  }

  public function get_member_details($member_id){
    if(empty($member_id)){
      echo "Member ID not found";
      exit;
    }
    $res_data = $this->members_model->get_member_row($member_id);
    $data['heading'] = 'Member Details';
    $data['mres'] = $res_data;
    $this->load->view('sitepanel/members/view_member_detail_modal', $data);
  }


  public function get_member_login_history($member_id){
    if(empty($member_id)){
      echo "Member ID not found";
      exit;
    }
    $res_data = $this->db->query("select * from gm_ip_details where member_id = '" . $member_id . "' ")->result_array();
    $data['heading'] = 'Member Login History';
    $data['mres'] = $res_data;
    $this->load->view('sitepanel/members/view_member_login_history_modal', $data);
  }

  public function check_upload_excel() {
    $filearrext = array('xls');
    if ($_FILES['excel_file']['name'] == '') {
      $this->form_validation->set_message('check_upload_excel', 'Please upload excel file.');
      return FALSE;
    }
    if ($_FILES['excel_file']['name'] != '') {
      $extension = substr(strrchr($_FILES['excel_file']['name'], '.'), 1);
      if (!in_array($extension, $filearrext)) {
        $this->form_validation->set_message('check_upload_excel', 'Please upload (xls) file only.');
        return FALSE;
      } else {
        return TRUE;
      }
    }
  }

}

// End of controller