<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model(array('sitepanel/login_model'));
	  }

	public function index(){

		if ($this->session->userdata('admin_logged_in')) {
			return redirect('sitepanel/dashboard', 'refresh');
		}else{
			$data['heading_title'] = "Login";
			$this->load->view('sitepanel/login_view', $data);
		}
	}

	public function auth() {
		if (!empty($this->input->post('auth'))) {
		  $postdata = array(
			  'username' => $this->input->post('username',TRUE),
			  'password' => $this->input->post('password',TRUE),
			  'status' => '1'
		  );
	
		  $this->form_validation->set_rules('username', 'Username', 'trim|required');
		  $this->form_validation->set_rules('password', 'Password', 'trim|required');
	
		  if ($this->form_validation->run() == TRUE) {
				$this->login_model->check_admin_login($postdata);
				
				if ($this->session->userdata('admin_id') != "") {
					return redirect('sitepanel/dashboard', 'refresh');
				}else{			
					$this->session->set_flashdata('error', 'Incorrect username or password');
					return redirect('sitepanel/login');	
				  }
		  } else {
			$this->index();
		  }
		} else {
		  return redirect('sitepanel/login');
		}
	  }

	  public function logout() {
		$this->session->unset_userdata(array(
			'admin_name',
			'admin_username', 
			'admin_role_id', 
			'admin_id', 
			'permissions', 
			'admin_logged_in'
		));
		$this->session->sess_destroy();
		return redirect('sitepanel/login', 'refresh');
	}
	


}
