<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Category extends Sitepanel_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('sitepanel/category_model'));
    $this->load->library('paginator');
  }

  public function index($parent_id=0) {

    if (!has_permission('category_view')) {
        redirect('sitepanel/errorpage/error403');
    }

    if(empty($this->session->userdata('admin_id'))){
        return redirect(base_url());
    }

    $get = $this->input->get();
    if(!empty($get['search'])){
        $get['search'] = $get['search'];
    }
    
    if(!empty($get['status'])){
        $get['status'] = $get['status'];
    }

    /*$status_search = $this->input->get('status_search');
    if(!empty($status_search)){
      $get['status_search'] = $status_search;
    }*/
    
    $total_row = $this->category_model->get_category($parent_id,$get,'count');
    $current_page = isset($get['page']) ? (int)$get['page'] : 1;
    $this->paginator->initialize(['base_url' => base_url('sitepanel/category/index/'.$parent_id),'total_items' => $total_row,'current_page' => $current_page]);
    $get['limit'] = $this->paginator->limit_end; 
    $get['offset'] = $this->paginator->limit_start;
    
	$data['pagelist'] = $this->category_model->get_category($parent_id,$get,$count=NULL);
    $data['pages'] = $get['offset'];
    $data['heading'] = 'Manage Categories';
    $data['breadcrumb'] = get_category_breadcrumb($parent_id, $this->db);
    $data['counts'] = $this->category_model->get_category_counts();

    $this->load->view('sitepanel/category/list_category_view', $data);
  }
  
  
  public function inactive($parent_id=0) {
     

    if (!has_permission('category_inactive')) {
        redirect('sitepanel/errorpage/error403');
    }

    if(empty($this->session->userdata('admin_id'))){
        return redirect(base_url());
    }

    $get = $this->input->get();
    if(!empty($get['search'])){
        $get['search'] = $get['search'];
    }
    
    if(!empty($get['status'])){
        $get['status'] = $get['status'];
    }

    /*$status_search = $this->input->get('status_search');
    if(!empty($status_search)){
      $get['status_search'] = $status_search;
    }*/
    
    $total_row = $this->category_model->inactive_category($parent_id,$get,'count');
    $current_page = isset($get['page']) ? (int)$get['page'] : 1;
    $this->paginator->initialize(['base_url' => base_url('sitepanel/category/deleted/'.$parent_id),'total_items' => $total_row,'current_page' => $current_page]);
    $get['limit'] = $this->paginator->limit_end; 
    $get['offset'] = $this->paginator->limit_start;
    
	$data['pagelist'] = $this->category_model->inactive_category($parent_id,$get,$count=NULL);
    $data['pages'] = $get['offset'];
    $data['heading'] = 'Deleted Categories';
    $data['breadcrumb'] = get_category_breadcrumb($parent_id, $this->db);
    $data['counts'] = $this->category_model->get_category_counts();

    $this->load->view('sitepanel/category/inactive_category_view', $data);
  }
  
  
  public function deleted($parent_id=0) {
     

    if (!has_permission('category_deleted')) {
        redirect('sitepanel/errorpage/error403');
    }

    if(empty($this->session->userdata('admin_id'))){
        return redirect(base_url());
    }

    $get = $this->input->get();
    if(!empty($get['search'])){
        $get['search'] = $get['search'];
    }
    
    if(!empty($get['status'])){
        $get['status'] = $get['status'];
    }

    /*$status_search = $this->input->get('status_search');
    if(!empty($status_search)){
      $get['status_search'] = $status_search;
    }*/
    
    $total_row = $this->category_model->deleted_category($parent_id,$get,'count');
    $current_page = isset($get['page']) ? (int)$get['page'] : 1;
    $this->paginator->initialize(['base_url' => base_url('sitepanel/category/deleted/'.$parent_id),'total_items' => $total_row,'current_page' => $current_page]);
    $get['limit'] = $this->paginator->limit_end; 
    $get['offset'] = $this->paginator->limit_start;
    
	$data['pagelist'] = $this->category_model->deleted_category($parent_id,$get,$count=NULL);
    $data['pages'] = $get['offset'];
    $data['heading'] = 'Deleted Categories';
    $data['breadcrumb'] = get_category_breadcrumb($parent_id, $this->db);
    $data['counts'] = $this->category_model->get_category_counts();

    $this->load->view('sitepanel/category/deleted_category_view', $data);
  }

  public function add($parent_id){

     if (!has_permission('category_add')) {
        redirect('sitepanel/errorpage/error403');
      }

    if (!is_numeric($parent_id) || (int)$parent_id < 0) {
      $this->session->set_flashdata('error', 'Invalid parent ID');
      redirect('sitepanel/category');
      return;
    }

    $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

   if(!empty($this->input->post())){
      
      $category_name = $this->db->escape_str($this->input->post('category_name'));
      $category_alt = $this->input->post('category_alt');
      $page_url = strtolower(url_title($category_name, '-', TRUE));

      if ($category_alt == '') {
        $category_alt = $this->input->post('category_name');
      }
      $category_description = $this->input->post('category_description');
      $parent_id = applyFilter('NUMERIC_GT_ZERO', $parent_id);

      $this->form_validation->set_rules('category_name', 'Category Name', [
        'trim', 'required', 'max_length[100]',
        [
            'unique_category_check',
            function ($category_name) {
                $CI = &get_instance(); 
                $exists = $CI->db->where('category_name', $category_name)
                                 ->where('status !=', '2')
                                 ->get('gm_categories')->row();
                return !$exists;
            }
        ]
      ]);
      $this->form_validation->set_message('unique_category_check', 'This category name already exists.');
      $this->form_validation->set_rules('category_description', 'Description', "max_length[6000]");
      $this->form_validation->set_rules('category_alt', 'Alt', "trim|max_length[100]");

        $upload_error = false;
        $uploaded_icon = '';
        $uploaded_file = '';
        $category_image_thumb = '';

        if (!empty($_FILES['category_image']['name'])) {
          $random_code = substr(md5(uniqid(mt_rand(), true)), 0, 10);
          $ext = pathinfo($_FILES['category_image']['name'], PATHINFO_EXTENSION);
          $new_filename_img = $page_url . '_' . $random_code . '.' . $ext;

          $config['upload_path']   =  UPLOAD_DIR . '/category/';
          $config['allowed_types'] = 'gif|jpg|jpeg|png|webp';
          $config['max_size']      = 4096; // in KB
          $config['max_width']     = 3000;
          $config['max_height']    = 3000;
          $config['file_name']     = $new_filename_img; 
          //$config['encrypt_name']  = TRUE;
      
          $this->load->library('upload', $config);
      
          if ($this->upload->do_upload('category_image')) {
              $uploaded_file = $this->upload->data('file_name');

              $source_path = $this->upload->data('full_path'); 
              $thumb_dir   = UPLOAD_DIR . '/category/thumb-cache/'; 
              $category_image_thumb  = create_thumbnail($source_path, $thumb_dir, 75, 75, $page_url);


          } else {
              $upload_error = true;
              //$this->session->set_flashdata('error', $this->upload->display_errors());
              $data['category_image_error'] = $this->upload->display_errors();
              //redirect(current_url());
          }
      }

      if (!empty($_FILES['category_icon']['name'])) {

        $random_code = substr(md5(uniqid(mt_rand(), true)), 0, 10);
        $ext = pathinfo($_FILES['category_icon']['name'], PATHINFO_EXTENSION);
        $new_filename_icon = $page_url . '_' . $random_code . '.' . $ext;

        $config['upload_path']   =  UPLOAD_DIR . '/category/';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|webp';
        $config['max_size']      = 100; // in KB
        $config['max_width']     = 100;
        $config['max_height']    = 100;
        $config['file_name']     = $new_filename_icon;
        //$config['encrypt_name']  = TRUE;
    
        $this->load->library('upload', $config);
    
        if ($this->upload->do_upload('category_icon')) {

           /* $upload_data = $this->upload->data();
           $img_width  = $upload_data['image_width'];
           $img_height = $upload_data['image_height'];

           if ($img_width > 56 || $img_height > 56) {
            $resize_config['image_library']  = 'gd2';
            $resize_config['source_image']   = $upload_data['full_path'];
            $resize_config['maintain_ratio'] = TRUE;
            $resize_config['width']          = 56;
            $resize_config['height']         = 56;
    
            $this->load->library('image_lib', $resize_config);
            $this->image_lib->initialize($resize_config);
    
            if (!$this->image_lib->resize()) {
                $upload_error = true;
                $this->session->set_flashdata('category_icon_error', $this->image_lib->display_errors());
              }
            } */

            $uploaded_icon = $this->upload->data('file_name');
        } else {
            $upload_error = true;
            //$this->session->set_flashdata('error', $this->upload->display_errors());
            $data['category_icon_error'] = $this->upload->display_errors();
            //redirect(current_url());
        }
    }

      $posted_data = array(
        'category_name' => $this->input->post('category_name'),
        'category_alt' => $category_alt,
        'category_short_desc' => $this->input->post('category_short_desc'),
        'category_description' => $category_description,
        'parent_id' => $parent_id,
        'friendly_url' => $page_url,
        'date_added' => date('Y-m-d H:i:s'),
        'category_image' => $uploaded_file,
        'category_image_thumb' => $category_image_thumb,
        'category_icon' => $uploaded_icon,
        'status' => $this->input->post('status')
      );

      if ($this->form_validation->run() === TRUE && !$upload_error) {

      $this->db->trans_start(); 

      $this->db->insert('gm_categories', $posted_data);
      $insertId = $this->db->insert_id();
      if ($insertId > 0) {

        $seo_data = array(
          'page_url' => $page_url,
          'entity_type' => 'category',
          'entity_id' => $insertId,
          'meta_title' => $this->input->post('meta_title'),
          'meta_description' => $this->input->post('meta_desc'),
          'meta_keyword' => $this->input->post('meta_keyword'),
          'created_at' => date('Y-m-d H:i:s')
      );
      $this->db->insert('gm_seo_urls', $seo_data);
      }
      $this->db->trans_complete(); 

      if ($this->db->trans_status() === FALSE) {
          $this->session->set_flashdata('error', 'Something went wrong. Please try again.');
          redirect(current_url());
      } else {
          
           $action = $this->input->post('submit');
            if ($action === 'save') {
                $this->session->set_flashdata('success', 'Category saved successfully.');
                redirect('sitepanel/category/add/'.$parent_id);
            } elseif ($action === 'save_new') {
                $this->session->set_flashdata('success', 'Category saved. Add another one.');
                redirect('sitepanel/category/add/'.$parent_id);
            } elseif ($action === 'save_close') {
                $this->session->set_flashdata('success', 'Category saved successfully.');
                redirect('sitepanel/category/index/' . $parent_id . $query_string);
            } else {
                redirect('sitepanel/category/index/' . $parent_id . $query_string);
            }
        
          /*$this->session->set_flashdata('success', 'Category added successfully.');
          redirect('sitepanel/category/index/' . $parent_id . $query_string);*/
      }

    }
  }

    $data['heading'] = 'Add Category'; 
    $data['parent_id'] = $parent_id;
    $data['query_string'] = $_SERVER['QUERY_STRING'];
    $this->load->view('sitepanel/category/add_category_view', $data);
  }




  public function edit($rowid=0,$parent_id=0){

    if (!has_permission('category_edit')) {
        redirect('sitepanel/errorpage/error403');
      //show_error('You do not have permission to perform this action.', 403);
    }
   
    if($rowid == '' || (int) $rowid == 0  || $parent_id == '' || (int) $parent_id < 0){  
      $this->session->set_flashdata('error', 'Invalid record');
      redirect('sitepanel/category');
      return;
    }
    $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

    if(!empty($this->input->post())){

      $category_name = $this->db->escape_str($this->input->post('category_name'));
      $category_alt = $this->input->post('category_alt');
      $page_url = strtolower(url_title($category_name, '-', TRUE));

      if ($category_alt == '') {
        $category_alt = $this->input->post('category_name');
      }
      $category_description = $this->input->post('category_description');
      $parent_id = applyFilter('NUMERIC_GT_ZERO', $parent_id);

      $this->form_validation->set_rules('category_name', 'Category Name', [
        'trim', 'required', 'max_length[100]',
        [
            'unique_category_check',
            function ($category_name) use ($rowid) {
                $CI = &get_instance();
                $CI->db->where('category_name', $category_name)
                       ->where('status !=', '2')
                       ->where('category_id !=', $rowid); // Exclude current row
                $exists = $CI->db->get('gm_categories')->row();
                return !$exists;
            }
        ]
    ]);
    
      $this->form_validation->set_message('unique_category_check', 'This category name already exists.');


      $this->form_validation->set_rules('category_description', 'Description', "max_length[6000]");
      $this->form_validation->set_rules('category_alt', 'Alt', "trim|max_length[100]");


      $upload_error = false;
      $uploaded_icon = '';
      $uploaded_file = '';

      $category_image_thumb = $this->input->post('hcategory_image_thumb'); 

      if (!empty($_FILES['category_image']['name'])) {

        $old_image = $this->input->post('hcategory_image');
        $old_thumb = $this->input->post('hcategory_image_thumb');

        $image_path = UPLOAD_DIR . '/category/' . $old_image;
        $thumb_path = UPLOAD_DIR . '/category/thumb-cache/' . $old_thumb;

        if (!empty($old_image) && file_exists($image_path)) {
            @unlink($image_path);
        }
        if (!empty($old_thumb) && file_exists($thumb_path)) {
            @unlink($thumb_path);
        }


        $random_code = substr(md5(uniqid(mt_rand(), true)), 0, 10);
        $ext = pathinfo($_FILES['category_image']['name'], PATHINFO_EXTENSION);
        $new_filename_img = $page_url . '_' . $random_code . '.' . $ext;

        $config['upload_path']   =  UPLOAD_DIR . '/category/';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|webp';
        $config['max_size']      = 4096; // in KB
        $config['max_width']     = 3000;
        $config['max_height']    = 3000;
        $config['file_name']     = $new_filename_img; 
        //$config['encrypt_name']  = TRUE;
    
        $this->load->library('upload', $config);
    
        if ($this->upload->do_upload('category_image')) {
            $uploaded_file = $this->upload->data('file_name');

            $source_path = $this->upload->data('full_path'); // Original uploaded image full path
            $thumb_dir   = UPLOAD_DIR . '/category/thumb-cache/'; // Folder only
            $category_image_thumb  = create_thumbnail($source_path, $thumb_dir, 75, 75, $page_url);


        } else {
            $upload_error = true;
            $data['category_image_error'] = $this->upload->display_errors();
        }
      }else{
        $uploaded_file = $this->input->post('hcategory_image');
      }


      if (!empty($_FILES['category_icon']['name'])) {

        $old_icon = $this->input->post('hcategory_icon');
        $icon_path = UPLOAD_DIR . '/category/' . $old_icon;

        if (!empty($old_icon) && file_exists($icon_path)) {
            @unlink($icon_path);
        }

        $random_code = substr(md5(uniqid(mt_rand(), true)), 0, 10);
        $ext = pathinfo($_FILES['category_icon']['name'], PATHINFO_EXTENSION);
        $new_filename_icon = $page_url . '_' . $random_code . '.' . $ext;

        $config['upload_path']   =  UPLOAD_DIR . '/category/';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|webp';
        $config['max_size']      = 100; // in KB
        $config['max_width']     = 100;
        $config['max_height']    = 100;
        $config['file_name']     = $new_filename_icon;
        //$config['encrypt_name']  = TRUE;
    
        $this->load->library('upload', $config);
    
        if ($this->upload->do_upload('category_icon')) {

            $uploaded_icon = $this->upload->data('file_name');
        } else {
            $upload_error = true;
            $data['category_icon_error'] = $this->upload->display_errors();
        }
      }else{
        $uploaded_icon = $this->input->post('hcategory_icon');
      }


    $posted_data = array(
      'category_name' => $this->input->post('category_name'),
      'category_alt' => $category_alt,
      'category_short_desc' => $this->input->post('category_short_desc'),
      'category_description' => $category_description,
      'parent_id' => $parent_id,
      'friendly_url' => $page_url,
      'date_modified' => date('Y-m-d H:i:s'),
      'category_image' => $uploaded_file,
      'category_image_thumb' => $category_image_thumb,
      'category_icon' => $uploaded_icon,
      'status' => $this->input->post('status')
    );

    
    if ($this->form_validation->run() === TRUE && !$upload_error) {

      $this->db->trans_start(); 

      $this->db->update('gm_categories', $posted_data,['category_id'=>$rowid]);
      
      if ($this->db->affected_rows()) {
        $seo_data = array(
          'page_url' => $page_url,
          'entity_type' => 'category',
          'entity_id' => $rowid,
          'meta_title' => $this->input->post('meta_title'),
          'meta_description' => $this->input->post('meta_desc'),
          'meta_keyword' => $this->input->post('meta_keyword'),
          'created_at' => date('Y-m-d H:i:s')
        );
        $this->db->update('gm_seo_urls', $seo_data,['entity_id'=>$rowid,'entity_type' => 'category']);
      }
      $this->db->trans_complete(); 

      if ($this->db->trans_status() === FALSE) {
          $this->session->set_flashdata('error', 'Something went wrong. Please try again.');
          redirect(current_url());
      } else {
          $this->session->set_flashdata('success', 'Category updated successfully.');
          redirect('sitepanel/category/index/'.$parent_id.$query_string);
      }

    }


    }

    $this->db->select('c.*, s.page_url, s.meta_title, s.meta_description, s.meta_keyword');
    $this->db->from('gm_categories c');
    $this->db->join('gm_seo_urls s', "s.entity_id = c.category_id AND s.entity_type = 'category'", 'left');
    $this->db->where('c.category_id', $rowid);
    $category_data = $this->db->get()->row_array();
    $data['res'] = $category_data;

    $data['heading'] = 'Edit Category'; 
    $data['rowid'] = $rowid;
    $data['parent_id'] = $parent_id;
    $data['query_string'] = $_SERVER['QUERY_STRING'];
    $this->load->view('sitepanel/category/edit_category_view', $data);

  }

  public function generate_slug() {
    $category_name = $this->input->post('category_name');
    $slug = strtolower(url_title($category_name, '-', TRUE));
    echo json_encode(['slug' => $slug]);
  }


  public function bulk_action() {
    $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';
    $parent_id = $this->input->post('parent_id');

    $action = $this->input->post('bulk_action');
    $ids = $this->input->post('category_ids');
    $sort_orders = $this->input->post('sort_order');
  
    if ($action === 'update_order') {
      if (!empty($sort_orders)) {
        foreach ($sort_orders as $id => $order) {
          $this->db->update('gm_categories', ['sort_order' => (int)$order], ['category_id' => (int)$id]);
        }
        $this->session->set_flashdata('success', 'Order updated successfully.');
      } else {
        $this->session->set_flashdata('error', 'No order values found.');
      }
      redirect('sitepanel/category/index/'.$parent_id.$query_string);
      return;
    }
  
    // For other actions, checkboxes must be selected
    if (empty($ids)) {
      $this->session->set_flashdata('error', 'No categories selected.');
      redirect('sitepanel/category/index/'.$parent_id.$query_string);
      return;
    }
  
    switch ($action) {
      case 'activate':
        $this->db->where_in('category_id', $ids)->update('gm_categories', ['status' => '1']);
        break;
      case 'deactivate':
        $this->db->where_in('category_id', $ids)->update('gm_categories', ['status' => '0']);
        break; 
      case 'featured':
        $this->db->where_in('category_id', $ids)->update('gm_categories', ['is_featured' => '1']);
        break;
      case 'unfeatured':
        $this->db->where_in('category_id', $ids)->update('gm_categories', ['is_featured' => '0']);
        break;
      case 'delete':
        if (!has_permission('category_delete')) {
          redirect('sitepanel/errorpage/error403');
        }
        $this->db->where_in('category_id', $ids)->update('gm_categories', ['status' => '2']);
        break;
    }
  
    $this->session->set_flashdata('success', 'Action applied successfully.');
    redirect('sitepanel/category/index/'.$parent_id.$query_string);
  }
  
  
  public function restore(){
        $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';
        $parent_id = $this->input->post('parent_id');
    
        $action = $this->input->post('bulk_action');
        $ids = $this->input->post('category_ids');
        
        switch ($action) {
          case 'restore':
            $this->db->where_in('category_id', $ids)->update('gm_categories', ['status' => '1']);
            break;
        }
      
        $this->session->set_flashdata('success', 'Action applied successfully.');
        redirect('sitepanel/category/deleted/'.$parent_id.$query_string);
      
  }
  
  public function activate(){
        $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';
        $parent_id = $this->input->post('parent_id');
    
        $action = $this->input->post('bulk_action');
        $ids = $this->input->post('category_ids');
        
        switch ($action) {
          case 'restore':
            $this->db->where_in('category_id', $ids)->update('gm_categories', ['status' => '1']);
            break;
        }
      
        $this->session->set_flashdata('success', 'Action applied successfully.');
        redirect('sitepanel/category/inactive/'.$parent_id.$query_string);
      
  }
  


  public function remove_image() {
    $category_id = (int) $this->input->post('category_id');
    $image_type = $this->input->post('image_type');
  
    $valid_types = ['category_image', 'category_icon'];
    if (!$category_id || !in_array($image_type, $valid_types)) {
      echo json_encode(['status' => 'error']);
      return;
    }
  
    $row = $this->db->get_where('gm_categories', ['category_id' => $category_id])->row();
    if (!$row || empty($row->$image_type)) {
      echo json_encode(['status' => 'error']);
      return;
    }
  
    $image_path = UPLOAD_DIR . '/category/' . $row->$image_type;
    if (file_exists($image_path)) {
      unlink($image_path);
    }
  
    if ($image_type == 'category_image' && !empty($row->category_image_thumb)) {
      $thumb_path = UPLOAD_DIR . '/category/thumb-cache/' . $row->category_image_thumb;
      if (file_exists($thumb_path)) {
        unlink($thumb_path);
      }
      $this->db->update('gm_categories', [
        'category_image' => '',
        'category_image_thumb' => ''
      ], ['category_id' => $category_id]);
    } else {
      $this->db->update('gm_categories', [
        $image_type => ''
      ], ['category_id' => $category_id]);
    }
  
    echo json_encode(['status' => 'success']);
  }
  
  

}
?>