<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Adminroles extends CI_Controller {

    public function __construct() {
        parent::__construct();
        add_breadcrumb('Dashboard', site_url('sitepanel'));
        //add_breadcrumb('Admin Roles', site_url('sitepanel/adminroles'));
        $this->load->helper(['url', 'form']);
        $this->load->library('session');
    }

    public function index() {
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }
        add_breadcrumb('Manage Roles');
        $data['heading'] = 'Manage Roles';
        //$data['roles'] = $this->db->get('gm_admin_roles')->result_array();

        $data['roles'] = $this->db->select('r.*, COUNT(u.admin_id) as user_count')
        ->from('gm_admin_roles r')
        ->join('gm_admin_users u', 'r.id = u.role_id', 'left')
        ->group_by('r.id')
        ->get()
        ->result_array();

        $this->load->view('sitepanel/adminroles/list_role_view', $data);
    }

    public function add() {
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }

        add_breadcrumb('Add Role');
        if ($this->input->post()) {
            $role_name = $this->input->post('role_name');
            $permissions = $this->input->post('permissions');

            // Insert role
            $this->db->insert('gm_admin_roles', ['role_name' => $role_name]);
            $role_id = $this->db->insert_id();

            // Insert permissions
            if (!empty($permissions)) {
                $insert_data = [];
                foreach ($permissions as $permission_id) {
                    $insert_data[] = [
                        'role_id' => $role_id,
                        'permission_id' => $permission_id
                    ];
                }
                if (!empty($insert_data)) {
                    $this->db->insert_batch('gm_admin_role_permissions', $insert_data);
                }
            }

            $this->session->set_flashdata('success', 'Role created successfully.');
            redirect('sitepanel/adminroles');
        } else {
            // Load grouped permissions
            $data['grouped_permissions'] = $this->get_grouped_permissions();
            $data['heading'] = 'Add New Role';
            $this->load->view('sitepanel/adminroles/add_role_view', $data);
        }
    }

    public function edit($id) {
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }
        add_breadcrumb('Edit Role');
        $role = $this->db->get_where('gm_admin_roles', ['id' => $id])->row_array();
        if (empty($role)) {
            show_404();
        }

        if ($this->input->post()) {
            $role_name = $this->input->post('role_name');
            $permissions = $this->input->post('permissions');

            // Update role name + permission_last_updated
            $this->db->where('id', $id)->update('gm_admin_roles', [
                'role_name' => $role_name,
                'permission_last_updated' => date('Y-m-d H:i:s')
            ]);

            // Update permissions
            $this->db->where('role_id', $id)->delete('gm_admin_role_permissions');
            if (!empty($permissions)) {
                $insert_data = [];
                foreach ($permissions as $permission_id) {
                    $insert_data[] = [
                        'role_id' => $id,
                        'permission_id' => $permission_id
                    ];
                }
                if (!empty($insert_data)) {
                    $this->db->insert_batch('gm_admin_role_permissions', $insert_data);
                }
            }

            $this->session->set_flashdata('success', 'Role updated successfully.');

            if($this->input->post('ref') == 'user'){
                return redirect('sitepanel/admin'); 
            } 
            redirect('sitepanel/adminroles');         
        } 

        $data['role'] = $role;
        $data['id'] = $id;
        $data['grouped_permissions'] = $this->get_grouped_permissions();

        $data['assigned_permissions'] = array_column(
            $this->db->select('permission_id')->get_where('gm_admin_role_permissions', ['role_id' => $id])->result_array(),
            'permission_id'
        );
        $data['heading'] = 'Manage Permissions';
        $this->load->view('sitepanel/adminroles/edit_role_view', $data);
        
    }

    public function delete($id) {
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }
        $this->db->where('id', $id)->delete('gm_admin_roles');
        $this->db->where('role_id', $id)->delete('gm_admin_role_permissions');
        $this->session->set_flashdata('success', 'Role deleted successfully.');
        redirect('sitepanel/adminroles');
    }

   
    private function get_grouped_permissions() {
        // Fetch all permission groups
        $groups = $this->db->order_by('id', 'ASC')->get('gm_admin_permission_groups')->result_array();

        $grouped_permissions = [];

        foreach ($groups as $group) {
            $permissions = $this->db->order_by('id', 'ASC')
                ->get_where('gm_admin_permissions', ['group_id' => $group['id']])
                ->result_array();
            
            if (!empty($permissions)) {
                $grouped_permissions[] = [
                    'group_id' => $group['id'],
                    'group_name' => $group['group_name'],
                    'permissions' => $permissions
                ];
            }
        }

        return $grouped_permissions;
    }


    public function permissions() {

        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }

        add_breadcrumb('Manage Permission');
        $search = $this->input->get('search');
        $group_id = $this->input->get('group_id');
    
        $this->db->select('p.*, g.group_name')
                 ->from('gm_admin_permissions p')
                 ->join('gm_admin_permission_groups g', 'g.id = p.group_id', 'left');
    
        if (!empty($search)) {
            $this->db->like('p.permission_name', $search);
            $this->db->or_like('p.permission_key', $search);
        }
    
        if (!empty($group_id)) {
            $this->db->where('p.group_id', $group_id);
        }
    
        $this->db->order_by('g.id, p.id');
        $result = $this->db->get()->result_array();
    
        // Group by group_name
        $grouped_permissions = [];
        foreach ($result as $perm) {
            $group_key = $perm['group_name'] ?: 'Ungrouped';
            $grouped_permissions[$group_key][] = $perm;
        }
    
        $data['grouped_permissions'] = $grouped_permissions;
        $data['all_groups'] = $this->db->get('gm_admin_permission_groups')->result_array();
        $data['heading'] = 'Manage Permissions';
        $this->load->view('sitepanel/adminroles/permissions/list_permission_view', $data);
    }
    
    


    public function add_permission() {
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }

        add_breadcrumb('Add Permission');
        if ($this->input->post()) {
            $name = trim($this->input->post('permission_name'));
            $key = trim($this->input->post('permission_key'));
            $group_id = $this->input->post('group_id');
    
            // Check case-insensitive duplicate permission_name
            $this->db->where('LOWER(permission_name)', strtolower($name));
            if ($this->db->get('gm_admin_permissions')->num_rows() > 0) {
                $this->session->set_flashdata('error', 'Permission name already exists (case-insensitive check).');
                redirect('sitepanel/adminroles/permissions/add');
            }
    
            // Check case-insensitive duplicate permission_key
            $this->db->where('LOWER(permission_key)', strtolower($key));
            if ($this->db->get('gm_admin_permissions')->num_rows() > 0) {
                $this->session->set_flashdata('error', 'Permission key already exists (case-insensitive check).');
                redirect('sitepanel/adminroles/permissions/add');
            }
    
            // Proceed with insert
            $this->db->insert('gm_admin_permissions', [
                'permission_name' => $name,
                'permission_key' => $key,
                'group_id' => $group_id
            ]);
    
            $this->session->set_flashdata('success', 'Permission added successfully.');
            redirect('sitepanel/adminroles/permissions');
        } else {
            $data['groups'] = $this->db->get('gm_admin_permission_groups')->result_array();
            $data['heading'] = 'Add Permissions';
            $this->load->view('sitepanel/adminroles/permissions/add_permission_view', $data);
        }
    }
    

    public function edit_permission($id) {
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }
        add_breadcrumb('Edit Permission');
        $permission = $this->db->get_where('gm_admin_permissions', ['id' => $id])->row_array();
        if (!$permission) {
            show_404();
        }
    
        if ($this->input->post()) {
            $name = trim($this->input->post('permission_name'));
            $key = trim($this->input->post('permission_key'));
            $group_id = $this->input->post('group_id');
    
            // Check case-insensitive duplicate permission_name
            $this->db->where('LOWER(permission_name)', strtolower($name));
            $this->db->where('id !=', $id);
            if ($this->db->get('gm_admin_permissions')->num_rows() > 0) {
                $this->session->set_flashdata('error', 'Permission name already exists (case-insensitive check).');
                redirect('sitepanel/adminroles/permissions/edit/' . $id);
            }
    
            // Check case-insensitive duplicate permission_key
            $this->db->where('LOWER(permission_key)', strtolower($key));
            $this->db->where('id !=', $id);
            if ($this->db->get('gm_admin_permissions')->num_rows() > 0) {
                $this->session->set_flashdata('error', 'Permission key already exists (case-insensitive check).');
                redirect('sitepanel/adminroles/permissions/edit/' . $id);
            }
    
            // Proceed with update
            $this->db->where('id', $id)->update('gm_admin_permissions', [
                'permission_name' => $name,
                'permission_key' => $key,
                'group_id' => $group_id
            ]);
    
            $this->session->set_flashdata('success', 'Permission updated successfully.');
            redirect('sitepanel/adminroles/permissions');
        } else {
            $data['permission'] = $permission;
            $data['groups'] = $this->db->get('gm_admin_permission_groups')->result_array();
            $data['heading'] = 'Edit Permission';
            $this->load->view('sitepanel/adminroles/permissions/edit_permission_view', $data);
        }
    }
    
    

    public function delete_permission($id) {
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }
        $this->db->where('id', $id)->delete('gm_admin_permissions');
        $this->session->set_flashdata('success', 'Permission deleted.');
        redirect('sitepanel/adminroles/permissions');
    }


    public function ajax_add_group(){
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }

        $group_name = trim($this->input->post('group_name'));

        if (empty($group_name)) {
            echo json_encode(['success' => false, 'message' => 'Group name is required.']);
            return;
        }

        // Case-insensitive duplicate check
        $this->db->where('LOWER(group_name)', strtolower($group_name));
        $exists = $this->db->get('gm_admin_permission_groups')->num_rows();

        if ($exists > 0) {
            echo json_encode(['success' => false, 'message' => 'Group name already exists.']);
            return;
        }

        $insert_data = [
            'group_name' => $group_name,
            'created_at' => date('Y-m-d H:i:s'),
        ];
        $this->db->insert('gm_admin_permission_groups', $insert_data);

        if ($this->db->affected_rows() > 0) {
            $group_id = $this->db->insert_id();
            echo json_encode([
                'success' => true,
                'group' => [
                    'id' => $group_id,
                    'group_name' => $group_name
                ]
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to add group.']);
        }
    }

    public function permission_group() {

        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }

        add_breadcrumb('Permission Groups');
        $data['groups'] = $this->db->order_by('id')->get('gm_admin_permission_groups')->result_array();
        $data['heading'] = 'Manage Permission Groups';
        $this->load->view('sitepanel/adminroles/permissions/list_permission_group_view', $data);
    }

    public function add_permission_group() {

        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        } 

        add_breadcrumb('Permission Groups', site_url('sitepanel/adminroles/permission_group'));
        add_breadcrumb('Add Permission Group');

        if ($this->input->post()) {
            $group_name = trim($this->input->post('group_name'));

            // Case-insensitive check
            $exists = $this->db->select('id')->where('LOWER(group_name)', strtolower($group_name))->get('gm_admin_permission_groups')->row();
            if ($exists) {
                $data['error'] = 'Group name already exists.';
            } else {
                $this->db->insert('gm_admin_permission_groups', ['group_name' => $group_name]);
                $this->session->set_flashdata('success', 'Group added successfully.');
                redirect('sitepanel/adminroles/permission_group');
            }
        }
        $data['heading'] = 'Add Permission Group';
        $this->load->view('sitepanel/adminroles/permissions/permission_group_view', $data);
    }

    public function edit_permission_group($id) {

        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }

        add_breadcrumb('Permission Groups', site_url('sitepanel/adminroles/permission_group'));
        add_breadcrumb('Edit Permission Group');
        $group = $this->db->get_where('gm_admin_permission_groups', ['id' => $id])->row_array();
        if (!$group) show_404();

        if ($this->input->post()) {
            $group_name = trim($this->input->post('group_name'));
            $exists = $this->db
                ->select('id')
                ->where('LOWER(group_name)', strtolower($group_name))
                ->where('id !=', $id)
                ->get('gm_admin_permission_groups')
                ->row();

            if ($exists) {
                $data['error'] = 'Group name already exists.';
            } else {
                $this->db->where('id', $id)->update('gm_admin_permission_groups', ['group_name' => $group_name]);
                $this->session->set_flashdata('success', 'Group updated successfully.');
                redirect('sitepanel/adminroles/permission_group');
            }
        }

        $data['group'] = $group;
        $data['heading'] = 'Edit Permission Group';
        $this->load->view('sitepanel/adminroles/permissions/permission_group_view', $data);
    }

    public function delete_permission_group($id) {

        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }
        
        $used = $this->db->get_where('gm_admin_permissions', ['group_id' => $id])->num_rows();
        if ($used > 0) {
            $this->session->set_flashdata('error', 'Group is assigned to permissions and cannot be deleted.');
        } else {
            $this->db->where('id', $id)->delete('gm_admin_permission_groups');
            $this->session->set_flashdata('success', 'Group deleted successfully.');
        }
        redirect('sitepanel/adminroles/permission_group');
    }



    public function ajax_users_by_role($role_id = 0) {
    $users = $this->db->where('role_id', (int)$role_id)->get('gm_admin_users')->result_array();

    if (empty($users)) {
        echo '<p>No users found under this role.</p>';
        return;
    }

    echo '<table class="table table-striped"><thead><tr><th>Name</th><th>Username</th><th>Designation</th></tr></thead><tbody>';
    foreach ($users as $user) {
        echo '<tr>';
        echo '<td>' . html_escape($user['admin_name']) . '</td>';
        echo '<td>' . html_escape($user['username']) . '</td>';
        echo '<td>' . html_escape($user['designation']) . '</td>';
        echo '</tr>';
    }
    echo '</tbody></table>';
}

       
    
}
?>