<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Login</title>
    <link rel="icon" href="<?=base_url('assets/sitepanel/')?>gmdesigner/images/favicon.ico">
    <link rel="stylesheet" type="text/css" href="<?=base_url('assets/sitepanel/')?>gmdesigner/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="<?=base_url('assets/sitepanel/')?>gmdesigner/css/custom.css">
</head>

<body>
    <style>
        .form-error p {
            color: red;
            font-size: 13px;
        }
    </style>
    <div class="page-section">
        <div class="page-decoration-1"></div>
        <div class="page-decoration-2"></div>
        <div class="page-decoration-3"></div>
        <div class="full-width-screen">
            <div class="container-fluid login-page">
                <div class="content-detail">
                        <?php if ($this->session->flashdata('error')): ?>
                            <div class="alert alert-danger">
                                <?php echo $this->session->flashdata('error'); ?>
                            </div>
                        <?php endif; ?>
                    <form method="post" action="<?=base_url('sitepanel/login/auth')?>">
                        <div class="signin_box">
                            <div class="form-group">
                                <div class="logo">
                                    <img src="<?=base_url('assets/sitepanel/')?>gmdesigner/images/logo.png" alt="Get Manufacturers" title="Get Manufacturers">
                                </div>
                                <span class="headtitle">Sign in</span>
                                <div class="service_name">to access <span>Get Manufacturers</span></div>
                            </div>

                            <div class="form-group">
                            <input type="text" class="form_input form-control" name="username" value="<?=set_value('username'); ?>" placeholder="">
                                <label>Username *</label>
                                <span class="form-error"><?php echo form_error('username'); ?></span>
                            </div>
                            <div class="form-group">
                            <input type="password" id="password" class="form_input form-control" name="password" value="<?=set_value('password'); ?>" placeholder="">
                                <label>Password*</label>
                                <span toggle="#password" class="password_visable"></span>
                                <span class="form-error"><?php echo form_error('password'); ?></span>
                            </div>

                            <div class="form-group">
                            <input type="hidden" value="login" name="auth"> 
                                <button class="loginBtn login_btn" type="submit">Sign In</button>
                                <div class="forgotLink">Sign in using Mobile OTP <a href="">Forgot password?</a></span>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="<?=base_url('assets/sitepanel/')?>gmdesigner/js/jquery-3.7.1.min.js"></script>
    <script>
        (function($) {
            $(".password_visable").click(function() {
                $(this).toggleClass("eye_slash");
                var input = $($(this).attr("toggle"));
                if (input.attr("type") == "password") {
                    input.attr("type", "text");
                } else {
                    input.attr("type", "password");
                }
            });
        })(jQuery);
    </script>
</body>

</html>