<?php $this->load->view('sitepanel/common/header-new'); ?>


 <style>
        .tag-container {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
            padding: 5px 8px;
            border: 1px solid #e3e3e3;
            border-radius: 4px;
            height: 45px;
            font-size: 14px;
            flex-direction: row-reverse;
        }
        .tag {
            background: #00b894;
            color: #fff;
            padding: 5px 10px;
            border-radius: 20px;
            display: flex;
            align-items: center;
        }

        .tag span {
            margin-left: 8px;
            cursor: pointer;
        }

        #search {
            border: none;
            outline: none;
            flex: 1;
            min-width: 150px;
        }

        #suggestions {
            border: 1px solid #ccc;
            max-height: 150px;
            overflow-y: auto;
            position: absolute;
            background: #fff;
            width: 100%;
            z-index: 1000;
        }

        #suggestions div {
            padding: 8px;
            cursor: pointer;
        }

        #suggestions div:hover {
            background: #f0f0f0;
        }


     #loader {
        display: none;
        font-size: 13px;
        color: #007bff;
    }
    #pincode-error {
        color: red;
        font-size: 13px;
        display: none;
    }
        
    </style>

<!-- main-content -->
<div class="content">

        <div class="pageTitleSection">
            <div class="pageTitle_1">
                <button class="backButton" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                    </svg> Back
                </button>
                <?=$heading?>
            </div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/company')?>">Company</a></li>
                <li class="breadcrumb-item active"><?=$heading?></li>
            </ol>
        </div>

         <!-- row  -->
                <div class="row">
                    <div class="col-12 col-sm-12">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="col-md-12">
                            <div class="alert alert-success">
                            <?php echo $this->session->flashdata('success'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
        
                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="col-md-12">
                            <div class="alert alert-danger">
                            <?php echo $this->session->flashdata('error'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    </div>
        
                </div>
              
            <div class="col-xxl-12 col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-body p-4"> 
                        <div class="row"><div class="col-md-12"><a href="<?=base_url('sitepanel/company')?>" class="btn btn-sm btn-light" style="float: right;">View All</a></div></div>
                    
                    <form action="<?=base_url('sitepanel/company/edit/'.$res['company_id'])?>" method="post" enctype="multipart/form-data">  
                        <div class="row">   
                               
                             <div class="col-md-12 pb-4 pt-2"><h5>Company Basic Details</h5></div> 
                               
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Company Name</label>
                                    <input type="text" class="form-control" name="company_name" id="company_name" data-id="<?=$res['company_id']?>" value="<?php echo set_value('company_name',$res['company_name']); ?>"> 
                                    <div id="slugLoader" style="display:none; color:blue; font-size:13px;">Checking availability...</div>
                                    <span class="text-danger" id="company_url_exist_error"></span>
                                    <?php if(form_error('company_name')){ ?>
                                    <div class="text-danger" ><?php echo form_error('company_name') ?></div>
                                    <?php } ?>
                                </div>
                            </div> 

                             <div class="col-md-6">
                                <div class="form-group">
                                    <label>Company Url</label>
                                    <input type="text" class="form-control" name="company_url" id="company_url" value="<?php echo set_value('company_url',$res['company_url']); ?>" readonly required> 
                                    <?php if(form_error('company_url')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_url') ?></div>
                                    <?php } ?>
                                </div>
                            </div> 
                            
                           <!-- <div class="col-md-6">
                                <div class="form-group">
                                    <label>Primary Business Type</label>
                                    <select name="primary_business_type" class="form-select">
                                        <option value="">-- Select Business Type--</option>
                                        <?php foreach($primary_busi_type as $btype) {?>
                                            <option value="<?=$btype['id']?>"<?=set_select('primary_business_type',$btype['id'], (isset($res['primary_business_type']) && $res['primary_business_type'] == $btype['id']))?>><?=$btype['business_type']?></option>
                                        <?php } ?>
                                    </select>
                                    <?php if(form_error('primary_business_type')){ ?>
                                    <div class="text-danger"><?php echo form_error('primary_business_type') ?></div>
                                    <?php } ?>
                                </div>
                            </div>-->
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Business Type</label><br>
                                    <?php
                                    $selected_btypes = set_value('seconday_business_type[]'); // CI's set_value may not work well with multiple selects
                                    if (empty($selected_btypes) && !empty($res['seconday_business_type'])) {
                                        $selected_btypes = explode(',', $res['seconday_business_type']);
                                    }
                                    ?>
                                    <select name="seconday_business_type[]" class="selectOne" multiple>
                                        <option value="">-- Business Type--</option>
                                        <?php foreach($secondary_busi_type as $btype) {?>
                                            <option value="<?=$btype['id']?>"<?= (!empty($selected_btypes)) && in_array($btype['id'], $selected_btypes) ? 'selected' : '' ?>><?=$btype['business_type']?></option>
                                        <?php } ?>
                                    </select>
                                    
                                    <?php if(form_error('seconday_business_type')){ ?>
                                    <div class="text-danger"><?php echo form_error('seconday_business_type') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Business Categories</label>
                                   
                                    <div class="form-wrapper">
                                        <div class="tag-container" id="tagContainer">
                                            <!-- Tags will be added here -->
                                            <input type="text" id="search" placeholder="Type a name..." onkeyup="searchUser()" autocomplete="off">
                                            
                                            <?php
                                            //$cat_ids = !empty($res['selected_categories']) ? explode(',', $res['selected_categories']) : [];
                                            
                                            $cat_ids = !empty($company_cat_list['selected_categories']) ? explode(',', $company_cat_list['selected_categories']) : [];
                                            
                                            
                                            if (!empty($cat_ids)) {
                                                $getResult = $this->db->where_in('category_id', $cat_ids)
                                                                      ->get('gm_categories')
                                                                      ->result_array();
                                            
                                                if (!empty($getResult)) {
                                                    foreach ($getResult as $result) {
                                                        $category_name = htmlspecialchars($result['category_name'], ENT_QUOTES, 'UTF-8');
                                                        $category_id = (int)$result['category_id']; 
                                                        ?>
                                                       
                                                        <div class="tag" data-id="<?=$category_id?>"><?=$category_name?> <span class="remove-btn" data-id="<?=$category_id?>">X</span> </div>
                                                        <?php
                                                    }
                                                }
                                            }
                                            ?>
                                        </div>
                                        <div id="loader" style="display:none;">Searching...</div>
                                        <div id="suggestions"></div>
                                        <input type="hidden" name="selected_categories" id="selected_users" value="<?=$res['selected_categories']?>">
                                    </div>
                                    <?php if(form_error('selected_categories')){ ?>
                                    <div class="text-danger"><?php echo form_error('selected_categories') ?></div>
                                    <?php } ?>
                                </div>
                                
                                
                            </div>
                            
                            
                            <div class="col-md-12 pb-4 pt-2"><h5>Contact Person's Details</h5></div> 
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" class="form-control" name="primary_person_name" value="<?php echo set_value('primary_person_name',$res['primary_person_name']); ?>" > 
                                    <?php if(form_error('primary_person_name')){ ?>
                                    <div class="text-danger"><?php echo form_error('primary_person_name') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
    
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Designation</label>
                                    <input type="text" class="form-control" name="designation" value="<?php echo set_value('designation',$res['designation']); ?>" > 
                                    <?php if(form_error('designation')){ ?>
                                    <div class="text-danger"><?php echo form_error('designation') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Mobile Number (Whatsapp Preferred)</label>
                                    <input type="text" class="form-control"  name="mobile" value="<?php echo set_value('mobile',$res['mobile']); ?>" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');"> 
                                    <?php if(form_error('mobile')){ ?>
                                    <div class="text-danger"><?php echo form_error('mobile') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                                
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Alt. Mobile</label>
                                    <input type="text" class="form-control"  name="alt_mobile" value="<?php echo set_value('alt_mobile',$res['alt_mobile']); ?>" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');"> 
                                    <?php if(form_error('alt_mobile')){ ?>
                                    <div class="text-danger"><?php echo form_error('alt_mobile') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Email ID.</label>
                                    <input type="text" class="form-control"  name="email" value="<?php echo set_value('email',$res['email']); ?>"> 
                                    <?php if(form_error('email')){ ?>
                                    <div class="text-danger"><?php echo form_error('email') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Alt. Email ID.</label>
                                    <input type="text" class="form-control"  name="alt_email" value="<?php echo set_value('alt_email',$res['alt_email']); ?>"> 
                                    <?php if(form_error('alt_email')){ ?>
                                    <div class="text-danger"><?php echo form_error('alt_email') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
  
                            <div class="col-md-12 pb-4 pt-2"><h5>Registered Company Address</h5></div> 
                            
     
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Pincode</label>
                                    <input type="text" class="form-control" name="pincode" id="pincode" value="<?php echo set_value('pincode',$res['pincode']); ?>" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');"> 
                                    <div id="loader">Loading info...</div>
                                    <div id="pincode-error"></div>
                                    <?php if(form_error('pincode')){ ?>
                                    <div class="text-danger"><?php echo form_error('pincode') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Country</label>
                                    <select name="country" class="form-select" id="country" readonly>
                                        <option value="">-- Select --</option>
                                        <?php foreach($country_list as $country) {?>
                                            <option value="<?=$country['name']?>"<?=set_select('country',$country['name'], (isset($res['country']) && $res['country'] == $country['name']))?>><?=$country['name']?></option>
                                        <?php } ?>
                                    </select>
                                    <?php if(form_error('country')){ ?>
                                    <div class="text-danger"><?php echo form_error('country') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>State</label>
                                    <select name="state" class="form-select" id="state" readonly>
                                        <option value="">-- Select State--</option>
                                        
                                        
                                        <?php foreach($state_list as $state) {?>
                                            <option value="<?=$state['name']?>"<?=set_select('state',$state['name'], (isset($res['state']) && $res['state'] == $state['name']))?>><?=$state['name']?></option>
                                        <?php } ?>
                                        
                                    </select>
                                    <?php if(form_error('state')){ ?>
                                    <div class="text-danger"><?php echo form_error('state') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>District</label>
                                    
                                    <input type="text" class="form-control" name="district" id="district" value="<?php echo set_value('district',$res['district']); ?>" readonly>
                                    
                                    <?php if(form_error('district')){ ?>
                                    <div class="text-danger"><?php echo form_error('district') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            

                            <!--<div class="col-md-4">
                                <div class="form-group">
                                    <label>City</label>
                                    <select name="city" class="form-select" id="city">
                                        <option value="">-- Select City--</option>
                                        
                                    </select>
                                    <?php if(form_error('city')){ ?>
                                    <div class="text-danger"><?php echo form_error('city') ?></div>
                                    <?php } ?>
                                </div>
                            </div>-->
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Landmark</label>
                                    <input type="text" class="form-control" name="landmark" value="<?php echo set_value('landmark',$res['landmark']); ?>" > 
                                    <?php if(form_error('landmark')){ ?>
                                    <div class="text-danger"><?php echo form_error('landmark') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Locality</label>
                                    <input type="text" class="form-control" name="locality" value="<?php echo set_value('locality',$res['locality']); ?>" > 
                                    <?php if(form_error('locality')){ ?>
                                    <div class="text-danger"><?php echo form_error('locality') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            
                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea class="form-control" name="address"><?php echo set_value('address', $res['address']);?></textarea>
                                    <?php if(form_error('address')){ ?>
                                    <div class="text-danger"><?php echo form_error('address') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            
                            
                            
                            <div class="col-md-12 pb-4 pt-2"><h5>Additional Company Details</h5></div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Company CEO</label>
                                    <input type="text" class="form-control" name="company_ceo" value="<?php echo set_value('company_ceo',$res['company_ceo']); ?>"> 
                                    <?php if(form_error('company_ceo')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_ceo') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Year of Establishment</label>
                                    <input type="text" class="form-control" name="established_year" value="<?php echo set_value('website', $res['established_year']); ?>" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');"> 
                                    <?php if(form_error('established_year')){ ?>
                                    <div class="text-danger"><?php echo form_error('established_year') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                             
                             
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label>Number of Employees</label>
                                    
                                    <select name="company_no_of_emp" class="form-select">
                                        <option value=""> --Select No of Employees -- </option>
                                        <option value="Below-10">Below 10</option>
                                        <option value="11-25" <?= set_select('company_no_of_emp', '11-25', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == '11-25') ?>>11 - 25</option>
                                        <option value="26-50" <?= set_select('company_no_of_emp', '26-50', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == '26-50') ?>>26 - 50</option>
                                        <option value="51-100" <?= set_select('company_no_of_emp', '51-100', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == '51-100') ?>>51 - 100</option>
                                        <option value="101-150" <?= set_select('company_no_of_emp', '101-150', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == '101-150') ?>>101 - 150</option>
                                        <option value="151-200" <?= set_select('company_no_of_emp', '151-200', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == '151-200') ?>>151 - 200</option>
                                        <option value="201-250" <?= set_select('company_no_of_emp', '201-250', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == '201-250') ?>>201 - 250</option>
                                        <option value="250-500" <?= set_select('company_no_of_emp', '250-500', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == '250-500') ?>>251 - 500</option>
                                        <option value="501-1000" <?= set_select('company_no_of_emp', '501-1000', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == '501-1000') ?>>501 - 1000</option>
                                        <option value="Above-1001" <?= set_select('company_no_of_emp', 'Above-1001', isset($res['company_no_of_emp']) && $res['company_no_of_emp'] == 'Above-1001') ?>>Above 1001</option>
                                    </select>
                                    
                                    <?php if(form_error('company_no_of_emp')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_no_of_emp') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Annual Turnover</label>
                                   
                                    <select name="turnover" class="form-select">
                                        <option value=""> --Select Annual Turnover -- </option>
                                        <option value="Below-10Lakh" <?= set_select('turnover', 'Below-10Lakh', isset($res['turnover']) && $res['turnover'] == 'Below-10Lakh') ?>>Below Rs.10 Lakh</option>
                                        <option value="10-25Lakh" <?= set_select('turnover', '10-25Lakh', isset($res['turnover']) && $res['turnover'] == '10-25Lakh') ?>>Rs.10 - 25 Lakh</option>
                                        <option value="26-50Lakh" <?= set_select('turnover', '26-50Lakh', isset($res['turnover']) && $res['turnover'] == '26-50Lakh') ?>>Rs.26 - 50 Lakh</option>
                                        <option value="51-1Cr" <?= set_select('turnover', '51-1Cr', isset($res['turnover']) && $res['turnover'] == '51-1Cr') ?>>Rs.51 - 1 Crore</option>
                                        <option value="2-5Cr" <?= set_select('turnover', '2-5Cr', isset($res['turnover']) && $res['turnover'] == '2-5Cr') ?>>Rs.2 - 5 Crore</option>
                                        <option value="6-10Cr" <?= set_select('turnover', '6-10Cr', isset($res['turnover']) && $res['turnover'] == '6-10Cr') ?>>Rs.6 - 10 Crore</option>
                                        <option value="11-25Cr" <?= set_select('turnover', '11-25Cr', isset($res['turnover']) && $res['turnover'] == '11-25Cr') ?>>Rs.11 - 25 Crore</option>
                                        <option value="26-50Cr" <?= set_select('turnover', '26-50Cr', isset($res['turnover']) && $res['turnover'] == '26-50Cr') ?>>Rs.26 - 50 Crore</option>
                                        <option value="51-100Cr" <?= set_select('turnover', '51-100Cr', isset($res) && $res['turnover'] == '51-100Cr') ?>>Rs.51 - 100 Crore</option>
                                        <option value="Above-101Cr" <?= set_select('turnover', 'Above-101Cr', isset($res['turnover']) && $res['turnover'] == 'Above-101Cr') ?>>Above Rs.100 Crore</option>
                                    </select>
                                    
                                    <?php if(form_error('turnover')){ ?>
                                    <div class="text-danger"><?php echo form_error('turnover') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Ownership Type</label>
                                    <select name="ownership_type" class="form-select">
                                        <option value="">--Choose one--</option>
                                        <option value="Public Limited Company" <?= set_select('ownership_type', 'Public Limited Company', isset($res['ownership_type']) && $res['ownership_type'] == 'Public Limited Company') ?>>Public Limited Company</option>
                                        <option value="Private Limited Company" <?= set_select('ownership_type', 'Private Limited Company', isset($res['ownership_type']) && $res['ownership_type'] == 'Private Limited Company') ?>>Private Limited Company</option>
                                        <option value="Partnership" <?= set_select('ownership_type', 'Partnership', isset($res['ownership_type']) && $res['ownership_type'] == 'Partnership') ?>>Partnership</option>
                                        <option value="Proprietorship" <?= set_select('ownership_type', 'Proprietorship', isset($res['ownership_type']) && $res['ownership_type'] == 'Proprietorship') ?>>Proprietorship</option>
                                        <option value="Professional Associations" <?= set_select('ownership_type', 'Professional Associations', isset($res['ownership_type']) && $res['ownership_type'] == 'Professional Associations') ?>>Professional Associations</option>
                                        <option value="Limited Liability Partnership (LLP)" <?= set_select('ownership_type', 'Limited Liability Partnership (LLP)', isset($res['ownership_type']) && $res['ownership_type'] == 'Limited Liability Partnership (LLP)') ?>>Limited Liability Partnership (LLP)</option>
                                    </select>
                                    <?php if(form_error('website')){ ?>
                                    <div class="text-danger"><?php echo form_error('website') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label>Website</label>
                                    <input type="text" class="form-control" name="website" value="<?php echo set_value('website',$res['website']); ?>"> 
                                    <?php if(form_error('website')){ ?>
                                    <div class="text-danger"><?php echo form_error('website') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                             
                              <div class="col-md-4">
                                <div class="form-group">
                                    <label>GSTIN</label>
                                    <input type="text" class="form-control" name="company_gst" value="<?php echo set_value('company_gst',$res['company_gst']); ?>"> 
                                    <?php if(form_error('company_gst')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_gst') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>PAN No.</label>
                                    <input type="text" class="form-control" name="company_pan" value="<?php echo set_value('company_pan',$res['company_pan']); ?>"> 
                                    <?php if(form_error('company_pan')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_pan') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>TAN No.</label>
                                    <input type="text" class="form-control" name="company_tan" value="<?php echo set_value('company_tan',$res['company_tan']); ?>"> 
                                    <?php if(form_error('company_tan')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_tan') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>CIN No.</label>
                                    <input type="text" class="form-control" name="company_cin" value="<?php echo set_value('company_cin',$res['company_cin']); ?>"> 
                                    <?php if(form_error('company_cin')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_cin') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                            
                            <!--<div class="col-md-4">
                                <div class="form-group">
                                    <label>Working Days</label>
                                    <input type="text" class="form-control" name="company_pan" value="<?php echo set_value('company_pan'); ?>"> 
                                    <?php if(form_error('company_pan')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_pan') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>-->
                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Company Descriptions</label>
                                    <textarea name="company_desc" class="form-control"><?php echo set_value('company_desc',$res['company_desc']); ?></textarea>
                                    <?php if(form_error('company_desc')){ ?>
                                    <div class="text-danger"><?php echo form_error('company_desc') ?></div>
                                    <?php } ?>
                                </div>  
                            </div>
                            
                             <div class="col-md-12 pb-4 pt-2"><h5>Bank Account Details</h5></div>
                             
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label>Account Number</label>
                                    <input type="text" class="form-control" name="account_no" value="<?php echo set_value('account_no',$res['account_no']); ?>"> 
                                    <?php if(form_error('account_no')){ ?>
                                    <div class="text-danger"><?php echo form_error('account_no') ?></div>
                                    <?php } ?>
                                </div>  
                             </div>
                             
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label>Account Type</label>
                                    <select class="form-select" name="account_type">
                                        <option value="">Select Account Type</option>
                                        <option value="saving" <?= set_select('account_type', 'saving', isset($res['account_type']) && $res['account_type'] == 'saving') ?>>Saving</option>
                                        <option value="current" <?= set_select('account_type', 'current', isset($res['account_type']) && $res['account_type'] == 'current') ?>>Current</option>
                                    </select>
                                    <?php if(form_error('account_type')){ ?>
                                    <div class="text-danger"><?php echo form_error('account_type') ?></div>
                                    <?php } ?>
                                </div>  
                             </div>
                             
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label>IFSC Code</label>
                                    <input type="text" class="form-control" name="ifsc_code" value="<?php echo set_value('ifsc_code',$res['ifsc_code']); ?>"> 
                                    <?php if(form_error('ifsc_code')){ ?>
                                    <div class="text-danger"><?php echo form_error('ifsc_code') ?></div>
                                    <?php } ?>
                                </div>  
                             </div>
                             
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label>Bank Name</label>
                                    <input type="text" class="form-control" name="bank_name" value="<?php echo set_value('bank_name',$res['bank_name']); ?>"> 
                                    <?php if(form_error('bank_name')){ ?>
                                    <div class="text-danger"><?php echo form_error('bank_name') ?></div>
                                    <?php } ?>
                                </div>  
                             </div>
                             
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label>Bank Branch</label>
                                    <input type="text" class="form-control" name="bank_branch" value="<?php echo set_value('bank_branch',$res['bank_branch']); ?>"> 
                                    <?php if(form_error('bank_branch')){ ?>
                                    <div class="text-danger"><?php echo form_error('bank_branch') ?></div>
                                    <?php } ?>
                                </div>  
                             </div>
                             
                             <div class="col-md-4">
                                <div class="form-group">
                                    <label>Mode of Payment</label>
                                    <input type="text" class="form-control" name="bank_name" value="<?php echo set_value('bank_name',$res['bank_name']); ?>"> 
                                    <?php if(form_error('bank_name')){ ?>
                                    <div class="text-danger"><?php echo form_error('bank_name') ?></div>
                                    <?php } ?>
                                </div>  
                             </div>
                            

                            
                            
                            <div class="col-md-12 pb-4 pt-2"><h5>Social Media/Chennels</h5></div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Facebook</label>
                                    <input type="text" class="form-control"  name="facebook" value="<?php echo set_value('facebook',$res['facebook']); ?>"> 
                                    <?php if(form_error('facebook')){ ?>
                                    <div class="text-danger"><?php echo form_error('facebook') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Instagram</label>
                                    <input type="text" class="form-control"  name="instagram" value="<?php echo set_value('instagram',$res['instagram']); ?>"> 
                                    <?php if(form_error('instagram')){ ?>
                                    <div class="text-danger"><?php echo form_error('instagram') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Youtube</label>
                                    <input type="text" class="form-control"  name="youtube" value="<?php echo set_value('youtube',$res['youtube']); ?>"> 
                                    <?php if(form_error('youtube')){ ?>
                                    <div class="text-danger"><?php echo form_error('youtube') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>X</label>
                                    <input type="text" class="form-control"  name="twitter" value="<?php echo set_value('twitter',$res['twitter']); ?>"> 
                                    <?php if(form_error('twitter')){ ?>
                                    <div class="text-danger"><?php echo form_error('twitter') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>LinkedIn</label>
                                    <input type="text" class="form-control"  name="linkedin" value="<?php echo set_value('linkedin',$res['linkedin']); ?>"> 
                                    <?php if(form_error('linkedin')){ ?>
                                    <div class="text-danger"><?php echo form_error('linkedin') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <!--<div class="col-md-7"> 
                                <div class="form-group">
                                    <label>Password</label>
                                    <input type="password" class="form-control"  name="password" value="<?php echo set_value('password'); ?>"> 
                                    <?php if(form_error('password')){ ?> 
                                    <div class="text-danger"><?php echo form_error('password') ?></div>
                                    <?php } ?>
                                </div>
                            </div> -->
                        </div>
                        
                        <?php 
                        $back_query_string = $_SERVER['QUERY_STRING'] ? '/?' . $_SERVER['QUERY_STRING'] : '';
                        ?>
                        
                        <div class="form-group">
                            <input type="hidden" name="query_string" value="<?= html_escape($query_string); ?>">
                            <button class="btn save_btn" type="submit" name="submit" value="save">Update</button>
                            <a href="<?=base_url('sitepanel/company/index'.$back_query_string)?>" class="btn cancel_btn">Cancel</a>
                        </div>
                
                        </form>
                    </div>
                </div>
            </div>

       
     
<?php $this->load->view('sitepanel/common/footer-new'); ?>


<script>
/*$('#company_name').on('blur', function() {
    let name = $(this).val().trim();
    if (name.length > 0) {
        $.post('<?= base_url("sitepanel/company/generate_slug") ?>', { company_name: name }, function(resp) {
            if(resp.error){
                 $('#company_url_exist_error').html(resp.error);
            }else{
                $('#company_url').val(resp.slug);
                $('#company_url_exist_error').html('');
            }
            
        }, 'json');
    }
});*/

</script>

<script>
$('#company_name').on('blur', function() {
    let name = $(this).val().trim();
    let company_id = $(this).attr('data-id');
    $('#company_url_exist_error').html('');
    if (name.length > 0) {
        
        // Show loader
        $('#slugLoader').show();
        $('#company_url_exist_error').html('');

        $.post('<?= base_url("sitepanel/company/generate_slug") ?>', { company_name: name, company_id: company_id }, function(resp) {
            
            // Hide loader
            $('#slugLoader').hide();

            if(resp.error){
                $('#company_url_exist_error').html(resp.error + 
                    (resp.suggest ? ' Try: <b>' + resp.suggest + '</b>' : ''));
            } else {
                $('#company_url').val(resp.slug);
                $('#company_url_exist_error').html('');
            }

        }, 'json')
        .fail(function() {
            $('#slugLoader').hide();
            $('#company_url_exist_error').html('Something went wrong. Please try again.');
        });
    }
});
</script>




<script>
$('#country').change(function(){
    var country_id = $(this).val();
    //alert(country_id);
    $('#state').html('<option>Loading...</option>');
    $('#city').html('<option value="">Select State</option>');
    $.post("<?= base_url('sitepanel/company/get_states') ?>", {country_id: country_id}, function(data){
        var options = '<option value="">Select State</option>';
        $.each(JSON.parse(data), function(i, state){
            options += `<option value="${state.id}">${state.name}</option>`;
        });
        $('#state').html(options);
    });
});

$('#state').change(function(){
    var state_id = $(this).val();
    $('#city').html('<option>Loading...</option>');
    $.post("<?= base_url('sitepanel/company/get_cities') ?>", {state_id: state_id}, function(data){
        var options = '<option value="">Select City</option>';
        $.each(JSON.parse(data), function(i, city){
            options += `<option value="${city.name}">${city.name}</option>`;
        });
        $('#city').html(options);
    });
});
</script>



    <script>
    
    $(document).ready(function () {
        const preSelected = $("#selected_users").val();
        if (preSelected) {
            const ids = preSelected.split(',');
            ids.forEach(function (id) {
                const name = $(`.tag[data-id='${id}']`).text().replace('', '').trim();
                selectedUsers.push({ id: id, name: name });
            });
        }
    });
    
    
    
    let selectedUsers = [];

    function searchUser() {
        const searchText = $("#search").val();
        const geturl = "<?= base_url('sitepanel/company/get_list') ?>";
    
        if (searchText.length > 0) {
            $("#loader").show(); // Show loader
    
            $.ajax({
                url: geturl,
                method: "POST",
                data: { query: searchText },
                success: function (response) {
                    $("#suggestions").html(response).show();
                },
                complete: function () {
                    $("#loader").hide(); // Always hide loader after response
                }
            });
        } else {
            $("#suggestions").hide();
            $("#loader").hide();
        }
    }
    
    
    

    function addUser(name, id) {
        // Prevent duplicates
        if (!selectedUsers.some(user => user.id == id)) {
            selectedUsers.push({ id, name });

            const tag = `<div class="tag" data-id="${id}">
                            ${name} <span class="remove-btn" data-id="${id}">×</span>
                         </div>`;
            $("#tagContainer").append(tag); // Append to maintain order

            updateHiddenInput();
        }

        $("#search").val('');
        $("#suggestions").hide();
    }

    // Use event delegation for dynamic remove buttons
    $(document).on('click', '.remove-btn', function () {
        const idToRemove = $(this).data('id');

        // Remove from array
        selectedUsers = selectedUsers.filter(user => user.id != idToRemove);

        // Remove tag visually
        $(`.tag[data-id="${idToRemove}"]`).remove();

        // Update hidden field
        updateHiddenInput();
    });

    function updateHiddenInput() {
        const selectedIds = selectedUsers.map(user => user.id);
        $("#selected_users").val(selectedIds.join(','));
    }
    
    

    // Hide suggestions when clicking outside
    $(document).on('click', function (e) {
        if (!$(e.target).closest('.form-wrapper').length) {
            $("#suggestions").hide();
        }
    });
</script>

<script>

    // Clear fields when pincode is manually removed
    $('#pincode').on('keyup', function () {
        const pincode = $(this).val().trim();
        if (pincode.length === 0) {
            $('#district').val('');
            $('#state').val('').trigger('change');
            $('#country').val('').trigger('change');
            $('#pincode-error').hide();
        }
    });
    
    $('#pincode').on('blur', function () {
        var pincode = $(this).val().trim();
        $('#pincode-error').hide();
        $('#loader').show();

        if (pincode.length !== 6 || !/^\d+$/.test(pincode)) {
            $('#loader').hide();
            $('#pincode-error').text('Please enter a valid 6-digit pincode.').show();
            return;
        }

        $.ajax({
            url: '<?= base_url("sitepanel/company/get_pincode_info") ?>',
            type: 'POST',
            data: { pincode: pincode },
            dataType: 'json',
            success: function (res) {
                $('#loader').hide();
                if (res.status === 'success') {
                    $('#district').val(res.district);

                    // Set state
                    $("#state option").each(function () {
                        if ($(this).val().toLowerCase() === res.state.toLowerCase()) {
                            $(this).prop('selected', true);
                        }
                    });

                    // Set country
                    $("#country option").each(function () {
                        if ($(this).val().toLowerCase() === res.country.toLowerCase()) {
                            $(this).prop('selected', true);
                        }
                    });
                } else {
                    $('#pincode-error').text(res.message || 'Pincode not found.').show();
                }
            },
            error: function () {
                $('#loader').hide();
                $('#pincode-error').text('Failed to fetch pincode info. Please try again.').show();
            }
        });
    });
</script>

<script>
  $('#country, #state').on('mousedown', function (e) {
    e.preventDefault();
    this.blur(); // Prevent opening the dropdown
  });
</script>

 </body>
</html>