<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->

<div class="content">
    
    
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>


        <div class="pageTitleSection">
            <div class="pageTitle_1"><button class="backButton" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                </svg> Back
            </button>
                Manage Permissions
            </div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Manage Permission</li>
            </ol>
        </div>

            
            <div class="col-12 col-sm-12">
                <div class="card">

                    <div class="card-body pb-3 example1-table">

                            <form method="get" style="margin-bottom:20px">
                                <div class="row">
                                    <div class="col-5 col-sm-5">
                                    <input type="text" class="form-control" name="search" placeholder="Search permission..." value="<?= htmlspecialchars($this->input->get('search')) ?>" />
                                    </div>
                                    <div class="col-2 col-sm-2">

                                    <select class="form-control" name="group_id">
                                        <option value="">All Groups</option>
                                        <?php foreach ($all_groups as $group): ?>
                                            <option value="<?= $group['id'] ?>" <?= ($this->input->get('group_id') == $group['id']) ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($group['group_name']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                   
                                    </div>
                                    <div class="col-3 col-sm-3">
                                        <button type="submit" class="btn btn-dark">Search</button>
                                        <a href="<?= base_url('sitepanel/adminroles/permissions') ?>" class="btn btn-light">Reset</a>
                                    </div>
                                   
                                    <div class="col-2 col-sm-2"><a href="<?= base_url('sitepanel/adminroles/add_permission') ?>" class="addCompanyBtn" style="float:right">Add New Permission</a></div>
                                    

                                </div>
                            </form>                           



                    <div class="table-responsive dataview">
                        <?php if (!empty($grouped_permissions)): ?>
                            
                           <table class="table dashboardTable" id="my_data">
                                <thead style="background-color: #f9f9f9;">
                                    <tr>
                                        <th>#</th>
                                        <th>Permission Name</th>
                                        <th>Permission Key</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $serial = 1; ?>
                                    <?php foreach ($grouped_permissions as $group_name => $permissions): ?>
                                        <!-- Group Row -->
                                        <tr style="background-color: #e3e3e3; font-weight: bold;">
                                            <td colspan="4"><?= htmlspecialchars($group_name) ?: 'Ungrouped' ?></td>
                                        </tr>
                        
                                        <?php foreach ($permissions as $perm): ?>
                                            <tr>
                                                <td><?= $serial++ ?></td>
                                                <td><div class="companyName"><?= htmlspecialchars($perm['permission_name']) ?></div></td>
                                                <td><div class="companyName"><?= htmlspecialchars($perm['permission_key']) ?></div></td>
                                                
                                                
                                                <td class="action-table-data">
                                                    <div class="edit-delete-action">
                                                        <a class="me-2 p-2 edit toolTip" href="<?= base_url('sitepanel/adminroles/edit_permission/' . $perm['id']) ?>" data-tooltip="Edit Permission">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                                <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                                <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                                                            </svg>
                                                         Edit
                                                        </a>
                                                        
                                                        <a href="<?= base_url('sitepanel/adminroles/delete_permission/' . $perm['id']) ?>" onclick="return confirm('Are you sure you want to delete this permission?')">Delete</a>
                                                        
                                                    </div>
                                                </td>
                                                
                                                
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            <p>No permissions found.</p>
                        <?php endif; ?>
                        </div>
                        
                    </div>
                </div>
            </div>
        
</div>
<!-- /main-content -->
<?php $this->load->view('sitepanel/common/footer-new'); ?>

