<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->
<div class="content">
    
    
    <div class="pageTitleSection">
        <div class="pageTitle_1">
            <button class="backButton" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                </svg> Back
            </button>
            Add New Permission
        </div>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/adminroles/permissions')?>">Permissions</a></li>
            <li class="breadcrumb-item active">Add New Permission</li>
        </ol>
    </div>
    
    <!-- row  -->
    <div class="row">
        <div class="col-12 col-sm-12">
        <?php if ($this->session->flashdata('success')): ?>
            <div class="col-md-12">
                <div class="alert alert-success">
                <?php echo $this->session->flashdata('success'); ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="col-md-12">
                <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
                </div>
            </div>
        <?php endif; ?>
        
        </div>

    </div>

    
            
        <div class="col-12 col-sm-12">
        
            <div class="card">
                <div class="card-body">
                <div class="row"><div class="col-md-12"><a href="<?=base_url('sitepanel/adminroles/permissions')?>" class="btn btn-sm btn-light" style="float: right;">Back</a></div></div>


               <form method="post">
                	<div class="row align-items-center mb-3">
                		<div class="col-2">
                			Permission Name:
                		</div>
                		<div class="col-4">
                			<input type="text" name="permission_name" required class="form-control">
                		</div>
                	</div>
                	<div class="row align-items-center mb-3">
                		<div class="col-2">
                			Permission Key:
                		</div>
                		<div class="col-4">
                			<input type="text" name="permission_key" required class="form-control">
                		</div>
                	</div>
                	<div class="row align-items-center mb-3">
                		<div class="col-2">
                			Group:
                		</div>
                		<div class="col-4">
                			<select name="group_id" id="group_id" required class="form-select">
                				<option value="">-- Select Group --</option>
                				<?php foreach ($groups as $group): ?>
                				<option value="<?= $group['id'] ?>">
                					<?= htmlspecialchars($group['group_name']) ?>
                				</option>
                				<?php endforeach; ?>
                			</select>
                		</div>
                		<div class="col-2">
                			<div class="d-flex align-items-end gap-3">
                				<button type="button" onclick="openGroupModal()" class="btn saveNew">+ Add Group</button>
                			</div>
                		</div>
                	</div>
                	
                	<div class="row align-items-center">
                		
                		<div class="offset-2 col-4">
                			<button type="submit" class="btn save_btn">Save Permission</button>
                			<a href="<?=base_url('sitepanel/adminroles/permissions')?>" class="btn btn-default">Cancel</a>
                		</div>
                	</div>
                </form>



                </div>
            </div>
        </div>

        
</div>
<!-- /main-content -->


<!-- Modal -->
<div id="groupModal" style="display:none; position:fixed; top:30%; left:35%; background:#fff; padding:20px; border:1px solid #ccc;">
    <h4>Add Permission Group</h4>
    <input type="text" id="new_group_name" placeholder="Enter group name">
    <button class="btn btn-sm btn-success" onclick="saveNewGroup()">Save</button>
    <button class="btn btn-sm btn-danger" onclick="closeGroupModal()">Cancel</button>
    <p id="group_error" style="color:red;"></p>
</div>



<?php $this->load->view('sitepanel/common/footer-new'); ?>


<script>
function openGroupModal() {
    document.getElementById('new_group_name').value = '';
    document.getElementById('group_error').innerText = '';
    document.getElementById('groupModal').style.display = 'block';
}

function closeGroupModal() {
    document.getElementById('groupModal').style.display = 'none';
}

function saveNewGroup() {
    const groupName = document.getElementById('new_group_name').value.trim();
    if (!groupName) {
        document.getElementById('group_error').innerText = 'Please enter a group name.';
        return;
    }

    fetch('<?= base_url('sitepanel/adminroles/ajax_add_group') ?>', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'group_name=' + encodeURIComponent(groupName)
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            const select = document.getElementById('group_id');
            const option = document.createElement('option');
            option.value = data.group.id;
            option.text = data.group.group_name;
            option.selected = true;
            select.appendChild(option);

            closeGroupModal();
        } else {
            document.getElementById('group_error').innerText = data.message || 'Error occurred.';
        }
    })
    .catch(() => {
        document.getElementById('group_error').innerText = 'Request failed.';
    });
}
</script>

