<?php $this->load->view('sitepanel/common/header-new'); ?>
<!-- main-content -->
<div class="content">
    
        <div class="pageTitleSection">
            <div class="pageTitle_1">
                <button class="backButton" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0"></path>
                    </svg> Back
                </button>
                Add New User
            </div>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/dashboard')?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?=base_url('sitepanel/admin')?>">Users</a></li>
                <li class="breadcrumb-item active">Add New User</li>
            </ol>
        </div>
        
        
         <!-- row  -->
                <div class="row">
                    <div class="col-12 col-sm-12">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="col-md-12">
                            <div class="alert alert-success">
                            <?php echo $this->session->flashdata('success'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
        
                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="col-md-12">
                            <div class="alert alert-danger">
                            <?php echo $this->session->flashdata('error'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    </div>
        
                </div>
                
                

            <div class="col-xxl-12 col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-body p-4">
                    
                    <form action="<?=base_url('sitepanel/admin/add')?>" method="post" enctype="multipart/form-data">  
                        <div class="row">  
                              
                            <div class="col-md-7">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" class="form-control" value="<?php echo set_value('admin_name'); ?>" name="admin_name"> 
                                    <?php if(form_error('admin_name')){ ?>
                                    <div class="text-danger"><?php echo form_error('admin_name') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-7">
                                <div class="form-group">
                                    <label>Designation/Position</label>
                                    <input type="text" class="form-control" value="<?php echo set_value('designation'); ?>" name="designation"> 
                                    <?php if(form_error('designation')){ ?>
                                    <div class="text-danger"><?php echo form_error('designation') ?></div>
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="col-md-7">
                                <div class="form-group">
                                    <label>Role</label>
                                    <select name="role_id" class="form-select">
                                        <option value="">Select Role</option>
                                        <?php foreach($roles as $role) {?>
                                            <option value="<?=$role['id']?>"<?=set_select('role_id',$role['id'])?>><?=$role['role_name']?></option>
                                        <?php } ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('role_id'); ?></span>
                                </div>
                            </div>
                            
                            <div class="col-md-7">
                                <div class="form-group">
                                    <label>Username</label>
                                    <input type="text" class="form-control" value="<?php echo set_value('username'); ?>" name="username"> 
                                    <?php if(form_error('username')){ ?>
                                    <div class="text-danger"><?php echo form_error('username') ?></div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <div class="col-md-7">
                                <div class="form-group">
                                    <label>Password</label>
                                    <input type="password" class="form-control" value="<?php echo set_value('password'); ?>" name="password"> 
                                    <?php if(form_error('password')){ ?>
                                    <div class="text-danger"><?php echo form_error('password') ?></div>
                                    <?php } ?>
                                </div>
                            </div> 
                        </div>
                        <?php 
                        $back_query_string = $_SERVER['QUERY_STRING'] ? '?' . $_SERVER['QUERY_STRING'] : '';
                        ?>
                        <div class="form-group">
                            <input type="hidden" name="query_string" value="<?= html_escape($query_string); ?>">
                            <button class="btn save_btn" type="submit" name="submit" value="save">Save</button>
                            <button class="btn saveNew" type="submit" name="submit" value="save_new">Save & New</button>
                            <button class="btn saveClosed" type="submit" name="submit" value="save_close">Save & Close</button>
                            <a href="<?=base_url('sitepanel/admin/index/'.$back_query_string)?>" class="btn cancel_btn">Cancel</a>

                        </div>

                        </form>
                    </div>
                </div>
            </div>

       
        </div>
            
<!-- /main-content -->
<?php $this->load->view('sitepanel/common/footer-new'); ?>


<script>
$('#location_name').on('blur', function() {
    let name = $(this).val().trim();
    if (name.length > 0) {
        $.post('<?= base_url("sitepanel/location/generate_slug") ?>', { location_name: name }, function(resp) {
            $('#location_url').val(resp.slug);
        }, 'json');
    }
});


</script>