<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php
    $location_name = ucfirst($location_detail['location_name']); 
    
    $title = str_replace('{location}', $location_name, '{location} Manufacturers Directory, Top Manufacturing Companies in {location}');

    $description = str_replace('{location}', $location_name, "Explore GetManufacturers.com - {location}'s leading manufacturers directory. Find verified suppliers, exporters from {location}, and top manufacturing companies in {location} across industries. Boost your B2B sourcing now!");

    $keywords = str_replace('{location}', $location_name, '{location} manufacturers directory, manufacturing companies in {location}, B2B suppliers {location}, industrial manufacturers in {location}, exporters {location}, top manufacturers in {location}, wholesale suppliers in {location}, factory directory {location}, GetManufacturers.com {location}, Top Manufacturers in {location}, Top Manufacturing Companies in {location}');
    ?>
    <title><?= $title ?></title>
    <meta name="description" content="<?= $description ?>">
    <meta name="keywords" content="<?= $keywords ?>">

    <?php $this->load->view('common/app_top'); ?>
</head>

<body>

    <?php $this->load->view('common/location_app_header'); ?>  

    <nav class="breadcrumbs">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <ul>
                    <?php if (!empty($breadcrumb)) echo $breadcrumb; ?>
                        <!-- <li><a href="#">Home</a></li>
                        <li><a href="#">Apparel & Fashion</a></li>
                        <li>Ladies Kurti</li> -->
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <div class="listDirectory">
        <div class="listDirectoryTop">
            <div class="container-fluid">
                <ul class="catList">
                    <li class="active"><a href="<?=base_url($location)?>">All</a></li>
                    <?php if(!empty($list_loc)) {?>
                        <?php foreach($list_loc as $loc){ ?>
                        <li><a href="<?=base_url($loc['location_url'])?>"><?=$loc['location_name']?></a></li>
                        <?php } ?>
                    <?php } ?>
                    
                    <?php /*
                    $current_location = $this->uri->segment(1); 
                    ?>
                    <li class="<?= empty($current_location) ? 'active' : '' ?>"><a href="<?= base_url($location) ?>">All</a></li>
                    <?php if (!empty($list_loc)) { ?>
                        <?php foreach ($list_loc as $loc) {
                            $is_active = ($loc['location_url'] == $current_location) ? 'active' : '';
                            ?>
                            <li class="<?= $is_active ?>">
                                <a href="<?= base_url($loc['location_url']) ?>"><?= $loc['location_name'] ?></a>
                            </li>
                        <?php } ?>
                    <?php } */?>

                </ul>
            </div>
        </div>


        <div class="container-fluid">
            <div class="listingTitleSection">
                <div class="">
                    <h1 class="listingTitleH1">Apparel manufacturer in Delhi</h1>
                    <div class="listingFilter">
                        <label>
                            <input type="checkbox" name="listFilter" value="Top Rated">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
                                    <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z" />
                                </svg> Top Rated</span>
                        </label>
                        <label>
                            <input type="checkbox" name="listFilter" data-value="postCompany" value="Agent">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-patch-check" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd" d="M10.354 6.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7 8.793l2.646-2.647a.5.5 0 0 1 .708 0" />
                                    <path d="m10.273 2.513-.921-.944.715-.698.622.637.89-.011a2.89 2.89 0 0 1 2.924 2.924l-.01.89.636.622a2.89 2.89 0 0 1 0 4.134l-.637.622.011.89a2.89 2.89 0 0 1-2.924 2.924l-.89-.01-.622.636a2.89 2.89 0 0 1-4.134 0l-.622-.637-.89.011a2.89 2.89 0 0 1-2.924-2.924l.01-.89-.636-.622a2.89 2.89 0 0 1 0-4.134l.637-.622-.011-.89a2.89 2.89 0 0 1 2.924-2.924l.89.01.622-.636a2.89 2.89 0 0 1 4.134 0l-.715.698a1.89 1.89 0 0 0-2.704 0l-.92.944-1.32-.016a1.89 1.89 0 0 0-1.911 1.912l.016 1.318-.944.921a1.89 1.89 0 0 0 0 2.704l.944.92-.016 1.32a1.89 1.89 0 0 0 1.912 1.911l1.318-.016.921.944a1.89 1.89 0 0 0 2.704 0l.92-.944 1.32.016a1.89 1.89 0 0 0 1.911-1.912l-.016-1.318.944-.921a1.89 1.89 0 0 0 0-2.704l-.944-.92.016-1.32a1.89 1.89 0 0 0-1.912-1.911z" />
                                </svg> GM Verified</span>
                        </label>

                        <div class="itemRating">
                            <div class="ratingBtn" id="selectedRating">Ratings</div>
                            <ul class="itemRatingsList" id="ratingsList">
                                <li data-value="Any">Any</li>
                                <li data-value="3.5">3.5</li>
                                <li data-value="4.0">4.0</li>
                                <li data-value="4.5">4.5</li>
                                <li data-value="5.0">5.0</li>
                                <li class="clear-option"><button id="clearOrClose">Closed</button></li>
                            </ul>
                        </div>


                    </div>
                </div>

                <ul class="listTags">
                    <li>
                        <a href="">
                            <span>Embroidered Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Short Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Designer Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Crepe Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Synthetic Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Synthetic Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Synthetic Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Synthetic Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Synthetic Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>Synthetic Kurtis</span>
                        </a>
                    </li>
                    <li>
                        <a href="">
                            <span>More...</span>
                        </a>
                    </li>
                </ul>
            </div>





            <div class="row">
                <div class="col-xxl-9 col-xl-9 col-md-9 col-sm-9 col-12">
                    <div class="listItem">
                        <div class="listItemLeft">
                            <div class="ribbon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                        <path d="M2466 4250 c-63 -16 -153 -70 -197 -117 -22 -24 -55 -74 -72 -111 -29 -61 -32 -76 -32 -162 0 -86 3 -102 31 -160 17 -36 45 -82 63 -102 l31 -36 -57 -111 c-54 -103 -60 -111 -83 -107 -67 14 -242 18 -323 7 -362 -49 -640 -239 -842 -576 -9 -14 -29 4 -132 118 l-123 136 33 68 c29 62 32 77 32 164 0 90 -2 99 -37 171 -45 91 -103 147 -196 191 -61 29 -76 32 -162 32 -86 0 -101 -3 -162 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -163 17 -37 50 -87 73 -112 43 -47 164 -116 204 -116 11 0 27 -4 34 -8 8 -5 62 -281 141 -723 110 -607 127 -715 114 -722 -40 -23 -85 -74 -110 -125 -23 -47 -28 -70 -28 -132 0 -125 62 -222 174 -274 l46 -21 1875 0 1875 0 46 21 c25 12 61 36 82 53 92 82 121 237 64 353 -25 51 -70 102 -110 125 -13 7 4 115 114 722 80 445 133 718 141 723 7 4 23 8 34 8 40 0 161 69 204 116 23 25 56 75 73 112 29 61 32 76 32 162 0 86 -3 101 -32 162 -44 93 -100 151 -191 196 -72 35 -81 37 -171 37 -87 0 -102 -3 -163 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -164 l33 -68 -122 -135 c-100 -110 -124 -133 -133 -120 -5 8 -31 49 -57 89 -154 241 -423 422 -713 478 -76 14 -289 18 -370 7 l-50 -8 -58 111 -57 111 31 36 c18 20 46 66 63 102 28 59 31 74 31 161 0 90 -2 99 -37 171 -68 136 -188 217 -336 224 -42 2 -94 -1 -116 -6z m204 -224 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m400 -1350 c308 -584 421 -791 440 -802 34 -18 70 -17 101 4 15 9 217 229 449 487 479 533 487 541 496 532 4 -3 -51 -328 -122 -722 l-129 -715 -682 0 c-507 0 -689 -3 -708 -12 -29 -13 -55 -55 -55 -88 0 -33 26 -75 55 -88 19 -9 209 -12 745 -12 536 0 726 -3 745 -12 47 -21 67 -82 43 -133 -26 -58 93 -55 -1887 -55 -1390 0 -1826 3 -1846 12 -69 31 -72 132 -5 171 25 15 94 17 749 17 537 0 727 3 746 12 29 13 55 55 55 88 0 33 -26 75 -55 88 -19 9 -200 12 -708 12 l-682 0 -129 715 c-71 394 -126 719 -122 722 9 9 16 2 496 -532 232 -258 434 -478 449 -487 14 -10 36 -18 49 -18 63 0 59 -7 486 807 225 428 413 783 417 788 4 6 49 10 101 9 l93 -1 415 -787z m-2560 750 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m4320 0 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m-2773 -274 c9 -6 -59 -145 -247 -502 -143 -271 -264 -498 -268 -502 -10 -10 -405 422 -410 447 -2 9 15 50 38 93 130 240 362 408 633 457 81 15 235 19 254 7z m1328 -21 c173 -45 359 -163 468 -298 61 -76 140 -215 135 -238 -5 -25 -400 -457 -410 -447 -4 4 -125 231 -268 502 -191 364 -257 496 -247 503 21 14 236 0 322 -22z" />
                                        <path d="M2348 2372 c-167 -166 -168 -168 -168 -212 0 -44 1 -46 168 -212 166 -167 168 -168 212 -168 44 0 46 1 212 168 167 166 168 168 168 212 0 44 -1 46 -168 212 -166 167 -168 168 -212 168 -44 0 -46 -1 -212 -168z m287 -142 l70 -70 -73 -73 -72 -72 -72 72 -73 73 70 70 c38 38 72 70 75 70 3 0 37 -32 75 -70z" />
                                        <path d="M2511 1446 c-87 -48 -50 -186 49 -186 51 0 100 49 100 99 0 75 -83 124 -149 87z" />
                                    </g>
                                </svg> Industry Leaders
                            </div>
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <!-- <div class="item">
                                    <div class="memberBox">
                                        <p><img src="designer/images/gst.webp"></p>
                                        <p><span>GST Number</span> <strong>03AIAPK8482E1ZG</strong></p>
                                    </div>
                                </div> -->

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>

                    <div class="listItem">
                        <div class="listItemLeft">
                            <div class="ribbon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                                    <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="currentColor" stroke="none">
                                        <path d="M2466 4250 c-63 -16 -153 -70 -197 -117 -22 -24 -55 -74 -72 -111 -29 -61 -32 -76 -32 -162 0 -86 3 -102 31 -160 17 -36 45 -82 63 -102 l31 -36 -57 -111 c-54 -103 -60 -111 -83 -107 -67 14 -242 18 -323 7 -362 -49 -640 -239 -842 -576 -9 -14 -29 4 -132 118 l-123 136 33 68 c29 62 32 77 32 164 0 90 -2 99 -37 171 -45 91 -103 147 -196 191 -61 29 -76 32 -162 32 -86 0 -101 -3 -162 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -163 17 -37 50 -87 73 -112 43 -47 164 -116 204 -116 11 0 27 -4 34 -8 8 -5 62 -281 141 -723 110 -607 127 -715 114 -722 -40 -23 -85 -74 -110 -125 -23 -47 -28 -70 -28 -132 0 -125 62 -222 174 -274 l46 -21 1875 0 1875 0 46 21 c25 12 61 36 82 53 92 82 121 237 64 353 -25 51 -70 102 -110 125 -13 7 4 115 114 722 80 445 133 718 141 723 7 4 23 8 34 8 40 0 161 69 204 116 23 25 56 75 73 112 29 61 32 76 32 162 0 86 -3 101 -32 162 -44 93 -100 151 -191 196 -72 35 -81 37 -171 37 -87 0 -102 -3 -163 -32 -93 -44 -151 -100 -196 -191 -35 -72 -37 -81 -37 -171 0 -87 3 -102 32 -164 l33 -68 -122 -135 c-100 -110 -124 -133 -133 -120 -5 8 -31 49 -57 89 -154 241 -423 422 -713 478 -76 14 -289 18 -370 7 l-50 -8 -58 111 -57 111 31 36 c18 20 46 66 63 102 28 59 31 74 31 161 0 90 -2 99 -37 171 -68 136 -188 217 -336 224 -42 2 -94 -1 -116 -6z m204 -224 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m400 -1350 c308 -584 421 -791 440 -802 34 -18 70 -17 101 4 15 9 217 229 449 487 479 533 487 541 496 532 4 -3 -51 -328 -122 -722 l-129 -715 -682 0 c-507 0 -689 -3 -708 -12 -29 -13 -55 -55 -55 -88 0 -33 26 -75 55 -88 19 -9 209 -12 745 -12 536 0 726 -3 745 -12 47 -21 67 -82 43 -133 -26 -58 93 -55 -1887 -55 -1390 0 -1826 3 -1846 12 -69 31 -72 132 -5 171 25 15 94 17 749 17 537 0 727 3 746 12 29 13 55 55 55 88 0 33 -26 75 -55 88 -19 9 -200 12 -708 12 l-682 0 -129 715 c-71 394 -126 719 -122 722 9 9 16 2 496 -532 232 -258 434 -478 449 -487 14 -10 36 -18 49 -18 63 0 59 -7 486 807 225 428 413 783 417 788 4 6 49 10 101 9 l93 -1 415 -787z m-2560 750 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m4320 0 c59 -39 85 -89 85 -166 0 -78 -26 -127 -88 -168 -56 -37 -153 -39 -210 -3 -76 47 -111 140 -88 229 14 51 75 117 123 131 53 16 135 6 178 -23z m-2773 -274 c9 -6 -59 -145 -247 -502 -143 -271 -264 -498 -268 -502 -10 -10 -405 422 -410 447 -2 9 15 50 38 93 130 240 362 408 633 457 81 15 235 19 254 7z m1328 -21 c173 -45 359 -163 468 -298 61 -76 140 -215 135 -238 -5 -25 -400 -457 -410 -447 -4 4 -125 231 -268 502 -191 364 -257 496 -247 503 21 14 236 0 322 -22z" />
                                        <path d="M2348 2372 c-167 -166 -168 -168 -168 -212 0 -44 1 -46 168 -212 166 -167 168 -168 212 -168 44 0 46 1 212 168 167 166 168 168 168 212 0 44 -1 46 -168 212 -166 167 -168 168 -212 168 -44 0 -46 -1 -212 -168z m287 -142 l70 -70 -73 -73 -72 -72 -72 72 -73 73 70 70 c38 38 72 70 75 70 3 0 37 -32 75 -70z" />
                                        <path d="M2511 1446 c-87 -48 -50 -186 49 -186 51 0 100 49 100 99 0 75 -83 124 -149 87z" />
                                    </g>
                                </svg> Industry Leaders
                            </div>

                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <!-- <div class="item">
                                    <div class="memberBox">
                                        <p><img src="designer/images/gst.webp"></p>
                                        <p><span>GST Number</span> <strong>03AIAPK8482E1ZG</strong></p>
                                    </div>
                                </div> -->

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>



                    <div class="listItem">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <!-- <div class="item">
                                    <div class="memberBox">
                                        <p><img src="designer/images/gst.webp"></p>
                                        <p><span>GST Number</span> <strong>03AIAPK8482E1ZG</strong></p>
                                    </div>
                                </div> -->

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>

                    <div class="listItem">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <!-- <div class="item">
                                    <div class="memberBox">
                                        <p><img src="designer/images/gst.webp"></p>
                                        <p><span>GST Number</span> <strong>03AIAPK8482E1ZG</strong></p>
                                    </div>
                                </div> -->

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>

                    <div class="postRequirement">
                        <div class="ribbonSave">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clock" viewBox="0 0 16 16">
                                    <path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71z" />
                                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0" />
                                </svg> Save Your Time</span>
                        </div>
                        <form>
                            <div class="postRequirementTitle">Post your Buy Requirement</div>
                            <p>Get Quotes from Verified Suppliers</p>
                            <div class="row">
                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="fname2" placeholder="Products / Services you are looking for..." value="" required="">
                                    </div>
                                </div>

                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <div class="inputGroup">
                                            <input type="text" name="quantity" class="form-control" placeholder="Quantity*" required="">
                                            <input type="hidden" name="unit" class="unitInput" value="Piece">
                                            <div class="unitToggle">Piece</div>
                                            <ul class="unitDropdown" style="display: none;">
                                                <li>Piece</li>
                                                <li>Unit</li>
                                            </ul>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control telePhone" name="phone" placeholder="Phone Number*" value="" required>
                                    </div>
                                </div>

                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <div class="form-group">
                                        <input type="email" class="form-control" name="fname2" placeholder="Email Address*" value="" required="">
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                                    <button type="submit" class="submitButton">Get Quotes Now</button>
                                </div>

                            </div>

                        </form>
                    </div>

                    <div class="listItem">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <!-- <div class="item">
                                    <div class="memberBox">
                                        <p><img src="designer/images/gst.webp"></p>
                                        <p><span>GST Number</span> <strong>03AIAPK8482E1ZG</strong></p>
                                    </div>
                                </div> -->

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>


                    <div class="listItem">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>

                    <div class="listItem hidden">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>

                    <div class="listItem hidden">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>


                    <div class="listItem hidden">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>


                    <div class="listItem hidden">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/designer/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>


                    <div class="listItem hidden">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/designer/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>

                    <div class="listItem hidden">
                        <div class="listItemLeft">
                            <a href="">
                                <div class="listHeader">
                                    <div class="itemLogo">
                                        <img src="<?=base_url('assets/frontend')?>/images/b.png">
                                    </div>
                                    <div class="ItemInfo">
                                        <div class="ItemInfoTitle"> Baghel Industries Pvt. Ltd.</div>
                                        <div class="link">https://www.onlinekurtisindia.com<span> › amp › ladies-kurti</span></div>
                                    </div>
                                </div>
                                <div class="listItemMoreInfoTitle">Ladies Kurti Manufacturers in Delhi</div>
                            </a>
                            <p>Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official. Established in 2011 as FS Clothing Company, our company has quickly risen to prominence in the fashion industry, specializing in stylish and high-quality ladies. Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officia quis explicabo placeat consectetur soluta dolorum! Nam eum official.</p>
                            <div class="catListWidthImg">
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>
                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>

                                <div class="catItem">
                                    <a href="">
                                        <div class="image">
                                            <img src="https://www.onlinekurtisindia.com/uploaded-files/category/images/thumbs/American-Crepe-Kurti-thumbs-245X370.jpg" alt="" title="">
                                        </div>
                                    </a>
                                </div>


                            </div>
                        </div>
                        <div class="listItemRight">
                            <div class="itemCompany">
                                <div class="companyName">
                                    <a href="https://www.onlinekurtisindia.com" target="_blank">
                                        <div class="title">Baghel Industries Pvt. Ltd.</div>
                                        <div class="since">Member Since: 2010</div>
                                    </a>
                                    <p class="itemLocation">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path>
                                        </svg> New Delhi - 110015, India
                                        <span class="tooltiptext">3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi, 110015</span>
                                    </p>
                                </div>
                            </div>
                            <div class="member">

                                <div class="item">
                                    <div data-bs-toggle="modal" data-bs-target="#videoModal" class="memberBox videoModal">
                                        <div class="memberIcon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="youtube" viewBox="0 0 16 16">
                                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                                            </svg>
                                        </div>
                                        <div class="memberText">Factory Video</div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox" data-bs-toggle="modal" data-bs-target="#certificate">
                                        <div class="memberIcon"><img src="<?=base_url('assets/frontend')?>/images/trustSeal.webp"></div>
                                        <div class="memberText"><span>GM Verified</span> <strong></strong></div>
                                    </div>
                                </div>

                                <div class="item">
                                    <div class="memberBox">
                                        <div class="memberIcon">
                                            <img src="<?=base_url('assets/frontend')?>/images/favicon.ico">
                                        </div>
                                        <div class="memberText">
                                            <!-- <span>GMB Listing</span> -->
                                            <div class="memberStar">
                                                <span class="ratingNumber">4.3</span>/5
                                                <div class="starDiv">
                                                    <div class="starWidth" style="width:86%"><span>★★★★★</span></div>
                                                    <div class="emsRt"><span>★★★★★</span></div>
                                                </div>
                                                <span class="color">(135)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="action">
                                <a href="" class="viewMobile">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                                        <path d="M21 16.42V19.9561C21 20.4811 20.5941 20.9167 20.0705 20.9537C19.6331 20.9846 19.2763 21 19 21C10.1634 21 3 13.8366 3 5C3 4.72371 3.01545 4.36687 3.04635 3.9295C3.08337 3.40588 3.51894 3 4.04386 3H7.5801C7.83678 3 8.05176 3.19442 8.07753 3.4498C8.10067 3.67907 8.12218 3.86314 8.14207 4.00202C8.34435 5.41472 8.75753 6.75936 9.3487 8.00303C9.44359 8.20265 9.38171 8.44159 9.20185 8.57006L7.04355 10.1118C8.35752 13.1811 10.8189 15.6425 13.8882 16.9565L15.4271 14.8019C15.5572 14.6199 15.799 14.5573 16.001 14.6532C17.2446 15.2439 18.5891 15.6566 20.0016 15.8584C20.1396 15.8782 20.3225 15.8995 20.5502 15.9225C20.8056 15.9483 21 16.1633 21 16.42Z"></path>
                                    </svg> View Mobile Number
                                </a>

                                <a href="" class="contactManufacturer">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z" />
                                    </svg> Contact Manufacturer</a>
                                <a href="" class="websiteBtn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-globe-central-south-asia" viewBox="0 0 16 16">
                                        <path d="M8 0a8 8 0 1 0 0 16A8 8 0 0 0 8 0M4.882 1.731a.48.48 0 0 0 .14.291.487.487 0 0 1-.126.78l-.291.146a.7.7 0 0 0-.188.135l-.48.48a1 1 0 0 1-1.023.242l-.02-.007a1 1 0 0 0-.462-.04 7 7 0 0 1 2.45-2.027m-3 9.674.86-.216a1 1 0 0 0 .758-.97v-.184a1 1 0 0 1 .445-.832l.04-.026a1 1 0 0 0 .152-1.54L3.121 6.621a.414.414 0 0 1 .542-.624l1.09.818a.5.5 0 0 0 .523.047.5.5 0 0 1 .724.447v.455a.8.8 0 0 0 .131.433l.795 1.192a1 1 0 0 1 .116.238l.73 2.19a1 1 0 0 0 .949.683h.058a1 1 0 0 0 .949-.684l.73-2.189a1 1 0 0 1 .116-.238l.791-1.187A.45.45 0 0 1 11.743 8c.16 0 .306.084.392.218.557.875 1.63 2.282 2.365 2.282l.04-.001a7.003 7.003 0 0 1-12.658.905Z" />
                                    </svg> Visit Website</a>

                            </div>
                        </div>
                    </div>


                    <button class="loadMoreBtn" type="button">Load More</button>

                </div>

                <div class="col-xxl-3 col-xl-3 col-md-3 col-sm-3 col-12">
                <?php $this->load->view('common/app_sidebar'); ?>  

                </div>
            </div>

        </div>
    </div>

    <?php $this->load->view('common/app_footer'); ?>
    <?php $this->load->view('common/app_modal'); ?>
    <?php $this->load->view('common/app_bottom'); ?>


    <script>
        $(document).ready(function() {
            var wordLimit = 75;

            $('.listItem p').each(function() {
                var $this = $(this);
                var text = $this.text().trim();
                var words = text.split(/\s+/);

                if (words.length > wordLimit) {
                    var truncated = words.slice(0, wordLimit).join(' ') + '...';
                    $this.text(truncated);
                }
            });
        });
    </script>

    <script>
        $(function() {
            $('.ratingBtn').click(() => $('#ratingsList').toggle());

            $('#ratingsList li:not(.clear-option)').click(function() {
                const text = $(this).text();
                $('#selectedRating').text(text).addClass('selected');
                $('#clearOrClose').text('Clear');
                $('#ratingsList').hide();
            });

            $('#clearOrClose').click(function(e) {
                e.stopPropagation();
                const btn = $('#selectedRating');
                if ($(this).text() === 'Clear') {
                    btn.text('Ratings').removeClass('selected');
                    $(this).text('Closed');
                }
                $('#ratingsList').hide();
            });

            $(document).click(function(e) {
                if (!$(e.target).closest('.itemRating').length) {
                    $('#ratingsList').hide();
                }
            });
        });
    </script>

    <script>
        const videoId = 'Tm7ui3Tv7j8'; // Replace with your YouTube video ID
        const $iframe = $('#youtubeIframe');

        $('#videoModal').on('show.bs.modal', function() {
            const videoUrl = `https://www.youtube.com/embed/${videoId}?autoplay=1`;
            $iframe.attr('src', videoUrl);
        });

        $('#videoModal').on('hidden.bs.modal', function() {
            $iframe.attr('src', ''); // Reset the iframe to stop video
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.inputGroup').each(function() {
                const group = $(this);

                group.find('.unitToggle').on('click', function() {
                    group.find('.unitDropdown').toggle();
                });

                group.find('.unitDropdown li').on('click', function() {
                    const selected = $(this).text();
                    group.find('.unitToggle').text(selected);
                    group.find('.unitInput').val(selected);
                    group.find('.unitDropdown').hide();
                });
            });

            $(document).on('click', function(e) {
                if (!$(e.target).closest('.inputGroup').length) {
                    $('.unitDropdown').hide();
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            let itemsToShow = 2;
            let hiddenItems = $('.listItem.hidden');
            let totalHidden = hiddenItems.length;

            $('.loadMoreBtn').click(function() {
                hiddenItems.slice(0, itemsToShow).removeClass('hidden');
                hiddenItems = $('.listItem.hidden');
                if (hiddenItems.length === 0) {
                    $(this).fadeOut("slow");
                }
            });
        });
    </script>
     

</body>

</html>