<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>GetManufacturers.com - Indian Manufacturers Directory, Top Manufacturing Companies</title>
    <meta name="description" content="Explore GetManufacturers.com – India’s leading manufacturers directory. Find verified suppliers, exporters, and top manufacturing companies across industries. Boost your B2B sourcing now!
">
    <meta name="keywords" content="Indian manufacturers directory, manufacturing companies in India, B2B suppliers India, industrial manufacturers, exporters India, top manufacturers, wholesale suppliers, factory directory India, GetManufacturers.com, Top Manufacturers in India, Top Manufacturing Companies">
    <?php $this->load->view('common/app_top'); ?>


    <meta itemprop="name" content="GetManufacturers.com - Indian Manufacturers Directory, Top Manufacturing Companies">
<meta itemprop="image" content="<?=base_url('assets/frontend')?>/images/gm.png">
<meta itemprop="description" content="Explore GetManufacturers.com – India’s leading manufacturers directory. Find verified suppliers, exporters, and top manufacturing companies across industries. Boost your B2B sourcing now!">
<meta itemprop="keywords" content="Indian manufacturers directory, manufacturing companies in India, B2B suppliers India, industrial manufacturers, exporters India, top manufacturers, wholesale suppliers, factory directory India, GetManufacturers.com, Top Manufacturers in India, Top Manufacturing Companies">
<!-- End -->

<meta name="document-type" content="Public">
<meta name="document-rating" content="Safe for Kids">
<meta name="Expires" content="never">
<meta name="HandheldFriendly" content="True">
<meta name="YahooSeeker" content="Index,Follow">
<meta name="geo.region" content="IN">
<meta name="State" content="">
<meta name="City" content="">
<meta name="geo.position" content="28.6590;77.1506">
<meta name="ICBM" content="28.6590;77.1506">
<meta name="address" content=" ">
<meta name="copyright" content="Copyright 2010-25 GetManufacturers.com">
<meta name="distribution" content="global">
<meta name="language" content="english">
<meta name="rating" content="general">
<meta name="subject" content="GetManufacturers.com - Indian Manufacturers Directory, Top Manufacturing Companies">
<meta name="robots" content="ALL">
<meta name="revisit-after" content="2 days">
<meta name="generator" content="">
<meta name="author" content="Webpulse Solution Pvt Ltd">
<meta name="og:type" content="article">
<meta name="og:title" content="GetManufacturers.com - Indian Manufacturers Directory, Top Manufacturing Companies">
<meta name="og:image" content="<?=base_url('assets/frontend')?>/images/favicon.ico">
<meta name="og:site_name" content="GetManufacturers.com">
<meta name="og:description" content="Explore GetManufacturers.com – India’s leading manufacturers directory. Find verified suppliers, exporters, and top manufacturing companies across industries. Boost your B2B sourcing now!">
<meta name="twitter:card" content="summary">
<meta name="twitter:desc" content="Explore GetManufacturers.com – India’s leading manufacturers directory. Find verified suppliers, exporters, and top manufacturing companies across industries. Boost your B2B sourcing now!">
<meta name="twitter:title" content="GetManufacturers.com - Indian Manufacturers Directory, Top Manufacturing Companies">
<meta name="abstract" content="GetManufacturers.com - Indian Manufacturers Directory, Top Manufacturing Companies">
<meta name="Classification" content="Explore GetManufacturers.com – India’s leading manufacturers directory. Find verified suppliers, exporters, and top manufacturing companies across industries. Boost your B2B sourcing now!">
<meta name="dc.source" content="">
<meta name="dc.title" content="GetManufacturers.com - Indian Manufacturers Directory, Top Manufacturing Companies">
<meta name="dc.keywords" content="Explore GetManufacturers.com – India’s leading manufacturers directory. Find verified suppliers, exporters, and top manufacturing companies across industries. Boost your B2B sourcing now!">
<meta name="dc.subject" content="GetManufacturers.com">
<meta name="dc.description" content="Explore GetManufacturers.com – India’s leading manufacturers directory. Find verified suppliers, exporters, and top manufacturing companies across industries. Boost your B2B sourcing now!">
<link rel="publisher" href="https://g.page/Webpulse">
<link rel="canonical" href="https://www.getmanufacturers.com">
<meta name="viewport" content="width=device-width, initial-scale=1">




</head>

<body>
    <div class="gmHome">
        <?php $this->load->view('common/app_home_header'); ?>
        <div class="homeWrapper">
            <div class="homeSearch">
                <div class="container">
                    <div class="logo">
                        <a href="<?= base_url() ?>" title="Get Manufacturers">
                            <img src="<?= base_url('assets/frontend') ?>/images/logo.png" alt="Get Manufacturers" title="Get Manufacturers">
                        </a>
                    </div>
                    <h1 class="homeTitleH1">India’s 1st Business Directory Dedicated to Verified Manufacturers!</h1>

                    <div class="searchWrapper">
                        <div class="searchBox">
                            <svg class="searchIcon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001q.044.06.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1 1 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0" />
                            </svg>
                            <input id="categorySearch" type="text" name="search" placeholder="Search manufacturers of any product..." required autocomplete="off">
                            <span class="mic">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M3.5 6.5A.5.5 0 0 1 4 7v1a4 4 0 0 0 8 0V7a.5.5 0 0 1 1 0v1a5 5 0 0 1-4.5 4.975V15h3a.5.5 0 0 1 0 1h-7a.5.5 0 0 1 0-1h3v-2.025A5 5 0 0 1 3 8V7a.5.5 0 0 1 .5-.5" />
                                    <path d="M10 8a2 2 0 1 1-4 0V3a2 2 0 1 1 4 0zM8 0a3 3 0 0 0-3 3v5a3 3 0 0 0 6 0V3a3 3 0 0 0-3-3" />
                                </svg>
                            </span>
                            <button class="homeSearchBtn" type="submit">Search</button>
                        </div>

                        <div class="trending-box" id="trendingBox"></div>



                        <div class="requirementTitle">Or you can <a href="">Submit Buy Requirement</a></div>
                    </div>

                    <div class="mainCategory">
                        <h2 class="mainCategoryTitle">Find Manufacturer by Industry</h2>

                        <?php if (!empty($category_tree)) { ?>
                            <div class="categoryWrapper">
                                <?php
                                foreach ($category_tree as $parent) {
                                ?>
                                    <div class="categoryItem">
                                        <a href="<?= base_url($parent['page_url']) ?>">
                                            <img src="<?= (!empty($parent['category_icon'])) ? base_url('uploaded-files/category/' . $parent['category_icon']) : base_url('uploaded-files/category/thumb_75_75_noimg.png') ?>" alt="<?= $parent['category_name'] ?>" title="<?= $parent['category_name'] ?>">
                                            <span><?= $parent['category_name'] ?></span>
                                        </a>
                                        <?php if (!empty($parent['children'])) { ?>
                                            <div class="categoryList">
                                                <div class="fullInfo">
                                                    <ul>
                                                        <?php
                                                        foreach ($parent['children'] as $child) {
                                                        ?>
                                                            <li><a href="<?= base_url($child['page_url']) ?>"><?= $child['category_name'] ?></a>
                                                                <?php if (!empty($child['children'])) { ?>
                                                                    <ul>
                                                                        <?php
                                                                        foreach ($child['children'] as $subchild) { ?>
                                                                            <li><a href="<?= base_url($subchild['page_url']) ?>"><?= $subchild['category_name'] ?></a></li>
                                                                        <?php } ?>
                                                                    </ul>
                                                                <?php } ?>
                                                            </li>
                                                        <?php } ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } ?>

                    </div>

                    <div class="clearfix"></div>
                    <?php /*
                    <div class="homeRegionSection">
                        <ul class="list">
                            <li>
                                <h3>Find Manufacturer by City</h3>
                            </li>
                            <?php if (!empty($list_loc)) { ?>
                                <?php foreach ($list_loc as $loc) { ?>
                                    <li>
                                        <a href="<?= base_url($loc['location_url']) ?>/">
                                            <span><?= $loc['location_name'] ?></span>
                                        </a>
                                    </li>
                                <?php } ?>
                            <?php } ?>
                            <li>
                                <a href="<?= base_url('gm-directory') ?>#market-area">
                                    <span>More Cities <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-double-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M3.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L9.293 8 3.646 2.354a.5.5 0 0 1 0-.708" />
                                            <path fill-rule="evenodd" d="M7.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L13.293 8 7.646 2.354a.5.5 0 0 1 0-.708" />
                                        </svg></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <?php */ ?>
                </div>

            </div>
        </div>
    </div>


    <!-- <div class="homeBottom">
        <div class="container-fluid">
            <ul class="bottomLinks">
                <li>Copyright © 2025 <a href="" target="_blank">Getmanufacturers.com</a> by Webpulse</li>
                <li></li>
                <li><a href="<?= base_url('faqs') ?>">FAQs</a></li>
                <li><a href="<?= base_url('contact-us') ?>">Contact us</a></li>
                <li><a href="<?= base_url('privacy-policy') ?>">Privacy Policy</a></li>
                <li><a href="<?= base_url('terms-conditions') ?>">Terms & Conditions</a></li>
            </ul>
        </div>
    </div> -->
    <div class="homeBottom">
        <div class="container-fluid">
            <ul class="bottomLinks">
                <li>Copyright © 2025 <a href="" target="_blank">Getmanufacturers.com</a> by Webpulse</li>
                <li></li>
                <li><a href="javascript:void(0);">FAQs</a></li>
                <li><a href="javascript:void(0);">Contact us</a></li>
                <li><a href="javascript:void(0);">Privacy Policy</a></li>
                <li><a href="javascript:void(0);">Terms & Conditions</a></li>
            </ul>
        </div>
    </div>

    <?php $this->load->view('common/app_bottom'); ?>


    <script>
        $(document).ready(function() {
            let currentIndex = -1; // Track the selected index
            let items = []; // To store the list of suggestions

            // Trigger AJAX request on input (instead of keyup)
            $('#categorySearch').on('input', function() {
                let search_url = '<?= base_url('search_categories') ?>';
                let query = $(this).val();

                if (query.length > 1) {
                    $.ajax({
                        url: search_url,
                        method: "POST",
                        data: {
                            keyword: query
                        },
                        success: function(data) {
                            $('#trendingBox').html(data).fadeIn();
                            items = $('#trendingBox li'); // Store the list items for easy access
                            currentIndex = -1; // Reset index when a new search is made
                        }
                    });
                } else {
                    $('#trendingBox').fadeOut();
                    items = []; // Clear the suggestions list
                }
            });

            // Handle keydown for navigation (ArrowDown, ArrowUp, Enter)
            $('#categorySearch').on('keydown', function(event) {
                items = $('#trendingBox li'); // Update items dynamically
                const totalItems = items.length;

                // ArrowDown: Move down in the list
                if (event.key === 'ArrowDown') {
                    event.preventDefault(); // Prevent default scroll behavior
                    if (currentIndex < totalItems - 1) {
                        currentIndex++;
                        updateSelection(items); // Update selection visually
                    }
                }

                // ArrowUp: Move up in the list
                if (event.key === 'ArrowUp') {
                    event.preventDefault(); // Prevent default scroll behavior
                    if (currentIndex > 0) {
                        currentIndex--;
                        updateSelection(items); // Update selection visually
                    }
                }

                // Enter: Select the highlighted suggestion and follow the link
                if (event.key === 'Enter') {
                    event.preventDefault(); // Prevent form submission (if any)
                    if (currentIndex >= 0 && currentIndex < totalItems) {
                        const selectedItem = items.eq(currentIndex);
                        const link = selectedItem.find('a').attr('href'); // Get the href of the selected link
                        window.location.href = link; // Navigate to the link
                        $('#trendingBox').fadeOut(); // Hide the suggestions box after selection
                    }
                }
            });

            // Function to highlight the selected item
            function updateSelection(items) {
                items.removeClass('selected'); // Remove the selected class from all items
                if (currentIndex >= 0 && currentIndex < items.length) {
                    items.eq(currentIndex).addClass('selected'); // Add the selected class to the current item
                }
            }

            // Hide the suggestions box if clicked outside
            $(document).click(function(event) {
                if (!$(event.target).closest('#categorySearch').length) {
                    $('#trendingBox').fadeOut();
                }
            });

            // Ensure clicking on a suggestion follows the link
            $('#trendingBox').on('click', 'li', function() {
                const link = $(this).find('a').attr('href');
                window.location.href = link; // Navigate to the link
                $('#trendingBox').fadeOut(); // Hide the suggestions box after selection
            });
        });
    </script>

    <!-- <script>
        $(document).ready(function() {
            const $trendingBox = $('#trendingBox');
            const $searchInput = $('#searchInput');
            const $clearAllBtn = $('#clearAllBtn');
            const $searchWrapper = $('#searchWrapper');
            const $trendList = $('.trend-list');
            let $trendItems = $('.trend-list li');
            let selectedIndex = -1;

            // Show on focus
            $searchInput.on('focus', function() {
                $trendingBox.slideDown(150);
            });

            // Hide when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('#searchWrapper').length) {
                    $trendingBox.slideUp(150);
                    clearSelection();
                }
            });

            // Click trending item
            $trendList.on('click', 'li', function() {
                const term = $(this).data('term');
                $searchInput.val(term);
                $trendingBox.slideUp(150);
                window.location.href = `https://www.google.com/search?q=${encodeURIComponent(term)}`;
            });

            // Keyboard navigation
            $searchInput.on('keydown', function(e) {
                $trendItems = $('.trend-list li'); // Refresh
                if (e.key === 'ArrowDown') {
                    e.preventDefault();
                    if (selectedIndex < $trendItems.length - 1) {
                        selectedIndex++;
                        updateSelection();
                    }
                } else if (e.key === 'ArrowUp') {
                    e.preventDefault();
                    if (selectedIndex > 0) {
                        selectedIndex--;
                        updateSelection();
                    }
                } else if (e.key === 'Enter') {
                    const selectedItem = $trendItems.eq(selectedIndex);
                    if (selectedItem.length) {
                        selectedItem.click();
                    } else {
                        const term = $(this).val().trim();
                        if (term !== '') {
                            $trendingBox.slideUp(150);
                            window.location.href = `https://www.google.com/search?q=${encodeURIComponent(term)}`;
                        }
                    }
                }
            });

            function updateSelection() {
                $trendItems.removeClass('selected');
                if (selectedIndex >= 0) {
                    $trendItems.eq(selectedIndex).addClass('selected');
                }
            }

            function clearSelection() {
                selectedIndex = -1;
                $trendItems.removeClass('selected');
            }

            // Delete individual item
            $trendList.on('click', '.delete-btn', function(e) {
                e.stopPropagation();
                $(this).closest('li').remove();
                $trendItems = $('.trend-list li');
                clearSelection();
                if ($trendItems.length === 0) {
                    $clearAllBtn.hide();
                    $trendingBox.slideUp(150);
                }
            });

            // Clear all
            $clearAllBtn.on('click', function() {
                $trendList.empty();
                $(this).hide();
                $('.trending-title').html('No Trending Searches');
                $trendingBox.slideUp(150);
            });

            // Show clear button if items exist
            if ($trendList.children().length > 0) {
                $clearAllBtn.show();
            }
        });
    </script> -->




</body>

</html>