<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Agriculture Manufacturers, Suppliers, Exporters, wholesale in India</title>
    <meta name="keywords" content="">
    <meta name="description" content="">
    <?php $this->load->view('common/app_top'); ?>
</head>

<body>

    <?php $this->load->view('common/app_header'); ?>

    <div class="innerBanner">
        <div class="container">
            <div class="listingInner">
                <h1>Indian Manufacturers Directory</h1>
                <p>Browse leading Indian Manufacturers Database from various product categories to reach millions of manufacturing companies in India</p>

            </div>
        </div>
    </div>


    <nav class="breadcrumbs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-12">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li>B2B Portal</li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <div class="marketPage">
        <div class="container">

            <h2 class="marketPageTitle">Top B2B Marketplace in India</h2>
            <div class="image">
                <img src="<?= base_url('assets/frontend') ?>/images/global-market.webp">
            </div>
            <h3>What is Getmanufacturers? - India's Fastest Growing B2B Portal for businesses.</h3>
            <p>Getmanufacturers is the fastest growing best b2b portal in India providing a single solution for all your business needs in a single roof from Sourcing - Quotation - Billing - Buying/Selling - Payments - Delivery. Reduce costs by buying from the largest b2b marketplace in india. You are a manufacturers, suppliers, traders or distributors, whether you have a small business or a large manufacturing enterprise, the options at Getmanufacturers allow you to reach more buyers easily.</p>
            <p>B2B portals are digital solutions that facilitate business interactions within a digital environment. These portals commonly offer e-commerce features, self-service options, and communication tools, serving as a means to effectively manage relationships with suppliers, partners, dealers, and clients.</p>
        </div>
    </div>

    <div class="marketSection">
        <div class="container">
            <div class="marketList" id="marketList">
                <div class="marketListTitle">Find Manufacturer by Country</div>
                <ul class="cityList">
                    <?php foreach ($countries as $country) { ?>
                        <li><a href="<?= base_url($country['location_url']) ?>/"><span><?= htmlspecialchars($country['location_name']) ?></span></a></li>
                    <?php } ?>

                </ul>
                <div class="marketListTitle">Find Manufacturer by States of India</div>
                <ul class="cityList">
                    <?php foreach ($indian_states as $state) { ?>
                        <li><a href="<?= base_url($state['location_url']) ?>/"><span><?= htmlspecialchars($state['location_name']) ?></span></a></li>
                    <?php } ?>

                </ul>


                <?php foreach ($state_cities as $group) { ?>
                    <div class="marketListTitle">Find Manufacturer by Cities of <?= htmlspecialchars($group['state']) ?> </div>
                    <?php if (!empty($group['cities'])) { ?>
                        <ul class="cityList">
                            <?php foreach ($group['cities'] as $city) { ?>
                                <li><a href="<?= base_url($city['location_url']) ?>/"><span><?= htmlspecialchars($city['location_name']) ?></span></a></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                <?php } ?>
            </div>
        </div>
    </div>

    <?php $this->load->view('common/app_footer'); ?>
    <?php $this->load->view('common/app_bottom'); ?>
    <script>
        $(document).ready(function() {
            var wordLimit = 75;

            $('.listItem p').each(function() {
                var $this = $(this);
                var text = $this.text().trim();
                var words = text.split(/\s+/);

                if (words.length > wordLimit) {
                    var truncated = words.slice(0, wordLimit).join(' ') + '...';
                    $this.text(truncated);
                }
            });
        });
    </script>

    <script>
        $(function() {
            $('.ratingBtn').click(() => $('#ratingsList').toggle());

            $('#ratingsList li:not(.clear-option)').click(function() {
                const text = $(this).text();
                $('#selectedRating').text(text).addClass('selected');
                $('#clearOrClose').text('Clear');
                $('#ratingsList').hide();
            });

            $('#clearOrClose').click(function(e) {
                e.stopPropagation();
                const btn = $('#selectedRating');
                if ($(this).text() === 'Clear') {
                    btn.text('Ratings').removeClass('selected');
                    $(this).text('Closed');
                }
                $('#ratingsList').hide();
            });

            $(document).click(function(e) {
                if (!$(e.target).closest('.itemRating').length) {
                    $('#ratingsList').hide();
                }
            });
        });
    </script>

    <script>
        const videoId = 'Tm7ui3Tv7j8'; // Replace with your YouTube video ID
        const $iframe = $('#youtubeIframe');

        $('#videoModal').on('show.bs.modal', function() {
            const videoUrl = `https://www.youtube.com/embed/${videoId}?autoplay=1`;
            $iframe.attr('src', videoUrl);
        });

        $('#videoModal').on('hidden.bs.modal', function() {
            $iframe.attr('src', ''); // Reset the iframe to stop video
        });
    </script>

    <script>
        $(document).ready(function() {
            $('.inputGroup').each(function() {
                const group = $(this);

                group.find('.unitToggle').on('click', function() {
                    group.find('.unitDropdown').toggle();
                });

                group.find('.unitDropdown li').on('click', function() {
                    const selected = $(this).text();
                    group.find('.unitToggle').text(selected);
                    group.find('.unitInput').val(selected);
                    group.find('.unitDropdown').hide();
                });
            });

            $(document).on('click', function(e) {
                if (!$(e.target).closest('.inputGroup').length) {
                    $('.unitDropdown').hide();
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            let itemsToShow = 2;
            let hiddenItems = $('.listItem.hidden');
            let totalHidden = hiddenItems.length;

            $('.loadMoreBtn').click(function() {
                hiddenItems.slice(0, itemsToShow).removeClass('hidden');
                hiddenItems = $('.listItem.hidden');
                if (hiddenItems.length === 0) {
                    $(this).fadeOut("slow");
                }
            });
        });
    </script>

</body>

</html>