<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Home_model extends CI_Model {

  public function __construct() {
    parent::__construct();
  }

  public function get_location_by_slug($slug) {
    return $this->db->get_where('gm_location', ['location_url' => $slug])->row_array();
  }
  
  public function get_company_location_by_slug($slug) {
    return $this->db->get_where('gm_company_locations', ['comp_location_url' => $slug])->row_array();
  }
  
  public function get_company_by_slug($slug) {
    return $this->db->get_where('gm_companies', ['company_url' => $slug])->row_array();
  }
  
  public function get_company_by_id($company_id) {
    return $this->db->get_where('gm_companies', ['company_id' => $company_id])->row_array();
  }
  
  
  
  public function get_company_categories($company_id) {
    return $this->db->get_where('gm_company_categories', ['company_id' => $company_id])->result_array();
  }
  
  public function get_company_category_by_slug($slug) {
    return $this->db->get_where('gm_company_categories', ['comp_category_url' => $slug])->row_array();
  }
  
  public function get_product_details($company_id,$product_url){
      return $this->db->get_where('gm_company_products', ['company_id' => $company_id, 'product_url' => $product_url])->row_array();
  }


  public function get_seo_entity_by_slug($slug) {
    return $this->db->get_where('gm_seo_urls', ['page_url' => $slug])->row_array();
  }

  public function get_category_by_page_url($slug) {
    $seo = $this->db
        ->where('page_url', $slug)
        ->where('entity_type', 'category')
        ->get('gm_seo_urls')
        ->row_array();

    if ($seo) {
        $category_id = $seo['entity_id'];
        $category = $this->db
            ->where('category_id', $category_id)
            ->get('gm_categories')
            ->row_array();
        return $category;
    }

    return null; // Or handle error
  }

  public function get_location_by_location_url($location_url){

    $location = $this->db->where('location_url', $location_url)->get('gm_location')->row_array();
    return $location;

  }
  
  
  public function get_company_location_by_location_url($location_url){

    $location = $this->db->where('comp_location_url', $location_url)->get('gm_company_locations')->row_array();
    return $location;

  }

  public function search_category_slug($keyword) {
        $this->db->select('c.category_name, s.page_url');
        $this->db->from('gm_categories c');
        $this->db->join('gm_seo_urls s', 's.entity_type = "category" AND s.entity_id = c.category_id');
        $this->db->like('c.category_name', $keyword);
        $this->db->limit(10);
        return $this->db->get()->result_array();
    }


    public function get_company_by_page_url($slug) {
        $this->db->where('company_url', $slug);
        $query = $this->db->get('gm_companies');
        return $query->row();
      }


}