<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if (!function_exists('create_thumbnail')) {
    function create_thumbnail($source_path, $thumb_dir, $thumb_width, $thumb_height, $page_url = 'image') {
        // Get CI instance
        $CI =& get_instance();
        $CI->load->library('image_lib');

        // Allowed extensions
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        $file_ext = strtolower(pathinfo($source_path, PATHINFO_EXTENSION));

        if (!in_array($file_ext, $allowed_extensions)) {
            return "Invalid file type: .$file_ext is not supported for thumbnail creation.";
        }

        // Create thumbnail directory if not exists
        if (!is_dir($thumb_dir)) {
            mkdir($thumb_dir, 0755, true);
        }

        // Generate thumbnail filename
        $random_str = substr(md5(uniqid(mt_rand(), true)), 0, 12);
        $thumb_name = 'thumb_' . $thumb_width . '_' . $thumb_height . '_' . $page_url . '_' . $random_str . '.' . $file_ext;
        $thumb_path = $thumb_dir . $thumb_name;

        if ($file_ext == 'webp') {
            // Load WebP image
            $src_img = imagecreatefromwebp($source_path);
            if (!$src_img) return "Failed to read WebP image.";

            $src_width  = imagesx($src_img);
            $src_height = imagesy($src_img);

            // Calculate new dimensions (maintaining ratio)
            $scale = min($thumb_width / $src_width, $thumb_height / $src_height);
            $new_width  = (int)($src_width * $scale);
            $new_height = (int)($src_height * $scale);

            $dst_img = imagecreatetruecolor($new_width, $new_height);
            imagealphablending($dst_img, false);
            imagesavealpha($dst_img, true);

            imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $new_width, $new_height, $src_width, $src_height);
            if (!imagewebp($dst_img, $thumb_path, 90)) {
                return "Failed to save WebP thumbnail.";
            }

            imagedestroy($src_img);
            imagedestroy($dst_img);
        } else {
            // Use GD2 image_lib for non-webp formats
            $config = array(
                'image_library'  => 'gd2',
                'source_image'   => $source_path,
                'new_image'      => $thumb_path,
                'maintain_ratio' => TRUE,
                'width'          => $thumb_width,
                'height'         => $thumb_height
            );

            $CI->image_lib->clear();
            $CI->image_lib->initialize($config);

            if (!$CI->image_lib->resize()) {
                return $CI->image_lib->display_errors();
            }
        }

        return $thumb_name;
    }
}
