<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Admin extends CI_Controller {

    public function __construct() {
        parent::__construct();
        
        $this->load->model(array('sitepanel/admin_model'));
        $this->load->library('paginator');
    }

    public function index() {
        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }


        $get = $this->input->get();
        if(!empty($get['search'])){
            $get['search'] = $get['search'];
        }
        
        if(!empty($get['status'])){
            $get['status'] = $get['status'];
        }

        //$data['heading'] = 'Manage Admin Users';
        //$data['pagelist'] = $this->db->get('gm_admin_users')->result_array();


        $total_row = $this->admin_model->get_admin($get,'count');
        $current_page = isset($get['page']) ? (int)$get['page'] : 1;
        $this->paginator->initialize(['base_url' => base_url('sitepanel/admin/index/'),'total_items' => $total_row,'current_page' => $current_page]);
        $get['limit'] = $this->paginator->limit_end; 
        $get['offset'] = $this->paginator->limit_start;
        
        $data['pagelist'] = $this->admin_model->get_admin($get,$count=NULL);
        $data['pages'] = $get['offset'];
        $data['heading'] = 'Manage Admin Users';
   

        $this->load->view('sitepanel/admin/list_admin_view', $data);
    }
    
    public function add() {

        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }

        $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';
        $data['heading'] = 'Add New Admin User';
        $data['roles'] = $this->db->get_where('gm_admin_roles', ['id >'=> 1, 'status' => '1'])->result_array();
        $data['query_string'] = $_SERVER['QUERY_STRING'];
    
        $this->form_validation->set_rules('admin_name', 'Name', 'trim|required');
        $this->form_validation->set_rules('designation', 'Designation', 'trim|required');
        $this->form_validation->set_rules('role_id', 'Role', 'trim|required|integer');
        $this->form_validation->set_rules('username', 'Username', 'trim|required|is_unique[gm_admin_users.username]');
        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[4]');
    
        if ($this->form_validation->run() == TRUE) {
            $insert_data = array(
                'admin_name'  => $this->input->post('admin_name', TRUE),
                'designation' => $this->input->post('designation', TRUE),
                'role_id'     => $this->input->post('role_id', TRUE),
                'username'    => $this->input->post('username', TRUE),
                'password'    => $this->input->post('password'),
                'status'      => 1,
                'created_at'  => date('Y-m-d H:i:s')
            );
    
            $this->db->insert('gm_admin_users', $insert_data);
    
            $submit_type = $this->input->post('submit');
            if ($submit_type == 'save') {
                $this->session->set_flashdata('success', 'Admin user added.');
                redirect('sitepanel/admin' . $query_string);
            } elseif ($submit_type == 'save_new') {
                $this->session->set_flashdata('success', 'Admin user added. Add another one.');
                redirect('sitepanel/admin/add' . $query_string);
            } elseif ($submit_type == 'save_close') {
                $this->session->set_flashdata('success', 'Admin user added.');
                redirect('sitepanel/admin' . $query_string);
            }
        }
    
        $this->load->view('sitepanel/admin/add_admin_view', $data);
    }

    
    public function edit($admin_id){

        if($this->session->userdata('admin_id') > 1){
             $this->session->set_flashdata('error', 'Access Denied.');
            return redirect(base_url('sitepanel/dashboard'));
        }

        if( $admin_id == '' || (int) $admin_id == 0 ){
            $this->session->set_flashdata('error', 'Invalid ID or ID not found');
            redirect('sitepanel/admin');
            return;
        }
        
        $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

        $this->form_validation->set_rules('admin_name', 'Name', 'trim|required');
        $this->form_validation->set_rules('designation', 'Designation', 'trim|required');
        $this->form_validation->set_rules('role_id', 'Role', 'trim|required|integer'); 
        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[4]');
        $this->form_validation->set_rules('username', 'Username', 'trim|required');

        if ($this->form_validation->run() == TRUE) {

            $exists = $this->db->where('username', $this->input->post('username'))->where('admin_id !=', $admin_id)->get('gm_admin_users')->num_rows();
            if ($exists > 0) {
                $this->session->set_flashdata('error', 'Username already exist.');
                redirect('sitepanel/admin/edit/'.$admin_id . $query_string);
            }

            $update_data = array(
            'admin_name'  => $this->input->post('admin_name', TRUE),
            'designation' => $this->input->post('designation', TRUE),
            'role_id'     => $this->input->post('role_id', TRUE),
            'username'    => $this->input->post('username', TRUE),
            'password'    => $this->input->post('password'),
            'updated_at'  => date('Y-m-d H:i:s') 
            );

            $this->db->where('admin_id', $admin_id);
            $this->db->update('gm_admin_users', $update_data);

            $this->session->set_flashdata('success', 'Updated successfully.');
            redirect('sitepanel/admin' . $query_string);
                 
        }


        $data['heading'] = 'Edit Admin User';
        $data['roles'] = $this->db->get_where('gm_admin_roles', ['status' => '1'])->result_array();
        $data['res'] = $this->db->where('admin_id',$admin_id)->get('gm_admin_users')->row_array();
        $data['query_string'] = $_SERVER['QUERY_STRING'];
        
        $this->load->view('sitepanel/admin/edit_admin_view', $data);

    }

    public function bulk_action() {

        $query_string = $this->input->post('query_string') ? '?' . ltrim($this->input->post('query_string'), '?') : '';

        $action = $this->input->post('bulk_action');
        $ids = $this->input->post('admin_ids');

        /* $sort_orders = $this->input->post('sort_order');
        if ($action === 'update_order') {
            if (!empty($sort_orders)) {
                foreach ($sort_orders as $id => $order) {
                $this->db->update('gm_admin_users', ['sort_order' => (int)$order], ['location_id' => (int)$id]);
                }
                $this->session->set_flashdata('success', 'Order updated successfully.');
            } else {
                $this->session->set_flashdata('error', 'No order values found.');
            }
        redirect('sitepanel/admin/index/' . $query_string);
        return;
        } */
    
        // For other actions, checkboxes must be selected
        if (empty($ids)) {
        $this->session->set_flashdata('error', 'No Record selected.');
        redirect('sitepanel/admin/index/' . $query_string);
        return;
        }
    
        switch ($action) {
        case 'activate':
            $this->db->where_in('admin_id', $ids)->update('gm_admin_users', ['status' => '1']);
            break;
        case 'deactivate':
            $this->db->where_in('admin_id', $ids)->update('gm_admin_users', ['status' => '0']);
            break;
        case 'delete':
            $this->db->where_in('admin_id', $ids)->update('gm_admin_users', ['status' => '2']);
            break;
        }
    
        $this->session->set_flashdata('success', 'Action applied successfully.');
        redirect('sitepanel/admin/index/' . $query_string);
    }


}