<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
//$route['default_controller'] = 'welcome';

// Superadmin panel (sitepanel)
$route['sitepanel'] = 'sitepanel/dashboard';
$route['sitepanel/category/(:num)'] = 'sitepanel/category/index/$1';
//$route['sitepanel/category/edit/(:num)/(:num)'] = 'sitepanel/category/edit/$1/$2';
$route['sitepanel/(:any)'] = 'sitepanel/$1';
$route['sitepanel/(:any)/(:any)'] = 'sitepanel/$1/$2';
$route['sitepanel/(:any)/(:any)/(:any)'] = 'sitepanel/$1/$2/$3';


// Vendor store pages
$route['store/([a-zA-Z0-9_-]+)'] = 'store/view/$1';
$route['store/([a-zA-Z0-9_-]+)/([a-zA-Z0-9_-]+)\.htm'] = 'store/category/$1/$2';
$route['store/([a-zA-Z0-9_-]+)/([a-zA-Z0-9_-]+)/([a-zA-Z0-9_-]+)\.htm'] = 'store/location_category/$1/$2/$3';

// static pages
$route['faqs'] = 'staticpage/faqs';
$route['privacy-policy'] = 'staticpage/privacy_policy';
$route['terms-conditions'] = 'staticpage/terms_conditions';
$route['contact-us'] = 'staticpage/contact_us';
$route['about-us'] = 'staticpage/about_us';
$route['blog'] = 'staticpage/blog';
$route['our-packages'] = 'staticpage/packages';

// gm directory page
$route['gm-directory'] = 'home/gmdirectory';
$route['search_categories'] = 'home/search_categories'; // this is temporary base
$route['send_enquiry'] = 'home/send_enquiry'; // this is temporary base

// Main home - location and category pages
$route['([a-zA-Z0-9_-]+)/([a-zA-Z0-9_-]+)'] = 'home/index/$1/$2'; // /location/category
$route['([a-zA-Z0-9_-]+)'] = 'home/index/$1';    // /category OR /location

$route['default_controller'] = 'home';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
