<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Popular Event Organisers in Mumbai</title>
    <meta name="description" content="">
    <meta name="keywords" content="">
    <?php include 'app_top.php'; ?>
</head>

<body>

    <?php include 'app_header.php';
    ?>

    <div class="loginPage">
        <div class="container">
            <div class="loginform">
                <div class="row g-0">
                    <div class="col-xl-7 col-lg-7 col-md-7 loginBox">
                        <!-- <div class="logo">
                            <a href="index.php" title="Get Manufacturers">
                                <img src="designer/images/logo.png" alt="Get Manufacturers" title="Get Manufacturers">
                            </a>
                        </div> -->
                        <form>
                            <div id="firstLogin">
                                <div class="getLogin">
                                    <strong>Register your Company Free</strong>
                                    <p>Start with your free account today.</p>
                                </div>

                                <div class="form-group">
                                    <input type="email" class="form-control" name="email" placeholder="Email*" autocomplete="off" value="" required="">
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="password" placeholder="Password*" autocomplete="off" value="" required="">
                                </div>

                                <div class="form-group">
                                    <input type="text" id="phoneNumber" class="form-control" name="user_name" placeholder="Mobile number" autocomplete="off" value="" required="">
                                </div>
                               <div class="form-group">
                                <label class="singleCheck"> <input type="checkbox" name="" required> <span>I agree to the Terms of Service and Privacy Policy.</span></label>
                               </div>

                                <div class="form-group">
                                    <button class="nextBtn" id="sendOtpButton"><span>Sign Up for Free</span></button>
                                </div>

                            </div>

                            <div id="mobileOpt">

                                <div class="getLogin">
                                    <div class="backWithOtp">
                                        <div class="backBtn2">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left-short" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd" d="M12 8a.5.5 0 0 1-.5.5H5.707l2.147 2.146a.5.5 0 0 1-.708.708l-3-3a.5.5 0 0 1 0-.708l3-3a.5.5 0 1 1 .708.708L5.707 7.5H11.5a.5.5 0 0 1 .5.5" />
                                            </svg>
                                        </div>
                                        <strong>Verify OTP</strong>
                                    </div>

                                    <p class="oneTimeText">A one time password sent on your mobile number <span class="otpViewNumber">+91-9876543210</span></p>
                                </div>
                                <div id="otpInputs">
                                    <input type="text" class="otp-input" maxlength="1" id="otp1">
                                    <input type="text" class="otp-input" maxlength="1" id="otp2">
                                    <input type="text" class="otp-input" maxlength="1" id="otp3">
                                    <input type="text" class="otp-input" maxlength="1" id="otp4">
                                </div>
                                <div class="mt-2 flex gap-1 didnotReceive">
                                    <p>Didn’t receive OTP? <span id="resendOtpButton"><strong class="resend">Resend</strong></span> <span id="timer"></span></p>
                                </div>
                                <button class="nextBtn" id="verifyOtpButton" type="submit"><span>Login</span></button>
                            </div>

                        </form>
                    </div>
                    <div class="col-xl-5 col-lg-5 col-md-5">
                        <div class="loginImage">
                            <img src="designer/images/signup.webp">
                            <div class="imageTitle">
                                Sell your products to millions of customer!
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'app_footer.php'; ?>
    <?php include 'app_modal.php'; ?>
    <?php include 'app_bottom.php'; ?>

    <script>
        $(document).ready(function() {
            let otpSent;
            let timer;
            let secondsLeft = 30;
            let otpExpired = false;

            const input = document.querySelector("#phoneNumber");

            const iti = window.intlTelInput(input, {
                initialCountry: "in",
                allowDropdown: true,
                autoPlaceholder: "polite",
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js"
            });

            $('#phoneNumber').on('input', function() {
                this.value = this.value.replace(/\D/g, '');
            });

            input.addEventListener('countrychange', function() {
                const selectedCountry = iti.getSelectedCountryData();
                if (selectedCountry.iso2 === "in") {
                    input.setAttribute("maxlength", "10");
                } else {
                    input.removeAttribute("maxlength");
                }
            });

            function startTimer() {
                otpExpired = false;
                secondsLeft = 30;
                timer = setInterval(function() {
                    if (secondsLeft <= 0) {
                        clearInterval(timer);
                        $('#timer').text('OTP expired!');
                        $('.resend').addClass("otpResend");
                        $('#verifyOtpButton').prop('disabled', true);
                        otpExpired = true;
                    } else {
                        $('.resend').removeClass("otpResend");
                        $('#timer').text(`in: ${secondsLeft} Sec`);
                        secondsLeft--;
                    }
                }, 1000);
            }

            $('#sendOtpButton').click(function(e) {
                e.preventDefault();

                const rawNumber = input.value.replace(/\D/g, '');
                const fullNumber = iti.getNumber().replace(/\D/g, '');
                const selectedCountry = iti.getSelectedCountryData();

                if (rawNumber === '') {
                    $('#phoneNumberError').text('Please enter a valid phone number.');
                    return;
                }

                if (selectedCountry.iso2 === "in") {
                    if (rawNumber.length !== 10 || !/^\d{10}$/.test(rawNumber)) {
                        $('#phoneNumberError').text('Please enter a valid 10-digit phone number.');
                        return;
                    }
                } else {
                    if (fullNumber.length < 4 || fullNumber.length > 17) {
                        $('#phoneNumberError').text('Please enter a valid phone number (4 to 17 digits).');
                        return;
                    }
                }

                $('#phoneNumberError').text("");
                otpSent = Math.floor(1000 + Math.random() * 9000);
                otpSent = 1234;// Fixed OTP

                console.log(`OTP sent to ${iti.getNumber()}: ${otpSent}`);
                $('.oneTimeText .otpViewNumber').text(iti.getNumber());
                $('#firstLogin').hide();
                $('#mobileOpt').show();
                $('#otp1, #otp2, #otp3, #otp4').val('');
                $('#verifyOtpButton').prop('disabled', false);
                startTimer();
                alert('OTP has been sent successfully!');
            });

            $('#verifyOtpButton').click(function(e) {
                e.preventDefault();

                const otpEntered = $('#otp1').val() + $('#otp2').val() + $('#otp3').val() + $('#otp4').val();

                if (otpEntered.length !== 4 || !/^\d{4}$/.test(otpEntered)) {
                    alert('Please enter a valid 4-digit OTP.');
                    return;
                }

                if (otpEntered === String(otpSent)) {
                    alert('OTP verified successfully');
                    location.href = "dashboard.php"; // Replace with your actual URL
                    // Proceed to next page or logic
                } else {
                    alert('Invalid OTP');
                }
            });

            $('#resendOtpButton').click(function() {
                if (otpExpired) {
                    $('#otp1, #otp2, #otp3, #otp4').val('');
                    $('#verifyOtpButton').prop('disabled', false);
                    $('#timer').text('');
                    otpSent = Math.floor(1000 + Math.random() * 9000);
                    console.log(`New OTP sent: ${otpSent}`);
                    startTimer();
                    alert('New OTP has been sent successfully!');
                }
            });

            $('.otp-input').on('input', function() {
                const currentInput = $(this);
                const nextInput = currentInput.next('.otp-input');
                const value = currentInput.val();
                if (!/^\d$/.test(value)) {
                    currentInput.val('');
                } else if (value && nextInput.length) {
                    nextInput.focus();
                }
            });

            $('.otp-input').on('keydown', function(e) {
                if (e.key === "Backspace") {
                    const currentInput = $(this);
                    const prevInput = currentInput.prev('.otp-input');
                    if (currentInput.val() === '' && prevInput.length) {
                        prevInput.focus();
                    }
                }
            });

            $('.backBtn2').click(function() {
                clearInterval(timer);
                $('#otp1, #otp2, #otp3, #otp4').val('');
                $('#timer').text('');
                $('#verifyOtpButton').prop('disabled', false);
                $('#firstLogin').show();
                $('#mobileOpt').hide();
            });
        });
    </script>



</body>

</html>