<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <title>Business Trust Profile of Baghel Industries Pvt. Ltd.</title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,500,700" rel="stylesheet">

    <style>
        * {
            margin: 0;
            padding: 0
        }

        body {
            font-family: 'Roboto', sans-serif;
        }

        .certificate {
            width: 100%;
            margin: 15px auto 0;
            border: 0 solid #e1e1e1;
            max-width: 600px;
            padding: 0 10px;
            box-sizing: border-box;
            position: relative;
            background:
                radial-gradient(circle at top left, transparent 1.25rem, #ca4 1.25rem, #ca4 1.5rem, transparent 1.5rem) left top / 1.5rem 1.5rem no-repeat,
                radial-gradient(circle at top right, transparent 1.25rem, #ca4 1.25rem, #ca4 1.5rem, transparent 1.5rem) right top / 1.5rem 1.5rem no-repeat,
                radial-gradient(circle at bottom left, transparent 1.25rem, #ca4 1.25rem, #ca4 1.5rem, transparent 1.5rem) left bottom / 1.5rem 1.5rem no-repeat,
                radial-gradient(circle at bottom right, transparent 1.25rem, #ca4 1.25rem, #ca4 1.5rem, transparent 1.5rem) right bottom / 1.5rem 1.5rem no-repeat,
                linear-gradient(90deg, transparent 1.25rem, #ca4 1.5rem) left top / 51% 0.25rem no-repeat,
                linear-gradient(-90deg, transparent 1.25rem, #ca4 1.5rem) right top / 51% 0.25rem no-repeat,
                linear-gradient(90deg, transparent 1.25rem, #ca4 1.5rem) left bottom / 51% 0.25rem no-repeat,
                linear-gradient(-90deg, transparent 1.25rem, #ca4 1.5rem) right bottom / 51% 0.25rem no-repeat,
                linear-gradient(180deg, transparent 1.25rem, #ca4 1.5rem) left top / 0.25rem 51% no-repeat,
                linear-gradient(0deg, transparent 1.25rem, #ca4 1.5rem) left bottom / 0.25rem 51% no-repeat,
                linear-gradient(180deg, transparent 1.25rem, #ca4 1.5rem) right top / 0.25rem 51% no-repeat,
                linear-gradient(0deg, transparent 1.25rem, #ca4 1.5rem) right bottom / 0.25rem 51% no-repeat;


        }

        .certificate:before {
            position: absolute;
            content: "";
            border: 0.25rem double #ca4;
            margin: 0.5rem;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: -1;

        }


        .certificate:after {
            left: 10px;
            right: 10px;
            top: 10px;
            bottom: 10px;
        }

        hr.clr4 {
            color: #bf9132;
            border: 1px solid #bf9132;
        }

        header {
            text-align: center;
            padding-bottom: 15px;
            margin-top: 0
        }

        .logo {
            margin-top: 10px;
            display: inline-block;
            width: 100%;
        }

        .logo img {
            max-width: 115px;
        }

        .footerLogo {
            max-width: 200px;
            margin-bottom: 5px;
        }

        header .certificateTitle {
            font-size: 18px;
            padding-bottom: 15px;
            position: relative;
            font-weight: 600;
            margin: 0;
        }

        header .certificateTitle:before {
            content: "";
            position: absolute;
            width: 80px;
            height: 2px;
            background-color: #bf9132;
            bottom: 10px;
            left: 0;
            right: 0;
            margin: 0 auto
        }

        header h1 {
            font-size: 22px;
            font-weight: 700;
            color: #bf9132
        }

        header h3 {
            font-weight: 500;
            font-size: 16px;
        }

        header p {
            font-size: 16px;
            margin-top: 5px;
        }

        main {
            display: block;
            margin: 0 5%;
            width: 90%;
        }

        main p {
            font-size: 12px;
            margin-top: 10px;
            color: #575757;
        }

        main ul {
            font-size: 14px;
        }

        main ul li {
            display: flex;
            margin-top: 5px;
            font-size: 13px;
        }

        main ul li::before {
            content: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="%2322bdef" viewBox="0 0 16 16"><path d="M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425z"/></svg>');
            min-width: 20px;
            margin-right: 10px;
        }

        main ul li span:first-child {
            white-space: nowrap;
        }

        main ul li span:last-child {
            font-weight: 500;
        }

        footer {
            padding-bottom: 15px;
            margin: 0 5% 10px;
            width: 90%;
        }

        footer p {
            font-size: 11px;
            color: #767576;

        }

        footer ul {
            margin-top: 10px;
            font-size: 13px;
            display: flex;
            justify-content: center;
        }

        footer ul li {
            display: flex;
            margin-right: 10px;
            color: #333;
            font-size: 14px;
        }

        footer ul li span:first-child {
            margin-right: 5px;
        }

        footer ul li span:last-child {
            font-weight: 500;
        }

        .bootom {
            margin-top: 10px;
            text-align: center;
            font-size: 11px;
            color: #767576;
        }

        .bootom ul {
            margin: 0;
            padding-bottom: 5px;
            display: flex;
            justify-content: center;

        }

        .bootom ul li {
            display: flex;
            margin-right: 10px;
            font-size: 11px;
            color: #767576;
        }

        .bootom ul li:first-child::before {
            margin-right: 5px;
            content: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="%23666" viewBox="0 0 16 16"><path d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.6 17.6 0 0 0 4.168 6.608 17.6 17.6 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.68.68 0 0 0-.58-.122l-2.19.547a1.75 1.75 0 0 1-1.657-.459L5.482 8.062a1.75 1.75 0 0 1-.46-1.657l.548-2.19a.68.68 0 0 0-.122-.58zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.68.68 0 0 0 .178.643l2.457 2.457a.68.68 0 0 0 .644.178l2.189-.547a1.75 1.75 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.6 18.6 0 0 1-7.01-4.42 18.6 18.6 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877z"/></svg>');

        }

        .bootom ul li:last-child::before {
            margin-right: 5px;
            content: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="%23666" viewBox="0 0 16 16"><path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1zm13 2.383-4.708 2.825L15 11.105zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741M1 11.105l4.708-2.897L1 5.383z"/></svg>');
        }

        .ts_lineh {
            height: 16px;
            width: 1px;
            background-color: #A6A6A6;
        }
    </style>
</head>

<body>
    <div class="certificate">
        <header>
            <div class="logo">
                <img src="designer/images/trustSeal.webp" alt="Trust Seal" title="Trust Seal">
            </div>
            <p class="certificateTitle">CERTIFICATE OF TRUST</p>
            <hgroup>
                <h1>Baghel Industries Pvt. Ltd.</h1>
                <h3>New Delhi, India</h3>
            </hgroup>
            <p>has been certified as a trusted member of Getmanufacturers.com</p>
        </header>

        <main>
            <hr class="clr4">
            <p>Following details of the company have been verified*</p>
            <ul>
                <li>
                    <span>Director / Proprietor:&nbsp;</span>
                    <span>Rahul Ranjan Singh </span>
                </li>
                <li>
                    <span>GSTIN: &nbsp;</span>
                    <span>ABCD12345ZXY777</span>
                </li>
                <li>
                    <span>Business Address:&nbsp;</span>
                    <span>3rd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi,
                        110015</span>
                </li>
                <li>
                    <span>Import Export Code: &nbsp;</span>
                    <span>12340*****</span>
                </li>
                <li>
                    <span>Mobile Number:</span>
                    <span>+91-99112-41819</span>
                </li>
                <li>
                    <span>Email Id:</span>
                    <span>info@onlinekurtisindia.com</span>
                </li>
            </ul>
        </main>
        <footer>
            <hr class="clr4">
            <ul>
                <li>
                    <span>Issue date:</span>
                    <span>24th April 2025</span>
                </li>
                <li class="ts_lineh"></li>
                <li>
                    <span>Expiry date:</span>
                    <span>25th Dec 2026</span>
                </li>
            </ul>
            <div class="bootom">
                <img class="mt10 footerLogo" src="designer/images/logo.png" alt="Get Manufacturers"
                    title="Get Manufacturers">
                <p>Get Manufacturers.com</p>
                <p>2nd Floor, 71/7A, Rama Road, Najafgarh Road Industrial Area, New Delhi, Delhi - 110015, India</p>
                <ul>
                    <li><span>+91-99112-41819</span></li>
                    <li><span>customercare@getmanufacturers.com</span></li>
                </ul>
            </div>
        </footer>
    </div>
</body>

</html>