<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <meta name="description" content="">
    <meta name="keywords" content="">
    <?php include "top.php"; ?>
</head>

<body>
    <div class="wrapper">
        <?php include "menubar.php"; ?>
        <div class="main">
            <?php include "topbar.php"; ?>
            <div class="content">
                <div class="pageTitleSection">
                    <div class="pageTitle_1">Add New Category</div>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="manage_category.php">Category Management</a></li>
                        <li class="breadcrumb-item active">Add New Category</li>
                    </ol>
                </div>

                <div class="row mt-3">
                    <div class="col-xl-3 col-sm-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="totalInfo manageCat">
                                        <p>Total Categories</p>
                                        <div class="totalTitle">1240</div>
                                    </div>
                                    <div class="avatar2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path d="M2 10h3a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1v-3a1 1 0 0 1 1-1m9-9h3a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1h-3a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1m0 9a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1zm0-10a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zM2 9a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h3a2 2 0 0 0 2-2v-3a2 2 0 0 0-2-2zm7 2a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2h-3a2 2 0 0 1-2-2zM0 2a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm5.354.854a.5.5 0 1 0-.708-.708L3 3.793l-.646-.647a.5.5 0 1 0-.708.708l1 1a.5.5 0 0 0 .708 0z" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-sm-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="totalInfo manageCat">
                                        <p>Active Listings</p>
                                        <div class="totalTitle">3180</div>
                                    </div>
                                    <div class="avatar2 bg-success">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M5 11.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5M3.854 2.146a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0l-.5-.5a.5.5 0 1 1 .708-.708L2 3.293l1.146-1.147a.5.5 0 0 1 .708 0m0 4a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0l-.5-.5a.5.5 0 1 1 .708-.708L2 7.293l1.146-1.147a.5.5 0 0 1 .708 0m0 4a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0l-.5-.5a.5.5 0 0 1 .708-.708l.146.147 1.146-1.147a.5.5 0 0 1 .708 0" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-sm-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="totalInfo manageCat">
                                        <p>Pending listings</p>
                                        <div class="totalTitle">150</div>
                                    </div>

                                    <div class="avatar2 bg-warning">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bag-check" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M10.854 8.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L7.5 10.793l2.646-2.647a.5.5 0 0 1 .708 0"></path>
                                            <path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1m3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z"></path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-sm-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="totalInfo manageCat">
                                        <p>New Listings (Last 7 days)</p>
                                        <div class="totalTitle">85</div>
                                    </div>

                                    <div class="avatar2 bg-info">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bag-check" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M10.854 8.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L7.5 10.793l2.646-2.647a.5.5 0 0 1 .708 0"></path>
                                            <path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1m3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z"></path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Manage Companies -->
                <div class="col-xxl-12 col-xl-12 col-lg-12">
                    <div class="card">
                        <div class="card-body p-4">
                            <form method="post" action="">
                                <div class="form-group">
                                    <label class="form-label text-dark">Category Title*</label>
                                    <input type="text" class="form-control" placeholder="" value="" required>
                                </div>

                                <div class="form-group">
                                    <label class="form-label text-dark">Category URL Link</label>
                                    <input type="text" class="form-control" placeholder="" value="https://www.getmanufacturers.com/category.htm" readonly>
                                </div>

                                <div class="metaBox">
                                    <div class="form-group">
                                        <label class="form-label text-dark">Category Meta Title</label>
                                        <input type="text" class="form-control" placeholder="" value="" required>

                                    </div>
                                    <div class="form-group">
                                        <label class="form-label text-dark">Category Meta Description</label>
                                        <input type="text" class="form-control" value="">
                                    </div>

                                    <div class="form-group">
                                        <label class="form-label text-dark">Category Meta Keyword</label>
                                        <input type="text" class="form-control" value="">
                                    </div>

                                </div>
                                <div class="form-group">
                                    <label class="form-label text-dark">Category Short Description</label>
                                    <textarea class="form-control" required></textarea>
                                </div>

                                <div class="form-group">
                                    <label class="form-label text-dark">Category Full Description</label>
                                    <textarea id="editor" class="form-control"></textarea>
                                </div>

                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-2 col-sm-6 col-12">
                                            <label class="form-label text-dark"> Category Image</label>
                                            <div class="image_upload_box">
                                                <label class="js--image-preview">
                                                    <span class="imgText">Click to upload image</span>
                                                </label>
                                                <input class="image-upload" type="file" accept="image/*">
                                                <div class="controls hidden">
                                                    <button type="button" class="edit-btn">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil" viewBox="0 0 16 16">
                                                            <path d="M12.146.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1 0 .708l-10 10a.5.5 0 0 1-.168.11l-5 2a.5.5 0 0 1-.65-.65l2-5a.5.5 0 0 1 .11-.168zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207zm1.586 3L10.5 3.207 4 9.707V10h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.293zm-9.761 5.175-.106.106-1.528 3.821 3.821-1.528.106-.106A.5.5 0 0 1 5 12.5V12h-.5a.5.5 0 0 1-.5-.5V11h-.5a.5.5 0 0 1-.468-.325" />
                                                        </svg>
                                                    </button>
                                                    <button type="button" class="delete-btn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash3" viewBox="0 0 16 16">
                                                            <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5" />
                                                        </svg>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-2 col-xl-2 col-lg-2 col-md-2 col-sm-6 col-12">
                                            <label class="form-label text-dark"> Category Icon</label>
                                            <div class="image_upload_box">
                                                <label class="js--image-preview">
                                                    <span class="imgText">Click to upload Icon</span>
                                                </label>
                                                <input class="image-upload" type="file" accept="image/*">
                                                <div class="controls hidden">
                                                    <button type="button" class="edit-btn">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil" viewBox="0 0 16 16">
                                                            <path d="M12.146.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1 0 .708l-10 10a.5.5 0 0 1-.168.11l-5 2a.5.5 0 0 1-.65-.65l2-5a.5.5 0 0 1 .11-.168zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207zm1.586 3L10.5 3.207 4 9.707V10h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.293zm-9.761 5.175-.106.106-1.528 3.821 3.821-1.528.106-.106A.5.5 0 0 1 5 12.5V12h-.5a.5.5 0 0 1-.5-.5V11h-.5a.5.5 0 0 1-.468-.325" />
                                                        </svg>
                                                    </button>
                                                    <button type="button" class="delete-btn"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash3" viewBox="0 0 16 16">
                                                            <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5" />
                                                        </svg>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="form-group">
                                    <button class="btn save_btn" type="submit">Save</button>
                                    <button class="btn cancel_btn" type="submit">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>



            </div>
        </div>
    </div>
    <?php include "bottom.php"; ?>
    <script>
        $(document).ready(function() {
            $('.image_upload_box').each(function() {
                const $box = $(this);
                const $preview = $box.find('.js--image-preview');
                const $uploadField = $box.find('.image-upload');
                const $controls = $box.find('.controls');

                $preview.on('click', function(e) {
                    const offset = $preview.offset();
                    const x = e.pageX - offset.left;
                    const y = e.pageY - offset.top;

                    const $drop = $('<span class="drop animate"></span>').css({
                        width: Math.max($preview.width(), $preview.height()),
                        height: Math.max($preview.width(), $preview.height()),
                        top: y - $preview.height() / 2,
                        left: x - $preview.width() / 2
                    });

                    $preview.append($drop);
                    setTimeout(() => $drop.remove(), 600);

                    $uploadField.click();
                });

                $uploadField.on('change', function() {
                    const file = this.files[0];
                    if (!file || !file.type.match(/image.*/)) {
                        alert('Please select a valid image file.');
                        return;
                    }

                    const reader = new FileReader();
                    reader.onload = function() {
                        $preview.css('background-image', 'url(' + reader.result + ')');
                        $preview.addClass('js--no-default');
                        $controls.removeClass('hidden');
                    };
                    reader.readAsDataURL(file);
                });

                $box.find('.edit-btn').on('click', function(e) {
                    e.stopPropagation();
                    $uploadField.click();
                });

                $box.find('.delete-btn').on('click', function(e) {
                    e.stopPropagation();
                    $preview.css('background-image', '');
                    $preview.removeClass('js--no-default');
                    $uploadField.val('');
                    $controls.addClass('hidden');
                });
            });
        });
    </script>

</body>

</html>