<?php
include('include/main.inc.php');
$res_gallery = $dbconn->query("select image,title from photo_tbl order by id desc");

$res_web = $dbconn->query("Select * from admin_details where slno = '1'");
$web_details = $res_web->fetch_assoc();
$page_metatitle = $web_details['companyName'] . ' || Photo Gallery';
$page_metadesc = $web_details['companyName'] . ' || Photo Gallery';
$page_metakey = $web_details['companyName'] . ' || Photo Gallery';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?= $page_metatitle ?></title>
    <meta name="description" content="<?= $page_metadesc ?>">
    <meta name="keywords" content="<?= $page_metakey ?>">
    <?php include "app_top.php"; ?>
</head>

<body>

    <?php include "app_header.php"; ?>

    <section class="heading_banner" style="background-image: url(<?= site_url; ?>/designer/images/gallery-banner.webp)">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center">
                    <h1 class="cat_title">Photo Gallery</h1>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>

    <div class="inner_breadcrumb hidden_xs">
        <div class="container">
            <div class="row">
                <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <ul class="breadcrumb">
                        <li><a href="<?= site_url; ?>" title="Home">Home</a></li>
                        <li class="active">Photo Gallery</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>


    <section class="gallery_page">
        <div class="container">
            <div class="title">Photo Gallery</div>
            <p class="text-center mx-auto mb-3 w-75">
            Step into our photo gallery and witness a stunning collection of exquisite jewelry. Each image highlights the intricate details and unique designs that define our creations. From elegant rings to dazzling necklaces, enjoy the beauty and craftsmanship that make every piece a timeless treasure, capturing the essence of style and sophistication.
           </p>  
            <div class="clearfix"></div>
            <div class="row">
                <?php if($res_gallery->num_rows > 0){ 
                    while($gallery = $res_gallery->fetch_assoc()){
                ?>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                    <div class="gallery_item">
                        <a class="hover_effect h_yellow" data-fancybox="photo-gallery"
                            href="<?= site_url; ?>/uploaded-files/gallery/photos/<?= $gallery['image']; ?>" title="<?= $gallery['title']; ?>">
                            <img src="<?= site_url; ?>/uploaded-files/gallery/photos/<?= $gallery['image']; ?>" alt="<?= $gallery['title']; ?>" title="<?= $gallery['title']; ?>">
                        </a>
                        <div class="gallery_item_info">
                            <h2 class="fs-6 mb-0"><?= $gallery['title']; ?></h2>
                        </div>
                    </div>
                </div>
                <?php } } ?>

            </div>
        </div>
    </section>
    <?php include "app_faq.php"; ?>

    <?php include "app_footer.php";?>
    <?php include "app_bottom.php"; ?>
</body>

</html>