<?php
$this->load->view("top");
$fieldType = $this->session->userdata('field_type');
?>
<div class="page_breadcrumbs">
  <div class="container">
    <ul>
      <li><a href="<?= site_url(); ?>" title="Home">Home</a>
      <li><a href="<?= base_url('my-account'); ?>" title="My Account">My Account</a>
      </li>
      <li>My Orders</li>
    </ul>
  </div>
</div>
<section class="my_account_page">
  <div class="container">
    <div class="row">
      <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-12 col-12">
        <div class="right_side">
          <h1>My Orders</h1>
          <div class="wps_right">
            <?php echo error_message();
            echo validation_message();
            if (is_array($orders) && !empty($orders)) {

            ?>
              <div class="my_account">
                <div class="my_account my_order">
                  <!--- Start Here-->
                  <?php foreach ($orders as $key => $val) {
                    $orderDets = $this->order_model->get_order_detail($val['order_id']); ?>
                    <div class="order_item">
                      <div class="order_top">
                        <div class="row">
                        <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-sm-9 col-12">
                            <a class="orderID" rel="noopener noreferrer" href="<?php echo site_url(); ?>members/order_details/<?php echo $val['order_id']; ?>"><?php echo $val['invoice_number']; ?></a>
                          </div>
                          <div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-3 col-12 text-right">
                            <a class="need_btn" href="<?php echo site_url(); ?>members/order_details/<?php echo $val['order_id']; ?>" title="Track"><i class="fa fa-map-marker"></i> Track</a>
                          </div>
                        </div>
                      </div>
                      <div class="order_body">
                        <?php if (is_array($orderDets) && !empty($orderDets)) {
                          foreach ($orderDets as $o => $pageVal) {
                            $furl = get_db_field_value("wps_products", "friendly_url", "WHERE products_id = '" . $pageVal['products_id'] . "'");
                            $img = get_db_field_value("wps_products_media", "media", "WHERE products_id = '" . $pageVal['products_id'] . "'");
                            $productName = get_db_field_value("wps_products", "product_name", "WHERE products_id = '" . $pageVal['products_id'] . "'");
                        ?>
                            <div class="row">
                              <div class="col-lg-5 col-md-5 col-sm-5">
                                <div class="row">
                                  <div class="col-lg-4 col-md-4 col-sm-4">
                                    <a href="<?= $furl; ?>" title="<?php echo $productName; ?>" target="_blank">
                                      <img src="<?php echo get_image('products', $img, '110', '67', 'R'); ?>" alt="<?php echo $productName; ?>" title="<?php echo $productName; ?>">
                                    </a>
                                  </div>
                                  <div class="col-lg-8 col-md-8 col-sm-8">
                                    <div class="order_info">
                                      <a href="<?= $furl; ?>" title="<?php echo $productName; ?>" target="_blank"><?php echo $productName; ?></a>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-7 col-md-7 col-sm-7">
                                <div class="row">
                                  <div class="col-lg-3 col-md-3 col-sm-3">
                                    <div class="order_price"><?php echo display_price($pageVal['product_price'] * $pageVal['quantity']); ?></div>
                                  </div>
                                  <div class="col-lg-4 col-md-4 col-sm-5">
                                    <a class="review_product" href="<?php echo site_url(); ?>members/post_review/<?php echo $pageVal['products_id']; ?>" title="Rate & Review Product"><i class="fa fa-star"></i> Rate & Review</a>
                                    <?php if ($val['order_status'] != '5' && $val['order_status'] != '2'  && $val['order_status'] != '8' && $val['order_status'] != '6') { ?>
                                      <a class="review_product external" href="javascript:void(0);" title="Cancer Request" id="cancel_order" data-orderid="<?= $val['order_id']; ?>" data-customers_id="<?= $val['customers_id']; ?>"><i class="fa fa-close cancelcon"></i> Cancel Order</a>
                                    <?php } ?>
                                    <?php
                                    $forReturn = getDateFormat($val['order_delivery_date'], 12) + 7;
                                    $currentDate = $this->config->item('config.date.time');
                                    $currentDate = getDateFormat($currentDate, 12);
                                    if ($currentDate <= $forReturn) {
                                    ?>

                                      <?php if ($val['order_status'] != '6' && $val['order_status'] == '8') { ?>
                                        <a class="review_product external" href="javascript:void(0);" title="Return Request" id="return_order" value="<?php echo $val['order_id']; ?>"><i class="fa fa-repeat"></i> Return Order</a>
                                        <script type="text/javascript">
                                          function confirmReturn() {
                                            var reasontext = $('.reason_for_return').val();
                                            var orderid = $('#oid').val();
                                            $.ajax({
                                              url: "<?php echo site_url('members/return_order') ?>",
                                              data: $('#returnForm').serialize(),
                                              type: "POST",
                                              success: function(data) {
                                                if (data == 'success') {
                                                  $('#return_status').html('<div class="alert alert-success">Your Request for Return has been Taken. One of our Team will contact you soon</div>');
                                                  $('#returnForm').trigger('reset');

                                                  setTimeout(function() {
                                                    location.reload();
                                                  }, 5000);



                                                } else {
                                                  $('#return_status').html(data);
                                                }
                                              }

                                            })
                                          }
                                        </script>
                                    <?php }
                                    } ?>
                                  </div>

                                </div>
                              </div>
                            </div>
                        <?php }
                        } ?>
                      </div>
                      <div class="order_foot">
                        <div class="row">
                          <div class="col-lg-6 col-md-6 col-sm-6">
                            <p>Ordered On <?php echo date('d M Y H:i A', strtotime($val['order_received_date'])); ?></p>
                          </div>
                          <div class="col-lg-6 col-md-6 col-sm-6">
                            <p class="text-right">Order Total <strong><?php echo display_price($val['total_amount']); ?></strong>
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  <?php } ?>

                </div>
              </div>
            <?php } else { ?>
              <div class="text-center mt10 thank-you">
                <h4 class="mb-70 thankyou-text">Sorry, No Orders Found!</h4>
                <a href="<?= site_url('products'); ?>" class="checkout_btn" title="Continue Shopping">Continue Shopping</a>
              </div>
            <?php } ?>
          </div>
        </div>
      </div>
      <div class="col-xl-3 col-xl-3 col-lg-3 col-md-3 col-sm-4 col-12 order-xxl-first order-xl-first order-lg-first">
        <?php $this->load->view('members/left'); ?>
      </div>
    </div>
  </div>
</section>

<?php $this->load->view("bottom"); ?>
<!-- Modal Cancellation Process -->
<div class="modal" id="myModal_cancel">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Cancellation Process</h4>
        <button type="button" class="close" data-dismiss="modal" style="margin-top:-50px;">&times;</button>
      </div>

      <!-- Modal body -->
      <form id="cancelForm" method="post" action="<?= base_url(); ?>members/cancel_order">
        <div class="modal-body">
          <input type="hidden" class="order_id" value="" name="order_id">
          <input type="hidden" class="customer_id" value="" name="customers_id">
          <select name="reason_for_cancelOrder" required class="form-control">
            <option>Select Reason</option>
            <option value="Order by Mistakenly">Order by mistakenly</option>
            <option value="Change my mood">Change my mood</option>
            <option value="Out of town">Out of town</option>
            <option value="No more need">No more need</option>
            <option value="Over price">Over price</option>
            <option value="Long shipping time">Long shipping time</option>
            <option value="Bought from another website">Bought from another website</option>
            <option value="Others">Others</option>
          </select>
          <br />

        </div>

        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" name="cancel_req">Cancel Order</button>
        </div>
      </form>

    </div>
  </div>
</div>
<!-- Modal Reason for Return -->
<div class="modal" id="myModalreturn">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Reason for Return</h4>
        <button type="button" class="close" data-dismiss="modal" style="margin-top:-50px;">&times;</button>
      </div>

      <!-- Modal body -->
      <form id="returnForm">
        <div id="return_status"></div>
        <div class="modal-body">
          <input type="hidden" class="order_id" value="" id="oid" name="order_id">
          <input type="text" name="reason_for_return" class="form-control reason_for_return" placeholder="Please Enter the reason for Return" required>
          <br />

        </div>

        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="button" class="btn btn-primary" id="return_req" onclick="return confirmReturn();">Submit</button>
        </div>
      </form>

    </div>
  </div>
</div>
<script type="text/javascript">
  $(document).on("click", "#return_order", function(e) {

    e.preventDefault();
    var orderid = $(this).attr("value");
    if (orderid != "") {
      $('#myModalreturn').modal('show');
      $(".order_id").val(orderid);

    } else {

    }
  });
</script>

<script type="text/javascript">
  $(document).on("click", "#cancel_order", function(e) {
    e.preventDefault();
    var orderid = $(this).data('orderid');
    var customers_id = $(this).data('customers_id');
    console.log(orderid);
    if (orderid != "") {
      $('#myModal_cancel').modal('show');
      $(".order_id").val(orderid);
      $(".customer_id").val(customers_id);
    } else {

    }
  });
</script>