<?php
$this->load->view("top");
$values_posted_back = (is_array($this->input->post())) ? TRUE : FALSE;
$is_same = $values_posted_back === TRUE ? $this->input->post('is_same') : '';
$titleArray = $this->config->item('titleArray');
$discount_amount = $this->session->userdata('discount_amount');
$cart = $this->cart->contents();
$posted_data = $this->session->userdata('posted_data');
//trace($this->session->userdata('posted_data'));
$same_val = 1;
if ($this->input->post()) {
  if (!$this->input->post('check_add')) {
    $same_val = 0;
  }
}

?>
<div class="page_breadcrumbs">
  <div class="container">
    <ul>
      <li><a href="<?= site_url(); ?>" title="Home">Home</a></li>
      <li>Confirm Address</li>
    </ul>
  </div>
</div>
<section class="checkout_page">
  <div class="container">
    <div class="row">
      <div class="col-lg-9 col-md-9 col-sm-8  col-xs-12">
        <div class="cart_left">
          <h1>Confirm Address</h1>
          <div class="panel-group checkout-steps" id="accordion">
            <!-- checkout-step-1  -->
            <section class="panel panel-default checkout-step-01">
              <h4 class="checkout_title">
                <a data-toggle="collapse" class="collapse"><span>1</span>User Logged In <span class="pull-right"><i class="fa fa-check-square"></i></span></a>
              </h4>
            </section>
            <!-- checkout-step-02  -->
            <section class="panel panel-default checkout-step-02">
              <h4 class="checkout_title"><a data-toggle="collapse" class="collapse"><span>2</span>Enter Address </a></h4>
              <div id="collapseTwo" class="panel-collapse">
                <div class="panel-body">
                  <div class="edit_address">
                    <?php
                    echo form_open('cart/delivery_info', 'id="deliveryForm"');
                    echo error_message();
                    //echo validation_message();
                    ?>
                    <div class="row">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <h5>Shipping Address</h5>
                        <div class="form-group">

                          <select name="mtitle" class="form-input" required>
                            <?php
                            foreach ($titleArray as $tk => $tval) {
                              if ($posted_data['mtitle'] != '') {
                                $sel = ($posted_data['mtitle'] == $tk) ? 'selected' : '';
                              } else {
                                $sel = ($mres['mtitle'] == $tk) ? 'selected' : '';
                              }
                            ?>
                              <option value="<?php echo $tk; ?>" <?php echo $sel; ?>><?php echo $tval; ?></option>
                            <?php
                            }
                            ?>
                          </select>
                          <?php echo form_error("mtitle"); ?>
                        </div>
                        <div class="form-group">
                          <input type="text" name="ship_name" value="<?= (@$posted_data['name'] != '') ? @$posted_data['name'] : @$mres['name']; ?>" class="form-input" required />
                          <label class="form-label">Full Name <span>*</span></label>
                          <?php echo form_error("ship_name"); ?>
                        </div>
                        <div class="form-group">
                          <input type="tel" minlength="10" maxlength="12" name="ship_mobile" value="<?= (@$posted_data['mobile'] != '') ? @$posted_data['mobile'] : @$mres['mobile']; ?>" class="form-input" required onkeypress="return isNumberKey(event)" />
                          <label class="form-label">Mobile Number <span>*</span></label>
                          <?php echo form_error("ship_mobile"); ?>
                        </div>
                        <div class="form-group">
                          <textarea name="ship_address" cols="1" rows="3" class="form-input" required><?= (@$posted_data['address'] != '') ? @$posted_data['address'] : @$mres['address']; ?></textarea>
                          <label class="form-label">Your Address <span>*</span></label>
                          <?php echo form_error("ship_address"); ?>
                        </div>
                        <div class="form-group">

                          <input type="text" name="ship_lmark" value="<?= (@$posted_data['landmark'] != '') ? @$posted_data['landmark'] : @$mres['landmark']; ?>" class="form-input" />
                          <label class="form-label">Landmark</label>
                          <?php echo form_error("ship_lmark"); ?>
                        </div>
                        <div class="form-group">
                          <input type="text" name="ship_city" value="<?php echo @$mres['city']; ?>" class="form-input" required />
                          <label class="form-label">City <span>*</span></label>
                          <?php echo form_error("ship_city"); ?>
                        </div>
                        <div class="form-group">
                          <input type="text" minlength="3" maxlength="6" name="ship_pin" value="<?php echo @$mres['zipcode']; ?>" class="form-input" required onkeypress="return isNumberKey(event)" />
                          <label class="form-label">Pincode <span>*</span></label>
                          <?php echo form_error("ship_pin"); ?>
                        </div>
                        <div class="form-group">
                          <input type="text" name="ship_state" value="<?php echo @$mres['state']; ?>" class="form-input" required />
                          <label class="form-label">State <span>*</span></label>
                          <?php echo form_error("ship_state"); ?>
                        </div>
                        <div class="form-group">
                          <?php echo CountrySelectBox(array("name" => "ship_country", 'current_selected_val' => @$mres['country'], "format" => 'class="form-input" required')); ?>
                          <?php echo form_error("ship_country"); ?>
                        </div>
                        <div class="form-group">
                          <textarea name="last_shopping_comment" cols="1" rows="3" class="form-input unicase-form-input"><?php echo @$mres['last_shopping_comment']; ?></textarea>
                          <label class="form-label">Comments</label>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <h5>Billing Address </h5>
                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12" style="margin-bottom:25px;"><span class="no-float-res pull-right"> <input id="check_add" name="check_add" value="1" onclick="Check_Bill_Ship(this.form);" type="checkbox" class="isCheck" style="height: 12px;">
                            <label for="check_add">Same as Shipping address</label> </span>
                        </div>
                        <div class="billingAd">
                          <div class="form-group">

                            <select name="bmtitle" class="form-input" required>
                              <option value="">Select </option>
                              <?php
                              foreach ($titleArray as $tk => $tval) {
                                if ($posted_data['bmtitle'] != '') {
                                  $sel1 = ($posted_data['bmtitle'] == $tk) ? 'selected' : '';
                                } else {
                                  $sel1 = ($mres['bmtitle'] == $tk) ? 'selected' : '';
                                }
                              ?>
                                <option value="<?php echo $tk; ?>" <?php echo $sel1; ?>><?php echo $tval; ?></option>
                              <?php
                              }
                              ?>
                            </select>
                            <?php echo form_error("bmtitle"); ?>
                          </div>
                          <div class="form-group">

                            <input type="text" name="bil_name" value="<?= (@$posted_data['bil_name'] != '') ? @$posted_data['bil_name'] : @$mres['bil_name']; ?>" class="form-input" required />
                            <label class="form-label">Full Name <span>*</span></label>
                            <?php echo form_error("bil_name"); ?>
                          </div>
                          <div class="form-group">
                            <input type="tel" minlength="10" maxlength="20" name="bil_mobile" value="<?= (@$posted_data['bil_mobile'] != '') ? @$posted_data['bil_mobile'] : @$mres['bil_mobile']; ?>" class="form-input" required onkeypress="return isNumberKey(event)" />
                            <label class="form-label">Mobile Number <span>*</span></label>
                            <?php echo form_error("bil_mobile"); ?>
                          </div>
                          <div class="form-group">
                            <textarea name="bil_address" cols="1" rows="3" class="form-input unicase-form-input" required><?= (@$posted_data['bil_address'] != '') ? @$posted_data['bil_address'] : @$mres['bil_address']; ?></textarea>
                            <label class="form-label">Your Address <span>*</span></label>
                            <?php echo form_error("bil_address"); ?>
                          </div>
                          <div class="form-group">
                            <input type="text" name="bil_lmark" value="<?= (@$posted_data['bil_landmark'] != '') ? @$posted_data['bil_landmark'] : @$mres['bil_landmark']; ?>" class="form-input" />
                            <label class="form-label">Landmark</label>
                            <?php echo form_error("bil_lmark"); ?>
                          </div>
                          <div class="form-group">

                            <input type="text" name="bil_city" value="<?php echo @$mres['bil_city']; ?>" class="form-input" required />
                            <label class="form-label">City <span>*</span></label>
                            <?php echo form_error("bil_city"); ?>
                          </div>
                          <div class="form-group">

                            <input type="text" minlength="3" maxlength="6" name="bil_pin" value="<?php echo @$mres['bil_zipcode']; ?>" class="form-input" onkeypress="return isNumberKey(event)" required />
                            <label class="form-label">Pincode <span>*</span></label>
                            <?php echo form_error("bil_pin"); ?>
                          </div>
                          <div class="form-group">
                            <input type="text" name="bil_state" value="<?php echo @$mres['bil_state']; ?>" class="form-input" required />
                            <label class="form-label">State <span>*</span></label>
                            <?php echo form_error("bil_state"); ?>
                          </div>
                          <div class="form-group">
                            <?php echo CountrySelectBox(array("name" => "bil_country", 'current_selected_val' => @$mres['bil_country'], "format" => 'class="form-input" required')); ?>

                            <?php echo form_error("bil_country"); ?>
                          </div>
                        </div>
                      </div>

                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <div class="custom-center form-group">
                          <button class="checkout_btn pull-right" type="submit" name="submit">Checkout</button>
                        </div>
                      </div>
                      <?php echo form_close(); ?>
                    </div>
                  </div>
            </section>
            <!-- checkout-step-03  -->
            <div class="panel panel-default checkout-step-03">
              <h4 class="checkout_title">
                <a data-toggle="collapse" data-toggle="collapse" class="collapsed">
                  <span>3</span>Order Summary <!-- <button class="change">View Order Summary</button> --></a>
              </h4>

            </div>
            <!-- checkout-step-04  -->
            <div class="panel panel-default checkout-step-04">
              <h4 class="checkout_title">
                <a data-toggle="collapse" class="collapsed">
                  <span>4</span>Payment Options</a>
              </h4>

            </div>
            <!-- checkout-step-04  -->
          </div>
          <!-- /.checkout-steps -->
        </div>
      </div>
      <div class="col-lg-3 col-md-3 col-sm-4  col-xs-12">
        <div class="left_title">Cart Details</div>
        <div class="cart_right">
          <table class="table table-totals">
            <tbody>
              <?php
              $totalAmount = $discountAmt = $total_shipping = 0;
              $i = 1;
              foreach ($cart as $items) {
                $link = ($this->session->userdata('user_id') > 0) ? 'href="' . site_url() . 'cart/add_to_wishlist/' . $items['pid'] . '"' : 'href="#" data-toggle="modal" data-target="#log-modal"';
                $pprice = ($items['discount_price'] > 0) ? $items['discount_price'] : $items['product_price'];
                $totalAmount += ($pprice * $items['qty']);
                $discountAmt += $pprice * $items['qty'];
                $url = $this->db->query("SELECT friendly_url FROM wps_products WHERE products_id = '" . $items['pid'] . "'")->row_array();
                $i++;
              }
              ?>
              <tr>
                <td>Sub Total</td>
                <td><?= display_price($totalAmount); ?></td>
              </tr>
              <?php if ($discount_amount > 0) { ?>
                <tr>
                  <td>Discount Price</td>
                  <td>- <?= display_price($discount_amount); ?></td>
                </tr>
              <?php } ?>
              <?php
              $deliveryCharge = delivery_charge(0, $totalAmount);  ?>
              <tr>
                <td>Delivery Charges</td>
                <td class="free"><?php echo ($deliveryCharge > 0) ? display_price($deliveryCharge) : 'Free'; ?></td>
              </tr>
              <tr>
                <td>GST(5%)</td>
                <td class="free"><?php $gst = gst($totalAmount);
                                  echo display_price($gst); ?></td>
              </tr>

            </tbody>
            <tfoot>
              <tr>
                <td>Amount Payable</td>
                <td><?= display_price(($totalAmount - $discount_amount) + $deliveryCharge + $gst); ?></td>
              </tr>
            </tfoot>

          </table>
          <!-- <a class="order_btn" href="javascript:void()" title="Place Order">Place Order</a> -->
          <p class="safe_info"><i class="fa fa-shield"></i> Safe and Secure Payments. 100% Authentic Services.</p>
        </div>
      </div>
    </div>
  </div>
</section>

<?php $this->load->view("bottom"); ?>
<script type="text/javascript">
  function Check_Bill_Ship(chk) {
    if (chk.check_add.checked == 1) {
      chk.bmtitle.value = chk.mtitle.value;
      chk.bil_name.value = chk.ship_name.value;
      chk.bil_mobile.value = chk.ship_mobile.value;
      chk.bil_address.value = chk.ship_address.value;
      chk.bil_lmark.value = chk.ship_lmark.value;
      chk.bil_city.value = chk.ship_city.value;
      chk.bil_pin.value = chk.ship_pin.value;
      chk.bil_state.value = chk.ship_state.value;
      chk.bil_city.value = chk.ship_city.options[chk.ship_city.selectedIndex].value;
    }
    if (chk.check_add.checked == 0) {
      chk.bmtitle.value = '';
      chk.bil_name.value = '';
      chk.bil_mobile.value = '';
      chk.bil_address.value = '';
      chk.bil_lmark.value = '';
      chk.bil_city.value = '';
      chk.bil_pin.value = '';
      chk.bil_state.value = '';
      chk.bil_city.value = chk.ship_city.options[0].value;
    }
  }
</script>

<script type="text/javascript">
  <?php if ($same_val == 1) { ?>
    //   $(".billingAd").hide();
  <?php } ?>
  $(".isCheck").click(function() {
    if ($(this).is(":checked")) {
      ChangeBill(this.form);
    } else {
      $(".billingAd").trigger('reset');
    }
  });


  function ChangeBill(chk) {
    chk.bmtitle.value = chk.mtitle.value;
    chk.bil_name.value = chk.ship_name.value;
    chk.bil_mobile.value = chk.ship_mobile.value;
    chk.bil_address.value = chk.ship_address.value;
    chk.bil_lmark.value = chk.ship_lmark.value;
    chk.bil_city.value = chk.ship_city.value;
    chk.bil_pin.value = chk.ship_pin.value;
    chk.bil_state.value = chk.ship_state.value;
    chk.bil_country.value = chk.ship_country.options[chk.ship_country.selectedIndex].value;
  }

  function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : event.keyCode
    if ((charCode > 47 && charCode < 58) || charCode == 46)
      return true;
    else
      return false;
  }
</script>