<?php
class Material extends Admin_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model(array('material_model'));
		$this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
	}

	public  function index()
	{

		$pagesize               =  (int) $this->input->get_post('pagesize');
		$config['limit']		 =  ($pagesize > 0) ? $pagesize : $this->config->item('pagesize');
		$offset                 =  ($this->input->get_post('per_page') > 0) ? $this->input->get_post('per_page') : 0;
		$base_url               =  current_url_query_string(array('filter' => 'result'), array('per_page'));
		$parent_id              =   (int) $this->uri->segment(4, 0);

		$keyword = trim($this->input->get_post('keyword', TRUE));
		$keyword = $this->db->escape_str($keyword);
		$condtion = " ";

		$condtion_array = array(
			'field' => "*",
			'condition' => $condtion,
			'limit' => $config['limit'],
			'offset' => $offset,
			'debug' => FALSE
		);

		$res_array              =  $this->material_model->getMaterials($condtion_array);
		$config['total_rows']	=  $this->material_model->total_rec_found;
		$data['page_links']     =  dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
		$data['headingTitle']  =  'Manage Environments';
		$data['res']            =  $res_array;
		$data['parent_id']      =  $parent_id;

		if ($this->input->post('action') != '') {
			$this->update_status('wps_materials', 'material_id');
		}
		if ($this->input->post('update_order') != '') {
			$this->update_displayOrder('wps_materials', 'sort_order', 'material_id');
		}
		$this->load->view('material/view_material_list', $data);
	}


	public function add()
	{

		$data['headingTitle'] = 'Add Environment';
		$this->form_validation->set_rules('material_name', 'Environment Title', "trim|required|max_length[32]|unique[wps_materials.material_name='" . $this->db->escape_str($this->input->post('material_name')) . "' AND status!='2']");

		if ($this->form_validation->run() === TRUE) {
			$posted_data = array(
				'material_name' => $this->input->post('material_name'),
				'material_date_added' => $this->config->item('config.date.time')
			);

			$this->material_model->safe_insert('wps_materials', $posted_data, FALSE);
			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Added Successfully!");
			redirect('wps-admin/material', '');
		}

		$this->load->view('material/view_material_add', $data);
	}


	public function edit()
	{
		$material_id = (int) $this->uri->segment(4);
		$rowdata = $this->material_model->get_material_by_id($material_id);
		$data['headingTitle'] = 'Edit Environment';
		if (!is_array($rowdata)) {
			$this->session->set_flashdata('message', lang('idmissing'));
			redirect('wps-admin/material', '');
		}

		$material_id = $rowdata['material_id'];
		$this->form_validation->set_rules('material_name', 'Environment Title', "trim|required|max_length[32]|unique[wps_materials.material_name='" . $this->db->escape_str($this->input->post('material_name')) . "' AND status!='2' AND material_id!='" . $material_id . "']");

		if ($this->form_validation->run() == TRUE) {
			$posted_data = array(
				'material_name' => $this->input->post('material_name'),
				'material_date_updated' => $this->config->item('config.date.time')
			);

			$where = "material_id = '" . $material_id . "'";
			$this->material_model->safe_update('wps_materials', $posted_data, $where, FALSE);

			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Updated Successfully!");
			redirect('wps-admin/material' . '/' . query_string(), '');
		}

		$data['edit_result'] = $rowdata;
		$this->load->view('material/view_material_edit', $data);
	}
}



// End of controller