<?php
class Capacity extends Admin_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model(array('capacity_model'));
		$this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
	}

	public  function index()
	{

		$pagesize               =  (int) $this->input->get_post('pagesize');
		$config['limit']		 =  ($pagesize > 0) ? $pagesize : $this->config->item('pagesize');
		$offset                 =  ($this->input->get_post('per_page') > 0) ? $this->input->get_post('per_page') : 0;
		$base_url               =  current_url_query_string(array('filter' => 'result'), array('per_page'));
		$parent_id              =   (int) $this->uri->segment(4, 0);

		$keyword = trim($this->input->get_post('keyword', TRUE));
		$keyword = $this->db->escape_str($keyword);
		$condtion = " ";

		$condtion_array = array(
			'field' => "*",
			'condition' => $condtion,
			'limit' => $config['limit'],
			'offset' => $offset,
			'debug' => FALSE
		);

		$res_array              =  $this->capacity_model->getCapacities($condtion_array);
		$config['total_rows']	=  $this->capacity_model->total_rec_found;
		$data['page_links']     =  dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
		$data['headingTitle']  =  'Manage Benefits';
		$data['res']            =  $res_array;
		$data['parent_id']      =  $parent_id;

		if ($this->input->post('action') != '') {
			$this->update_status('wps_capacities', 'capacity_id');
		}
		if ($this->input->post('update_order') != '') {
			$this->update_displayOrder('wps_capacities', 'sort_order', 'capacity_id');
		}
		$this->load->view('capacity/view_capacity_list', $data);
	}


	public function add()
	{

		$data['headingTitle'] = 'Add Capacity';
		$this->form_validation->set_rules('capacity_name', 'Benefit Title', "trim|required|max_length[100]|unique[wps_capacities.capacity_name='" . $this->db->escape_str($this->input->post('capacity_name')) . "' AND status!='2']");

		if ($this->form_validation->run() === TRUE) {
			$posted_data = array(
				'capacity_name' => $this->input->post('capacity_name'),
				'capacity_date_added' => $this->config->item('config.date.time')
			);

			$this->capacity_model->safe_insert('wps_capacities', $posted_data, FALSE);
			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Added Successfully!");
			redirect('wps-admin/capacity', '');
		}

		$this->load->view('capacity/view_capacity_add', $data);
	}


	public function edit()
	{
		$capacity_id = (int) $this->uri->segment(4);
		$rowdata = $this->capacity_model->get_capacity_by_id($capacity_id);
		$data['headingTitle'] = 'Edit Benefit';
		if (!is_array($rowdata)) {
			$this->session->set_flashdata('message', lang('idmissing'));
			redirect('wps-admin/capacity', '');
		}

		$capacity_id = $rowdata['capacity_id'];
		$this->form_validation->set_rules('capacity_name', 'Benefit Title', "trim|required|max_length[100]|unique[wps_capacities.capacity_name='" . $this->db->escape_str($this->input->post('capacity_name')) . "' AND status!='2' AND capacity_id!='" . $capacity_id . "']");

		if ($this->form_validation->run() == TRUE) {
			$posted_data = array(
				'capacity_name' => $this->input->post('capacity_name'),
				'capacity_date_updated' => $this->config->item('config.date.time')
			);

			$where = "capacity_id = '" . $capacity_id . "'";
			$this->capacity_model->safe_update('wps_capacities', $posted_data, $where, FALSE);

			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Updated Successfully!");
			redirect('wps-admin/capacity' . '/' . query_string(), '');
		}

		$data['edit_result'] = $rowdata;
		$this->load->view('capacity/view_capacity_edit', $data);
	}
}



// End of controller