<?php

class Products extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('category/category_model', 'products/product_model','admin/brand_model', 'admin/color_model', 'admin/size_model', 'admin/material_model', 'admin/capacity_model', 'admin/captype_model','admin/features_model'));
    $this->load->helper(array('products/product', 'category/category'));
     $this->load->library(array('Dmailer', 'safe_encrypt'));
  }

  public function index() {
    //Product Price Sort Query
    //SELECT product_price, (case when (product_discounted_price > 0) THEN product_discounted_price ELSE product_price END) as price from wps_products order by price
    //print_r($_POST);die;
    $this->page_section_ct = 'product';
    $condtion = array();
    $cat_res = '';
    $categories= (int) $this->input->get_post('categories');
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $this->uri->segment(3);
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "products/index/$category_id/pg/" : "products/index/pg/";
    $condtion['status'] = '1';

    if ($this->input->get_post('keywordSearch')) {
      $page_title = "Search Result - (" . strtoupper($this->input->get_post('keywordSearch')) . ")";
    } else {
      $page_title = "Products List";
    }

     //Sorting
    $sort = $this->input->get_post('sort');
    if ($sort > 0) {
      if ($sort == 5) {//Popular Products
        $condtion['orderby'] = 'wlp.products_viewed DESC';
      }
      if ($sort == 2) {//New Arrival
        $condtion['orderby'] = 'wlp.products_id DESC';
      }
      if ($sort == 4) {//Price Low to High
        $condtion['orderby'] = '(CASE WHEN wlp.product_discounted_price > 0 THEN wlp.product_discounted_price ELSE wlp.product_price END) ASC';
        //$condtion['orderby'] = 'wlp.product_price ASC';
      }
      if ($sort == 3) {//Price High to Low
        $condtion['orderby'] = '(CASE WHEN wlp.product_discounted_price > 0 THEN wlp.product_discounted_price ELSE wlp.product_price END) DESC';
        //$condtion['orderby'] = 'wlp.product_price DESC';
      }
    } else {
      $condtion['orderby'] = 'wlp.product_code asc';
    }

    //Filter
    $type = $this->uri->segment(1);
    if ($type != "") {
      if ($type == 'latest') {
        $condtion['latest_product'] = '1';
        $page_title = "Latest Products";
      }
      if ($type == 'best-seller') {
        $condtion['bestseller'] = '1';
        $page_title = "Best Seller Products";
      }
      if ($type == 'popular') {
        $condtion['popular'] = '1';
        $page_title = "Popular Products";
      }
      if ($type == 'new-arrival') {
        $condtion['newarrival'] = '1';
        $page_title = "New Arrival Products";
      }
    }
    
    $color = $this->input->get_post('color');
    $size = $this->input->get_post('size');
    $price = $this->input->get_post('price');
    $category_ids = $this->input->get_post('category_id');
    $brand = $this->input->get_post('brand');
    $style = $this->input->get_post('style');
    $room = $this->input->get_post('room');
    $material = $this->input->get_post('material');
    $capacity = $this->input->get_post('capacity');
    $captype = $this->input->get_post('captype');
    $feature = $this->input->get_post('feature');
    $pattern = $this->input->get_post('pattern');

    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    
    if (!empty($material)) {
      $materials = implode(',', $material);
      $condtion['material'] = $materials;
    }
    if (!empty($capacity)) {
      $capacities = implode(',', $capacity);
      $condtion['capacity'] = $capacities;
    }
    if (!empty($captype)) {
      $captypes = implode(',', $captype);
      $condtion['captype'] = $captypes;
    }
    if (!empty($feature)) {
      $features = implode(',', $feature);
      $condtion['feature'] = $features;
    } 
    if (!empty($pattern)) {
      $patterns = implode(',', $pattern);
      $condtion['pattern'] = $patterns;
    }
    if (!empty($brand)) {
      $brand = implode(',', $brand);
      $condtion['brand'] = $brand;
    }
    
    
    if (!empty($price)) {
      $condtion['price'] = $price;
    }
    if (!empty($style)) {
      $style = implode(',', $style);
      $condtion['style'] = $style;
    }
    if (!empty($room)) {
      $room = implode(',', $room);
      $condtion['room'] = $room;
    }
    if ($category_ids>0) {
      $condtion['category_ids'] = $category_ids;
    }

    if ($categories>0) {
      $condtion['categories'] = $categories;
    }

    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$category_id'");
      $page_title = $cat_res['category_name'];
    }
    $data['catid'] = '';
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);

    /* Available Color Records */
    $color_cond_config = array(
      'condition' => " AND status='1' ",
      'order' => 'color_name '
    );
    $colors = $this->color_model->getcolors($color_cond_config);
    $data['colors'] = $colors;
    /* Available Size Records */
    $size_cond_config = array(
        'condition' => " AND status='1' ",
        'order' => 'size_name '
    );
    $sizes = $this->size_model->getsizes($size_cond_config);
    $data['sizes'] = $sizes;
     /* Available Category Records */
    $size_categorycond_config = array(
        'condition' => " AND status='1' ",
        'order' => 'category_name '
    );
    $categories = $this->category_model->getcategory($size_categorycond_config);
    $data['categories'] = $categories; 

    /* Available Brand Records */
    $brand_config = array(
      'condition' => " AND status='1' ",
      'order' => 'brand_name '
    );
    $brands = $this->brand_model->getBrands($brand_config);
    $data['brands'] = $brands;

    /* Available material Records */
    $material_config = array(
      'condition' => " AND status='1' ",
      'order' => 'material_name '
    );

    $materials = $this->material_model->getMaterials($material_config);
    $data['materials'] = $materials;

    /* Available Capacity Records */
    $capacity_config = array(
      'condition' => " AND status='1' ",
      'order' => 'capacity_name '
    );
    $capacities = $this->capacity_model->getCapacities($capacity_config);
    $data['capacities'] = $capacities;

    /* Available Captype Records */
    $captype_config = array(
      'condition' => " AND status='1' ",
      'order' => 'captype_name '
    );
    $captypes = $this->captype_model->getCaptypes($captype_config);
    $data['captypes'] = $captypes;

    /* Available Features Records */
    $features_config = array(
      'condition' => " AND status='1' ",
      'order' => 'features_name '
    );
    $features = $this->features_model->getfeatures($features_config);
    $data['features'] = $features;

    $data['total_rows'] = $data['total_list_rows'] = $config['total_rows'] = get_found_rows();
    $data['heading_title'] = $page_title;
    $data['products'] = $res_array;
    $data['cat_res'] = $cat_res;
    //echo "<pre>";print_r($data);die;
    $this->load->view('products/view_product_listing', $data);
   // print_r($_POST);
   // print_r(count($res_array));
  }


   public function newarrival() {
    $this->page_section_ct = 'product';
    $condtion = array();
    $cat_res = '';
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $this->uri->segment(3);
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "products/index/$category_id/pg/" : "products/index/pg/";
    $condtion['status'] = '1';
    $condtion['newarrival'] = '1';

    if ($this->input->get_post('keywordSearch')) {
      $page_title = "Search Result - (" . strtoupper($this->input->get_post('keywordSearch')) . ")";
    } else {
      $page_title = "New Arrival Products";
    }

     //Sorting
     $sort = $this->input->get_post('sort');
     if ($sort > 0) {
       if ($sort == 5) {//Popular Products
         $condtion['orderby'] = 'wlp.products_viewed DESC';
       }
       if ($sort == 2) {//New Arrival
         $condtion['orderby'] = 'wlp.products_id DESC';
       }
       if ($sort == 4) {//Price Low to High
         $condtion['orderby'] = '(CASE WHEN wlp.product_discounted_price > 0 THEN wlp.product_discounted_price ELSE wlp.product_price END) ASC';
         //$condtion['orderby'] = 'wlp.product_price ASC';
       }
       if ($sort == 3) {//Price High to Low
         $condtion['orderby'] = '(CASE WHEN wlp.product_discounted_price > 0 THEN wlp.product_discounted_price ELSE wlp.product_price END) DESC';
         //$condtion['orderby'] = 'wlp.product_price DESC';
       }
     } else {
       $condtion['orderby'] = 'wlp.product_code asc';
     }
    

    //Filter
    $type = $this->uri->segment(1);
    if ($type != "") {
      if ($type == 'latest') {
        $condtion['latest_product'] = '1';
        $page_title = "Latest Products";
      }
      if ($type == 'best-seller') {
        $condtion['bestseller'] = '1';
        $page_title = "Best Seller Products";
      }
      if ($type == 'popular') {
        $condtion['popular'] = '1';
        $page_title = "Popular Products";
      }
      if ($type == 'new-arrival') {
        $condtion['newarrival'] = '1';
        $page_title = "New Arrival Products";
      }
    }
    
    $color = $this->input->get_post('color');
    $size = $this->input->get_post('size');
    $price = $this->input->get_post('price');

    $brand = $this->input->get_post('brand');
    $material = $this->input->get_post('material');
    $capacity = $this->input->get_post('capacity');
    $captype = $this->input->get_post('captype');
    $feature = $this->input->get_post('feature');
    $pattern = $this->input->get_post('pattern');

    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    
    if (!empty($material)) {
      $materials = implode(',', $material);
      $condtion['material'] = $materials;
    }
    if (!empty($capacity)) {
      $capacities = implode(',', $capacity);
      $condtion['capacity'] = $capacities;
    }
    if (!empty($captype)) {
      $captypes = implode(',', $captype);
      $condtion['captype'] = $captypes;
    }
    if (!empty($feature)) {
      $features = implode(',', $feature);
      $condtion['feature'] = $features;
    } 
    if (!empty($pattern)) {
      $patterns = implode(',', $pattern);
      $condtion['pattern'] = $patterns;
    }
    if (!empty($brand)) {
      $brand = implode(',', $brand);
      $condtion['brand'] = $brand;
    }



    if (!empty($price)) {
      $condtion['price'] = $price;
    }

    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$category_id'");
      $page_title = $cat_res['category_name'];
    }
    $data['catid'] = '';
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    $res_array2 = $this->product_model->get_products('5000', $offset, $condtion);
    $data['total_rows'] = $data['total_list_rows'] = $config['total_rows'] = get_found_rows();
    $data['heading_title'] = $page_title;
    $data['products'] = $res_array;
    $data['products2'] = $res_array2;
    $data['cat_res'] = $cat_res;
    /* Available Color Records */
    $color_cond_config = array(
      'condition' => " AND status='1' ",
      'order' => 'color_name '
    );
    $colors = $this->color_model->getcolors($color_cond_config);
    $data['colors'] = $colors;
    /* Available Size Records */
    $size_cond_config = array(
        'condition' => " AND status='1' ",
        'order' => 'size_name '
    );
    $sizes = $this->size_model->getsizes($size_cond_config);
    $data['sizes'] = $sizes;
    /* Available Size Records */

    /* Available Brand Records */
    $brand_config = array(
      'condition' => " AND status='1' ",
      'order' => 'brand_name '
    );
    $brands = $this->brand_model->getBrands($brand_config);
    $data['brands'] = $brands;

    /* Available material Records */
    $material_config = array(
      'condition' => " AND status='1' ",
      'order' => 'material_name '
    );

    $materials = $this->material_model->getMaterials($material_config);
    $data['materials'] = $materials;

    /* Available Capacity Records */
    $capacity_config = array(
      'condition' => " AND status='1' ",
      'order' => 'capacity_name '
    );
    $capacities = $this->capacity_model->getCapacities($capacity_config);
    $data['capacities'] = $capacities;

    /* Available Captype Records */
    $captype_config = array(
      'condition' => " AND status='1' ",
      'order' => 'captype_name '
    );
    $captypes = $this->captype_model->getCaptypes($captype_config);
    $data['captypes'] = $captypes;

    /* Available Features Records */
    $features_config = array(
      'condition' => " AND status='1' ",
      'order' => 'features_name '
    );
    $features = $this->features_model->getfeatures($features_config);
    $data['features'] = $features;

    $this->load->view('products/view_product_listing', $data);
  }

   

  public function sale() {
   
    $this->page_section_ct = 'product';
    $condtion = array();
    $cat_res = '';
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $this->uri->segment(3);
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "products/index/$category_id/pg/" : "products/index/pg/";
    $condtion['status'] = '1';
    $condtion['on_sale_product'] = '1';

    if ($this->input->get_post('keywordSearch')) {
      $page_title = "Search Result - (" . strtoupper($this->input->get_post('keywordSearch')) . ")";
    } else {
      $page_title = "Products On Sale";
    }

   //Sorting
   $sort = $this->input->get_post('sort');
   if ($sort > 0) {
     if ($sort == 5) {//Popular Products
       $condtion['orderby'] = 'wlp.products_viewed DESC';
     }
     if ($sort == 2) {//New Arrival
       $condtion['orderby'] = 'wlp.products_id DESC';
     }
     if ($sort == 4) {//Price Low to High
       $condtion['orderby'] = '(CASE WHEN wlp.product_discounted_price > 0 THEN wlp.product_discounted_price ELSE wlp.product_price END) ASC';
       //$condtion['orderby'] = 'wlp.product_price ASC';
     }
     if ($sort == 3) {//Price High to Low
       $condtion['orderby'] = '(CASE WHEN wlp.product_discounted_price > 0 THEN wlp.product_discounted_price ELSE wlp.product_price END) DESC';
       //$condtion['orderby'] = 'wlp.product_price DESC';
     }
   } else {
     $condtion['orderby'] = 'wlp.product_code asc';
   }
    

    //Filter
    $type = $this->uri->segment(1);
    if ($type != "") {
      if ($type == 'latest') {
        $condtion['latest_product'] = '1';
        $page_title = "Latest Products";
      }
      if ($type == 'best-seller') {
        $condtion['bestseller'] = '1';
        $page_title = "Best Seller Products";
      }
      if ($type == 'popular') {
        $condtion['popular'] = '1';
        $page_title = "Popular Products";
      }
      if ($type == 'new-arrival') {
        $condtion['newarrival'] = '1';
        $page_title = "New Arrival Products";
      }
    }
    
    $color = $this->input->get_post('color');
    $size = $this->input->get_post('size');
    $price = $this->input->get_post('price');

    $brand = $this->input->get_post('brand');
    $material = $this->input->get_post('material');
    $capacity = $this->input->get_post('capacity');
    $captype = $this->input->get_post('captype');
    $feature = $this->input->get_post('feature');
    $pattern = $this->input->get_post('pattern');

    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    
    if (!empty($material)) {
      $materials = implode(',', $material);
      $condtion['material'] = $materials;
    }
    if (!empty($capacity)) {
      $capacities = implode(',', $capacity);
      $condtion['capacity'] = $capacities;
    }
    if (!empty($captype)) {
      $captypes = implode(',', $captype);
      $condtion['captype'] = $captypes;
    }
    if (!empty($feature)) {
      $features = implode(',', $feature);
      $condtion['feature'] = $features;
    } 
    if (!empty($pattern)) {
      $patterns = implode(',', $pattern);
      $condtion['pattern'] = $patterns;
    }
    if (!empty($brand)) {
      $brand = implode(',', $brand);
      $condtion['brand'] = $brand;
    }


    if (!empty($price)) {
      $condtion['price'] = $price;
    }
    

    if ($category_id > 0) {
      $condtion['category_id'] = $category_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$category_id'");
      $page_title = $cat_res['category_name'];
    }
    $data['catid'] = '';
    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    $data['total_rows'] = $data['total_list_rows'] = $config['total_rows'] = get_found_rows();
    $data['heading_title'] = $page_title;
    $data['products'] = $res_array;
    $data['cat_res'] = $cat_res;
    /* Available Color Records */
    $color_cond_config = array(
      'condition' => " AND status='1' ",
      'order' => 'color_name '
    );
    $colors = $this->color_model->getcolors($color_cond_config);
    $data['colors'] = $colors;
    /* Available Size Records */
    $size_cond_config = array(
        'condition' => " AND status='1' ",
        'order' => 'size_name '
    );
    $sizes = $this->size_model->getsizes($size_cond_config);
    $data['sizes'] = $sizes;
    /* Available Size Records */

    /* Available Brand Records */
    $brand_config = array(
      'condition' => " AND status='1' ",
      'order' => 'brand_name '
    );
    $brands = $this->brand_model->getBrands($brand_config);
    $data['brands'] = $brands;

    /* Available material Records */
    $material_config = array(
      'condition' => " AND status='1' ",
      'order' => 'material_name '
    );

    $materials = $this->material_model->getMaterials($material_config);
    $data['materials'] = $materials;

    /* Available Capacity Records */
    $capacity_config = array(
      'condition' => " AND status='1' ",
      'order' => 'capacity_name '
    );
    $capacities = $this->capacity_model->getCapacities($capacity_config);
    $data['capacities'] = $capacities;

    /* Available Captype Records */
    $captype_config = array(
      'condition' => " AND status='1' ",
      'order' => 'captype_name '
    );
    $captypes = $this->captype_model->getCaptypes($captype_config);
    $data['captypes'] = $captypes;
    
    /* Available Features Records */
    $features_config = array(
      'condition' => " AND status='1' ",
      'order' => 'features_name '
    );
    $features = $this->features_model->getfeatures($features_config);
    $data['features'] = $features;

    $this->load->view('products/view_product_listing', $data);
  }

  public function ajax_load_product_view() {

    $data['title'] = 'Ajax Load Products';
    $config['per_page'] = $this->config->item('per_page');
    $offset = $this->input->get_post('stOffSet');

    if ($this->input->get_post('category_id')) {
      $parent_segment = (int) $this->input->get_post('category_id');
    } else {
      $parent_segment = (int) $this->input->get_post('category_id');
    }
    $page_segment = find_paging_segment();
    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';

    $condtion['status'] = '1';
    $page_title = "Products List";
    if ($parent_id > 0) {
      $condtion['category_id'] = $parent_id;
      $cat_res = get_db_single_row('wps_categories', '*', " category_id='$parent_id'");
      $page_title = $cat_res['category_name'];
      $data['catid'] = $parent_id;
    }

      //Sorting
    $sort = $this->input->get_post('sort');
    if ($sort > 0) {
      if ($sort == 5) {//Popular Products
        $condtion['orderby'] = 'wlp.products_viewed DESC';
      }
      if ($sort == 2) {//New Arrival
        $condtion['orderby'] = 'wlp.products_id DESC';
      }
      if ($sort == 4) {//Price Low to High
        $condtion['orderby'] = '(CASE WHEN wlp.product_discounted_price > 0 THEN wlp.product_discounted_price ELSE wlp.product_price END) ASC';
        //$condtion['orderby'] = 'wlp.product_price ASC';
      }
      if ($sort == 3) {//Price High to Low
        $condtion['orderby'] = '(CASE WHEN wlp.product_discounted_price > 0 THEN wlp.product_discounted_price ELSE wlp.product_price END) DESC';
        //$condtion['orderby'] = 'wlp.product_price DESC';
      }
    } else {
      $condtion['orderby'] = 'wlp.product_code asc';
    }
    

    $type = $this->input->get_post('type');
    if ($type != "") {
      if ($type == 'latest') {
        $condtion['latest_product'] = '1';
      }
      if ($type == 'best-seller') {
        $condtion['bestseller'] = '1';
      }
      if ($type == 'popular') {
        $condtion['popular'] = '1';
      }
      if ($type == 'new-arrival') {
        $condtion['newarrival'] = '1';
      }
    }

    if ($this->input->get_post('keywordSearch') != '') {
      $condtion['keywordSearch'] = $this->input->get_post('keywordSearch');
    }

    $color = $this->input->get_post('color');
    $size = $this->input->get_post('size');
    $price = $this->input->get_post('price');

    $brand = $this->input->get_post('brand');
    $material = $this->input->get_post('material');
    $capacity = $this->input->get_post('capacity');
    $captype = $this->input->get_post('captype');
    $feature = $this->input->get_post('feature');
    $pattern = $this->input->get_post('pattern');

    if (!empty($color)) {
      $colors = implode(',', $color);
      $condtion['color'] = $colors;
    }
    if (!empty($size)) {
      $sizes = implode(',', $size);
      $condtion['size'] = $sizes;
    }
    
    if (!empty($material)) {
      $materials = implode(',', $material);
      $condtion['material'] = $materials;
    }
    if (!empty($capacity)) {
      $capacities = implode(',', $capacity);
      $condtion['capacity'] = $capacities;
    }
    if (!empty($captype)) {
      $captypes = implode(',', $captype);
      $condtion['captype'] = $captypes;
    }
    if (!empty($feature)) {
      $features = implode(',', $feature);
      $condtion['feature'] = $features;
    } 
    if (!empty($pattern)) {
      $patterns = implode(',', $pattern);
      $condtion['pattern'] = $patterns;
    }
    if (!empty($brand)) {
      $brand = implode(',', $brand);
      $condtion['brand'] = $brand;
    }


    if (!empty($price)) {
      $condtion['price'] = $price;
    }
    

    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    $data['listRes'] = $res_array;
    /* Available Color Records */
    $color_cond_config = array(
      'condition' => " AND status='1' ",
      'order' => 'color_name '
    );
    $colors = $this->color_model->getcolors($color_cond_config);
    $data['colors'] = $colors;
    /* Available Size Records */
    $size_cond_config = array(
        'condition' => " AND status='1' ",
        'order' => 'size_name '
    );
    $sizes = $this->size_model->getsizes($size_cond_config);
    $data['sizes'] = $sizes;
    /* Available Size Records */

    /* Available Brand Records */
    $brand_config = array(
      'condition' => " AND status='1' ",
      'order' => 'brand_name '
    );
    $brands = $this->brand_model->getBrands($brand_config);
    $data['brands'] = $brands;

    /* Available material Records */
    $material_config = array(
      'condition' => " AND status='1' ",
      'order' => 'material_name '
    );

    $materials = $this->material_model->getMaterials($material_config);
    $data['materials'] = $materials;

    /* Available Capacity Records */
    $capacity_config = array(
      'condition' => " AND status='1' ",
      'order' => 'capacity_name '
    );
    $capacities = $this->capacity_model->getCapacities($capacity_config);
    $data['capacities'] = $capacities;

    /* Available Captype Records */
    $captype_config = array(
      'condition' => " AND status='1' ",
      'order' => 'captype_name '
    );
    $captypes = $this->captype_model->getCaptypes($captype_config);
    $data['captypes'] = $captypes;
    
    /* Available Features Records */
    $features_config = array(
      'condition' => " AND status='1' ",
      'order' => 'features_name '
    );
    $features = $this->features_model->getfeatures($features_config);
    $data['features'] = $features;
    
    $this->load->view('products/ajax_load_products', $data);
  }

  public function detail() {
    ini_set('memory_limit','2048M');
    $this->page_section_ct = 'product';
    $data['unq_section'] = "Product";
    $productId = (int) $this->meta_info['entity_id'];
    
    $where = "wlp.products_id = '" . $productId . "'";
    $option = array(
        'fields' => "SQL_CALC_FOUND_ROWS wlp.*,wlc.first_name,wlc.user_name,wlc.mobile_number,wlcat.category_id",
        'where' => $where
    );
    $res = $this->product_model->get_products('1', '', $option);
    if (is_array($res) && !empty($res)) {
      $res = $res[0];
      // Recent View
      $id = $res['products_id'];
      $ee = $this->session->userdata('recent_view');
      if (is_array($ee)) {
        if (!@in_array($id, $ee)) {
          @array_push($ee, $id);
          $this->session->set_userdata('recent_view', $ee);
        }
      } else {
        $this->session->set_userdata('recent_view', array($id));
      }
      // End Here

      // $this->load->model('comments/comments_model');
      // $data['error_validate'] = TRUE;

      $data['title'] = "Product";
      $data['res'] = $res;
      $this->product_model->update_viewed($res['products_id'], $res['products_viewed']);
      $media_res = $this->product_model->get_product_media(6, 0, array('productid' => $res['products_id']));
      $data['media_res'] = $media_res;

      //Reviews
      // $qry_options = array('limit' => 200, 'offset' => 0, 'condition' => " AND product_id ='" . $res['products_id'] . "' AND entity_type='product' AND a.status='1'");
      // $review_res = $this->comments_model->get_comments($qry_options);
      // $data['review_count'] = get_found_rows();
      // $data['review_res'] = $review_res;

      //Related Products
      $related_products = $this->get_product_related_list($res['category_id'], $productId);
      $data['related'] = $related_products;
      //End

      $data['REMARKSS'] = $this->config->item('REMARKS'); 

      $this->load->view('products/view_product_details', $data);
    } else {
      redirect('products', '');
    }
  }


  public function enquireNow() {
    
    $this->form_validation->set_rules('name', 'Name', 'trim|required|alpha');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Mobile Number', 'trim|required|max_length[15]|min_length[10]');
    $this->form_validation->set_rules('message', 'Message', 'trim|xss_clean|required|max_length[500]|alpha_numeric_spaces');
    $this->form_validation->set_rules('captcha', 'Captcha', 'trim|required');
    $this->form_validation->set_rules('product_id', 'Product Id', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
        $posted_data = array(
            'type' => '4',
            'first_name' => $this->input->post('name'),
            'products_id' => $this->input->post('product_id'),
            'post_url' => $_SERVER['HTTP_REFERER'],
            'last_name' => '',
            'email' => $this->input->post('email'),
            'mobile_number' => $this->input->post('phone'),
            'message' => $this->input->post('message'),
            'receive_date' => $this->config->item('config.date.time'),
        );
        $result = $this->product_model->safe_insert('wps_enquiry', $posted_data, false);

        $subject = "Enquiry From ".$this->config->item('site_name_www');
         $body='<html><head></head><body>
              <table border="0" width="100%">
              <tbody>
              <tr>
              <td colspan="2">
              <strong>Dear Admin</strong></td>
              </tr>
              <tr>
              <td colspan="2">
              Enquiry&nbsp; has been submitted with following info :</td>
              </tr>
              <tr>
              <td colspan="2">
              &nbsp;</td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Name : </strong></td>
              <td>
              <span style="margin-top:15px">'.$this->input->post('name').'</span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Email : </strong></td>
              <td>
              <span style="margin-top:15px"><a href="mailto:'.$this->input->post('email').'" target="_blank">'.$this->input->post('email').'</a></span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Mobile : </strong></td>
              <td>
              <span style="margin-top:15px">'.$this->input->post('phone').'</span></td>
              </tr>
              <tr>
              <td width="26%">
              <strong>Message : </strong></td>
              <td>
              <span style="margin-top:15px">'.$this->input->post('message').'</span></td>
              </tr>
               <tr>
              <td width="26%">
              <strong>URL : </strong></td>
              <td>
              <span style="margin-top:15px">'.$_SERVER['HTTP_REFERER'].'</span></td>
              </tr>
              <tr>
              <td colspan="2">
              &nbsp;</td>
              </tr>
              </tbody>
              </table><br/>
              <span style="margin-top:15px">
               Thank you.<br>
               '.$this->config->item('site_name').' Customer Service<br>
               Email: <a href="mailto:'.$this->admin_info->admin_email.'" target="_blank">'.$this->admin_info->admin_email.'</a><div class="yj6qo"></div><div class="adL"> 
              </div></span></body</html>';
            if($this->admin_info->website_mode=='Live'){
                  $mail_conf = array(
                      'subject' => $subject,
                      'to_email' => $this->admin_info->admin_email, //
                      'from_email' => $this->input->post('email'),
                      'from_name' => $this->input->post('name'),
                      'reply_to' => $this->input->post('email'),
                      'body_part' => $body,
                  );
                  $admin_email = $this->admin_info->admin_email;
                  $from_email = $this->input->post('email');
                  BrevoMail($admin_email, $subject, $body, $from_email);
                //   $this->dmailer->mail_notify($mail_conf);
                  
                  $mail_conf2 = array(
                      'subject' => "Webpulseindia.com - Enquiry From ".$this->config->item('site_name_www'),
                      'to_email' => 'webpulseindia@gmail.com', //
                      'from_email' => $this->input->post('email'),
                      'from_name' => $this->input->post('name'),
                      'reply_to' => $this->input->post('email'),
                      'body_part' => $body,
                  );
                  BrevoMail('webpulseindia@gmail.com', $subject, $body, $from_email);
                //   $this->dmailer->mail_notify($mail_conf2);

                  
            }else{
               $mail_conf4 = array(
                  'subject' => "Webpulseindia.com - Enquiry From ".$this->config->item('site_name_www'),
                  'to_email' => 'test.webpulse@gmail.com', //
                  'from_email' => $this->input->post('email'),
                  'from_name' => $this->input->post('name'),
                  'reply_to' => $this->input->post('email'),
                  'body_part' => $body,
              );
                $from_email = $this->input->post('email');
                  BrevoMail('test.webpulse@gmail.com', $subject, $body, $from_email);
            //   $this->dmailer->mail_notify($mail_conf4);
            }
       $res = 'success';
    } else {
      $res = '<div class="alert alert-danger">
                      <strong>'.validation_errors().'
                  </div>';
    }

    echo $res;
    exit;
  }

   

  public function get_product_related_list($catId = "", $productId) {
    $condtion['status'] = '1';
    $condtion['where'] = "wlp.category_id = '" . $catId . "' AND wlp.products_id != '" . $productId . "'";
    $condtion['orderby'] = 'products_id DESC';
    $product_list = $this->product_model->get_products('10', '0', $condtion);
    //echo_sql();
    return $product_list;
  }

  public function get_product_price() {
    $sid = (int) $this->input->post('sid');
    $cid = (int) $this->input->post('cid');
    $pid = (int) $this->input->post('pid');

    //if ($cid > 0 && $sid > 0) {
      $res = $this->db->select('quantity,product_price,product_qty,products_description,product_discounted_price')->get_where('wps_product_attributes', array('color_id' => $cid, 'size_id' => $sid, 'product_id' => $pid))->row();
      //echo_sql();
      if (is_object($res)) {
        echo $res->quantity . '-' . $res->product_price . '-' . $res->product_discounted_price;
      }
    //}
  }


  public function post_review() {
    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");
    $this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[70]');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|max_length[80]|valid_email');
    $this->form_validation->set_rules('rating', 'Rating', 'trim|required|max_length[1]');
    $this->form_validation->set_rules('reviews', 'Review', 'trim|required|max_length[450]');
    if ($this->form_validation->run() === TRUE) {
      $mem_id = $this->session->userdata('user_id');
      $posted_data = array(
          'entity_id' => $this->input->get_post('products_id'),
          'entity_type' => 'product',
          'customer_id' => $mem_id,
          'ads_rating' => $this->input->post('rating'),
          'author' => $this->input->post('name'),
          'author_email' => $this->input->post('email'),
          'text' => $this->input->post('reviews'),
          'status' => '1',
          'review_date' => $this->config->item('config.date.time')
      );
      $this->product_model->safe_insert('wps_review', $posted_data, FALSE);

      $data['success'] = true;
      $data['message'] = 'Thank you. Your review has been submitted successfully';
      echo json_encode($data);
    } else {
      $data['success'] = false;
      $data['error'] = validation_errors();
      echo json_encode($data);
    }
  }

  public function check_product_exits_into_cart($pres) {
    $cart_array = $this->cart->contents();
    $insert_flag = 0;
    if (is_array($cart_array) && !empty($cart_array)) {
      foreach ($this->cart->contents() as $item) {
        if (array_key_exists('pid', $item)) {
          if ($item['pid'] == $pres['products_id']) {
            $insert_flag = 1;
          }
        }
      }
    }
    return $insert_flag;
  }

  public function postEnquiry() {

    $this->form_validation->set_error_delimiters("<div class='required'>", "</div>");



    $this->form_validation->set_rules('fullName', 'Your Name', 'trim|required|max_length[30]');

    $this->form_validation->set_rules('mobileNumber', 'Mobile Number', 'trim|required|max_length[10]');

    $this->form_validation->set_rules('emailAddress', 'Email', 'trim|required|max_length[80]|valid_email');
    //$this->form_validation->set_rules('country', 'Country', 'trim|required|max_length[200]');
    $this->form_validation->set_rules('location', 'Address', 'trim|required|max_length[220]');
    //$this->form_validation->set_rules('productQuantity', 'Quantity', 'trim|required|max_length[10]');

    $this->form_validation->set_rules('enquiryMessage', 'Message', 'trim|required');





    if ($this->form_validation->run() === TRUE) {

      $mem_id = (int) $this->input->post('companyID');
      $product_name = $this->input->post('proName');
      $pro_id = $this->input->post('productID');
      $post_url = $this->input->post('post_url');
      $proType = $this->input->post('proType');
      $type = $this->input->post('type');
      $adminRes = get_site_email();


      $product = array();

      /*
      if($pro_id>0){

        $product = get_db_single_row('wps_products', 'product_name, unit_measurement', "products_id = '" . $pro_id . "'");

        if ($this->input->post('type') == 'category') {

          $product = get_db_single_row('wps_company_categories', 'category_name as product_name', "category_id = '" . $pro_id . "'");

        }

      }*/


      $posted_data = array( 

          'products_id' => $pro_id,
          'product_name' => $product_name,
          'customers_id' => $mem_id,
          'type' => $this->input->post('type'),
          'email' => $this->input->post('emailAddress'),
          'first_name' => $this->input->post('fullName'),
          'mobile_number' => $this->input->post('mobileNumber'),
          'message' => $this->input->post('enquiryMessage'),
          //'country' => $this->input->post('country'),
          'location' => $this->input->post('location'),
          'post_url' => $post_url,
          'status' => '1',
          'receive_date' => $this->config->item('config.date.time')

      );

      $this->product_model->safe_insert('wps_enquiry', $posted_data, FALSE);

      //Mail
      $content = get_content('wps_auto_respond_mails', '15');
      $name = $this->input->post('first_name');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', 'Admin', $body);
      $body = str_replace('{user_name}', $name, $body);
      $body = str_replace('{enqfor}', $product_name, $body);
      $body = str_replace('{email}', $this->input->post('email'), $body);
      $body = str_replace('{phone}', $this->input->post('phone'), $body);
      $body = str_replace('{country}', $this->input->post('country'), $body);
      $body = str_replace('{location}', $this->input->post('location'), $body);
      $body = str_replace('{comments}', $this->input->post('message'), $body);
      $body = str_replace('{site_name}', SITENAME, $body);
      $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
      if($this->admin_info->mode=='Live'){
          $mail_conf = array(
              'subject' => "Enquiry from ".$this->config->item('site_name_www'),
              'to_email' => $adminRes->admin_email,
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
          $admin_email = $this->admin_info->admin_email;
          $subject = "Enquiry from ".$this->config->item('site_name_www');
          BrevoMail($admin_email, $subject, $body, $this->input->post('email'));
        //   $this->dmailer->mail_notify($mail_conf);
          $mail_conf = array(
              'subject' => "Enquiry from ".$this->config->item('site_name_www'),
              'to_email' => 'webpulseindia@gmail.com',
              'from_email' => $this->input->post('email'),
              'from_name' => $name,
              'body_part' => $body
          );
        //   $this->dmailer->mail_notify($mail_conf);
          BrevoMail('webpulseindia@gmail.com', $subject, $body, $this->input->post('email'));
        
      }else{
          $mail_conf = array(
            'subject' => "Enquiry from ".$this->config->item('site_name_www'),
            'to_email' => $this->admin_info->admin_email,
            'from_email' => $this->input->post('email'),
            'from_name' => $name,
            'body_part' => $body
          );
          $admin_email = $this->admin_info->admin_email;
          BrevoMail($admin_email, $subject, $body, $this->input->post('email'));
        //   $this->dmailer->mail_notify($mail_conf);
      }





      $data['success'] = 'true';

      $data['message'] = 'Thank you. Your enquiry has been submitted successfully!';

      echo json_encode($data);

    } else {

      $data['success'] = 'false';

      $data['error'] = validation_errors();

      echo json_encode($data);

    }

  }

}
?>