<?php

class Pages extends Public_Controller
{

  public function __construct()
  {

    parent::__construct();
    $this->load->helper(array('file'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->load->model(array('pages/pages_model'));
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
    $this->page_section_ct = 'static';
  }

  public function index()
  {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/cms_page_view', $data);
  }

  public function aboutus()
  {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_page='about' and status='1' and CURDATE() between banner_start_date and banner_end_date")->row_array();
    $data['latestnews1'] = $this->db->query("SELECT * FROM wps_news WHERE status='1' order by news_id desc limit 1")->row_array();
    $data['latestnews2'] = $this->db->query("SELECT * FROM wps_news WHERE status='1' order by news_id desc limit 3 offset 1")->result_array();
    // trace($data);
    // exit;
    $this->load->view('pages/about', $data);
  }

  public function privacypolicy()
  {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_page='about' and status='1' and CURDATE() between banner_start_date and banner_end_date")->row_array();
    $data['latestnews1'] = $this->db->query("SELECT * FROM wps_news WHERE status='1' order by news_id desc limit 1")->row_array();
    $data['latestnews2'] = $this->db->query("SELECT * FROM wps_news WHERE status='1' order by news_id desc limit 3 offset 1")->result_array();
    // trace($data);
    // exit;
    $this->load->view('pages/privacy-policy', $data);
  }
  public function portfolio()
  {
    $data = array();
    $this->load->view('pages/our-portfolio', $data);
  }

  public function sizeguide()
  {
    $data = array();
    $this->load->view('pages/size-guide', $data);
  }
  public function color_chart()
  {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/color_chart', $data);
  }

  // public function contactus() {
  //   $adminRes = get_site_email();
  //   $data['adminRes'] = $adminRes;
  //   //trace($_SERVER['HTTP_REFERER']);

  //   $this->form_validation->set_rules('first_name', 'Name', 'trim|required|alpha');
  //   $this->form_validation->set_rules('location', 'Location', 'trim|required');
  //   $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
  //   $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[10]');
  //   $this->form_validation->set_rules('message', 'Message', 'trim|required|alpha'); //Comment
  //   //  $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');


  //   if ($this->form_validation->run() == TRUE) {
  //       if($_POST['g-recaptcha-response'] == ''){
  //       $response = [
  //           'message_response'=>'Please check google Re-captcha box',
  //           'status'=>'false'
  //       ];
  //       echo json_encode($response);
  //       exit;
  //   }
  //     $post_data = http_build_query(
  //           array(
  //               'secret' => CAPTCHA_SECRET,
  //               'response' => $_POST['g-recaptcha-response'],
  //               'remoteip' => $_SERVER['REMOTE_ADDR'],
  //           )
  //     );
  //     $opts = array('http' => array(
  //             'method' => 'POST',
  //             'header' => 'Content-type: application/x-www-form-urlencoded',
  //             'content' => $post_data,
  //         ),
  //     );
  //     $context = stream_context_create($opts);
  //     $response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
  //     $capcha_result = json_decode($response);

  //     if (!$capcha_result->success) {
  //       //throw new Exception('Gah! CAPTCHA verification failed. Please try again', 1);
  //       $msg = "CAPTCHA verification failed!";
  //       $this->session->set_userdata(array('msg_type' => 'error'));
  //       $this->session->set_flashdata('error', $msg);
  //       $friendly_url = $this->uri->uri_string;
  //       $condition = array('friendly_url' => $friendly_url, 'status' => '1');
  //       $content = $this->pages_model->get_cms_page($condition);
  //       // $data['content'] = $content;
  //       // $data['title'] = "Contact Us";
  //       // $this->load->view('contactus', $data);
  //       $response = [
  //           'message_response'=>'Google Captcha Verification failed',
  //           'status'=>'false'
  //       ];
  //       echo json_encode($response);
  //       exit;
  //     } else {

  //     $posted_data = array(
  //         'type' => '1',
  //         'first_name' => $this->input->post('first_name'),
  //         'location' => $this->input->post('location'),
  //         'email' => $this->input->post('email'),
  //         'mobile_number' => $this->input->post('phone'),
  //         'message' => $this->input->post('message'),
  //         'receive_date' => $this->config->item('config.date.time')
  //     );
  //     $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

  //     //Mail
  //     $content = get_content('wps_auto_respond_mails', '5');
  //     $name = $this->input->post('first_name');
  //     $body = $content->email_content;
  //     $body = str_replace('{mem_name}', 'Admin', $body);
  //     $body = str_replace('{user_name}', $name, $body);
  //     $body = str_replace('{email}', $this->input->post('email'), $body);
  //     $body = str_replace('{phone}', $this->input->post('phone'), $body);
  //     $body = str_replace('{location}', $this->input->post('location'), $body);
  //     $body = str_replace('{comments}', $this->input->post('message'), $body);
  //     $body = str_replace('{site_name}', SITENAME, $body);
  //     $body = str_replace('{admin_email}', $adminRes->admin_email, $body);
  //     if($this->admin_info->mode=='Testing'){
  //         $mail_conf = array(
  //             'subject' => "Enquiry from ".$this->config->item('site_name_www'),
  //             'to_email' => $adminRes->admin_email,
  //             'from_email' => $this->input->post('email'),
  //             'from_name' => $name,
  //             'body_part' => $body
  //         );

  //       $this->dmailer->mail_notify($mail_conf);

  //         $mail_conf1 = array(
  //             'subject' => "Enquiry from ".$this->config->item('site_name_www'),
  //             'to_email' => $adminRes->admin_email,
  //             'from_email' => $this->input->post('email'),
  //             'from_name' => $name,
  //             'body_part' => $body
  //         );
  //         $this->dmailer->mail_notify($mail_conf1);
  //       }else{

  //         $mail_conf = array(
  //           'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
  //           'to_email' => $adminRes->admin_email,
  //           'from_email' => $this->input->post('email'),
  //           'from_name' => $name,
  //           'body_part' => $body
  //         );
  //         $this->dmailer->mail_notify($mail_conf);

  //          $mail_conf2 = array(
  //           'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
  //           'to_email' => $adminRes->admin_email,
  //           'from_email' => $this->input->post('email'),
  //           'from_name' => $name,
  //           'body_part' => $body
  //         );
  //         $this->dmailer->mail_notify($mail_conf2);
  //     }

  //       $response = [
  //           'message_response'=>'Your Enquiry is submitted successfully. We will contact you soon.',
  //           'status'=>'true'
  //       ];
  //       echo json_encode($response);
  //       exit;
  //   }
  // }

  //   $friendly_url = $this->uri->uri_string;
  //   $condition = array('friendly_url' => $friendly_url, 'status' => '14');
  //   $content = $this->pages_model->get_cms_page($condition);
  //   $data['content'] = $content;
  //   $data['title'] = "Contact Us";
  //   $this->load->view('contactus', $data);
  // }



  // added code@10-June-2025
  public function contactus()
  {
    $adminRes = get_site_email();
    $user_ip = $this->input->ip_address();

    // --- reCAPTCHA verification ---
    $recaptchaResponse = $this->input->post('g-recaptcha-response');
    $remoteIp = $user_ip;

    $recaptchaData = [
      'secret' => CAPTCHA_SECRET,
      'response' => $recaptchaResponse,
      'remoteip' => $remoteIp,
    ];

    $verify = curl_init();
    curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
    curl_setopt($verify, CURLOPT_POST, true);
    curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($recaptchaData));
    curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($verify);
    curl_close($verify);

    $responseData = json_decode($response);

    if (!$responseData->success) {
      $response = [
        'status' => 'false',
        'message_response' => 'Robot verification failed, please try again.',
      ];

      if ($this->input->is_ajax_request()) {
        echo json_encode($response);
        exit;
      } else {
        $data['content'] = $this->pages_model->get_cms_page([
          'friendly_url' => $this->uri->uri_string,
          'status' => '14'
        ]);
        $data['title'] = "Contact Us";
        $data['error_message'] = $response['message_response'];
        $this->load->view('contactus', $data);
        return;  // stop processing if recaptcha fails
      }
    }
    // --- End reCAPTCHA verification ---

    // Form validation rules
    $this->form_validation->set_rules('first_name', 'Name', 'trim|required|regex_match[/^[a-zA-Z ]+$/]');
    $this->form_validation->set_rules('location', 'Location', 'trim|required');
    $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[15]');
    $this->form_validation->set_rules('message', 'Message', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
      $posted_data = array(
        'type' => '1',
        'first_name' => $this->input->post('first_name'),
        'location' => $this->input->post('location'),
        'email' => $this->input->post('email'),
        'mobile_number' => $this->input->post('phone'),
        'message' => $this->input->post('message'),
        'receive_date' => date('Y-m-d H:i:s'),
      );
      $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

      // Email content setup
      $content = get_content('wps_auto_respond_mails', '5');
      $name = $this->input->post('first_name');
      $body = str_replace(
        ['{mem_name}', '{user_name}', '{email}', '{phone}', '{location}', '{comments}', '{site_name}', '{admin_email}'],
        ['Admin', $name, $this->input->post('email'), $this->input->post('phone'), $this->input->post('location'), $this->input->post('message'), SITENAME, $adminRes->admin_email],
        $content->email_content
      );

      $mail_conf = array(
        'subject' => "Fabaccurate - Enquiry from " . $this->config->item('site_name_www'),
        //'to_email' => 'webpulse.phpdev3@gmail.com',
        'to_email' => $adminRes->admin_email,
        'cc'             => 'webpulseindia@gmail.com',
        'from_email' => $this->input->post('email'),
        'from_name' => $name,
        'body_part' => $body
      );

      if ($this->admin_info->mode == 'Live') {
        $this->dmailer->mail_notify($mail_conf);
      }

      $response = [
        'status' => 'true',
        'message_response' => "Your message has been sent successfully. We will reply within 24 hours."
      ];
    } else {
      // Validation failed
      $response = [
        'status' => 'false',
        'message_response' => "All Fields Required"
      ];
    }

    // Return JSON for AJAX or load view for normal request
    if ($this->input->is_ajax_request()) {
      echo json_encode($response);
      exit;
    } else {
      if ($response['status'] == 'true') {
        $this->session->set_flashdata('success', $response['message_response']);
        redirect(base_url('contact-us'));
      } else {
        $data['content'] = $this->pages_model->get_cms_page([
          'friendly_url' => $this->uri->uri_string,
          'status' => '14'
        ]);
        $data['title'] = "Contact Us";
        $data['error_message'] = $response['message_response'];
        $this->load->view('contactus', $data);
      }
    }
  }


  // This code email send user & admin both
  // public function contactus()
  // {
  //   $adminRes = get_site_email();
  //   $user_ip = $this->input->ip_address();

  //   // --- reCAPTCHA verification ---
  //   $recaptchaResponse = $this->input->post('g-recaptcha-response');
  //   $remoteIp = $user_ip;

  //   $recaptchaData = [
  //     'secret' => CAPTCHA_SECRET,
  //     'response' => $recaptchaResponse,
  //     'remoteip' => $remoteIp,
  //   ];

  //   $verify = curl_init();
  //   curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
  //   curl_setopt($verify, CURLOPT_POST, true);
  //   curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($recaptchaData));
  //   curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
  //   $response = curl_exec($verify);
  //   curl_close($verify);

  //   $responseData = json_decode($response);

  //   if (!$responseData->success) {
  //     $response = [
  //       'status' => 'false',
  //       'message_response' => 'Robot verification failed, please try again.',
  //     ];

  //     if ($this->input->is_ajax_request()) {
  //       echo json_encode($response);
  //       exit;
  //     } else {
  //       $data['content'] = $this->pages_model->get_cms_page([
  //         'friendly_url' => $this->uri->uri_string,
  //         'status' => '14'
  //       ]);
  //       $data['title'] = "Contact Us";
  //       $data['error_message'] = $response['message_response'];
  //       $this->load->view('contactus', $data);
  //       return;  // stop processing if recaptcha fails
  //     }
  //   }
  //   // --- End reCAPTCHA verification ---

  //   // Form validation rules
  //   $this->form_validation->set_rules('first_name', 'Name', 'trim|required|regex_match[/^[a-zA-Z ]+$/]');
  //   $this->form_validation->set_rules('location', 'Location', 'trim|required');
  //   $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
  //   $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|numeric|min_length[10]|max_length[15]');
  //   $this->form_validation->set_rules('message', 'Message', 'trim|required');

  //   if ($this->form_validation->run() == TRUE) {
  //     $posted_data = array(
  //       'type' => '1',
  //       'first_name' => $this->input->post('first_name'),
  //       'location' => $this->input->post('location'),
  //       'email' => $this->input->post('email'),
  //       'mobile_number' => $this->input->post('phone'),
  //       'message' => $this->input->post('message'),
  //       'receive_date' => date('Y-m-d H:i:s'),
  //     );
  //     $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

  //     $name = $this->input->post('first_name');

  //     // Email content for Admin
  //     $content = get_content('wps_auto_respond_mails', '5');
  //     $body = str_replace(
  //       ['{mem_name}', '{user_name}', '{email}', '{phone}', '{location}', '{comments}', '{site_name}', '{admin_email}'],
  //       ['Admin', $name, $this->input->post('email'), $this->input->post('phone'), $this->input->post('location'), $this->input->post('message'), SITENAME, $adminRes->admin_email],
  //       $content->email_content
  //     );

  //     $adminMailConf = array(
  //       'subject'    => "Webpulseindia.com - Enquiry from " . $this->config->item('site_name_www'),
  //       'to_email'   => 'webpulse.phpdev3@gmail.com',       // Admin main email
  //       'cc_email'   => 'cc_email@example.com',             // Your CC email here
  //       'from_email' => $this->input->post('email'),
  //       'from_name'  => $name,
  //       'body_part'  => $body
  //     );

  //     // Email content for User (auto reply)
  //     $userContent = get_content('wps_auto_respond_mails', '5');  // Update with your user template id
  //     $userBody = str_replace(
  //       ['{mem_name}', '{user_name}', '{email}', '{phone}', '{location}', '{comments}', '{site_name}', '{admin_email}'],
  //       ['User', $name, $this->input->post('email'), $this->input->post('phone'), $this->input->post('location'), $this->input->post('message'), SITENAME, $adminRes->admin_email],
  //       $userContent->email_content
  //     );

  //     $userMailConf = array(
  //       'subject'    => "Thank you for contacting " . SITENAME,
  //       'to_email'   => $this->input->post('email'),
  //       'from_email' => $adminRes->admin_email,
  //       'from_name'  => SITENAME,
  //       'body_part'  => $userBody
  //     );

  //     if ($this->admin_info->mode == 'Live') {
  //       $this->dmailer->mail_notify($adminMailConf);  // Admin mail with CC
  //       $this->dmailer->mail_notify($userMailConf);   // User auto-reply
  //     }

  //     $response = [
  //       'status' => 'true',
  //       'message_response' => "Your message has been sent successfully. We will reply within 24 hours."
  //     ];
  //   } else {
  //     // Validation failed
  //     $response = [
  //       'status' => 'false',
  //       'message_response' => "All Fields Required"
  //     ];
  //   }

  //   // Return JSON for AJAX or load view for normal request
  //   if ($this->input->is_ajax_request()) {
  //     echo json_encode($response);
  //     exit;
  //   } else {
  //     if ($response['status'] == 'true') {
  //       $this->session->set_flashdata('success', $response['message_response']);
  //       redirect(base_url('contact-us'));
  //     } else {
  //       $data['content'] = $this->pages_model->get_cms_page([
  //         'friendly_url' => $this->uri->uri_string,
  //         'status' => '14'
  //       ]);
  //       $data['title'] = "Contact Us";
  //       $data['error_message'] = $response['message_response'];
  //       $this->load->view('contactus', $data);
  //     }
  //   }
  // }





  public function whatsappenq()
  {
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    $this->form_validation->set_rules('wname', 'Name', 'trim|required');
    $this->form_validation->set_rules('wmobile', 'Mobile Number', 'trim|required|max_length[15]|min_length[7]|numeric');
    $url = $_SERVER['HTTP_REFERER'];
    if ($this->form_validation->run() == TRUE) {
      $posted_data = array(
        'type' => '1',
        'first_name' => $this->input->post('wname'),
        'mobile_number' => $this->input->post('wmobile'),
        'message' => 'Whatsapp Enquiry',
        'post_url' => $url,
        'receive_date' => $this->config->item('config.date.time')
      );

      $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, false);

      $subject = "Whatsapp Lead from " . $this->config->item('site_name_www');
      $content = get_content('wps_auto_respond_mails', '20');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', 'Admin', $body);
      $body = str_replace('{name}', $this->input->post('wname'), $body);
      $body = str_replace('{phone}', $this->input->post('wmobile'), $body);
      $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
      $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
      $body = str_replace('{post_url}', $url, $body);
      $mail_conf = array(
        'subject' => $subject,
        'to_email' => $adminRes->admin_email,
        'reply_to' => 'enquiry@webpulseindia.com',
        'reply_name' => $this->input->post('wname'),
        'from_email' => 'enquiry@webpulseindia.com',
        'from_name' => $this->input->post('wname'),
        'body_part' => $body
      );

      //Send the Mail To Client

      $this->dmailer->mail_notify($mail_conf);
      $mail_conf1 = array(
        'subject' => $subject,
        'to_email' => 'webpulseindia@gmail.com',
        'reply_to' => 'enquiry@webpulseindia.com',
        'reply_name' => $this->input->post('wname'),
        'from_email' => 'enquiry@webpulseindia.com',
        'from_name' => $this->input->post('wname'),
        'body_part' => $body
      );

      //Send the Mail To Client

      $this->dmailer->mail_notify($mail_conf1);
      $res = 'success';
    } else {
      $res = '<div class="alert alert-danger">
                      <strong>' . validation_errors() . '
                  </div>';
    }
    echo $res;
    exit;
  }
  public function marketarea()
  {
    $data = array();

    $data['country'] = $this->db->query("SELECT id, name, country_temp_name, status FROM wps_countries_list order By name")->result_array();
    // $data['state'] = $this->db->query("SELECT id, name, country_id, temp_title, status FROM wps_states_list WHERE status ='1' order By name")->result_array();
    // $data['city'] = $this->db->query("SELECT id, city, country_id, temp_title, status FROM wps_cities_list WHERE status ='1' order By city")->result_array();

    $this->load->view('marketarea', $data);
  }

  public function sitemap()
  {
    $data = array();
    $this->load->view('sitemap', $data);
  }

  //   Seo Friendly Url
  public function create_seo_url()
  {

    $msg_arr = array();
    $rec_id = (int) $this->input->post('rec_id');
    $pg_title = $this->input->post('title', TRUE);
    $pg_title = str_replace(base_url(), "", $pg_title);
    $pre_title = $this->input->post('pre_title', TRUE);
    $pre_title = str_replace(base_url(), "", $pre_title);
    $pg_title = seo_url_title($pg_title);

    if ($pre_title != '') {

      $friendly_url = $pre_title . $pg_title;
    } else {
      $friendly_url = $pg_title;
    }
    $this->db->select('meta_id');
    $this->db->from('wps_meta_tags');
    $this->db->where('page_url', $friendly_url);
    if ($rec_id > 0) {
      $this->db->where('entity_id !=', $rec_id);
    }
    $meta_qry = $this->db->get();

    if ($meta_qry->num_rows() > 0) {
      $msg_arr['error'] = 1;
      $msg_arr['msg'] = 'URL already exists';
    } else {
      $msg_arr['error'] = 0;
      $msg_arr['msg'] = 'URL passed';
    }
    $msg_arr['friendly_name'] = $pg_title;
    echo json_encode($msg_arr);
  }

  // Save Newsletters Subscription
  public function newsletter_subscribe()
  {
    $email_add = $this->input->post('newslatter');
    if ($email_add == '') {
      $message = [
        'message' => 'Please Enter Your Email Id',
        'status' => 'false',
      ];
      echo json_encode($message);
      exit;
    }
    if (preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $email_add) == 'false') {
      $message = [
        'message' => 'Please Enter a Valid Email Address',
        'status' => 'false',
      ];
      echo json_encode($message);
      exit;
    }
    $this->db->where('subscriber_email', $email_add);
    $result = $this->db->get('wps_newsletters');
    if ($result->num_rows() > 0) {
      $message = [
        'message' => 'This Email is already exists',
        'status' => 'false',
      ];
      echo json_encode($message);
      exit;
    } else {
      $content = get_content('wps_auto_respond_mails', '3');
      $body = $content->email_content;
      $body = str_replace('{email}', $email_add, $body);
      $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
      $subject = "Newsletter Subscription";


      // print_r($mail_conf);die;

      $this->dmailer->mail_notify($mail_conf);


      $data = array(
        'subscriber_email' => $email_add,
        'subscribe_date' => date('d-m-y H:i:s'),
        'mail_sent_date' => date('d-m-y H:i:s'),
      );
      $res = $this->pages_model->safe_insert('wps_newsletters', $data);
      if ($res) {
        $message = [
          'message' => 'Your Newsletter Subscription is Successful!!!',
          'status' => 'true',
        ];
        echo json_encode($message);
        exit;
      }
    }
  }
}

/* End of file pages.php */