<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends Public_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model(array('products/product_model', 'category/category_model', 'members/members_model'));
    }

    public function index_old() {
        //home category
        $home_cat = array('field' => "*", 'condition' => "AND status='1' AND home_menu = '1'", 'limit' => "3", 'debug' => FALSE);
        $category_result = $this->category_model->getcategory($home_cat);
        $data['home_cat'] = $category_result;

        $home_cat1 = array('field' => "*", 'condition' => "AND status='1' AND home_cat = '1'", 'limit' => "6", 'debug' => FALSE);
        $category_result1 = $this->category_model->getcategory($home_cat1);
        $data['home_cat1'] = $category_result1;

        $data['bottomBanner1'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 1' AND status = '1'")->row_array();
        $data['bottomBanner2'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 2' AND status = '1'")->row_array();
      
        //Popular products
        $data['popular_products'] = $this->get_popular_product();
        //New Arrival products
        $data['new_products'] = $this->get_new_product();

        $data['featured_products'] = $this->get_featured_products();
        $data['top_collections'] = $this->get_top_collections();
        $data['trending_products'] = $this->get_trending_products();

        $content = "";
        $homeHeading = '';
        //Check if it is subdomain
        $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $uri_segments = explode('/', $uri_path);
        $st = $uri_segments[1];
        if (strstr($st, '.html')) {
            $st = substr($st, 0, -5);
        }

        $stArray = $this->db->query("SELECT meta_id, page_url FROM wps_meta_tags WHERE is_fixed='L' AND page_url='" . $st . "'")->row_array();

        if (is_array($stArray) & !empty($stArray)) {
            $locId = $stArray['meta_id'];
            $resprosub = $this->db->query("SELECT * FROM wps_subloccontent WHERE status = '1' AND FIND_IN_SET($locId,location_id)")->row();
            if (is_object($resprosub) && !empty($resprosub)) {
                $key1 = $resprosub->meta_key1;
                $key2 = $resprosub->meta_key2;
                $key3 = $resprosub->meta_key3;
                $content = str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosub->description))));
                $homeHeading = 'Fab Accurate - Best Online Shopping Site for Fabrics, Dupattas in ' . ucwords(locationName($st));
            }
        } else {
            $content = get_db_field_value('wps_cms_pages', 'page_description', "WHERE page_id = '10'");
            $homeHeading = "Fab Accurate - Best Online Shopping Site for Fabrics";
        }
        $data['subheading1'] = get_db_field_value('wps_cms_pages', 'page_name', "WHERE page_id = '10'");
        $data['subheading2'] = get_db_field_value('wps_cms_pages', 'page_name', "WHERE page_id = '10'");
        $data['subheading3'] = get_db_field_value('wps_cms_pages', 'page_name', "WHERE page_id = '10'");
        $data['subheading4'] = get_db_field_value('wps_cms_pages', 'page_name', "WHERE page_id = '10'");
        $data['homeHeading'] = $homeHeading;
        $data['home'] = $content;
//echo $homeHeading;
        //banners
        $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND banner_position = 'Index Slider' order by banner_id asc")->result_array();
        $data['newsmedias'] = $this->db->query("SELECT * FROM wps_news_media WHERE status = '1' order by article_id desc limit 3")->result_array();
        $data['blogs'] = $this->db->query("SELECT * FROM wps_blog WHERE status = '1' order by article_id desc limit 3")->result_array();
        $data['testimonials'] = $this->db->query("SELECT testimonial_id,testimonial_title,testimonial_description,posted_date,poster_name FROM wps_testimonial WHERE status = '1' order by testimonial_id desc limit 0,10")->result_array();

        //echo "<pre>";print_r($data);die;
        $this->load->view('view_home', $data);
    }

    public function index() {
        //home category
        $home_cat = array('field' => "*", 'condition' => "AND status='1' AND home_menu = '1'", 'limit' => "3", 'debug' => FALSE);
        $category_result = $this->category_model->getcategory($home_cat);
        $data['home_cat'] = $category_result;

        $home_cat1 = array('field' => "*", 'condition' => "AND status='1' AND home_cat = '1'", 'limit' => "9", 'debug' => FALSE);
        $category_result1 = $this->category_model->getcategory($home_cat1);
        $data['home_cat1'] = $category_result1;

        $data['bottomBanner1'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 1' AND status = '1'")->row_array();
        $data['bottomBanner2'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position = 'Index Bottom 2' AND status = '1'")->row_array();
       
        $data['popular_products'] = $this->get_popular_product();
        //New Arrival products
        $data['new_products'] = $this->get_new_product();

        $data['featured_products'] = $this->get_featured_products();
        $data['top_collections'] = $this->get_top_collections();
        $data['trending_products'] = $this->get_trending_products();
        $data['top_categories'] = $this->get_top_categories();
        //get_featured_products get_top_collections get_trending_products
        //featured_product   top_collection  trending_product

        $content = "";
        $homeHeading = '';
        //Check if it is subdomain
        $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $uri_segments = explode('/', $uri_path);
        $st = $uri_segments[1];
        if (strstr($st, '.html')) {
            $st = substr($st, 0, -5);
        }

        $stArray = $this->db->query("SELECT meta_id, page_url FROM wps_meta_tags WHERE is_fixed='L' AND page_url='" . $st . "'")->row_array();

        if (is_array($stArray) & !empty($stArray)) {
            $locId = $stArray['meta_id'];
            $resprosub = $this->db->query("SELECT * FROM wps_subloccontent WHERE status = '1' AND FIND_IN_SET($locId,location_id)")->row();
            if (is_object($resprosub) && !empty($resprosub)) {
                $key1 = $resprosub->meta_key1;
                $key2 = $resprosub->meta_key2;
                $key3 = $resprosub->meta_key3;
                $content = str_replace('{location}', ucwords(locationName($st)), str_replace('{key3}', $key3, str_replace('{key2}', $key2, str_replace('{key1}', $key1, $resprosub->description))));
                $homeHeading = 'Buy Printed Fabrics Online in ' . ucwords(locationName($st));
            }
        } else {
            $content = get_db_field_value('wps_cms_pages', 'page_description', "WHERE page_id = '10'");
            $homeHeading = "Buy Printed Fabrics Online in Surat";
        }
        $data['subheading1'] = get_db_field_value('wps_cms_pages', 'page_name', "WHERE page_id = '10'");
        $data['subheading2'] = get_db_field_value('wps_cms_pages', 'page_name', "WHERE page_id = '10'");
        $data['subheading3'] = get_db_field_value('wps_cms_pages', 'page_name', "WHERE page_id = '10'");
        $data['subheading4'] = get_db_field_value('wps_cms_pages', 'page_name', "WHERE page_id = '10'");
        $data['homeHeading'] = $homeHeading;
        $data['home'] = $content;
//echo $homeHeading;
        //banners
        $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND banner_position = 'Index Slider' order by banner_id asc")->result_array();
        $data['newsmedias'] = $this->db->query("SELECT * FROM wps_news_media WHERE status = '1' order by article_id desc limit 3")->result_array();
        $data['blogs'] = $this->db->query("SELECT * FROM wps_blog WHERE status = '1' order by article_id desc limit 3")->result_array();
        $data['testimonials'] = $this->db->query("SELECT testimonial_id,testimonial_title,testimonial_description,posted_date,poster_name FROM wps_testimonial WHERE status = '1' order by testimonial_id desc limit 0,10")->result_array();

        //echo "<pre>";print_r($data);die;
        $this->load->view('view_home', $data);
    }
    
    public function get_top_categories(){

        $categories_list = $this->category_model->get_top_categories();
        return $categories_list;
    }

    public function get_popular_product() {
        $condtion['status'] = '1';
        $condtion['where'] = "popular_product = '1'";
        $condtion['orderby'] = 'products_id DESC';
        // $condtion['limit'] = 'products_id DESC';
        $product_list = $this->product_model->get_products('5', '0', $condtion);
        return $product_list;
    }

    public function get_new_product() {
        $condtion['status'] = '1';
        $condtion['where'] = "newarrival_product = '1'";
        //$condtion['orderby'] = 'products_id ASC';
        $product_list = $this->product_model->get_products('8', '0', $condtion);
        // echo "<pre>";
        // print_r($product_list);die;
        return $product_list;
    }

    public function get_featured_products() {
        $condtion['status'] = '1';
        $condtion['where'] = "featured_product = '1'";
        //$condtion['orderby'] = 'products_id ASC';
        $product_list = $this->product_model->get_products('8', '0', $condtion);
        return $product_list;
    }

    public function get_top_collections() {
        $condtion['status'] = '1';
        $condtion['where'] = "top_collection = '1'";
        //$condtion['orderby'] = 'products_id ASC';
        $product_list = $this->product_model->get_products('8', '0', $condtion);
        return $product_list;
    }

    public function get_trending_products() {
        $condtion['status'] = '1';
        $condtion['where'] = "trending_product = '1'";
        //$condtion['orderby'] = 'products_id ASC';
        $product_list = $this->product_model->get_products('8', '0', $condtion);
        // echo "<pre>";
        // print_r($product_list);die;
        return $product_list;
    }

    public function submit_newslater() {
        $this->form_validation->set_rules('txtemail', 'Email', 'trim|required');
        if ($this->form_validation->run() == TRUE) {
            $posted_data = array(
                'subscriber_email' => $this->input->post('txtemail'),
                'message' => 'Signup For Newsletter',
                'subscribe_date' => $this->config->item('config.date.time')
            );
            $result = $this->members_model->safe_insert('wps_newsletters', $posted_data, false);
            $subject = "WebpulseIndia.com - Signup For Newsletter from www.delhi-interior.com";
            $content = get_content('wps_auto_respond_mails', '3');
            $body = $content->email_content;
            $body = str_replace('{mem_name}', 'Admin', $body);
            $body = str_replace('{admin_email}', $this->input->post('txtemail'), $body);
            $body = str_replace('{date}', $this->config->item('config.date.time'), $body);
            $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
            $mail_conf = array(
                'subject' => $subject,
                'to_email' => 'webpulse.php01@gmail.com',
                'reply_to' => 'enquiry@webpulseindia.com',
                'reply_name' => $this->input->post('wname'),
                'from_email' => 'enquiry@webpulseindia.com',
                'from_name' => $this->input->post('wname'),
                'body_part' => $body
            );
            $to_email = $this->input->post('txtemail');
            BrevoMail($to_email, $subject, $body, $this->admin_info->admin_email);
            // $this->dmailer->mail_notify($mail_conf);
            $res = 'success';
        } else {
            $res = '<div class="alert alert-danger">
      <strong>' . validation_errors() . '
      </div>';
        }
        echo $res;
        exit;
    }

}
