<?php


class Testimonial extends Admin_Controller {



  public function __construct() {

    parent::__construct();

    $this->load->model(array('testimonials/testimonial_model'));

    $this->config->set_item('menu_highlight', 'other management');
		$this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
  }



  public function index() {


    //$this->db->query("ALTER TABLE `wps_testimonial` ADD `designation` VARCHAR(255) NULL DEFAULT NULL AFTER `status`");

    $pagesize = (int) $this->input->get_post('pagesize');

    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');

    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;

    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    $res_array = $this->testimonial_model->get_testimonial($config['limit'], $offset);

    $config['total_rows'] = get_found_rows();

    $data['headingTitle']=$data['heading_title'] = 'Testimonials';

    $data['res'] = $res_array;

    if ($this->input->post('action') != '') {

      if ($this->input->post('action') == 'Delete') {

        $prod_id = $this->input->post('arr_ids');

        foreach ($prod_id as $v) {

          $where = array('entity_type' => 'testimonials/details/' . $v, 'entity_id' => $v);

          $this->testimonial_model->safe_delete('wps_meta_tags', $where, TRUE);

        }

      }
      $this->update_status('wps_testimonial', 'testimonial_id');
    }


    $this->load->view('testimonial/view_testimonial_list', $data);

  }



  public function post() {

    $this->form_validation->set_rules('testimonial_title','Title','trim|required|max_length[150]');
    //$this->form_validation->set_rules('email','Email','trim|valid_email|xss_clean|max_length[80]');
    $this->form_validation->set_rules('poster_name', 'Name', 'trim|required|alpha|max_length[30]');
    //$this->form_validation->set_rules('designation', 'Designation', 'trim|required|max_length[30]');
    //$this->form_validation->set_rules('image1', 'Testimonial Image', "file_allowed_type[image]");
    $this->form_validation->set_rules('testimonial_description', 'Success Story', 'trim|required|max_length[8500]');
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'testimonial_description'));
    //$data['ckeditor1'] = set_ck_config(array('textarea_id' => 'testimonial_description_p'));

    if ($this->form_validation->run() == TRUE) {
      
        $uploaded_file = '';
        if (!empty($_FILES) && $_FILES['testimonial_image']['name'] != '') {
          $this->load->library('upload');
          $config1['upload_path'] = UPLOAD_DIR . '/testimonial/';
          $config1['allowed_types'] = 'gif|jpg|png|jpeg';
          $this->upload->initialize($config1);
          $uploaded_data = $this->upload->do_upload('testimonial_image');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
          }
        }


      $maxID = get_db_field_value('wps_testimonial', 'MAX(testimonial_id)', ' WHERE 1');

      $maxID = $maxID + 1;

      $postedURL = $this->input->post('poster_name') . '-' . $maxID;

      $posted_data = array(
          'testimonial_title' => $this->input->post('testimonial_title'),
          'poster_name' => $this->input->post('poster_name'),
          'designation' => $this->input->post('designation'),
          'testimonial_image'=>$uploaded_file,
          'friendly_url' => seo_url_title($postedURL),
          'testimonial_description' => $this->input->post('testimonial_description'),
          'status' => '1',
          'posted_date' => $this->config->item('config.date.time')
      );

      $insertId = $this->testimonial_model->safe_insert('wps_testimonial', $posted_data, FALSE);



      if ($insertId > 0) {

        $posted_friendly_url = $this->input->post('poster_name');
        $posted_friendly_url = $posted_friendly_url . '-' . $insertId;
        $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
        $redirect_url = "testimonials/details/" . $insertId;

        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $insertId,
            'page_url' => $this->cbk_friendly_url,
            'meta_title' => get_text($this->input->post('poster_name'), 80),
            'meta_description' => get_text($this->input->post('testimonial_description')),
            'meta_keyword' => get_keywords($this->input->post('testimonial_description'))
        );

        create_meta($meta_array);

      }

      $message = $this->config->item('testimonial_post_success');
      $message = str_replace('<site_name>', $this->config->item('site_name'), $message);
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', $message);
      redirect('wps-admin/testimonial', '');
    }

    $data['heading_title'] = "Post Testimonial";
    $this->load->view('testimonial/view_post_testimonials', $data);

  }



  public function edit() {

    $id = (int) $this->uri->segment(4);
    $param = array('where' => "testimonial_id ='$id' ");
    $res = $this->testimonial_model->get_testimonial(1, 0, $param);
    //print_r($res);exit;
    if (is_array($res) && !empty($res)) {
      $seo_url_length = $this->config->item('seo_url_length');
      $this->cbk_friendly_url = seo_url_title($this->input->post('poster_name')).'-'.$res['testimonial_id'];
      //$this->cbk_friendly_url = seo_url_title($this->input->post('friendly_url', TRUE));
      $this->form_validation->set_rules('testimonial_title','Title','trim|required|max_length[150]');
      $this->form_validation->set_rules('poster_name', 'Name', 'trim|required|alpha|max_length[30]');
      //$this->form_validation->set_rules('designation', 'Designation', 'trim|required|max_length[30]');
      //$this->form_validation->set_rules('testimonial_image', 'Testimonial Image', "false");
      $this->form_validation->set_rules('testimonial_description', 'Success Story', 'trim|required|max_length[8500]');
      $data['ckeditor'] = set_ck_config(array('textarea_id' => 'testimonial_description'));
      //$data['ckeditor1'] = set_ck_config(array('textarea_id' => 'testimonial_description_p'));

      if ($this->form_validation->run() == TRUE) {

         $uploaded_file = $res['testimonial_image'];
        if (!empty($_FILES) && $_FILES['testimonial_image']['name'] != '') {
          $this->load->library('upload');
          $config1['upload_path'] = UPLOAD_DIR . '/testimonial/';
          $config1['allowed_types'] = 'gif|jpg|png|jpeg';
          $this->upload->initialize($config1);
          $uploaded_data = $this->upload->do_upload('testimonial_image');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
          }
        }

        $posted_data = array(
          'testimonial_title' => $this->input->post('testimonial_title'),
          'poster_name' => $this->input->post('poster_name'),
          'designation' => $this->input->post('designation'),
          'testimonial_image' => $uploaded_file,
          'testimonial_description' => $this->input->post('testimonial_description'),
        );

        $where = "testimonial_id = '" . $res['testimonial_id'] . "'";
        $insertId = $this->testimonial_model->safe_update('wps_testimonial', $posted_data, $where, FALSE);

        update_meta_page_url('testimonials/details/'.$id, $id, $this->cbk_friendly_url);



        $this->session->set_userdata(array('msg_type' => 'success'));

        $this->session->set_flashdata('success', lang('successupdate'));

        redirect('wps-admin/testimonial', '');

      }

      $data['heading_title'] = "Edit Testimonial";

      $data['res'] = $res;

      $this->load->view('testimonial/view_edit_testimonials', $data);

    } else {

      redirect('wps-admin/testimonial', '');

    }

  }



}



// End of controller