<?php



class Staticpages extends Admin_Controller {



  public function __construct() {

    parent::__construct();

    $this->load->model(array('pages/pages_model'));
		$this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
  }



  public function index() {

    if($this->session->userdata('admin_type')==1){

    $pagesize = (int) $this->input->get_post('pagesize');

    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');

    $offset = ($this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;

    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));

    //print_r($offset);exit;				

    $res_array = $this->pages_model->get_all_cms_page($offset, $config['limit']);

    //$config['total_rows']    =  get_found_rows();

    $config['total_rows'] = $this->pages_model->total_rec_found;

    //$data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);

    $data['headingTitle'] = 'Manage Static Pages';

    $data['pagelist'] = $res_array;

    $this->load->view('staticpage/staticpage_list_index_view', $data);

  }else{ redirect('wps-admin/index', ''); }

  }



  public function edit() {

    if($this->session->userdata('admin_type')==1){

    $page_id = (int) $this->uri->segment(4);
    
    $res = $this->pages_model->get_cms_page(array('page_id' => $page_id));
    $data['ckeditor'] = set_ck_config(array('textarea_id' => 'page_description'));
    if (is_array($res)) {

      $this->form_validation->set_rules('page_description', 'Description', 'required');
      if($res['page_id']==1){
      //$this->form_validation->set_rules('image1', 'Image', "required|callback_validateFile[image1,image,false]");
      if (empty($_FILES['image1']['name']) && $res['image']=="")
      {
        $this->form_validation->set_rules('image1', 'Image', 'required|file_allowed_type[image]');
      }
      $this->form_validation->set_rules('image_alt', 'Image Alt', 'required|max_length[255]');
      } 
      //Meta Details - Main
      $metaDets = get_db_single_row("wps_meta_tags", "meta_title, meta_description, meta_keyword", "page_url = '" . $res['friendly_url'] . "'");



      if ($this->form_validation->run() == TRUE) {

        $uploaded_file = $res['image'];
        $unlink_image = array('source_dir' => "statispage", 'source_file' => $res['image']);
        if (!empty($_FILES) && $_FILES['image1']['name'] != '') {
          $this->load->library('upload');
          $config1['upload_path'] = UPLOAD_DIR . '/statispage/';
          $config1['allowed_types'] = 'gif|jpg|png|jpeg';
          $this->upload->initialize($config1);
          $uploaded_data = $this->upload->do_upload('image1');
          if (is_array($uploaded_data) && !empty($uploaded_data)) {
            $uploaded_file = $uploaded_data['upload_data']['file_name'];
            removeImage($unlink_image);
          }
        }
        



        $posted_data = array(

            'page_description' => $this->input->post('page_description', TRUE),
            'image' => $uploaded_file,
            'image_alt' => $this->input->post('image_alt', TRUE),
            'video' => $this->input->post('video', TRUE),
            'page_updated_date' => $this->config->item('config.date.time')

        );

        $where = "page_id = '" . $res['page_id'] . "'";

        $this->pages_model->safe_update('wps_cms_pages', $posted_data, $where, FALSE);



        //Update Meta

        if ($this->input->get_post('meta_title') != '' && $this->input->get_post('meta_description') != '') {

          $title = get_text($this->input->get_post('meta_title'));

          $description = get_text($this->input->get_post('meta_description'));

          $keywords = $this->input->get_post('meta_keyword');

        } else {

          $title = $metaDets['meta_title'];

          $description = $metaDets['meta_description'];

          $keywords = $metaDets['meta_keyword'];

        }

        $posted_data_meta = array(

            'meta_title' => $title,

            'meta_description' => $description,

            'meta_keyword' => $keywords,

        );

        $where_meta = "page_url = '" . $res['friendly_url'] . "'";

        $this->pages_model->safe_update('wps_meta_tags', $posted_data_meta, $where_meta, FALSE);



        $this->session->set_userdata('success', 'Content has been updated!');

        redirect('wps-admin/staticpages/' . query_string(), '');

      }

      $data['headingTitle'] = 'Edit Static Pages';

      $data['page_title'] = 'Edit Information';

      $data['pageresult'] = $res;

      $data['metaDets'] = $metaDets;

      $this->load->view('staticpage/statispage_edit_view', $data);

    } else {

      redirect('wps-admin/staticpages', '');

    }

  }else{ redirect('wps-admin/index', ''); }

  }



  public function pagedatadisplay() {

    $id = (int) $this->uri->segment(4);

    $res = $this->pages_model->getStaticpage_by_id($id);



    $data['heading_title'] = 'Static Pages';

    $data['page_title'] = 'View Page Information';

    $data['pageresult'] = $res;

    $this->load->view('staticpage/statispage_detail_view', $data);

  }

  function validateFile($flName, $ext) {
    $parameter = explode(',', $ext);
    $fileName = $parameter[0];
    $allowedExt = $parameter[1];
    $isRequired = $parameter[2];
    if ($isRequired == 'false') {
      if (empty($_FILES[$fileName]['name'])) {
        return TRUE;
      } else {
        $file = $_FILES[$fileName];
        $ext_groups = array();
        $ext_groups['image'] = array('jpg', 'jpeg', 'gif', 'png', 'JPG', 'JPEG', 'GIF', 'PNG');
        $ext_groups['document'] = array('rtf', 'doc', 'docx', 'pdf', 'txt', 'ppt', 'zip');
        $ext_groups['media'] = array('mp4', 'mpeg4');
        $ext_groups['compressed'] = array('zip', 'gzip', 'tar', 'gz');
        $exts = $ext_groups[$allowedExt];
        //get file ext
        $file_ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        if (!in_array($file_ext, $exts)) {
          $exts_allowed = implode(" | ", $exts);
          $this->form_validation->set_message('validateFile', "File should be " . $exts_allowed);
          return FALSE;
        } else {
          return TRUE;
        }
      }
    } else {
      if (empty($_FILES[$fileName]['name'])) {
        $this->form_validation->set_message('validateFile', 'Please select file.');
        return false;
      } else {
        $file = $_FILES[$fileName];
        $ext_groups = array();
        $ext_groups['image'] = array('jpg', 'jpeg', 'gif', 'png', 'JPG', 'JPEG', 'GIF', 'PNG');
        $ext_groups['document'] = array('rtf', 'doc', 'docx', 'pdf', 'txt', 'ppt', 'zip');
        $ext_groups['media'] = array('mp4', 'mpeg4');
        $ext_groups['compressed'] = array('zip', 'gzip', 'tar', 'gz');
        $exts = $ext_groups[$allowedExt];
        //get file ext
        $file_ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        if (!in_array($file_ext, $exts)) {
          $exts_allowed = implode(" | ", $exts);
          $this->form_validation->set_message('validateFile', "File should be " . $exts_allowed);
          return FALSE;
        } else {
          return TRUE;
        }
      }
    }
  }



}



// End of controller