<?php

class Faq extends Admin_Controller
{

	public function __construct()
	{		
		parent::__construct(); 				
		$this->load->model(array('faq/faq_model'));
		$this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
	}

	public  function index()
	{

		 $pagesize               =  (int) $this->input->get_post('pagesize');
	     $config['limit']		 =  ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');		 		 				
		 $offset                 =  ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;		
		 $base_url               =  current_url_query_string(array('filter'=>'result'),array('per_page'));				 
		 $parent_id              =   (int) $this->uri->segment(4,0);			

		 $keyword = trim($this->input->get_post('keyword',TRUE));		
		 $keyword = $this->db->escape_str($keyword);
	     $condtion = array();

		$res_array              =  $this->faq_model->get_faq($config['limit'], $offset,$condtion);
		$config['total_rows']	=  $this->faq_model->total_rec_found;	
		$data['page_links']     =  dashboard_pagination($base_url,$config['total_rows'],$config['limit'],$offset);
		$data['headingTitle']  =  "Manage FAQ's";
		$data['res']            =  $res_array; 	
		$data['parent_id']      =  $parent_id; 	
		if( $this->input->post('action')!='')
		{	//status_action		
			$this->update_status('wps_faq','faq_id');	
		}
		if( $this->input->post('update_order')!='')
		{			
			$this->update_displayOrder('wps_faq','sort_order','faq_id');
			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_userdata('success', 'Record(s) order have been updated successfully!');
	}

		$this->load->view('faq/view_faq_list',$data);		

	}	

	public function add()
	{

		 $data['headingTitle'] = 'Add FAQ';
		 $data['ckeditor']      =  set_ck_config(array('textarea_id' => 'faq_answer'));
		 $this->form_validation->set_rules('faq_question', 'Question', "trim|required|max_length[250]|unique[wps_faq.faq_question='".$this->db->escape_str($this->input->post('faq_question'))."' AND status!='2']");
		 $this->form_validation->set_rules('faq_answer', 'Answer', 'trim|required|required_stripped|max_length[8500]');
 
		if($this->form_validation->run()===TRUE)
		{
			    $posted_data = array(
					'faq_question' => $this->input->post('faq_question', TRUE),
					'faq_answer' => $this->input->post('faq_answer', TRUE),
					'faq_date_added' => $this->config->item('config.date.time')
					 );

		    $this->faq_model->safe_insert('wps_faq',$posted_data,FALSE);	
			//$this->session->set_userdata(array('msg_type'=>'success'));			
			//$this->session->set_flashdata('success',lang('success'));
			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_userdata('success', 'Record has been added successfully!');
			  
			redirect('wps-admin/faq', '');		
		}	
		$this->load->view('faq/view_faq_add',$data);		  
	}

	

	

	public function edit()
	{
		$faqId = (int) $this->uri->segment(4);
		$rowdata=$this->faq_model->get_faq_by_id($faqId);

		$data['ckeditor']  =  set_ck_config(array('textarea_id' => 'faq_answer'));
		$data['headingTitle'] = 'Edit FAQ';
		if( !is_array($rowdata) )
		{
			$this->session->set_flashdata('message', lang('idmissing'));	
			redirect('wps-admin/faq', ''); 	
		}

		$faqId = $rowdata['faq_id'];
		$this->form_validation->set_rules('faq_question', 'Question', "trim|required|max_length[250]|unique[wps_faq.faq_question='".$this->db->escape_str($this->input->post('faq_question'))."' AND status!='2' AND faq_id!='".$faqId."']");
		$this->form_validation->set_rules('faq_answer', 'Answer', 'trim|required|required_stripped|max_length[8500]');
		if($this->form_validation->run()==TRUE)
			{	

				$posted_data = array(
					'faq_question' => $this->input->post('faq_question', TRUE),
					'faq_answer' => $this->input->post('faq_answer', TRUE)
				 );

			 	$where = "faq_id = '".$faqId."'"; 				
				$this->faq_model->safe_update('wps_faq',$posted_data,$where,FALSE);	

				//$this->session->set_userdata(array('msg_type'=>'success'));				
				//$this->session->set_flashdata('success',lang('successupdate'));	
				$this->session->set_userdata(array('msg_type' => 'success'));
				$this->session->set_userdata('success', 'Record has been updated successfully!');
					redirect('wps-admin/faq'.'/'.query_string(), ''); 	
			}						

		$data['edit_result']=$rowdata;		
		$this->load->view('faq/view_faq_edit',$data);				

	}

}

// End of controller