<?php

class Rooms extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('rooms/room_model'));
    $this->load->helper('rooms/room');
    $this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
    $this->default_view = 'rooms';
    $this->deletePrvg = TRUE;
  }

  public function index() {
    $pagesize = (int) $this->input->get_post('pagesize');
    $config['limit'] = ( $pagesize > 0 ) ? $pagesize : $this->config->item('pagesize');
    $offset = ( $this->input->get_post('per_page') > 0 ) ? $this->input->get_post('per_page') : 0;
    $base_url = current_url_query_string(array('filter' => 'result'), array('per_page'));
    $parent_id = (int) $this->uri->segment(4, 0);

    $keyword = trim($this->input->get_post('keyword', TRUE));
    $keyword = $this->db->escape_str($keyword);
    $condtion = "AND parent_id = '$parent_id'";
    $condtion_array = array(
        'field' => "*,( SELECT COUNT(room_id) FROM wps_rooms AS b WHERE b.parent_id=a.room_id ) AS total_subrooms",
        'condition' => $condtion,
        'debug' => FALSE
    );
    $res_array = $this->room_model->getrooms($condtion_array);
    $config['total_rows'] = $this->room_model->total_rec_found;
    //$data['page_links'] = admin_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
    $data['headingTitle'] = ( $parent_id > 0 ) ? 'Manage Subrooms' : 'Manage rooms';
    $data['res'] = $res_array;
    $data['parent_id'] = $parent_id;

    if ($this->input->get_post('set_home_rooms')) {
      $this->db->query("UPDATE wps_rooms SET home_cat = '1' WHERE room_id = '" . $this->input->get_post('set_home_rooms') . "'");
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Select rooms has been set as Home rooms.');
      redirect($_SERVER['HTTP_REFERER']);
    }
    if ($this->input->get_post('unset_home_rooms')) {
      $this->db->query("UPDATE wps_rooms SET home_cat = '0' WHERE room_id = '" . $this->input->get_post('unset_home_rooms') . "'");
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Select rooms has been removed from Home rooms.');
      redirect($_SERVER['HTTP_REFERER']);
    }
    if ($this->input->get_post('set_shop_rooms')) {
      $this->db->query("UPDATE wps_rooms SET home_menu = '1' WHERE room_id = '" . $this->input->get_post('set_shop_rooms') . "'");
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Select rooms has been set as Shop By Rooms.');
      redirect($_SERVER['HTTP_REFERER']);
    }
    if ($this->input->get_post('unset_shop_rooms')) {
      $this->db->query("UPDATE wps_rooms SET home_menu = '0' WHERE room_id = '" . $this->input->get_post('unset_shop_rooms') . "'");
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Select rooms has been removed from Shop By Rooms.');
      redirect($_SERVER['HTTP_REFERER']);
    }

    if ($this->input->post('action') != '') {
      if ($this->input->post('action') == 'Delete') {
        $prod_id = $this->input->post('arr_ids');
        $this->session->set_userdata('success', 'rooms Has been deleted Successfully!');
        foreach ($prod_id as $v) {
          $where = array('entity_type' => 'rooms/index', 'entity_id' => $v);
          safe_delete('wps_meta_tags', $where, TRUE);
        }
      }
      $this->update_status('wps_rooms', 'room_id');
    }
    if ($this->input->post('update_order') != '') {
      $this->update_displayOrder('wps_rooms', 'sort_order', 'room_id');
    }

    /* upload Bulk Excel */
    if ($this->input->post('formAction') == 'submit_excel') {
      $filearrext = array('xls', 'xlsx');
      if ($_FILES['excel_file']['name'] == '') {
        $this->session->set_userdata('error', 'Please upload (xls) file only.');
        redirect('wps-admin/rooms');
      }
      if ($_FILES['excel_file']['name'] != '') {
        $extension = substr(strrchr($_FILES['excel_file']['name'], '.'), 1);
        if (!in_array($extension, $filearrext)) {
          $this->session->set_userdata('error', 'Please upload (xls) file only.');
          redirect('wps-admin/rooms');
        } else {
          require_once FCPATH . 'apps/third_party/Excel/reader.php';
          $data = new Spreadsheet_Excel_Reader();
          $data->setOutputEncoding('CP1251');
          chmod($_FILES["excel_file"]["tmp_name"], 0777);
          $data->read($_FILES["excel_file"]["tmp_name"]);
          $worksheet = $data->sheets[0]['cells'];
          $process_add = $this->room_model->add_bulk_upload_rooms($worksheet);
          if ($process_add === TRUE) {
            $this->session->set_userdata('success', 'Excel file inserted successfully!!!');
            redirect('wps-admin/rooms');
          } else {
            $this->session->set_userdata('error', 'Please upload (xls) file only.');
            redirect('wps-admin/rooms');
          }
        }
      }
    }

    //echo "<pre>";print_r($data);die;
    $this->load->view($this->default_view . '/view_room_list', $data);
  }

  public function add() {
    //echo "helooo";die;
    $data['ckeditor1'] = set_ck_config(array('textarea_id' => 'description'));
    $parent_id = (int) $this->uri->segment(4, 0);
    $room_name = $this->db->escape_str($this->input->post('roomName'));
    $posted_friendly_url = $this->input->post('friendlyUrl');

    if ($parent_id != '' && $parent_id > 0) {
      $parent_id = applyFilter('NUMERIC_GT_ZERO', $parent_id);
      $data['headingTitle'] = 'Add Subroom';
      if ($parent_id <= 0) {
        redirect("wps-admin/rooms");
      }
      $parentdata = $this->rooms_model->get_rooms_by_id($parent_id);
      if (!is_array($parentdata)) {
        $this->session->set_userdata('error', 'Invalid Record!');
        redirect('wps-admin/rooms', '');
      }
      $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
      $data['parentData'] = $parentdata;
    } else {
      $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
      $data['parentData'] = '';
      $data['headingTitle'] = 'Add room';
    }

    $this->form_validation->set_rules('roomName', 'room Name', "trim|required|max_length[100]|unique[wps_rooms.room_name ='" . $room_name . "' AND status!='2' AND parent_id='" . $parent_id . "']");
    $this->form_validation->set_rules('friendlyUrl', 'Page URL', "trim|required|unique[wps_meta_tags.page_url ='" . $this->cbk_friendly_url . "'] ");
    $this->form_validation->set_rules('roomImage', 'rooms Image', "callback_validateFile[roomImage,image,false]");
    $this->form_validation->set_rules('description', 'Description', "max_length[6000]");


    if ($this->form_validation->run() === TRUE) {
      $uploaded_icon = $uploaded_file = "";
      if (!empty($_FILES) && $_FILES['roomImage']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/room/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('roomImage');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
        }
      }

      if (!empty($_FILES) && $_FILES['room_icon']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/room/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('room_icon');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_icon = $uploaded_data['upload_data']['file_name'];
        }
      }
      
      $redirect_url = "rooms/index";
      $rooms_alt = $this->input->post('roomName');
      $rooms_description = $this->input->post('description');

      $posted_data = array(
          'room_name' => $this->input->post('roomName'),
          'room_alt' => $rooms_alt,
          'room_description' => $rooms_description,
          'parent_id' => $parent_id,
          'friendly_url' => $this->cbk_friendly_url,
          'date_added' => $this->config->item('config.date.time'),
          'room_image' => $uploaded_file,
          'room_icon' => $uploaded_icon,
      );
      $this->db->insert('wps_rooms', $posted_data);
      $insertId = $this->db->insert_id();
      if ($insertId > 0) {
        if ($this->input->get_post('metaTitle') != '' && $this->input->get_post('metaDescription') != '') {
          $title = get_text($this->input->get_post('metaTitle'));
          $description = get_text($this->input->get_post('metaDescription'));
          $keywords = get_keywords($this->input->get_post('metaKeyword'));
        } else {
          $title = '';
          $description = '';
          $keywords = '';
        }
        $meta_array = array(
            'entity_type' => $redirect_url,
            'entity_id' => $insertId,
            'page_url' => $this->cbk_friendly_url,
            'meta_title' => $title,
            'meta_description' => $description,
            'meta_keyword' => $keywords
        );
        $this->db->insert('wps_meta_tags', $meta_array);
      }

      $this->session->set_userdata('success', 'Record has been added successfully!');
      $redirect_path = isset($parentdata) && is_array($parentdata) ? 'rooms/index/' . $parentdata['room_id'] : 'rooms';
      $this->load->helper('url');
      redirect(base_url() . 'wps-admin/' . $redirect_path, '');
      exit;
    }
    $data['parent_id'] = $parent_id;
    $this->load->view($this->default_view . '/view_room_add', $data);
  }

  public function edit() {
    $data['ckeditor1'] = set_ck_config(array('textarea_id' => 'description'));
    $baseURL = base_url();
    $roomId = (int) $this->uri->segment(4);
    $rowdata = $this->room_model->get_room_by_id($roomId);
    $data['headingTitle'] = ($rowdata['parent_id'] > 0 ) ? 'Edit room' : 'Edit room';

    if (!is_array($rowdata)) {
      $this->session->set_flashdata('message', lang('idmissing'));
      redirect('wps-admin/rooms', '');
    }

    $posted_friendly_url = $this->input->post('friendlyUrl');
    $this->cbk_friendly_url = seo_url_title($posted_friendly_url);
    $room_name = $this->db->escape_str($this->input->post('roomName'));
    $roomId = $rowdata['room_id'];
    //Meta Details - Main
    $metaDets = get_db_single_row("wps_meta_tags", "meta_title, meta_description, meta_keyword", "entity_type = 'rooms/index' AND entity_id = '" . $roomId . "'");
      //echo $this->db->last_query();die;

    $this->form_validation->set_rules('roomName', 'room Name', "trim|required|max_length[100]|unique[wps_rooms.room_name ='" . $room_name . "' AND status!='2' AND parent_id='" . $rowdata['parent_id'] . "' AND room_id!='" . $roomId . "']");
    //$this->form_validation->set_rules('friendlyUrl', 'Page URL', "trim|required|unique[wps_meta_tags.page_url ='" . $this->cbk_friendly_url . "' AND entity_id!='" . $roomId . "'] ");
    $this->form_validation->set_rules('roomImage', 'rooms Image', "callback_validateFile[roomImage,image,false]");
    $this->form_validation->set_rules('description', 'Description', "max_length[6000]");

    if ($this->form_validation->run() == TRUE) {

      $uploaded_file = $rowdata['room_image'];
      $unlink_image = array('source_dir' => "rooms", 'source_file' => $rowdata['room_image']);
      if ($this->input->post('cat_img_delete') === 'Y') {
        removeImage($unlink_image);
        $uploaded_file = NULL;
      }

      if (!empty($_FILES) && $_FILES['roomImage']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/room/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('roomImage');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_file = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image);
        }
      }

      $uploaded_icon = $rowdata['room_icon'];
      $unlink_image2 = array('source_dir' => "rooms", 'source_file' => $rowdata['rooms_image']);
      if (!empty($_FILES) && $_FILES['room_icon']['name'] != '') {
        $this->load->library('upload');
        $config1['upload_path'] = UPLOAD_DIR . '/room/';
        $config1['allowed_types'] = 'gif|jpg|png|jpeg';
        $this->upload->initialize($config1);
        $uploaded_data = $this->upload->do_upload('room_icon');
        if (is_array($uploaded_data) && !empty($uploaded_data)) {
          $uploaded_icon = $uploaded_data['upload_data']['file_name'];
          removeImage($unlink_image2);
        }
      }

      $rooms_alt = $this->input->post('roomName');
      $rooms_description = $this->input->post('description');
      $rooms_description = $rooms_description != '' ? $rooms_description : null;

      $posted_data = array(
          'room_name' => $this->input->post('roomName'),
          'friendly_url' => $this->cbk_friendly_url,
          'room_alt' => $rooms_alt,
          'room_description' => $rooms_description,
          'room_image' => $uploaded_file,
          'room_icon' => $uploaded_icon,
      );
      //trace($posted_data);

      $this->db->where('room_id', $roomId);
      $this->db->update('wps_rooms', $posted_data);


      //Update Meta
      if ($roomId > 0) {
        if ($this->input->get_post('metaTitle') != '' && $this->input->get_post('metaDescription') != '') {
          $title = get_text($this->input->get_post('metaTitle'));
          $description = get_text($this->input->get_post('metaDescription'));
          $keywords = $this->input->get_post('metaKeyword');
        } else {
          $title = '';
          $description = '';
          $keywords = '';
        }
        $posted_data_meta = array(
            'meta_title' => $title,
            'meta_description' => $description,
            'meta_keyword' => $keywords,
        );
        $this->db->where('entity_id', $roomId);
        $this->db->where('entity_type', 'rooms/index');
        $this->db->update('wps_meta_tags', $posted_data_meta);
      }
      //End here

      $this->session->set_userdata('success', 'Record has been updated successfully!');
      $redirect_path = $rowdata['parent_id'] > 0 ? 'rooms/index/' . $rowdata['parent_id'] : 'rooms';
      //header("Location:".$baseURL.'wps-admin/' . $redirect_path);
      redirect(base_url('wps-admin/' . $redirect_path), '');
    }
    $data['parent_id'] = $rowdata['parent_id'];

    $data['metaDets'] = $metaDets;
    $data['catresult'] = $rowdata;
    //echo "<pre>";print_r($data);die;
    $this->load->view($this->default_view . '/view_room_edit', $data);
  }

  public function delete() {
    $roomId = (int) $this->uri->segment(4, 0);
    $rowdata = $this->rooms_model->get_rooms_by_id($roomId);

    if (!is_array($rowdata)) {
      $this->session->set_flashdata('message', lang('idmissing'));
      redirect('sitepanel/rooms', '');
    } else {
      $total_rooms = count_rooms("AND parent_id='$roomId' ");
      $total_product = count_products("AND rooms_id='$roomId' ");

      if ($total_rooms > 0 || $total_product > 0) {
        $this->session->set_userdata(array('msg_type' => 'error'));
        $this->session->set_flashdata('error', lang('child_to_delete'));
      } else {
        $where = array('rooms_id' => $roomId);
        $this->rooms_model->safe_delete('wps_rooms', $where, TRUE);
        $this->session->set_userdata(array('msg_type' => 'success'));
        $this->session->set_flashdata('success', lang('deleted'));
      }
      redirect($_SERVER['HTTP_REFERER'], '');
    }
  }

  function validateFile($flName, $ext) {
    $parameter = explode(',', $ext);
    $fileName = $parameter[0];
    $allowedExt = $parameter[1];
    $isRequired = $parameter[2];
    if ($isRequired == 'false') {
      if (empty($_FILES[$fileName]['name'])) {
        return TRUE;
      } else {
        $file = $_FILES[$fileName];
        $ext_groups = array();
        $ext_groups['image'] = array('jpg', 'jpeg', 'gif', 'png', 'JPG', 'JPEG', 'GIF', 'PNG');
        $ext_groups['document'] = array('rtf', 'doc', 'docx', 'pdf', 'txt', 'ppt', 'zip');
        $ext_groups['media'] = array('mp4', 'mpeg4');
        $ext_groups['compressed'] = array('zip', 'gzip', 'tar', 'gz');
        $exts = $ext_groups[$allowedExt];
        //get file ext
        $file_ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        if (!in_array($file_ext, $exts)) {
          $exts_allowed = implode(" | ", $exts);
          $this->form_validation->set_message('validateFile', "File should be " . $exts_allowed);
          return FALSE;
        } else {
          return TRUE;
        }
      }
    } else {
      if (empty($_FILES[$fileName]['name'])) {
        $this->form_validation->set_message('validateFile', 'Please select file.');
        return false;
      } else {
        $file = $_FILES[$fileName];
        $ext_groups = array();
        $ext_groups['image'] = array('jpg', 'jpeg', 'gif', 'png', 'JPG', 'JPEG', 'GIF', 'PNG');
        $ext_groups['document'] = array('rtf', 'doc', 'docx', 'pdf', 'txt', 'ppt', 'zip');
        $ext_groups['media'] = array('mp4', 'mpeg4');
        $ext_groups['compressed'] = array('zip', 'gzip', 'tar', 'gz');
        $exts = $ext_groups[$allowedExt];
        //get file ext
        $file_ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        if (!in_array($file_ext, $exts)) {
          $exts_allowed = implode(" | ", $exts);
          $this->form_validation->set_message('validateFile', "File should be " . $exts_allowed);
          return FALSE;
        } else {
          return TRUE;
        }
      }
    }
  }

  public function updateuserstatus() {
    $userId = $this->input->post('userId');
    $status = $this->input->post('status');
    if ($userId > 0) {
      $this->db->query("UPDATE wps_rooms SET status = '" . $status . "' WHERE rooms_id = '" . $userId . "'");
      if ($status == 0) {
        echo 'Record has been Deactived successfully!';
      } else {
        echo 'Record has been Actived successfully!';
      }
    } else {
      echo 'Something went wrong, please try again later!';
    }
  }

  public function check_upload_excel() {
    $filearrext = array('xls', 'xlsx');
    if ($_FILES['excel_file']['name'] == '') {
      $this->form_validation->set_message('check_upload_excel', 'Please upload excel file.');
      return FALSE;
    }
    if ($_FILES['excel_file']['name'] != '') {
      $extension = substr(strrchr($_FILES['excel_file']['name'], '.'), 1);
      if (!in_array($extension, $filearrext)) {
        $this->form_validation->set_message('check_upload_excel', 'Please upload (xls) file only.');
        return FALSE;
      } else {
        return TRUE;
      }
    }
  }

}

// End of controller
