<?php
class Features extends Admin_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model(array('features_model'));
		$this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
	}

	public  function index()
	{

		$pagesize               =  (int) $this->input->get_post('pagesize');
		$config['limit']		 =  ($pagesize > 0) ? $pagesize : $this->config->item('pagesize');
		$offset                 =  ($this->input->get_post('per_page') > 0) ? $this->input->get_post('per_page') : 0;
		$base_url               =  current_url_query_string(array('filter' => 'result'), array('per_page'));
		$parent_id              =   (int) $this->uri->segment(4, 0);

		$keyword = trim($this->input->get_post('keyword', TRUE));
		$keyword = $this->db->escape_str($keyword);
		$condtion = " ";

		$condtion_array = array(
			'field' => "*",
			'condition' => $condtion,
			'limit' => $config['limit'],
			'offset' => $offset,
			'debug' => FALSE
		);

		$res_array              =  $this->features_model->getfeatures($condtion_array);
		$config['total_rows']	=  $this->features_model->total_rec_found;
		$data['page_links']     =  dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
		$data['headingTitle']  =  'Manage Features';
		$data['res']            =  $res_array;
		$data['parent_id']      =  $parent_id;

		if ($this->input->post('action') != '') {
			$this->update_status('wps_features', 'features_id');
		}
		if ($this->input->post('update_order') != '') {
			$this->update_displayOrder('wps_features', 'sort_order', 'features_id');
		}
		$this->load->view('features/view_features_list', $data);
	}


	public function add()
	{

		$data['headingTitle'] = 'Add Feature';
		$this->form_validation->set_rules('features_name', 'Feature Title', "trim|required|max_length[255]|unique[wps_features.features_name='" . $this->db->escape_str($this->input->post('features_name')) . "' AND status!='2']");

		if ($this->form_validation->run() === TRUE) {
			$posted_data = array(
				'features_name' => $this->input->post('features_name'),
				'features_date_added' => $this->config->item('config.date.time')
			);

			$this->features_model->safe_insert('wps_features', $posted_data, FALSE);
			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Added Successfully!");
			redirect('wps-admin/features', '');
		}

		$this->load->view('features/view_features_add', $data);
	}


	public function edit()
	{
		$features_id = (int) $this->uri->segment(4);
		$rowdata = $this->features_model->get_features_by_id($features_id);
		$data['headingTitle'] = 'Edit Feature';
		if (!is_array($rowdata)) {
			$this->session->set_flashdata('message', lang('idmissing'));
			redirect('wps-admin/features', '');
		}

		$features_id = $rowdata['features_id'];
		$this->form_validation->set_rules('features_name', 'Feature Title', "trim|required|max_length[255]|unique[wps_features.features_name='" . $this->db->escape_str($this->input->post('features_name')) . "' AND status!='2' AND features_id!='" . $features_id . "']");

		if ($this->form_validation->run() == TRUE) {
			$posted_data = array(
				'features_name' => $this->input->post('features_name'),
				'features_date_updated' => $this->config->item('config.date.time')
			);

			$where = "features_id = '" . $features_id . "'";
			$this->features_model->safe_update('wps_features', $posted_data, $where, FALSE);

			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Updated Successfully!");
			redirect('wps-admin/features' . '/' . query_string(), '');
		}

		$data['edit_result'] = $rowdata;
		$this->load->view('features/view_features_edit', $data);
	}
}



// End of controller