<?php
class Captype extends Admin_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model(array('captype_model'));
		$this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
	}

	public  function index()
	{

		$pagesize               =  (int) $this->input->get_post('pagesize');
		$config['limit']		 =  ($pagesize > 0) ? $pagesize : $this->config->item('pagesize');
		$offset                 =  ($this->input->get_post('per_page') > 0) ? $this->input->get_post('per_page') : 0;
		$base_url               =  current_url_query_string(array('filter' => 'result'), array('per_page'));
		$parent_id              =   (int) $this->uri->segment(4, 0);

		$keyword = trim($this->input->get_post('keyword', TRUE));
		$keyword = $this->db->escape_str($keyword);
		$condtion = " ";

		$condtion_array = array(
			'field' => "*",
			'condition' => $condtion,
			'limit' => $config['limit'],
			'offset' => $offset,
			'debug' => FALSE
		);

		$res_array              =  $this->captype_model->getCaptypes($condtion_array);
		$config['total_rows']	=  $this->captype_model->total_rec_found;
		$data['page_links']     =  dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
		$data['headingTitle']  =  'Manage Standards';
		$data['res']            =  $res_array;
		$data['parent_id']      =  $parent_id;

		if ($this->input->post('action') != '') {
			$this->update_status('wps_captypes', 'captype_id');
		}
		if ($this->input->post('update_order') != '') {
			$this->update_displayOrder('wps_captypes', 'sort_order', 'captype_id');
		}
		$this->load->view('captype/view_captype_list', $data);
	}


	public function add()
	{

		$data['headingTitle'] = 'Add Standard';
		$this->form_validation->set_rules('captype_name', 'Standard Title', "trim|required|max_length[32]|unique[wps_captypes.captype_name='" . $this->db->escape_str($this->input->post('captype_name')) . "' AND status!='2']");

		if ($this->form_validation->run() === TRUE) {
			$posted_data = array(
				'captype_name' => $this->input->post('captype_name'),
				'captype_date_added' => $this->config->item('config.date.time')
			);

			$this->captype_model->safe_insert('wps_captypes', $posted_data, FALSE);
			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Added Successfully!");
			redirect('wps-admin/captype', '');
		}

		$this->load->view('captype/view_captype_add', $data);
	}


	public function edit()
	{
		$captype_id = (int) $this->uri->segment(4);
		$rowdata = $this->captype_model->get_captype_by_id($captype_id);
		$data['headingTitle'] = 'Edit Standard';
		if (!is_array($rowdata)) {
			$this->session->set_flashdata('message', lang('idmissing'));
			redirect('wps-admin/captype', '');
		}

		$captype_id = $rowdata['captype_id'];
		$this->form_validation->set_rules('captype_name', 'Standard Title', "trim|required|max_length[32]|unique[wps_captypes.captype_name='" . $this->db->escape_str($this->input->post('captype_name')) . "' AND status!='2' AND captype_id!='" . $captype_id . "']");

		if ($this->form_validation->run() == TRUE) {
			$posted_data = array(
				'captype_name' => $this->input->post('captype_name'),
				'captype_date_updated' => $this->config->item('config.date.time')
			);

			$where = "captype_id = '" . $captype_id . "'";
			$this->captype_model->safe_update('wps_captypes', $posted_data, $where, FALSE);

			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Updated Successfully!");
			redirect('wps-admin/captype' . '/' . query_string(), '');
		}

		$data['edit_result'] = $rowdata;
		$this->load->view('captype/view_captype_edit', $data);
	}
}



// End of controller