<?php
class Brand extends Admin_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model(array('brand_model'));
		$this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
	}

	public  function index()
	{

		$pagesize               =  (int) $this->input->get_post('pagesize');
		$config['limit']		 =  ($pagesize > 0) ? $pagesize : $this->config->item('pagesize');
		$offset                 =  ($this->input->get_post('per_page') > 0) ? $this->input->get_post('per_page') : 0;
		$base_url               =  current_url_query_string(array('filter' => 'result'), array('per_page'));
		$parent_id              =   (int) $this->uri->segment(4, 0);

		$keyword = trim($this->input->get_post('keyword', TRUE));
		$keyword = $this->db->escape_str($keyword);
		$condtion = " ";

		$condtion_array = array(
			'field' => "*",
			'condition' => $condtion,
			'limit' => $config['limit'],
			'offset' => $offset,
			'debug' => FALSE
		);

		$res_array              =  $this->brand_model->getBrands($condtion_array);
		$config['total_rows']	=  $this->brand_model->total_rec_found;
		$data['page_links']     =  dashboard_pagination($base_url, $config['total_rows'], $config['limit'], $offset);
		$data['headingTitle']  =  'Manage Industries';
		$data['res']            =  $res_array;
		$data['parent_id']      =  $parent_id;

		if ($this->input->post('action') != '') {
			$this->update_status('wps_brands', 'brand_id');
		}
		if ($this->input->post('update_order') != '') {
			$this->update_displayOrder('wps_brands', 'sort_order', 'brand_id');
		}
		$this->load->view('brand/view_brand_list', $data);
	}


	public function add()
	{

		$data['headingTitle'] = 'Add Industry';
		$this->form_validation->set_rules('brand_name', 'Industry Title', "trim|required|max_length[32]|unique[wps_brands.brand_name='" . $this->db->escape_str($this->input->post('brand_name')) . "' AND status!='2']");

		if ($this->form_validation->run() === TRUE) {
			$posted_data = array(
				'brand_name' => $this->input->post('brand_name'),
				'brand_date_added' => $this->config->item('config.date.time')
			);

			$this->brand_model->safe_insert('wps_brands', $posted_data, FALSE);
			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Added Successfully!");
			redirect('wps-admin/brand', '');
		}

		$this->load->view('brand/view_brand_add', $data);
	}


	public function edit()
	{
		$brand_id = (int) $this->uri->segment(4);
		$rowdata = $this->brand_model->get_brand_by_id($brand_id);
		$data['headingTitle'] = 'Edit Industry';
		if (!is_array($rowdata)) {
			$this->session->set_flashdata('message', lang('idmissing'));
			redirect('wps-admin/brand', '');
		}

		$brand_id = $rowdata['brand_id'];
		$this->form_validation->set_rules('brand_name', 'Industry Title', "trim|required|max_length[32]|unique[wps_brands.brand_name='" . $this->db->escape_str($this->input->post('brand_name')) . "' AND status!='2' AND brand_id!='" . $brand_id . "']");

		if ($this->form_validation->run() == TRUE) {
			$posted_data = array(
				'brand_name' => $this->input->post('brand_name'),
				'brand_date_updated' => $this->config->item('config.date.time')
			);

			$where = "brand_id = '" . $brand_id . "'";
			$this->brand_model->safe_update('wps_brands', $posted_data, $where, FALSE);

			$this->session->set_userdata(array('msg_type' => 'success'));
			$this->session->set_flashdata('success', "Record has been Updated Successfully!");
			redirect('wps-admin/brand' . '/' . query_string(), '');
		}

		$data['edit_result'] = $rowdata;
		$this->load->view('brand/view_brand_edit', $data);
	}
}



// End of controller