<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Subcontent_model extends MY_Model {

  public $wps_name;

  public function __construct() {
    parent::__construct();
    $this->wps_name = "wps_subcontent";
  }

  // =============================
  // Get all subcontent records
  // =============================
  public function get_record($opts = array()) {
    $status = $this->db->escape_str($this->input->get_post('status', TRUE));

    if (!array_key_exists('condition', $opts) || $opts['condition'] == '') {
      $opts['condition'] = "status !='2' ";
    } else {
      $opts['condition'] = "status !='2' " . $opts['condition'];
    }

    if ($status != '') {
      $opts['condition'] .= " AND status='$status' ";
    }

    $opts['order'] = "subcontentId ASC ";
    $opts['condition'] .= " ";

    $fetch_config = array(
      'condition' => $opts['condition'],
      'order' => $opts['order'],
      'return_type' => "array"
    );

    if (array_key_exists('debug', $opts)) {
      $fetch_config['debug'] = $opts['debug'];
    }
    if (array_key_exists('field', $opts) && $opts['field'] != '') {
      $fetch_config['field'] = $opts['field'];
    }
    if (array_key_exists('limit', $opts) && applyFilter('NUMERIC_GT_ZERO', $opts['limit']) > 0) {
      $fetch_config['limit'] = $opts['limit'];
    }
    if (array_key_exists('offset', $opts) && applyFilter('NUMERIC_WT_ZERO', $opts['offset']) != -1) {
      $fetch_config['start'] = $opts['offset'];
    }

    $result = $this->findAll($this->wps_name, $fetch_config);
    return $result;
  }

  // =============================
  // Get single subcontent record by ID
  // =============================
  public function get_record_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);

    if ($id > 0) {
      $condition = "status !='2' AND subcontentId=$id";
      $fetch_config = array(
        'condition' => $condition,
        'debug' => FALSE,
        'return_type' => "object"
      );
      $result = $this->find($this->wps_name, $fetch_config);
      return $result;
    }
  }

  // =============================
  // META TAG RELATED FUNCTIONS
  // =============================

  // Get all meta sets
  public function get_meta_sets($opts = array()) {
    $condition = "status != '2'";
    if (array_key_exists('condition', $opts) && !empty($opts['condition'])) {
      $condition .= " " . $opts['condition'];
    }

    $fetch_config = array(
      'condition' => $condition,
      'order' => "set_id DESC",
      'return_type' => "array"
    );

    $result = $this->findAll('wps_meta_sets', $fetch_config);
    return $result;
  }

  // Get meta set by ID
  public function get_meta_set_by_id($id) {
    $id = applyFilter('NUMERIC_GT_ZERO', $id);
    if ($id > 0) {
      $cond = "status != '2' AND set_id = $id";
      $fetch_config = array(
        'condition' => $cond,
        'debug' => FALSE,
        'return_type' => "object"
      );
      $result = $this->find('wps_meta_sets', $fetch_config);
      return $result;
    }
  }

  // Save or update meta set
  public function save_meta_set($data, $id = 0) {
    if ($id > 0) {
      $this->safe_update('wps_meta_sets', $data, "set_id = '".$id."'", FALSE);
      return $id;
    } else {
      $this->safe_insert('wps_meta_sets', $data);
      return $this->db->insert_id();
    }
  }

public function sets() {
  $data['headingTitle'] = "Manage Subcontent Sets";
  $data['ckeditor'] = set_ck_config(array('textarea_id' => 'description'));

  if ($this->input->post('submit')) {
    $this->_save_content_data('wps_subcontent_sets');
  }

  $data['locations'] = $this->db->query("SELECT meta_id,page_url FROM wps_meta_tags WHERE is_fixed='L' ORDER BY page_url")->result_array();
  $this->load->view("subcontent/subcontent_sets", $data);
}
  
} // class end

// model end here
