<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends Admin_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('admin/admin_model'));
    //$this->form_validation->set_error_delimiters("<div style='color:#FC0000; margin-bottom:5px;'>", "</div>");
    $this->form_validation->set_error_delimiters("<span class='red'>", "</span>");
  }

  public function index() {
    $data = array('headingTitle'=>"");
    $startDate = date("Y-m-d",strtotime("-11 months"));
    $data['startDate'] = $startDate;
    //$endDate = Date("Y-m-d", strtotime($startDate." +1 Month"));
    
    /*
    $danceMembershipValue= $this->db->query("SELECT sum(o.total_amount) as amount FROM wps_order as o JOIN wps_orders_details as od ON o.order_id = od.order_id JOIN wps_classes as c ON od.class_id = c.class_id WHERE o.payment_status = '1' AND FIND_IN_SET (1, c.category_links)")->row_array();
    $data['danceMembershipValue'] = $danceMembershipValue['amount'];
    
    $fitnessMembershipValue= $this->db->query("SELECT sum(o.total_amount) as amount FROM wps_order as o JOIN wps_orders_details as od ON o.order_id = od.order_id JOIN wps_classes as c ON od.class_id = c.class_id WHERE o.payment_status = '1' AND FIND_IN_SET (2, c.category_links)")->row_array();
    $data['fitnessMembershipValue'] = $fitnessMembershipValue['amount'];
    * 
    */
    
    //DDA Orders
    //$data['ddaSeller'] = $this->db->query("SELECT * FROM wps_orders_membership WHERE userType != '1' ORDER BY order_id DESC LIMIT 5")->result_array();
   
    //$data['ddaBuyer'] = $this->db->query("SELECT * FROM wps_orders_membership WHERE userType = '1' ORDER BY order_id DESC LIMIT 5")->result_array();
    
    //$data['orders'] = $this->db->query("SELECT * FROM wps_order WHERE 1 ORDER BY order_id DESC LIMIT 5")->result_array();
    
    $data['enq'] = $this->db->query("SELECT * FROM wps_enquiry WHERE type = '3' ORDER BY id DESC LIMIT 5")->result_array();
    
    
    $this->load->view('dashboard/admin_dashboard_view', $data);
  }
  
  public function changepassword() {

    $this->form_validation->set_rules('old_pass', 'Old Password', 'required|max_length[80]');
    $this->form_validation->set_rules('new_pass', 'New Password', 'required|valid_password|max_length[80]');
    $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[new_pass]|max_length[80]');
    
    if ($this->form_validation->run() == TRUE) {

      $this->admin_model->update_info($this->input->post('old_pass'), '1');
      redirect('wps-admin/dashboard/changepassword', '');
    }

    $data['headingTitle'] = 'Change Password';
    $data['admin_info'] = $this->admin_model->get_admin_info(1);
    $this->load->view('dashboard/admin_change_password_view', $data);
  }

  public function website_configuration() {
    
    $this->form_validation->set_rules('admin_email', 'Email ID', 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', 'Phone Number', 'trim|required|max_length[15]');
    $this->form_validation->set_rules('contact_phone', 'Alternate Contact Number', 'trim|max_length[15]');
    $this->form_validation->set_rules('whatsapp_no', 'Whatsapp Number', 'trim|required|max_length[15]');
    $this->form_validation->set_rules('address', 'Address', 'required');
    $this->form_validation->set_rules('facebook', 'facebook', 'trim');
    $this->form_validation->set_rules('twitter', 'twitter', 'trim');
    $this->form_validation->set_rules('linkedin', 'linkedin', 'trim');
    $this->form_validation->set_rules('instagram', 'instagram', 'trim');
    $this->form_validation->set_rules('youtube', 'youtube', 'trim');
    $this->form_validation->set_rules('mode', 'mode', 'trim');



    if ($this->form_validation->run() == TRUE) {
      
      $this->admin_model->update_config('1');
      $this->session->set_userdata(array('msg_type' => 'success'));
      $this->session->set_flashdata('success', 'Updated successfully!');
      redirect('wps-admin/dashboard/website_configuration', '');
    }

    $data['headingTitle'] = 'Website Configuration';
    $data['admin_info'] = $this->admin_model->get_admin_info(1);
    $this->load->view('dashboard/website_configuration', $data);
  }
  
  public function unlink_files() {
    $file = $this->input->get('f');
    $file_root = FCROOT . "$file";
    @unlink($file_root);
  }

  public function count_record($table, $condition = "") {
    if ($table != "" && $condition != "") {
      $this->db->from($table);
      $this->db->where($condition);
      $num = $this->db->count_all_results();
    } else {
      $num = $this->db->count_all($table);
    }
    return $num;
  }

  public function remove_thumb_cache() {
    $path = IMG_CACH_DIR;
    $this->load->helper("file");
    delete_files($path);
  }

  public function php_info() {
    phpinfo();
  }

  public function make_folder($name = '') {
    if ($name != '') {
      make_missing_folder($name);
    }
  }

  public function get_ini() {
    trace(ini_get_all());
  }

  public function clear_cache() {
    $path = UPLOAD_DIR . '/thumb-cache';
    $dir_handle = @opendir($path) or die("Unable to open folder");
    while (false !== ($file = readdir($dir_handle))) {
      if ($file != '.' && $file != '..') {
        // echo $file.'<br>';
        unlink($path . '/' . $file);
      }
    }
    closedir($dir_handle);
    redirect('wps-admin/dashbord/');
    echo 'Not Redirect Properly';
  }
  
  public function updateMeta(){
    $res = $this->db->query("SELECT page_id, page_name from wps_cms_pages WHERE status = '1'")->result_array();
    foreach($res as $val){
      echo $val['page_id'].' - '.$val['page_name'].'<br />';
      $qry = "UPDATE wps_meta_tags SET meta_title = '".$val['page_name']." - Goyal Laser' WHERE entity_type = 'pages/index' AND entity_id = '".$val['page_id']."'";
      echo $qry.'<br />';
      $this->db->query($qry);
      echo '<br />';
    }
  }

}
