<?php

class Treatment extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->helper(array('treatment/treatment', 'products/product'));
    $this->load->model(array('treatment/treatment_model', 'products/product_model', 'admin/color_model', 'admin/size_model'));
  }
 
  public function index() {

    $data['unq_section'] = "treatment";
    $data['title'] = "Treatment";
    $data['heading_title'] = 'Treatment';
    $page_title = 'Treatment';

    //For paging
    $record_per_page = (int) $this->input->post('per_page');
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = "treatment/index/pg/";

      //treatment List    
      $condtion_array = array('field' => "*", 'condition' => "AND status='1' ", 'limit' => $config['per_page'], 'offset' => $offset, 'debug' => FALSE);
      $res_array = $this->treatment_model->gettreatment($condtion_array);
      $data['total_rows'] = $config['total_rows'] = $this->treatment_model->total_rec_found;
      //$data['page_links'] = front_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);
      $data['res'] = $res_array;

      $data['page_title'] = 'Treatment';
      $this->load->view('treatment/view_treatment', $data);
  }



  public function details() {

    $category_id = (int) $this->meta_info['entity_id'];

    $this->page_section_ct = 'details';
    $condtion = array();
    $cat_res = '';
    $record_per_page = (int) $this->input->post('per_page');
    $category_id = (int) $category_id;
    $page_segment = find_paging_segment();
    $config['per_page'] = ( $record_per_page > 0 ) ? $record_per_page : $this->config->item('per_page');
    $offset = (int) $this->uri->segment($page_segment, 0);
    $base_url = ( $category_id != '' ) ? "treatment/details/$category_id/pg/" : "treatment/details/pg/";
    
    $page_title = "Treatment Details";

    
    
    $condtion['status'] = '1';

    if ($category_id > 0) {
      $condtion['treatment_id'] = $category_id;
      $cat_res = get_db_single_row('wps_treatment', '*', " treatment_id='$category_id'");
      $page_title = $cat_res['treatment_name'];
      $data['page_title'] = $page_title;
      $treatment_description = $cat_res['treatment_description'];
      $data['catid'] = $category_id;
    }


    $res_array = $this->product_model->get_products($config['per_page'], $offset, $condtion);
    //echo_sql();
    $data['total_rows'] = $data['total_list_rows'] = $config['total_rows'] = get_found_rows();
    //$data['page_links'] = front_pagination("$base_url", $config['total_rows'], $config['per_page'], $page_segment);
    $data['heading_title'] = $page_title;
    $data['treatment_description'] = $treatment_description;
    $data['products'] = $res_array;
    $data['cat_res'] = $cat_res;

    $this->load->view('treatment/view_product_listing', $data);
  }

  


  public function ajax_load_treatment_view() {
    $data['title'] = 'Ajax Load Treatment';
    //For Paging
    $config['per_page'] = $this->config->item('per_page');
    $offset = $this->input->get_post('stOffSet');
    if (array_key_exists('entity_id', $this->meta_info) && $this->meta_info['entity_id'] > 0) {
      $parent_segment = (int) $this->meta_info['entity_id'];
    } else {
      $parent_segment = (int) $this->input->get_post('category_id');
    }
    $page_segment = find_paging_segment();
    $parent_id = ( $parent_segment > 0 ) ? $parent_segment : '0';

    //cat result
    $condtion_array = array('field' => "*,( SELECT COUNT(category_id) FROM wps_treatment AS b WHERE b.parent_id=a.category_id ) AS total_subcategories", 'condition' => "AND parent_id = '$parent_id' AND status='1' ", 'limit' => $config['per_page'], 'offset' => $offset, 'debug' => FALSE);
    $res_array = $this->treatment_model->getcategory($condtion_array);
    $config['total_rows'] = $this->treatment_model->total_rec_found;
    $data['res'] = $res_array;
    $this->load->view('category/ajax_load_category', $data);
  }

}

/* End of file member.php */
/* Location: .application/modules/products/controllers/products.php */