<?php

class Pages extends Public_Controller
{

  public function __construct()
  {

    parent::__construct();
    $this->load->helper(array('file'));
    $this->load->library(array('Dmailer', 'safe_encrypt'));
    $this->load->model(array('pages/pages_model'));
    $this->form_validation->set_error_delimiters("<div class='required red'>", "</div>");
    $this->page_section_ct = 'static';
  }

  public function index()
  {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $this->load->view('pages/cms_page_view', $data);
  }

  public function aboutus()
  {
    $friendly_url = $this->uri->uri_string;
    $condition = array('friendly_url' => $friendly_url, 'status' => '1');
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['page_name'] = $content['page_name'];

    $data['heading_title'] = "Winner of Global Excellence Award 2019 as best laser centre in North India";
    //$data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_page='about' and status='1' and CURDATE() between banner_start_date and banner_end_date")->row_array();
    $this->load->view('pages/about', $data);
  }

  public function sitemap()
  {
    $this->load->view('pages/sitemap');
  }


  public function whatsappenq()
  {
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;
    $this->form_validation->set_rules('wname', 'Name', 'trim|required');
    $this->form_validation->set_rules('wmobile', 'Mobile Number', 'trim|required|max_length[15]|min_length[6]|numeric');
    $url = $_SERVER['HTTP_REFERER'];
    if ($this->form_validation->run() == TRUE) {
      $posted_data = array(
        'type' => '3',
        'first_name' => $this->input->post('wname'),
        'mobile_number' => $this->input->post('wmobile'),
        'message' => 'Whatsapp Enquiry',
        'post_url' => $url,
        'receive_date' => $this->config->item('config.date.time')
      );
      $result = $this->pages_model->safe_insert('wps_enquiry', $posted_data, false);

      $name = $this->input->post('wname');
      $subject = "WebpulseIndia.com - Whatsapp Enquiry from " . $this->config->item('site_name_www');
      $content = get_content('wps_auto_respond_mails', '3');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', 'Admin', $body);
      $body = str_replace('{name}', $this->input->post('wname'), $body);
      $body = str_replace('{phone}', $this->input->post('wmobile'), $body);
      $body = str_replace('{site_name}', $this->config->item('site_name'), $body);
      $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);
      $body = str_replace('{post_url}', $url, $body);

      if ($this->admin_info->mode == 'Live') {
        $mail_conf = array(
          'subject' => "Webpulseindia.com - Whatsapp Enquiry from " . $this->config->item('site_name_www'),
          'to_email' => $adminRes->admin_email,
          // 'bcc' => 'webpulseindia@gmail.com',
          'from_email' => $adminRes->admin_email,
          'from_name' => $name,
          //'reply_to' => 'webpulseindia@gmail.com',
          //'reply_name' => $this->input->post('wname'),
          'body_part' => $body
        );
        $this->dmailer->mail_notify($mail_conf);
        $mail_conf = array(
          'subject' => "Webpulseindia.com - Whatsapp Enquiry from " . $this->config->item('site_name_www'),
          'to_email' => $adminRes->admin_email,
          // 'bcc' => 'webpulseindia@gmail.com',
          'from_email' => $adminRes->admin_email,
          'from_name' => $name,
          //'reply_to' => 'webpulseindia@gmail.com',
          //'reply_name' => $this->input->post('wname'),
          'body_part' => $body
        );
        $this->dmailer->mail_notify($mail_conf);
      } else {
        $mail_conf = array(
          'subject' => "Webpulseindia.com - Whatsapp Enquiry from " . $this->config->item('site_name_www'),
          'to_email' => $adminRes->admin_email,
          // 'bcc' => 'webpulseindia@gmail.com',
          'from_email' => $adminRes->admin_email,
          'from_name' => $name,
          'body_part' => $body
        );
        $this->dmailer->mail_notify($mail_conf);
      }

      $res = 'success';
    } else {
      $res = '<div class="alert alert-danger">
                          <strong>' . validation_errors() . '
                      </div>';
    }
    echo $res;
    exit;
  }

  // public function contactus() {
  //   $adminRes = get_site_email();
  //   $data['adminRes'] = $adminRes;
  //   //trace($_SERVER['HTTP_REFERER']);

  //   $this->form_validation->set_rules('first_name', 'Name', 'trim|required|alpha|max_length[30]');
  //   $this->form_validation->set_rules('email', 'Email', 'trim|valid_email|max_length[80]');
  //   //$this->form_validation->set_rules('subject', 'Subject', 'trim|required|max_length[255]');
  //   //$this->form_validation->set_rules('country', 'Country', 'trim|required|max_length[200]');
  //   $this->form_validation->set_rules('location', 'Location', 'trim|required|max_length[220]');
  //   $this->form_validation->set_rules('phone', 'Contact Number', 'trim|required|numeric|min_length[6]|max_length[15]');
  //   $this->form_validation->set_rules('message', 'Comment', 'trim|max_length[5000]');
  //    $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');


  //   if ($this->form_validation->run() == TRUE) {
  //     $post_data = http_build_query(
  //           array(
  //               'secret' => CAPTCHA_SECRET,
  //               'response' => $_POST['g-recaptcha-response'],
  //               'remoteip' => $_SERVER['REMOTE_ADDR'],
  //           )
  //     );
  //     $opts = array('http' => array(
  //             'method' => 'POST',
  //             'header' => 'Content-type: application/x-www-form-urlencoded',
  //             'content' => $post_data,
  //         ),
  //     );
  //     $context = stream_context_create($opts);
  //     $response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
  //     $capcha_result = json_decode($response);
  //     if (!$capcha_result->success) {
  //       //throw new Exception('Gah! CAPTCHA verification failed. Please try again', 1);
  //       $msg = "CAPTCHA verification failed!";
  //       $this->session->set_userdata(array('msg_type' => 'error'));
  //       $this->session->set_flashdata('error', $msg);
  //       $friendly_url = $this->uri->uri_string;
  //       $condition = array('friendly_url' => $friendly_url, 'status' => '1');
  //       $content = $this->pages_model->get_cms_page($condition);
  //       $data['content'] = $content;
  //       $data['title'] = "Contact Us";
  //       $this->load->view('contactus', $data);
  //     } else {

  //       $posted_data = array(
  //           'type' => '1',
  //           'first_name' => $this->input->post('first_name'),
  //           'email' => $this->input->post('email'),
  //           'mobile_number' => $this->input->post('phone'),
  //           //'country' => $this->input->post('location'),
  //           'location' => $this->input->post('location'),
  //           'message' => $this->input->post('message'),
  //           //'subject' => $this->input->post('subject'),
  //           'receive_date' => $this->config->item('config.date.time')
  //       );
  //       $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

  //       //Mail
  //       $content = get_content('wps_auto_respond_mails', '5');
  //       $name = $this->input->post('first_name');
  //       $body = $content->email_content;
  //       $body = str_replace('{mem_name}', 'Admin', $body);
  //       $body = str_replace('{user_name}', $name, $body);
  //       //$body = str_replace('{subject}', $this->input->post('subject'), $body);
  //       $body = str_replace('{email}', $this->input->post('email'), $body);
  //       $body = str_replace('{phone}', $this->input->post('phone'), $body);
  //       //$body = str_replace('{country}', $this->input->post('country'), $body);
  //       $body = str_replace('{location}', $this->input->post('location'), $body);
  //       $body = str_replace('{comments}', $this->input->post('message'), $body);
  //       $body = str_replace('{site_name}', SITENAME, $body);
  //       $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);

  //       if($this->admin_info->mode=='Live'){
  //           $mail_conf = array(
  //               'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
  //               'to_email' => $this->admin_info->admin_email,
  //               'from_email' => $this->admin_info->admin_email,
  //               'from_name' => $name,
  //               'body_part' => $body
  //           );
  //           $this->dmailer->mail_notify($mail_conf);
  //           $mail_conf1 = array(
  //               'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
  //               'to_email' => 'webpulseindia@gmail.com',
  //               'from_email' => $this->admin_info->admin_email,
  //               'from_name' => $name,
  //               'body_part' => $body
  //           );
  //           $this->dmailer->mail_notify($mail_conf1);
  //       }else{
  //           $mail_conf = array(
  //             'subject' => "Webpulseindia.com - Enquiry from ".$this->config->item('site_name_www'),
  //             'to_email' => $this->admin_info->admin_email,
  //             'from_email' => $this->admin_info->admin_email,
  //             'from_name' => $name,
  //             'body_part' => $body
  //           );
  //           $this->dmailer->mail_notify($mail_conf);
  //       }

  //       $msg = "Your message has been sent successfully to ".$this->config->item('site_name_').". We will endeavour to reply within 24hrs. Thank You";
  //       $this->session->set_userdata(array('msg_type' => 'success'));
  //       $this->session->set_flashdata('success', $msg);
  //       redirect(base_url('contact-us'));
  //     }
  //   }

  //   $friendly_url = $this->uri->uri_string;
  //   $condition = array('friendly_url' => $friendly_url, 'status' => '14');
  //   $content = $this->pages_model->get_cms_page($condition);
  //   $data['content'] = $content;
  //   $data['title'] = "Contact Us";
  //   $data['banner']=$this->db->query("select * from wps_banners where banner_position='Contact Us Banner' and status='1'")->row_array();
  //   $this->load->view('contactus', $data);
  // }

  public function contactus()
  {
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;

    // Anti-Spam: Block specific email domains (e.g., 1ti.ru and others)
    $email = $this->input->post('email');
    $blocked_email_patterns = [
      '/@.*\.ru$/',
      '/@.*\.xyz$/',
      '/@.*\.top$/',
      '/@.*\.club$/',
      '/@.*\.gq$/',
      '/@.*\.cf$/',
      '/@.*\.tk$/',
      '/@.*\.bid$/',
      '/@.*\.online$/',
      '/@.*\.work$/',
      '/@.*\.co$/',
      '/@.*\.pw$/',
      '/@.*\.gmx$/',
      '/@.*\.mail$/',
      '/@.*\.pro$/',
      '/@.*\.top$/',
      '/@.*\.info$/',
      '/@.*\.to$/',
      '/@.*\.name$/',
      '/@.*\.xyz$/',
      '/@.*\.bargains$/',
      '/@.*\.cn$/',
      '/@.*\.party$/',
      '/@.*\.store$/',
      '/@.*\.shop$/',
      '/@.*\.website$/',
      '/@.*\.stream$/',
      '/@.*\.win$/',
      '/@.*\.download$/',
    ];

    foreach ($blocked_email_patterns as $pattern) {
      if (preg_match($pattern, $email)) {
        $msg = "Spam detected: Messages from this email domain are not allowed.";
        $this->session->set_userdata(['msg_type' => 'error']);
        $this->session->set_flashdata('error', $msg);
        redirect(base_url('contact-us'));
        return;
      }
    }

    // Anti-Spam: Check for specific keywords in the message
    $blocked_keywords = [
      'bromo',
      'chloro',
      'methyl',
      'nitrophenol',
      'n methylpyridine',
      'carboxamide',
      'hydrochloride',
      'nitrophenol',
      'chimmed',
      '4-brom-2-metil-6-nitrofenol',
      'drug',
      'meds'
    ];

    $message = $this->input->post('message');
    foreach ($blocked_keywords as $keyword) {
      if (stripos($message, $keyword) !== false) {
        // If any keyword is found in the message, block the submission
        $msg = "Spam detected in the message content.";
        $this->session->set_userdata(['msg_type' => 'error']);
        $this->session->set_flashdata('error', $msg);
        redirect(base_url('contact-us'));
        return;
      }
    }

    // Form validation


$this->form_validation->set_rules(
    'first_name',
    'Name',
    'trim|required|regex_match[/^(?=.*[aeiouAEIOU])[a-zA-Z\s.\-]+$/]|max_length[30]'
);

    $this->form_validation->set_rules('email', 'Email', 'trim|valid_email|max_length[80]');
    $this->form_validation->set_rules('location', 'Location', 'trim|required|max_length[220]');
    $this->form_validation->set_rules('phone', 'Contact Number', 'trim|required|numeric|min_length[6]|max_length[15]');
    $this->form_validation->set_rules('message', 'Comment', 'trim|max_length[5000]');
    $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');

    if ($this->form_validation->run() == TRUE) {
      // CAPTCHA validation
      $post_data = http_build_query([
        'secret' => CAPTCHA_SECRET,
        'response' => $_POST['g-recaptcha-response'],
        'remoteip' => $_SERVER['REMOTE_ADDR'],
      ]);
      $opts = ['http' => [
        'method'  => 'POST',
        'header'  => 'Content-type: application/x-www-form-urlencoded',
        'content' => $post_data,
      ]];
      $context = stream_context_create($opts);
      $response = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
      $capcha_result = json_decode($response);

      if (!$capcha_result->success) {
        $msg = "CAPTCHA verification failed!";
        $this->session->set_userdata(['msg_type' => 'error']);
        $this->session->set_flashdata('error', $msg);
        $friendly_url = $this->uri->uri_string;
        $condition = ['friendly_url' => $friendly_url, 'status' => '1'];
        $content = $this->pages_model->get_cms_page($condition);
        $data['content'] = $content;
        $data['title'] = "Contact Us";
        $this->load->view('contactus', $data);
        return;
      }

      // Sanitize and validate message
      $message = $this->sanitize_message($message);

      // Disallow question marks
      if (strpos($message, '?') !== false) {
        $msg = "Special characters like '?' are not allowed in the comment.";
        $this->session->set_userdata(['msg_type' => 'error']);
        $this->session->set_flashdata('error', $msg);
        redirect(base_url('contact-us'));
        return;
      }

$first_name = $this->input->post('first_name');


// 🔹 Gibberish check - place here BEFORE saving to DB
if ($this->is_gibberish($first_name)) {
    $msg = "Please enter a valid name.";
    $this->session->set_userdata(['msg_type' => 'error']);
    $this->session->set_flashdata('error', $msg);
    redirect(base_url('contact-us'));
    return;
}


      // Save to DB
      $posted_data = [
        'type' => '1',
        'first_name' => $this->input->post('first_name'),
        'email' => $this->input->post('email'),
        'mobile_number' => $this->input->post('phone'),
        'location' => $this->input->post('location'),
        'message' => $message,
        'user_ip' => $this->input->ip_address(),  // Save the user's IP address
        'receive_date' => $this->config->item('config.date.time')
      ];
      $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

      // Prepare Email
      $content = get_content('wps_auto_respond_mails', '5');
      $name = $this->input->post('first_name');
      $body = $content->email_content;
      $body = str_replace('{mem_name}', 'Admin', $body);
      $body = str_replace('{user_name}', $name, $body);
      $body = str_replace('{email}', $this->input->post('email'), $body);
      $body = str_replace('{phone}', $this->input->post('phone'), $body);
      $body = str_replace('{location}', $this->input->post('location'), $body);
      $body = str_replace('{comments}', $message, $body);
      $body = str_replace('{site_name}', SITENAME, $body);
      $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);

      // Email Headers
      $headers = "MIME-Version: 1.0\r\n";
      $headers .= "Content-type: text/html; charset=UTF-8\r\n";

      // Send Mail
      $mail_conf = [
        'subject' => "Webpulseindia.com - Enquiry from " . $this->config->item('site_name_www'),
        'to_email' => $this->admin_info->admin_email,
        'bcc' => 'tanuja.wpsranchi@gmail.com',
        'from_email' => $this->admin_info->admin_email,
        'from_name' => $name,
        'body_part' => $body,
        'headers' => $headers
      ];
      $this->dmailer->mail_notify($mail_conf);

      // Optional live copy
      if ($this->admin_info->mode == 'Live') {
        $mail_conf1 = $mail_conf;
        $mail_conf1['to_email'] = 'tanuja.wpsranchi@gmail.com';
        $this->dmailer->mail_notify($mail_conf1);
      }

      // Success message
      $msg = "Your message has been sent successfully to " . $this->config->item('site_name_') . ". We will endeavour to reply within 24hrs. Thank You";
      $this->session->set_userdata(['msg_type' => 'success']);
      $this->session->set_flashdata('success', $msg);
      redirect(base_url('contact-us'));
    }

    // Load page (form not submitted or failed)
    $friendly_url = $this->uri->uri_string;
    $condition = ['friendly_url' => $friendly_url, 'status' => '14'];
    $content = $this->pages_model->get_cms_page($condition);
    $data['content'] = $content;
    $data['title'] = "Contact Us";
    $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE banner_position='Contact Us Banner' AND status='1'")->row_array();
    $this->load->view('contactus', $data);
  }

  private function is_gibberish($text) {
    // Check for at least one vowel
    if (!preg_match('/[aeiouAEIOU]/', $text)) {
        return true;
    }

    // Check if too few vowels for long text
    $length = strlen($text);
    $vowels = preg_match_all('/[aeiouAEIOU]/', $text);
    if ($length > 3 && ($vowels / $length) < 0.3) { 
        return true; // likely gibberish
    }

    return false; // valid text
}

  private function sanitize_message($string)
  {
    // Remove all HTML tags
    $string = strip_tags($string);

    // Remove base64 images or image URLs
    $string = preg_replace('/data:image\/[^;]+;base64[^"]+/i', '', $string);
    $string = preg_replace('/https?:\/\/[^ ]+\.(jpg|jpeg|png|gif|webp)/i', '', $string);
    $string = preg_replace('/<img\s[^>]*src=[^>]+>/i', '', $string);
    $string = preg_replace('/[\x{1F600}-\x{1F64F}]/u', '', $string);
    $string = preg_replace('/[^a-zA-Z0-9\s.,!?@()-]/', '', $string);

    // Return sanitized string
    return htmlspecialchars(trim($string), ENT_QUOTES, 'UTF-8');
  }


  public function enquiry()
  {
    $adminRes = get_site_email();
    $data['adminRes'] = $adminRes;

    $this->form_validation->set_rules('qname', 'Name', 'trim|required|alpha|max_length[30]');
    $this->form_validation->set_rules('qemail', 'Email', 'trim|valid_email|max_length[80]');
    $this->form_validation->set_rules('qlocation', 'Location', 'trim|required|max_length[220]');
    $this->form_validation->set_rules('qmobile_number', 'Contact Number', 'trim|required|numeric|min_length[6]|max_length[15]');
    $this->form_validation->set_rules('qmessage', 'Message', 'trim|max_length[5000]');
    $this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'trim|required');

    if ($this->form_validation->run() == TRUE) {

      // reCAPTCHA verification
      $captcha_response = $this->input->post('g-recaptcha-response');
      $verify_url = 'https://www.google.com/recaptcha/api/siteverify';
      $captcha_data = [
        'secret'   => CAPTCHA_SECRET, // your secret key
        'response' => $captcha_response,
        'remoteip' => $_SERVER['REMOTE_ADDR']
      ];
      $options = [
        'http' => [
          'method'  => 'POST',
          'header'  => 'Content-type: application/x-www-form-urlencoded',
          'content' => http_build_query($captcha_data),
        ]
      ];
      $context = stream_context_create($options);
      $verify_response = file_get_contents($verify_url, false, $context);
      $captcha_result = json_decode($verify_response, true);

      if (!empty($captcha_result['success']) && $captcha_result['success'] == true) {
        // CAPTCHA passed – insert to DB and send mail

        $posted_data = array(
          'type' => '1',
          'first_name' => $this->input->post('qname'),
          'email' => $this->input->post('qemail'),
          'mobile_number' => $this->input->post('qmobile_number'),
          'location' => $this->input->post('qlocation'),
          'message' => $this->input->post('qmessage'),
          'receive_date' => $this->config->item('config.date.time')
        );
        $this->pages_model->safe_insert('wps_enquiry', $posted_data, FALSE);

        // Mail content & logic
        $content = get_content('wps_auto_respond_mails', '5');
        $name = $this->input->post('qname');
        $email = $this->input->post('qemail');
        $body = $content->email_content;
        $body = str_replace('{mem_name}', 'Admin', $body);
        $body = str_replace('{user_name}', $name, $body);
        $body = str_replace('{email}', $email, $body);
        $body = str_replace('{phone}', $this->input->post('qmobile_number'), $body);
        $body = str_replace('{location}', $this->input->post('qlocation'), $body);
        $body = str_replace('{comments}', $this->input->post('qmessage'), $body);
        $body = str_replace('{site_name}', SITENAME, $body);
        $body = str_replace('{admin_email}', $this->admin_info->admin_email, $body);

        // Send Mail
        $mail_conf = array(
          'subject'    => "Webpulseindia.com - Enquiry from " . $this->config->item('site_name_www'),
          'to_email'   => $this->admin_info->admin_email,
          'from_email' => $this->admin_info->admin_email,
          'from_name'  => $name,
          'reply_to'   => $email,
          'reply_name' => $name,
          'body_part'  => $body
        );
        $this->dmailer->mail_notify($mail_conf);

        // Also send to webpulseindia@gmail.com if live
        if ($this->admin_info->mode == 'Live') {
          $mail_conf['to_email'] = 'tanuja.wpsranchi@gmail.com';
          $this->dmailer->mail_notify($mail_conf);
        }

        $res = 'success';
      } else {
        $res = '<div class="alert alert-danger"><strong>CAPTCHA verification failed. Please try again.</strong></div>';
      }
    } else {
      $res = '<div class="alert alert-danger"><strong>' . validation_errors() . '</strong></div>';
    }

    echo $res;
    exit;
  }


  public function marketarea()
  {
    $data = array();

    $data['country'] = $this->db->query("SELECT id, name, country_temp_name, status FROM wps_countries_list WHERE status ='1'")->result_array();

    $data['state'] = $this->db->query("SELECT id, name, country_id, temp_title, status FROM wps_states_list WHERE status ='1'")->result_array();
    $data['banner'] = $this->db->query("select * from wps_banners where banner_position='Market Area Banner' and status='1'")->row_array();
    $this->load->view('marketarea', $data);
  }
}

/* End of file pages.php */