<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends Public_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(array('products/product_model','category/category_model'));
  }

  public function index() {
    //home category
    $data['home_category'] = $this->db->query("SELECT * FROM wps_categories WHERE status = '1' AND home_cat = '1' ")->result_array();
    $data['home_cat'] = $this->db->query("SELECT * FROM wps_categories WHERE status = '1' AND category_id='21' or category_id='22' ")->result_array();
    $data['home_rand'] = $this->db->query("SELECT * FROM wps_categories WHERE parent_id='12' ORDER BY rand() limit 0,4 ")->result_array();
    $data['home_pro'] = $this->db->query("SELECT * FROM wps_categories WHERE parent_id='1' ORDER BY rand() limit 0,6 ")->result_array();

    $content = "";
    $homeHeading = '';

    //Check if it is subdomain
    $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $uri_segments = explode('/', $uri_path);
    $st = $uri_segments[1];
    if (strstr($st, '.html')) {
      $st = substr($st, 0, -5);
    }

    $stArray = $this->db->query("SELECT meta_id, page_url FROM wps_meta_tags WHERE is_fixed='L' AND page_url='" . $st . "'")->row_array();

    if (is_array($stArray) & !empty($stArray)) {
      $locId = $stArray['meta_id'];

      // ✅ Added Logic — detect correct subcontent record (1 or 2)
      $defaultContent = $this->db->query("SELECT * FROM wps_subloccontent WHERE subcontentId='1' AND status='1'")->row();
      $secondContent  = $this->db->query("SELECT * FROM wps_subloccontent WHERE subcontentId='2' AND status='1'")->row();

      $resprosub = $defaultContent;
      if ($secondContent && in_array($locId, explode(',', $secondContent->location_id))) {
        $resprosub = $secondContent;
      }

      // ✅ Existing logic preserved
      if (is_object($resprosub) && !empty($resprosub)) {
        $key1 = $resprosub->meta_key1;
        $key2 = $resprosub->meta_key2;
        $key3 = $resprosub->meta_key3;

        $content = str_replace('{location}', ucwords(locationName($st)),
          str_replace('{key3}', $key3,
          str_replace('{key2}', $key2,
          str_replace('{key1}', $key1, $resprosub->description))));

        $homeHeading = 'Best Modular Kitchen Manufacturers in '.ucwords(locationName($st));

        // ✅ Added Meta Tag Handling
        $data['meta_title'] = str_replace('{location}', ucwords(locationName($st)), $resprosub->meta_title);
        $data['meta_keyword'] = str_replace('{location}', ucwords(locationName($st)), $resprosub->meta_keyword);
        $data['meta_description'] = str_replace('{location}', ucwords(locationName($st)), $resprosub->meta_description);
      }

    } else {
      $content = get_db_field_value('wps_cms_pages', 'page_description', "WHERE page_id = '3'");
      $homeHeading = 'Best Modular Kitchen Manufacturers <span class="theme_color">in Delhi</span>';

      // ✅ Default meta tags for main site
      $data['meta_title'] = "Best Modular Kitchen Manufacturers in Delhi | Ederra Home Studio";
      $data['meta_keyword'] = "Modular Kitchen in Delhi, Modular Wardrobe in Delhi, Kitchen Manufacturers Delhi";
      $data['meta_description'] = "Get premium quality modular kitchens and wardrobes in Delhi. Explore custom designs and expert craftsmanship at Ederra Home Studio.";
    }

    $data['video_id'] = get_db_field_value('wps_cms_pages', 'video_link', "WHERE page_id = '3'");
    $data['homeHeading'] = $homeHeading;
    $data['home'] = $content;

    //banners
    $data['banner'] = $this->db->query("SELECT * FROM wps_banners WHERE status = '1' AND banner_position = 'Index Slider' order by banner_id asc")->result_array();
    $data['blog'] = $this->db->query("SELECT * FROM wps_blog WHERE status = '1' and article_id!='1' order by article_id asc limit 0,2")->result_array();
    $data['blog1'] = $this->db->query("SELECT * FROM wps_blog WHERE status = '1' and article_id='1'")->result_array();
    $data['testimonials'] = $this->db->query("SELECT poster_name,designation,testimonial_description,photo FROM wps_testimonial WHERE status = '1' order by testimonial_id desc limit 0,6")->result_array();

    $this->load->view('view_home', $data);
  }

  public function get_popular_product() {
    $condtion['status'] = '1';
    $condtion['where'] = "popular_product = '1'";
    $condtion['orderby'] = 'products_id DESC';
    $product_list = $this->product_model->get_products('5', '0', $condtion);
    return $product_list;
  }

  public function get_new_product() {
    $condtion['status'] = '1';
    $condtion['where'] = "newarrival_product = '1'";
    $product_list = $this->product_model->get_products('8', '0', $condtion);
    return $product_list;
  }

}
